<?xml version='1.0' encoding='UTF-8'?>
<Folder
  Browseable="True"
  Group="Explorer"
  Name="European Southern Observatory (ESO)"
  Searchable="True"
>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;03_sn-1987a_cc&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-03-12T18:51:38+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.26905268109698"
    Magnitude="0"
    Name="SN 1987A fades"
    Opacity="100"
    RA="5.591031231643389"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/03_sn-1987a_cc/thumb.jpg"
    ZoomLevel="0.04181233032016489"
  >
    <Description>Image in continuum light of the surroundings of supernova SN 1987A, taken by the NTT, at La Silla Observatory, almost 5 years after the explosion was detected in the Large Magellanic Cloud. SN 1987A is the spot between the two brighter stars, belonging to the same multiple system. After reaching an impressive magnitude 3 at its maximum, the supernova had already faded to magnitude 18 by the time this image was captured. SN 1987A was the first naked-eye supernova to be seen in almost four hundred years and is one of the most studied objects in modern astronomy. ESO telescopes have played a major role in this campaign. More information in ESO Messenger 66, p35: http://www.eso.org/sci/publications/messenger/archive/no.58-dec89/messenger-no58.pdf  </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0059100739518464"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8654727234"
        CenterY="-69.2690540602"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SN 1987A fades"
        OffsetX="1.4428891484e-06"
        OffsetY="1.4428891484e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-2.480000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/03_sn-1987a_cc/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/03_sn-1987a_cc/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/03_sn-1987a_cc/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;05_sn-1987a_cc&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-03-12T18:51:39+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.2688537915643"
    Magnitude="0"
    Name="Ring-shaped nebula around SN 1987A"
    Opacity="100"
    RA="5.59099326295538"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/05_sn-1987a_cc/thumb.jpg"
    ZoomLevel="0.036064758706617295"
  >
    <Description>High resolution NTT image of SN 1987A taken from La Silla Observatory in December 1993. Seven years after the explosion of SN 1987A, the observations indicate the beginning of a more active phase while the interaction between the stellar material which was ejected during the explosion and the surrounding ring-shaped nebula has started. SN 1987A is one of the most studied objects in modern astronomy and ESO telescopes have been observing it since its first detection, in February 1987. More information in ESO Messenger 75: http://www.eso.org/sci/publications/messenger/archive/no.75-mar94/messenger-no75.pdf</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0045399610198016"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8649006429"
        CenterY="-69.2688542943"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Ring-shaped nebula around SN 1987A"
        OffsetX="5.54194460425e-07"
        OffsetY="5.54194460425e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-5.099999999999997"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/05_sn-1987a_cc/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/05_sn-1987a_cc/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/05_sn-1987a_cc/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;06_sn-1987a_cc&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-03-12T18:51:40+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.26900322410086"
    Magnitude="0"
    Name="Ring-shaped nebula around SN 1987A"
    Opacity="100"
    RA="5.591006570673193"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/06_sn-1987a_cc/thumb.jpg"
    ZoomLevel="0.0306880477661167"
  >
    <Description>High resolution NTT image of supernova SN 1987A taken from La Silla Observatory in December 1993. Seven years after the explosion of SN 1987A, the observations indicate the beginning of a more active phase while the interaction between the stellar material which was ejected during the explosion and the surrounding ring-shaped nebulae has started. SN 1987A is one of the most studied objects in modern astronomy and ESO telescopes have been observing it since its first detection, in February 1987. More information in ESO Messenger 75, p22: http://www.eso.org/sci/publications/messenger/archive/no.75-mar94/messenger-no75.pdf</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.003057905017516032"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8650996296"
        CenterY="-69.269003592"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Ring-shaped nebula around SN 1987A"
        OffsetX="3.732794210835e-07"
        OffsetY="3.732794210835e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.8200000000000005"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/06_sn-1987a_cc/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/06_sn-1987a_cc/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/06_sn-1987a_cc/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;10_sn-1987a_cc&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-06-10T18:32:05+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.26901067810688"
    Magnitude="0"
    Name="Neighbourhood of SN 1987A"
    Opacity="100"
    RA="5.5910222827552145"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/10_sn-1987a_cc/thumb.jpg"
    ZoomLevel="0.20127092939165303"
  >
    <Description>Image of the neighbourhood of supernova SN 1987A, taken with the NTT, in the light of ionised nitrogen, during very good seeing. The colour coding shows the intensity contours in the image. SN 1987A was detected in the Large Magellanic Cloud in February 1987 and was the first naked-eye supernova in nearly four centuries. ESO telescopes have been observing SN 1987A for more than twenty years. More information in ESO Messenger 59, p16: http://www.eso.org/sci/publications/messenger/archive/no.59-mar90/messenger-no59.pdf</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0327753815334912"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.865382466"
        CenterY="-69.2690255383"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Neighbourhood of SN 1987A"
        OffsetX="1.60036042644e-05"
        OffsetY="1.60036042644e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-3.9600000000000035"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/10_sn-1987a_cc/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/10_sn-1987a_cc/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/10_sn-1987a_cc/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;16_sn-1987a_cc&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-03-12T18:51:48+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.29247883392287"
    Magnitude="0"
    Name="Honeycomb structure around SN 1987A"
    Opacity="100"
    RA="5.593789838875849"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/16_sn-1987a_cc/thumb.jpg"
    ZoomLevel="0.5335264866739617"
  >
    <Description>This frame was obtained by NTT and EMMI in 1992, with 10 minutes exposure in H-alpha. It shows an interesting honeycomb structure in the interstellar matter around supernova SN1987A, which lies at the centre of the structure, in the lower left. SN 1987A, detected in 1987 in the nearby Large Magellanic Cloud was the closest supernova for several centuries, the first visible by naked-eye for 383 years and definitely one of the most studied objects in modern astronomy. ESO telescopes have been observing SN 1987A for more than twenty years. More information in ESO Messenger 69, p34: http://www.eso.org/sci/publications/messenger/archive/no.69-sep92/messenger-no69.pdf</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0758666781028352"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.9068734529"
        CenterY="-69.2924882072"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Honeycomb structure around SN 1987A"
        OffsetX="9.26106910435e-06"
        OffsetY="9.26106910435e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.698463809563936"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/16_sn-1987a_cc/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/16_sn-1987a_cc/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/16_sn-1987a_cc/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;20171102_whya&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-11-09T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-28.367629583262836"
    Magnitude="0"
    Name="Winds blowing on a dying star"
    Opacity="100"
    RA="13.817220533344996"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/20171102_whya/thumb.jpg"
    ZoomLevel="0.015469052480874552"
  >
    <Description>Stars like our Sun constantly eject large amounts of gas and dust into space, but over their lifetimes the levels of this activity change. Scientists continually scour the skies in search of explanations for how and why these changes occur. One such stage of development is the asymptotic giant branch (AGB) near a star&amp;#x27;s end of life. Dust around these stars plays an important role in regulating stellar winds. This dust is composed of many elements — including metals — which disperse into the galaxy as the winds accelerate. Two such elements are silicon and aluminium. In space, silicon is ten times more abundant than aluminium. However, many oxygen-rich AGB stars are rich in aluminium oxide dust — the source of aluminium — but poor in silicate dust — the source of silicon. This has puzzled researchers: why is aluminium oxide dust so abundant around oxygen-rich AGB stars? A research team led by Aki Takigawa of Kyoto University have utilized a new high spatial-resolution array to obtain and analyse detailed images of the dust surrounding an AGB star. &amp;quot;Previously, there was a limit to how well we could observe stars,&amp;quot; explains Takigawa. &amp;quot;Now, thanks to the high spatial resolution of the Atacama Large Millimeter/submillimeter Array, or ALMA, we can obtain images of stars in finer detail. We pointed it toward an aluminium oxide-rich AGB star in the constellation Hydra, W Hydrae.&amp;quot; Gas molecules aluminium monoxide and silicon monoxide — AlO and SiO — accelerate around a star, eventually forming aluminium oxide and silicate dust. The team observed that AlO was distributed within three stellar radii of W Hydrae, reflecting the results of previous data. Surprisingly though, SiO was detected beyond five stellar radii, and moreover 70% of these remained gaseous, without forming into dust. &amp;quot;These results indicate that as aluminium oxide accumulates near a star, the addition of a small amount of silicate dust may trigger wind acceleration,&amp;quot; elaborates Takigawa. &amp;quot;This decreases gas density, further suppressing silicate dust formation.&amp;quot; &amp;quot;This may explain the presence of aluminium-oxide-rich but silicate-poor AGB stars.&amp;quot; These results shed light not only on the dynamics of gas and dust surrounding stars, but also on the importance of studying both together. The team plans to continue using ALMA to elucidate gas and dust dynamics in the universe.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00299801456211968"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="207.258308832"
        CenterY="-28.3676303152"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Winds blowing on a dying star"
        OffsetX="7.31937148955e-07"
        OffsetY="7.31937148955e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/20171102_whya/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO), Takigawa et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/20171102_whya/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/20171102_whya/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;ann11014a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-03-31T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.699045077437415"
    Magnitude="0"
    Name="Supernova 1994D in the galaxy NGC 4526"
    Opacity="100"
    RA="12.567501543162818"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/ann11014a/thumb.jpg"
    ZoomLevel="0.08398300168087476"
  >
    <Description>This image obtained by the Hubble Space Telescope shows the galaxy NGC 4526 and its supernova 1994D (lower left).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.012931341531519272"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="188.504052708"
        CenterY="7.70313610194"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Supernova 1994D in the galaxy NGC 4526"
        OffsetX="0.007469343527450007"
        OffsetY="0.005604165455046211"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="169.10075622098"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/ann11014a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>NASA/ESA, The Hubble Key Project Team and The High-Z Supernova Search Team</Credits>
        <CreditsUrl>https://www.eso.org/public/images/ann11014a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/ann11014a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;ann11075a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-10-21T16:40:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-44.442297457435394"
    Magnitude="0"
    Name="The Phoenix dwarf galaxy"
    Opacity="100"
    RA="1.8520556088330669"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/ann11075a/thumb.jpg"
    ZoomLevel="0.19017357129622187"
  >
    <Description>The Phoenix Dwarf, imaged here by the NASA/ESA Hubble Space Telescope, is an irregular dwarf galaxy that was discovered in 1976 by Hans-Emil Schuster and Richard Martin West. It is located in the constellation Phoenix in the southern sky, 1.44 million light-years away from Earth.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0285380194330624"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="27.7808535013"
        CenterY="-44.4423343648"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Phoenix dwarf galaxy"
        OffsetX="2.78691596026e-05"
        OffsetY="2.78691596026e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="24.459999999999965"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/ann11075a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESA/Hubble and NASA</Credits>
        <CreditsUrl>https://www.eso.org/public/images/ann11075a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/ann11075a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;ann18006a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2018-01-30T11:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.10213330914965"
    Magnitude="0"
    Name="The Tarantula Nebula region imaged with HAWK-I with the Adaptive Optics Facility"
    Opacity="100"
    RA="5.6450633617770105"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/ann18006a/thumb.jpg"
    ZoomLevel="1.2833955307069052"
  >
    <Description>This image of the dramatic star formation region 30 Doradus, also known as the Tarantula Nebula, was created from a mosaic of images taken using the HAWK-I instrument working with the Adaptive optics Facility of ESO’s Very Large Telescope in Chile. The stars are significantly sharper than the same image without adaptive optics being used, and fainter stars can be seen.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2425277090553856"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6759913272"
        CenterY="-69.1021483222"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Tarantula Nebula region imaged with HAWK-I with the Adaptive Optics Facility"
        OffsetX="1.480271661715e-05"
        OffsetY="1.480271661715e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.8199999999999998"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/ann18006a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/ann18006a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/ann18006a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;ann18006b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2018-01-30T11:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.10213330914965"
    Magnitude="0"
    Name="The Tarantula Nebula region imaged with HAWK-I without adaptive optics"
    Opacity="100"
    RA="5.6450633617770105"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/ann18006b/thumb.jpg"
    ZoomLevel="1.2833955307069052"
  >
    <Description>This image of the dramatic star formation region 30 Doradus, also known as the Tarantula Nebula, was created from a mosaic of images taken using the HAWK-I instrument working without adaptive optics.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2425277090553856"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6759913272"
        CenterY="-69.1021483222"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Tarantula Nebula region imaged with HAWK-I without adaptive optics"
        OffsetX="1.480271661715e-05"
        OffsetY="1.480271661715e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.8199999999999998"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/ann18006b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/ann18006b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/ann18006b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;ann21010a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-06T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.77492361544291"
    Magnitude="0"
    Name="CONCERTO show starts with new view of the Cat’s Paw Nebula"
    Opacity="100"
    RA="17.347424846136978"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/ann21010a/thumb.jpg"
    ZoomLevel="4.198355109212939"
  >
    <Description>This image of the star-forming region NGC 6334, also known as the Cat’s Paw Nebula, is one of the first-light images taken by the CONCERTO instrument on the APEX telescope, operated by ESO. The new observations, shown in white and pink tones, have been superimposed to an image of the same region taken in near-infrared light by ESO’s VISTA telescope at Paranal. CONCERTO is able to scan the sky at frequencies between infrared and radio waves and has been designed to look at radiation emitted by ionised carbon atoms, one of the most valuable tracers of star formation in the early cosmic ages.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.21289762500608"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="260.211622096"
        CenterY="-35.7748697755"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="CONCERTO show starts with new view of the Cat’s Paw Nebula"
        OffsetX="0.000148058792115"
        OffsetY="0.000148058792115"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-59.90000000000013"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/ann21010a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/J. Emerson/VISTA Acknowledgment: Cambridge Astronomical Survey Unit</Credits>
        <CreditsUrl>https://www.eso.org/public/images/ann21010a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/ann21010a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;ann21010b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-06T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.012041889298857"
    Magnitude="0"
    Name="CONCERTO show starts with new view of the Crab Nebula"
    Opacity="100"
    RA="5.575484094296998"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/ann21010b/thumb.jpg"
    ZoomLevel="1.16741880007536"
  >
    <Description>This image of the Crab Nebula (also known as Messier 1) in the constellation of Taurus is an overlay of one of the first-light images taken by the CONCERTO instrument on the APEX telescope, operated by ESO, with an image taken by the FORS 2 instrument on ESO’s VLT. CONCERTO’s data is the white central glow, with the colourful structures in the background coming from the VLT image. The Crab Nebula is the remnant of a supernova explosion at a distance of about 6,000 light-years, observed almost 1,000 years ago, in the year 1054.  CONCERTO is able to scan the sky at frequencies between infrared and radio waves and has been designed to look at radiation emitted by ionised carbon atoms, one of the most valuable tracers of star formation in the early cosmic ages. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1171996913016832"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.6322922235"
        CenterY="22.0120132262"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="CONCERTO show starts with new view of the Crab Nebula"
        OffsetX="2.86132058842e-05"
        OffsetY="2.86132058842e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.10000000000000023"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/ann21010b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>CONCERTO team/A. Beelen, ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/ann21010b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/ann21010b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;ann21010c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-06T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.77580197704966"
    Magnitude="0"
    Name="The Cat’s Paw Nebula as seen by CONCERTO"
    Opacity="100"
    RA="17.34762880704222"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/ann21010c/thumb.jpg"
    ZoomLevel="3.7641752301136897"
  >
    <Description>This image of the star-forming region NGC 6334, also known as the Cat’s Paw Nebula, is one of the first-light images taken by the CONCERTO instrument on the APEX telescope, operated by ESO. The total integration time is 16 minutes. CONCERTO is able to scan the sky at frequencies between infrared and radio waves and has been designed to look at radiation emitted by ionised carbon atoms, one of the most valuable tracers of star formation in the early cosmic ages.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.715707708637184"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="260.214726143"
        CenterY="-35.7757375208"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Cat’s Paw Nebula as seen by CONCERTO"
        OffsetX="0.000174733327304"
        OffsetY="0.000174733327304"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-60.120000000000246"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/ann21010c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>CONCERTO team/A. Beelen, ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/ann21010c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/ann21010c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;ann21010d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-06T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.01533436368912"
    Magnitude="0"
    Name="The Crab Nebula as seen by CONCERTO"
    Opacity="100"
    RA="5.57590411592633"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/ann21010d/thumb.jpg"
    ZoomLevel="2.153481359638963"
  >
    <Description>This image of the Crab Nebula (also known as Messier 1) in the constellation of Taurus is one of the first-light images taken by the CONCERTO instrument on APEX telescope, operated by ESO. It is the remnant of a supernova explosion at a distance of about 6,000 light-years, observed almost 1,000 years ago, in the year 1054. The total integration time is 3 minutes. CONCERTO is able to scan the sky at frequencies between infrared and radio waves and has been designed to look at radiation emitted by ionised carbon atoms, one of the most valuable tracers of star formation in the early cosmic ages.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.241286426850304"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.6386888209"
        CenterY="22.0152165481"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Crab Nebula as seen by CONCERTO"
        OffsetX="0.0001178156381105"
        OffsetY="0.0001178156381105"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/ann21010d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>CONCERTO team/A. Beelen, ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/ann21010d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/ann21010d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="1.3198323687799076"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso-2613&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T23:19:57+00:00&quot;}"
    DataSetType="Sky"
    Dec="-22.973207793306916"
    Magnitude="0"
    Name="A Milky Way cousin"
    Opacity="100"
    RA="8.556041982348717"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso-2613/thumb.jpg"
    ZoomLevel="1.3198323687799076"
  >
    <Description>NGC 2613 is a rarely imaged spiral galaxy located about 60 million light years away towards the southern constellation of Pyxis (the mariner’s compass). It is thought to resemble our own Milky Way.  This image is based on data acquired with the 1.5-metre Danish telescope at ESO’s La Silla Observatory in Chile, through three filters (B, V, R).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22457765796454396"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="128.3449444868797"
        CenterY="-22.97398093466451"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A Milky Way cousin"
        OffsetX="0.0021958230526016725"
        OffsetY="-0.0026901118195146395"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="44.84480678809"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso-2613/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/IDA/Danish 1.5 m/R. Gendler, J.-E. Ovaldsen, C. Thöne and C. Féron</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso-2613/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso-2613/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0004b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-01-28T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.02238245505049"
    Magnitude="0"
    Name="Centre of the Crab Nebula"
    Opacity="100"
    RA="5.575225660248629"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0004b/thumb.jpg"
    ZoomLevel="0.2157121422839295"
  >
    <Description>This is the central region of the Crab Nebula, the famous supernova remnant in the constellation Taurus (The Bull). It was obtained early in the night of &amp;quot;First Light&amp;quot; with the third 8.2-m VLT Unit Telescope, MELIPAL. It is a composite of several 30-sec exposures with the VLT Test Camera in three broad-band filters, B (here rendered as blue; most synchrotron emission), V (green) and R (red; mostly emission from hydrogen atoms). The Crab Pulsar is visible to the left; it is the lower of the two brightest stars near each other. The image quality is about 0.9 arcsec, and is completely determined by the external seeing caused by the atmospheric turbulence above the telescope at the time of the observation. The coloured, vertical lines to the left are artifacts of a &amp;quot;bad column&amp;quot; of the CCD. The field measures about 1.3 x 1.3 arcmin 2. This image may be compared with that of the same area that was obtained earlier with the FORS2 instrument at KUEYEN.  (see  ESO Press Photo eso9948 - The Crab Nebula in Taurus).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.026185982134663895"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.628385116"
        CenterY="22.0223462471"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centre of the Crab Nebula"
        OffsetX="2.56342415073e-05"
        OffsetY="2.5634241507299946e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="44.6893603282004"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0004b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0004b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0004b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0005a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-02-08T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.09952492000131"
    Magnitude="0"
    Name="Tarantula Nebula"
    Opacity="100"
    RA="5.645065548786642"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0005a/thumb.jpg"
    ZoomLevel="1.16879505867"
  >
    <Description>The Tarantula Nebula in the Large Magellanic Cloud (LMC) as obtained with FORS2  at KUEYEN during the night of January 31 - February 1, 2000. The LMC is a satellite galaxy to our Milky Way system, located in the southern constellation Dorado (The Swordfish) at a distance of approximately 170,000 light-years. It is a composite of three exposures in B (30 sec exposure, image quality 0.75 arcsec; here rendered in blue colour), V (15 sec, 0.70 arcsec; green) and R (10 sec, 0.60 arcsec; red). The full-resolution version of this photo retains the orginal pixels.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14750201995022"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.657649"
        CenterY="-69.094978"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Tarantula Nebula"
        OffsetX="-0.006561832811324314"
        OffsetY="-0.004517326136604163"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.2676513419513979"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0005a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0005a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0005a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0005b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-02-08T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.01586369603458"
    Magnitude="0"
    Name="Radio galaxy Centaurus A"
    Opacity="100"
    RA="13.424986279688119"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0005b/thumb.jpg"
    ZoomLevel="1.1655014492940001"
  >
    <Description>The new FORS2 image of Centaurus A, also known as NGC 5128, is an example of how frontier science can be combined with esthetic aspects. This galaxy is a most interesting object for the present attempts to understand active galaxies. It is being investigated by means of observations in all spectral regions, from radio via infrared and optical wavelengths to X- and gamma-rays. It is one of the most extensively studied objects in the southern sky. FORS2, with its large field-of-view and excellent optical resolution, makes it possible to study the global context of the active region in Centaurus A in great detail. Note for instance the great number of massive and luminous blue stars that are well resolved individually, in the upper right and lower left in ESO Press Photo eso0005b. Centaurus A is one of the foremost examples of a radio-loud active galactic nucleus (AGN). On images obtained at optical wavelengths, thick dust layers almost completely obscure the galaxy&amp;#x27;s centre. This structure was first reported by Sir John Herschel in 1847. Until 1949, NGC 5128 was thought to be a strange object in the Milky Way, but it was then identified as a powerful radio galaxy and designated Centaurus A. The distance is about 10-13 million light-years (3-4 Mpc) and the apparent visual magnitude is about 8, or 5 times too faint to be seen with the unaided eye.There is strong evidence that Centaurus A is a merger of an elliptical with a spiral galaxy, since elliptical galaxies would not have had enough dust and gas to form the young, blue stars seen along the edges of the dust lane. The core of Centaurus A is the smallest known extragalactic radio source, only 10 light-days across. A jet of high-energy particles from this centre is observed in radio and X-ray images. The core probably contains a supermassive black hole with a mass of about 100 million solar masses. This image is a composite of three exposures in B (300 sec exposure, image quality 0.60 arcsec; here rendered in blue colour), V (240 sec, 0.60 arcsec; green) and R (240 sec, 0.55 arcsec; red). The full-resolution version of this photo retains the original pixels.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.18883551232"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.36542"
        CenterY="-43.019319"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Radio galaxy Centaurus A"
        OffsetX="-0.006846676931292643"
        OffsetY="0.0034695732990576906"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.12254623951"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0005b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0005b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0005b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0005c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-02-08T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.000985704443536"
    Magnitude="0"
    Name="Centaurus A"
    Opacity="100"
    RA="13.421810258357048"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0005c/thumb.jpg"
    ZoomLevel="0.45233668822799994"
  >
    <Description>An area, north-west of the centre of Centaurus A  with a detailed view of the dust lane and clusters of luminous blue stars. The normal version of this photo retains the orginal pixels.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.057192765439999994"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.374"
        CenterY="-43.0013"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centaurus A"
        OffsetX="0.03426076250587069"
        OffsetY="0.00027852435558371763"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.04384721109"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0005c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0005c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0005c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0006b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-02-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.790444767534957"
    Magnitude="0"
    Name="Distant galaxies in &quot;AXAF Deep Field&quot;"
    Opacity="100"
    RA="3.5376994870532816"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0006b/thumb.jpg"
    ZoomLevel="0.41797740449230203"
  >
    <Description>This image is a combination of a K-band image from ANTU/ISAAC   with two images obtained in the B and R bands with the SUSI-2  optical imager at the New Technology Telescope (NTT) on La Silla. Note the relatively high density of red galaxies, visible in the upper right part of this image. The colours of most of these galaxies are consistent with those of &amp;quot;evolved&amp;quot; galaxies, already present when the Universe was only 4 billions years old. The redshift, estimated on the basis of the measured colours of the mentioned over-density of yellow galaxies, is between 0.6 and 0.7 and that of the red galaxies is between 1 and 1.4.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04570986182666039"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.0655178683"
        CenterY="-27.7904676836"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Distant galaxies in &quot;AXAF Deep Field&quot;"
        OffsetX="2.2765653839451053e-05"
        OffsetY="2.2765653839449593e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.38019362489077607"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0006b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0006b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0006b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0007a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-02-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-11.623107265316092"
    Magnitude="0"
    Name="Fine shades of a Sombrero*"
    Opacity="100"
    RA="12.666548417139012"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0007a/thumb.jpg"
    ZoomLevel="1.1517971559599998"
  >
    <Description>Image of the famous early-type spiral galaxy Messier 104, widely known as the &amp;quot;Sombrero&amp;quot; (the Mexican hat) because of its particular shape. The &amp;quot;Sombrero&amp;quot; is located in the constellation Virgo (The Virgin), at a distance of about 50 million light-years. Messier 104 is the 104th object in the famous catalogue of nebulae by French astronomer Charles Messier (1730 - 1817). It was not included in the first two editions (with 45 objects in 1774; 103 in 1781), but Messier soon thereafter added it by hand in his personal copy as a &amp;quot;very faint nebula&amp;quot;. The recession velocity, about 1000 km/sec, was first measured by American astronomer Vesto M. Slipher at the Lowell Observatory in 1912; he was also the first to detect the galaxy&amp;#x27;s rotation. This galaxy is notable for its dominant nuclear bulge, composed primarily of mature stars, and its nearly edge-on disc composed of stars, gas, and intricately structured dust. The complexity of this dust, and the high resolution of this image, is most apparent directly in front of the bright nucleus, but is also very evident as dark absorbing lanes throughout the disc. A significant fraction of the galaxy disc is even visible on the far side of the source, despite its massive bulge. A large number of small and slightly diffuse sources can be seen as a swarm in the halo of Messier 104. Most of these are globular clusters, similar to those found in our own Galaxy This picture was obtained with FORS1 multi-mode instrument at VLT ANTU on January 30, 2000. It is a composite of three exposures in different wavebands. North is up and East is left. Technical information : This composite image is based on three exposures from the FORS1 instrument at VLT ANTU. They were obtained at about 6:20 hrs UT on January 30, 2000, through V-band (central wavelength 554 nm; 112 nm Full Width Half Maximum (FWHM); exposure time 120 sec; here rendered as blue), R-band (657 nm; 150 nm FWHM; 120 sec; green) and I-band (768 nm; 138 nm FWHM, 240 sec; red). The seeing was 0.6–0.7 arcseconds. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1864646656"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="189.997503"
        CenterY="-11.623115"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Fine shades of a Sombrero*"
        OffsetX="-0.0007084078402333607"
        OffsetY="9.251135961355698e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.12272135292000001"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0007a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/P. BarthelAcknowledgments: Mark Neeser (Kapteyn Institute, Groningen) and Richard Hook (ST/ECF, Garching, Germany). </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0007a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0007a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0007b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-02-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-11.624068676446429"
    Magnitude="0"
    Name="Detail of the Sombrero galaxy"
    Opacity="100"
    RA="12.668484757724523"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0007b/thumb.jpg"
    ZoomLevel="0.60868393002"
  >
    <Description>This is the eastern area of the Sombrero Galaxy, with the pronounced dust bands and many background galaxies. North is up and East is left. Technical information : This composite image is based on three exposures from the FORS1 instrument at VLT ANTU. They were obtained at about 6:20 hrs UT on January 30, 2000, through V-band (central wavelength 554 nm; 112 nm Full Width Half Maximum (FWHM); exposure time 120 sec; here rendered as blue), R-band (657 nm; 150 nm FWHM; 120 sec; green) and I-band (768 nm; 138 nm FWHM, 240 sec; red). The seeing was 0.6 - 0.7 arcsec. Image processing by Mark Neeser (Kapteyn Institute, Groningen) and Richard Hook (ST/ECF, Garching, Germany).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11379346849608939"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="189.997503"
        CenterY="-11.623255"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of the Sombrero galaxy"
        OffsetX="-0.029158621771145546"
        OffsetY="-0.0007869527352302057"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.05592673180676345"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0007b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/P. Barthel</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0007b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0007b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0007c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-02-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-11.62747562138153"
    Magnitude="0"
    Name="Dustbands in the Sombrero Galaxy"
    Opacity="100"
    RA="12.666505549364704"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0007c/thumb.jpg"
    ZoomLevel="0.7514493395998885"
  >
    <Description>It is possible to follow the spiral structure of the Sombrero Galaxy almost all the way round. The dark areas around the stars and galaxies in the field are artefacts of the image processing.  This galaxy is notable for its dominant nuclear bulge, composed primarily of mature stars, and its nearly edge-on disk composed of stars, gas, and intricately structured dust. The complexity of this dust, and the high resolution of this image, is most apparent directly in front of the bright nucleus, but is also very evident as dark absorbing lanes throughout the disk. A significant fraction of the galaxy disk is even visible on the far side of the source, despite its massive bulge. Technical information : The image has been processed to show the numerous dust bands in the central plane. It was made by dividing the V-band image by itself smoothed with a 2D gaussian profile (sigma: 10 pix); this removes the uniform areas and enhances the high spatial frequency features, e.g. the dust bands. Image processing by Mark Neeser (Kapteyn Institute, Groningen) and Richard Hook (ST/ECF, Garching, Germany).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.113957129872384"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="189.995010146"
        CenterY="-11.6213974538"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Dustbands in the Sombrero Galaxy"
        OffsetX="-0.0025313186684525085"
        OffsetY="-0.0060735948156279765"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.10398860430000041"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0007c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/P. Barthel</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0007c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0007c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0024a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-07-28T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.20344064204452"
    Magnitude="0"
    Name="Giant elliptical galaxy NGC 1316 in Fornax Cluster"
    Opacity="100"
    RA="3.3783920771257185"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0024a/thumb.jpg"
    ZoomLevel="1.1040683823119921"
  >
    <Description>Colour composite photo of the central area of NGC 1316, a giant elliptical galaxy in the Fornax cluster of galaxies. Many dark dust clouds and lanes are visible. Some of the star-like objects in the field are globular clusters of stars that belong to the galaxy. It is based on CCD exposures, obtained with the 8.2-m VLT/ANTU telescope and the FORS-1  multi-mode instrument through B (blue), V (green-yellow) and I (here rendered as red) filters, respectively. The &amp;quot;pyramids&amp;quot; above and below the bright centre of the galaxy and the vertical lines at some of the brighter stars are caused by overexposure (&amp;quot;CCD bleeding&amp;quot;). The field measures 6.8 x 6.8 arcmin 2, with 0.2 arcsec/pixel. The image quality of this composite is about 0.9 arcsec. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11403272245294521"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="50.6799618373"
        CenterY="-37.1995246099"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Giant elliptical galaxy NGC 1316 in Fornax Cluster"
        OffsetX="0.0032455739355424025"
        OffsetY="-0.0039199789091616"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.06817438081252566"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0024a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0024a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0024a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0028a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-09-04T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="15.780843952238612"
    Magnitude="0"
    Name="Planetary Nebula Hen 2-428"
    Opacity="100"
    RA="19.218517371097754"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0028a/thumb.jpg"
    ZoomLevel="0.194809852224"
  >
    <Description>Colour composite of some of the first astronomical exposures obtained by YEPUN . The object is the planetary nebula Hen 2-428 that is located at a distance of 6,000-8,000 light-years and seen in a dense sky field, only 2° from the main plane of the Milky Way. As other planetary nebulae, it is caused by a dying star (the bluish object at the centre) that shreds its outer layers. The image is based on exposures through three optical filtres: B(lue) (10 min exposure, seeing 0.9 arcsec; here rendered as blue), V(isual) (5 min; 0.9 arcsec; green) and R(ed) (3 min; 0.9 arcsec; red). The field measures 88 x 78 arcsec 2 (1 pixel = 0.09 arcsec). North is to the lower right and East is to the lower left. The 5-day old Moon was about 90° away in the sky that was accordingly bright. The zenith angle was 44°.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.02263585792"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="288.271834"
        CenterY="15.777815"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Planetary Nebula Hen 2-428"
        OffsetX="0.0027639649139592107"
        OffsetY="-0.005836256528543133"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-143.3148580066"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0028a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0028a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0028a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0030a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-09-14T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-16.198515473991502"
    Magnitude="0"
    Name="Peering into a star factory"
    Opacity="100"
    RA="18.34043210142113"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0030a/thumb.jpg"
    ZoomLevel="0.8179781777999999"
  >
    <Description>This is a near-infrared, colour-coded composite image of a sky field in the south-western part of the galactic star-forming region Messier 17. In this image, young and heavily obscured stars are recognized by their red colour. Bluer objects are either foreground stars or well-developed massive stars whose intense light ionizes the hydrogen in this region. The diffuse light that is visible nearly everywhere in the photo is due to emission from hydrogen atoms that have (re-)combined from protons and electrons. The dark areas are due to obscuration of the light from background objects by large amounts of dust — this effect also causes many of those stars to appear quite red. A cluster of young stars in the upper-left part of the photo, so deeply embedded in the nebula that it is invisible in optical light, is well visible in this infrared image. Technical information : The exposures were made through three filtres, J (at wavelength 1.25 µm; exposure time 5 min; here rendered as blue), H (1.65 µm; 5 min; green) and Ks (2.2 µm; 5 min; red); an additional 15 min was spent on separate sky frames. The seeing was 0.5 - 0.6 arcsec. The objects in the uppermost left corner area appear somewhat elongated because of a colour-dependent aberration introduced at the edge by the large-field optics. The sky field shown measures approx. 5 x 5 arcmin 2 (corresponding to about 3% of the full moon). North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0843973212086331"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="275.108213"
        CenterY="-16.17704"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Peering into a star factory"
        OffsetX="0.001626573789392209"
        OffsetY="-0.021478248210909403"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.09648566662490922"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0030a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0030a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0030a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0031a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-10-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.97533180060528"
    Magnitude="0"
    Name="R Coronae Australis Complex"
    Opacity="100"
    RA="19.032059431459235"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0031a/thumb.jpg"
    ZoomLevel="5.382672717504001"
  >
    <Description>This is a colour photo of the R Coronae Australis  region in the southern Milky Way, obtained with the Wide Field Imager (WFI) (camera) at the 2.2-m MPG/ESO Telescope on La Silla (Chile). It is based on a series of CCD exposures through optical B-, V- and R-filters, here rendered as blue, green and red, respectively. The sky field shown measures approx. 33.7 x 31.9 arcmin (about the diameter of the full moon). Tecnical information : The observations were obtained on the night of 30 August 2000. The image is a combination of twelve large (8000 x 8000 pix) CCD frames taken through B, V, and R filters. Four exposures of 5 min each were obtained in each filter, with the telescope pointing at slightly different positions so that the gaps among the eight individual CCD-chips of the detector can be adequately filled. All frames were carefully aligned, and the intensity levels were cut in order to achieve the proper colour balance. A logarithmic intensity scale was used to improve the dynamical range. This image displays the full field and was rebinned to a smaller scale in order to allow transportation over the web. The images were prepared by Fernando Comeron (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.082650886644588"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="285.473822"
        CenterY="-36.95263"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="R Coronae Australis Complex"
        OffsetX="-0.005690797224140117"
        OffsetY="-0.022691234471446418"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1086364572780129"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0031a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0031a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0031a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0031b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-10-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.99487424749938"
    Magnitude="0"
    Name="R Coronae Australis Complex (detail)"
    Opacity="100"
    RA="19.02773563268757"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0031b/thumb.jpg"
    ZoomLevel="2.018513832192"
  >
    <Description>This is a colour photo of a small area of about 12 x 12 arcmin 2, near the centre of the R Coronae Australis  region in the southern Milky Way, obtained with the Wide Field Imager (WFI) (camera) at the 2.2-m MPG/ESO Telescope on La Silla (Chile). It is based on a series of CCD exposures through optical B-, V- and R-filters, here rendered as blue, green and red, respectively. The sky field shown measures approx. 33.7 x 31.9 arcmin 2 (about the diameter of the full moon).  . North is up and East is left. Tecnical information : The observations were obtained on the night of 30 August 2000. The image is a combination of twelve large (8000 x 8000 pix) CCD frames taken through B, V, and R filters. Four exposures of 5 min each were obtained in each filter, with the telescope pointing at slightly different positions so that the gaps among the eight individual CCD-chips of the detector can be adequately filled. All frames were carefully aligned, and the intensity levels were cut in order to achieve the proper colour balance. A logarithmic intensity scale was used to improve the dynamical range. The image shows part of this field at the original resolution. The images were prepared by Fernando Comeron (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.26831242273557104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="285.473535"
        CenterY="-36.952387"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="R Coronae Australis Complex (detail)"
        OffsetX="0.04580884631757334"
        OffsetY="-0.04262825908459889"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.15643923332098122"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0031b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0031b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0031b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0034a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-10-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-51.97674554019535"
    Magnitude="0"
    Name="Sky field around GRB 000131"
    Opacity="100"
    RA="6.224469709352543"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0034a/thumb.jpg"
    ZoomLevel="1.1648885545449428"
  >
    <Description>Colour composite image of the sky field around the position of the gamma-ray burst GRB 000131 that was detected on January 31, 2000. It is based on images obtained with the ESO Very Large Telescope at Paranal. The object is indicated with an arrow, near a rather bright star (magnitude 9, i.e., over 1 million times brighter than the faintest objects visible on this photo). This and other bright objects in the field are responsible for various unavoidable imaging effects, caused by optical reflections (ring-shaped &amp;quot;ghost images&amp;quot;, e.g. to the left of the brightest star) and detector saturation effects (horizontal and vertical straight lines and coloured &amp;quot;coronae&amp;quot; at the bright objects, and areas of &amp;quot;bleeding&amp;quot;, e.g. below the bright star). Technical information: The photo is based on three 8-min exposures obtained with VLT ANTU and the multi-mode FORS1 instrument. The optical filters were B (seeing 0.9 arcsec; here rendered as blue), V (0.8 arcsec; green) and R (0.7 arcsec; red). The field measures 6.8 x 6.8 arcmin 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11420476024950418"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="93.3569318138"
        CenterY="-51.9800201443"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Sky field around GRB 000131"
        OffsetX="-0.006138616270178296"
        OffsetY="0.0034446911444165882"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.557240183592417"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0034a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0034a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0034a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0037a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-10-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-48.862816042402464"
    Magnitude="0"
    Name="Infrared wide angle view of RCW 108"
    Opacity="100"
    RA="16.666591629742154"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0037a/thumb.jpg"
    ZoomLevel="2.1536432469599998"
  >
    <Description>Image showing a unique, wide-field infrared view of the region around IRAS 16362-4845, an &amp;quot;emission&amp;quot; nebula that shines by its own light. It is situated within a dark cloud in a Milky Way region (the &amp;quot;RCW 108 complex&amp;quot;) at a distance of about 4,000 light-years in the direction of the Southern constellation of Ara (the Altar). The dark cloud is seen silhouetted against the rich background of stars in the Milky Way, whose light is blocked by the dust particles in the cloud. The photo is based on approx. 600 individual exposures with the SOFI  instrument at the 3.58-m ESO New Technology Telescope (NTT). The field-of-view measures about 13 x 13 arcmin^2, coresponding to 17 x 17 light-years^2. Technical information: this image was obtained in February 2000 by means of SOFI, the infrared camera and spectrograph at the ESO 3.58-m New Technology Telescope (NTT). The image is a mosaic that was prepared by combining 33 overlapping frames, taken in each of the J (wavelength 1.25 µm; here rendered as blue), H (1.65 µm; green) and K (2.2 µm; red) infrared filters. Each individual frame is in turn a stack of six frames totaling 12 sec exposure time, with the exception of the one covering the center of the region which is 15 times longer in order to increase the sensitivity around the central emission nebula (an HII region). The total area imaged is 12.8 x 12.8 arcmin^2, using SOFI in its normal resolution mode with 0.29 arcsec pixels and a field of about 5 arcmin. Thus the field shown here is about 6.6 times the field-of-view in a single SOFI frame. Five-sigma detection limits in the least-exposed areas of the image are typically J=18.6, H=17.7, K=17.2 mag. The image quality is between 0.6 and 0.7 arcsec for the different filters over most of the field. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.35922557121528553"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="250.000686"
        CenterY="-48.86257"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Infrared wide angle view of RCW 108"
        OffsetX="0.0011906934999296442"
        OffsetY="-0.00025116391401484373"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.24495036060276595"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0037a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0037a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0037a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0037b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2000-10-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-48.850120340635065"
    Magnitude="0"
    Name="Infrared wide angle view of RCW 108 (detail)"
    Opacity="100"
    RA="16.66864495246851"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0037b/thumb.jpg"
    ZoomLevel="1.122723574128"
  >
    <Description>This image shows an area  near the centre of a unique, wide-field infrared view of the region around IRAS 16362-4845, an &amp;quot;emission&amp;quot; nebula that shines by its own light. It is situated within a dark cloud in a Milky Way region (the &amp;quot;RCW 108 complex&amp;quot;) at a distance of about 4,000 light-years in the direction of the Southern constellation of Ara (the Altar). The dark cloud is seen silhouetted against the rich background of stars in the Milky Way, whose light is blocked by the dust particles in the cloud. The photo is based on approx. 600 individual exposures with the SOFI  instrument at the 3.58-m ESO New Technology Telescope (NTT).  Technical information: this image was obtained in February 2000 by means of SOFI, the infrared camera and spectrograph at the ESO 3.58-m New Technology Telescope (NTT). It is a smaller area near the centre of the field; it measures approx. 6.3 x 6.6 arcmin^2. North is up and East is left. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.17890895423390474"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="250.000686"
        CenterY="-48.86257"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Infrared wide angle view of RCW 108 (detail)"
        OffsetX="-0.019055633610541828"
        OffsetY="0.012475233824297953"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.08993610937155032"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0037b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0037b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0037b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0102a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-01-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-23.832719353896582"
    Magnitude="0"
    Name="How to become a star"
    Opacity="100"
    RA="17.377616161486444"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0102a/thumb.jpg"
    ZoomLevel="1.161895411572"
  >
    <Description>This image shows a colour composite of visible and near-infrared images of the dark cloud Barnard 68. It was obtained with the 8.2-m VLT ANTU telescope and the multimode FORS1 instrument in March 1999. At these wavelengths, the small cloud is completely opaque because of the obscuring effect of dust particles in its interior. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22255222784000003"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="260.659294"
        CenterY="-23.826164"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="How to become a star"
        OffsetX="-0.004534637394480586"
        OffsetY="-0.006549782943271372"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.07145245634"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0102a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0102a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0102a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0102b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-01-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-23.83163425985046"
    Magnitude="0"
    Name="Bok globule B68"
    Opacity="100"
    RA="17.377584212964514"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0102b/thumb.jpg"
    ZoomLevel="0.8206954884"
  >
    <Description>This view of the dark cloud B68, a so-called Bok globule,  is a false-colour composite based on a visible (here rendered as blue), a near-infrared (green) and an infrared (red) image. Since the light from stars behind the cloud is only visible at the longest (infrared) wavelengths, they appear red.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14416691199999998"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="260.659371"
        CenterY="-23.826228"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Bok globule B68"
        OffsetX="-0.004023202161602359"
        OffsetY="-0.005402230001602859"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.058316647200000016"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0102b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0102b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0102b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0104a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-01-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-5.384621266402692"
    Magnitude="0"
    Name="The Orion Nebula*"
    Opacity="100"
    RA="5.587651694460556"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0104a/thumb.jpg"
    ZoomLevel="1.1742477495804113"
  >
    <Description>This photo shows a colour composite mosaic image of the central part of the Orion Nebula, based on 81 images obtained with the infrared multi-mode ISAAC instrument on the ESO Very Large Telescope (VLT) at the Paranal Observatory. The famous Trapezium stars are seen near the centre and the photo also shows the associated cluster of about 1,000 stars, approximately one million years old. This image is available as a mounted image in the ESOshop.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1681672814145536"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.811506336"
        CenterY="-5.38331259103"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Orion Nebula*"
        OffsetX="-0.0032550078807733343"
        OffsetY="-0.0013078063255964213"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.015451480759998132"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0104a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M.McCaughrean et al. (AIP)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0104a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0104a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0104c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-01-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-5.410207509767114"
    Magnitude="0"
    Name="The Orion Nebula: The jewel in the sword"
    Opacity="100"
    RA="5.58758271281284"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0104c/thumb.jpg"
    ZoomLevel="0.6530342365701647"
  >
    <Description>This image shows smaller, particularly interesting areas of ESO Press Photo eso0104a. It shows the delicate tracery created at the so-called Bright Bar, as the intense UV-light and strong winds from the hot Trapezium stars eat their way into the surrounding molecular cloud. Also visible are a number of very young red objects partly hidden in the cloud, waiting to be revealed as new members of the Trapezium Cluster.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0840506609160192"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.813761297"
        CenterY="-5.41022803711"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Orion Nebula: The jewel in the sword"
        OffsetX="2.05201808877e-05"
        OffsetY="2.05201808877e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.019999999999999993"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0104c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M.McCaughrean et al. (AIP)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0104c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0104c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0106a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-02-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-16.013219650380634"
    Magnitude="0"
    Name="The Milky Way star field around CS 31082-001"
    Opacity="100"
    RA="1.4919523991766868"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0106a/thumb.jpg"
    ZoomLevel="1.1749589698735106"
  >
    <Description>The Milky Way star field around CS 31082-001, the 12th-magnitude star at the centre. The &amp;quot;cross&amp;quot; is caused by reflections in the telescope optics, a typical effect for relatively bright stars.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.18119303411801976"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="22.396077409"
        CenterY="-16.0172208166"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Milky Way star field around CS 31082-001"
        OffsetX="0.016243879753536205"
        OffsetY="0.0035547548491118067"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.57724074177"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0106a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>AURA</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0106a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0106a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0109a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-03-08T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.018376497578835"
    Magnitude="0"
    Name="The heavily obscured centre of Centaurus A"
    Opacity="100"
    RA="13.42415950498835"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0109a/thumb.jpg"
    ZoomLevel="0.219226661778609"
  >
    <Description>A small area in the direction of the heavily obscured centre of the peculiar radio galaxy Centaurus A, as seen in visual light. It measures about 80 x 80 arcsec 2, or 4400 x 4400 light-year 2 at the distance of this galaxy, and has been reproduced from exposures made with the FORS2 multi-mode instrument at the 8.2-m VLT KUEYEN telescope at Paranal.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.032461117135360006"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.362435887"
        CenterY="-43.0183924141"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The heavily obscured centre of Centaurus A"
        OffsetX="3.1700309702500005e-05"
        OffsetY="1.5850154851250003e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.12000000000000048"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0109a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0109a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0109a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0116a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-04-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.593114146450652"
    Magnitude="0"
    Name="The Capodimonte Deep Field"
    Opacity="100"
    RA="12.405909604887183"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0116a/thumb.jpg"
    ZoomLevel="5.2093034685303"
  >
    <Description>This is a three-colour image of about 1/4 of the Capodimonte Deep Field (OACDF) obtained with the Wide-Field Imager (WFI) on the MPG/ESO 2.2-m telescope at the la Silla Observatory. It covers &amp;quot;OACDF Subfield no. 2 (OACDF2)&amp;quot; with an area of about 35 x 32 arcmin 2 (about the size of the full moon), and it is one of the &amp;quot;deepest&amp;quot; wide-field images ever obtained.  It has been obtained by the combination of the B, V, and R stacked images of the OACDF2 field. The total exposure times in the three bands are 2 hours in B and V (12 ditherings of 10 min each were stacked to produce the B and V images) and 3 hours in R (13 ditherings of 15 min each). The mosaic images in the B and V bands were aligned relative to the R-band image and adjusted to a logarithmic intensity scale prior to the combination. The typical seeing was of the order of 1 arcsec in each of the three bands. Preliminary estimates of the three-sigma limiting magnitudes in B, V and R indicate 25.5, 25.0 and 25.0, respectively. More than 35,000 objects are detected above the three-sigma level. Technical information : this image has been obtained by the combination of the B, V, and R stacked images of the OACDF2 field. The total exposure times in the three bands are 2 hours in B and V (12 ditherings of 10 min each were stacked to produce the B and V images) and 3 hours in R (13 ditherings of 15 min each). The mosaic images in the B and V bands were aligned relative to the R-band image and adjusted to a logarithmic intensity scale prior to the combination. The typical seeing was of the order of 1 arcsec in each of the three bands. Preliminary estimates of the three-sigma limiting magnitudes in B, V and R indicate 25.5, 25.0 and 25.0, respectively. More than 35,000 objects are detected above the three-sigma level. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.811125569536"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="186.08874567"
        CenterY="-12.593312106"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Capodimonte Deep Field"
        OffsetX="9.901435175e-05"
        OffsetY="0.0001980287035"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.04000000000009033"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0116a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0116a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0116a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0116b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-04-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.376822573469141"
    Magnitude="0"
    Name="Interacting galaxies in the Capodimonte Deep Field"
    Opacity="100"
    RA="12.418958795181062"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0116b/thumb.jpg"
    ZoomLevel="0.7425683767825564"
  >
    <Description>This is an image of interacting galaxies that are seen in the Capodimonte Deep Field. The enlargement covers 1250 x 1130 WFI pixels (1 pixel = 0.24 arcsec), or about 5.0 x 4.5 arcmin 2 in the sky. The lower spiral is itself an interactive double. Technical information: this image displays selected areas of the field shown in ESO Press Photo eso0116a at the original WFI scale, hereby also demonstrating the enormous amount of information contained in these wide-field images. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1130372114681856"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="186.284396089"
        CenterY="-12.3768363382"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Interacting galaxies in the Capodimonte Deep Field"
        OffsetX="1.379848772805e-05"
        OffsetY="1.379848772805e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.14"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0116b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0116b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0116b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0116c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-04-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.479998554872633"
    Magnitude="0"
    Name="Celestial objects in the Capodimonte Deep Field"
    Opacity="100"
    RA="12.40605991357876"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0116c/thumb.jpg"
    ZoomLevel="0.500702217336"
  >
    <Description>This image shows a spiral galaxy and a nebulous object in the Capodimonte Deep Field. The field shown covers 1250 x 750 pixels, or about 5 x 3 arcmin 2 in the sky. Note the very red objects next to the two bright stars in the lower-right corner. The colours of these objects are consistent with those of spheroidal galaxies at intermediate distances (redshifts). Technical information: this image displays selected areas of the field shown in ESO Press Photo eso0116a at the original WFI scale, hereby also demonstrating the enormous amount of information contained in these wide-field images. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.10951323648"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="186.250194"
        CenterY="-12.816549"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Celestial objects in the Capodimonte Deep Field"
        OffsetX="0.1537420411929765"
        OffsetY="0.33733026456688686"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.30481170254999995"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0116c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0116c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0116c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0116d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-04-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.658727367967254"
    Magnitude="0"
    Name="Galaxy cluster in the Capodimonte Deep Field"
    Opacity="100"
    RA="12.391242411714007"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0116d/thumb.jpg"
    ZoomLevel="1.0662381171692363"
  >
    <Description>This is an enlargement of a galaxy cluster of the Capodimonte Deep Field, which most members are located in the north-east quadrant (upper left) and have a reddish colour. The nebulous object to the upper left is a dwarf galaxy of spheroidal shape. The red object, located near the centre of the field and resembling a double star, is very likely a gravitational lens. Some of the very red, point-like objects in the field may be distant quasars, very-low mass stars or, possibly, relatively nearby brown dwarf stars. The field shown covers 1380 x 1630 pixels, or 5.5 x 6.5 arcmin 2. Technical information: this image displays selected areas of the field shown in ESO Press Photo eso0116a at the original WFI scale, hereby also demonstrating the enormous amount of information contained in these wide-field images. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1363591647285248"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="185.868653206"
        CenterY="-12.6587440424"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy cluster in the Capodimonte Deep Field"
        OffsetX="1.664540585065e-05"
        OffsetY="1.664540585065e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0116d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0116d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0116d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0116e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-04-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.813474269571762"
    Magnitude="0"
    Name="Galaxy cluster in the Capodimonte Deep Field"
    Opacity="100"
    RA="12.41282614678638"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0116e/thumb.jpg"
    ZoomLevel="0.7276979706356504"
  >
    <Description>This image shows an enlargement of a moderately distant galaxy cluster in the south-east quadrant (lower left) of the Capodimonte Deep Field. The field measures 1380 x 1260 pixels, or about 5.5 x 5.0 arcmin 2 in the sky. Technical information: this image displays selected areas of the field shown in ESO Press Photo eso0116a at the original WFI scale, hereby also demonstrating the enormous amount of information contained in these wide-field images. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1170755910524928"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="186.192406848"
        CenterY="-12.813488571"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy cluster in the Capodimonte Deep Field"
        OffsetX="1.42914539859e-05"
        OffsetY="1.42914539859e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.039999999999999966"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0116e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0116e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0116e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0116f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-04-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.554638283307554"
    Magnitude="0"
    Name="The Capodimonte Deep Field"
    Opacity="100"
    RA="12.389051499432876"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0116f/thumb.jpg"
    ZoomLevel="0.8303713387785093"
  >
    <Description>This image shows an enlargement of an elliptical galaxy that is located to the west (right) in the Capodimonte Deep Field. The numerous tiny objects surrounding the galaxy may be globular clusters. The fuzzy object on the right edge of the field may be a dwarf spheroidal galaxy. The size of the field is about 6 x 5 arcmin 2. Technical information: this image displays selected areas of the field shown in ESO Press Photo eso0116a at the original WFI scale, hereby also demonstrating the enormous amount of information contained in these wide-field images. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1408749804765184"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="185.835790134"
        CenterY="-12.5546726646"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Capodimonte Deep Field"
        OffsetX="1.71966528902e-05"
        OffsetY="3.43933057804e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.04000000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0116f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0116f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0116f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0122a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-05-31T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.86552051100258"
    Magnitude="0"
    Name="Quasar HE 1013-2136 with tidal tails"
    Opacity="100"
    RA="10.264549056227475"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0122a/thumb.jpg"
    ZoomLevel="0.0964106362685058"
  >
    <Description>This photograph shows an image of the Quasar HE 1013-2136 (center) and its surroundings, as obtained with the FORS2 multi-mode instrument at the 8.2-m VLT KUEYEN telescope in February 2001. A spectacular arc-like tidal tail stretches from the quasar towards south-east (lower-left) over a distance of more than 150,000 light-years. Another, shorter tidal tail towards the east-northeast is barely visible. Technical information: this image is based on an image that was obtained in the morning of February 26, 2001 with the FORS2 instrument on VLT KUEYEN. It is composed of eight exposures in the I-band filter (effective wavelength 768 nm; FWHM 138 nm), lasting a total of 32 min. The combined image has a FWHM of 0.6 arcsec. The field shown measures 33 x 33 arcsec 2, or 540,000 x 540,000 light-years 2 projected at the distance of the quasar; 1 pixel = 0.2 arcsec. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.012298439287808"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="153.968242314"
        CenterY="-21.8655265161"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Quasar HE 1013-2136 with tidal tails"
        OffsetX="6.0050973085e-06"
        OffsetY="6.0050973085e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0122a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0122a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0122a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0122b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-05-31T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.865397699498327"
    Magnitude="0"
    Name="Quasar HE 1013-2136 with tidal tails"
    Opacity="100"
    RA="10.264563613457454"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0122b/thumb.jpg"
    ZoomLevel="0.107107477008"
  >
    <Description>This photograph shows an image of the Quasar HE 1013-2136 (center) and its surroundings sharpened with a computer algorithm to bring out more details in the immediate neighbourhood of the quasar. Now numerous details can be recognized within the two tidal tails, including various knotty structures. In particular, a very close companion galaxy at 20,000 light-years projected distance to the quasar can now be seen (at the 5 o&amp;#x27;&amp;#x27;clock position) that may be in gravitational interaction with the quasar host galaxy. Quasar activity is believed to be triggered by such dramatic events. Technical information: this image has been processed by applying the Lucy algorithm with 15 iterations. The field shown measures 33 x 33 arcsec 2, or 540,000 x 540,000 light-years 2 projected at the distance of the quasar; 1 pixel = 0.2 arcsec. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.013803274240000002"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="153.968404"
        CenterY="-21.865644"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Quasar HE 1013-2136 with tidal tails"
        OffsetX="3.281598284605519e-05"
        OffsetY="0.00024851098707874395"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="18.23396487547"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0122b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0122b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0122b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0124a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-06-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-5.392250457657111"
    Magnitude="0"
    Name="The Trapezium cluster"
    Opacity="100"
    RA="5.587517080690139"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0124a/thumb.jpg"
    ZoomLevel="0.7909522076645243"
  >
    <Description>This image shows a colour composite of near-infrared images of the central regions of the Orion Nebula, obtained on March 14, 2000, with the SOFI instrument at the ESO 3.5-m New Technology Telescope (NTT) at La Silla. Three exposures were made through J- (wavelength 1.25 µm here colour-coded as &amp;quot;blue&amp;quot;), H- (1.65 µm; &amp;quot;green&amp;quot;) and Ks-filters (2.16 µm; &amp;quot;red&amp;quot;), respectively. The central group of bright stars is the famous &amp;quot;Trapezium&amp;quot; . The total effective exposure time was 86.4 seconds per band. The sky field measures about 4.9 x 4.9 arcmin 2 (1024 x 1024 pix 2). North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.09549657017774078"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8127794158"
        CenterY="-5.39229719216"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Trapezium cluster"
        OffsetX="2.3314592328549996e-05"
        OffsetY="4.662918465709999e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.2599999999999997"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0124a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0124a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0124a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0136a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-11-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.86740758388879"
    Magnitude="0"
    Name="An infrared portrait of the barred spiral galaxy Messier 83"
    Opacity="100"
    RA="13.616323170805032"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0136a/thumb.jpg"
    ZoomLevel="1.4877638201099999"
  >
    <Description>The image is a false-colour infrared photo of the nearby barred spiral galaxy Messier 83. It is based on the combination of three images obtained in the Ks- (wavelength 2.2 µm), J- (1.2 µm) and I-bands (0.8 µm), respectively. The first two were recorded with the SOFI instrument at the ESO 3.5-m New Technology Telescope , the third with the DFOSC instrument at the Danish 1.54-m telescope, both at the La Silla Observatory. Technical information: This image of Messier 83 is based on a composite of three images in the filters Ks (NTT + SOFI ; wavelength 2.162 µm; Full-Width-Half-Maximum (FWHM) 0.275 µm; total exposure time on target 49 min; approx. 12 min per quadrant; here rendered as red); J (NTT + SOFI; 1.247 µm; 0.290 µm; 22 min; 5 min; green), and I (Danish 1.54-m + DFOSC ; 0.797 µm; 0.142 µm; 20 min; full-field coverage; blue). As indicated, the Ks and J images were created from exposures of four neighbouring fields. These images were taken in May 2001 during a period with 1.0 arcsec average seeing. The original frames have 1024 x 1024 pixels, each measuring 0.29 arcsec. The resulting mosaic was created from 31 Ks-band object frames and 17 J-band object frames, each with 100 sec exposure time. From each object frame, a sky frame with the same exposure time was subtracted to remove the sky contribution. The final size of the mosaic image is 1905 x 1839 pixels (9.2 x 8.9 arcmin). The I image was observed in February 1998 by Søren Larsen (more information about this image is available in &amp;quot;Astronomy and Astrophysics Supplement&amp;quot;, Vol 139, p.393-415, 1999 and at URL: http://nedwww.ipac.caltech.edu/). The original frame size was 2036 x 2042 pixels, each measuring 0.39 arcsec. The pixel size and the field-of-view of this image was changed to match the characteristics of the Ks and J images. North is up and east to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2711934976"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="204.253991"
        CenterY="-29.865596"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="An infrared portrait of the barred spiral galaxy Messier 83"
        OffsetX="0.007932355201949058"
        OffsetY="-0.0017971890143654687"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.10627298932000001"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0136a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0136a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0136a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0137d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-12-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-61.26071013529613"
    Magnitude="0"
    Name="The star-forming region around NGC 3603"
    Opacity="100"
    RA="11.252135731814096"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0137d/thumb.jpg"
    ZoomLevel="0.5650188438599999"
  >
    <Description>The sky area shown in the NAOS-CONICA high-resolution image is indicated on an earlier image of a much larger area, obtained in 1999 with the ISAAC multi-mode instrument on VLT ANTU (ESO Press Release eso9946)</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0841594368"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="168.788166"
        CenterY="-61.271524"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The star-forming region around NGC 3603"
        OffsetX="0.0029678904849972615"
        OffsetY="0.01080813921636083"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1082376931"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0137d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0137d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0137d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0142a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-12-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.829770644580888"
    Magnitude="0"
    Name="The Eagle's EGGs *"
    Opacity="100"
    RA="18.314711102053824"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0142a/thumb.jpg"
    ZoomLevel="1.5635638425600002"
  >
    <Description>Messier 16 (M16), also known as the Eagle Nebula, is located in the southern constellation of Serpens (the Snake). Using the infrared multi-mode ISAAC instrument on the 8.2-m VLT ANTU telescope, European astronomers were able to image the Eagle Nebula at near-infrared wavelength.  The ISAAC near-infrared images cover a 9 x 9 arcminutes region, in three broad-band colours and with sufficient sensitivity to detect young stars of all masses and — most importantly — with an image sharpness as good as 0.35 arcseconds. The wide-field view of M16 shows that there is much happening in the region. The first impression one gets is of an enormous number of stars. Those which are blue in the infrared image are either members of the young NGC 6611 cluster — whose massive stars are concentrated in the upper right (north west) part of the field — or foreground stars which happen to lie along the line of sight towards M16. Most of the stars are fainter and more yellow. They are ordinary stars behind M16, along the line of sight through the galactic bulge, and are seen through the molecular clouds out of which NGC 6611 formed. Some very red stars are also seen: these are either very young and embedded in gas and dust clouds, or just brighter stars in the background shining through them. This photo is the result of a three-colour composite mosaic image of the Eagle Nebula (Messier 16), based on 144 individual images obtained with the infrared multi-mode instrument ISAAC on the ESO Very Large Telescope (VLT) at the Paranal Observatory. At the centre, the so-called &amp;quot;Pillars of Creation&amp;quot; can be seen. This wide-field infrared image shows not only the central three pillars but also several others in the same star-forming region, as well as a huge number of stars in front of, in, or behind the Eagle Nebula. The cluster of bright blue stars to the upper right is NGC 6611, home to the massive and hot stars that illuminate the pillars. Technical information: This image was made using the near-infrared camera ISAAC on the ESO 8.2-m VLT ANTU telescope on April 8 and May 8 - 10, 2001. The full field measures approximately 9.1 x 9.1 arcmin, covering roughly 17 x 17 light-years (5.3 x 5.3 pc) at the distance to the region (about 6,500 light-years or 2 kpc). This required a 16-position mosaic (4 x 4 grid) of ISAAC pointings : at each pointing, a series of images were taken in each of the near-infrared J s - (centred at 1.24 µm wavelength), H- (1.65µm), and K s - (2.16 µm) bands. North is up and East left.The total integration time for each pixel in the mosaic was 1200, 300, and 300 seconds in the central 4.5 x 4.5 arcmin region, and 200, 50, and 50 seconds in the outer part, in J s -, H-, and K s - bands, respectively. The seeing FWHM (full width at half maximum) was excellent, at 0.38, 0.36, and 0.33 arcsec in J s, H, and K s, respectively. Point sources are detected in the central region at the 3-sigma level (brightest pixel above background noise) at 22.6, 21.3, and 20.4 magnitudes in J s, H, and K s, respectively. These limits imply that a 1 million year old, 0.075 solar-mass object on the star/brown dwarf boundary could be detected in M16 through roughly 15, 20, and 30 magnitudes of visual extinction at J s, H, and K s, respectively.After removal of instrumental signatures and the bright infrared sky background, all frames in a given band were carefully aligned and adjusted to form a seamless mosaic. The three monochromatic mosaics were then scaled to the cube root of their intensities to reduce the enormous dynamic range and enhance faint nebular features. The mosaics were then combined to create the colour-coded image, with the J s -band being rendered as blue, the H-band as green, and the K s -band as red. A total of 144 individual 1024 x 1024 pixel ISAAC images were merged to form this mosaic.   #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.17724154867714892"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.699819"
        CenterY="-13.807084"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Eagle's EGGs *"
        OffsetX="-0.02027858886220245"
        OffsetY="-0.022655853534965312"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.08951634991216502"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0142a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M.McCaughrean &amp;amp; M.Andersen (AIP)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0142a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0142a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0142b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-12-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.838597324750472"
    Magnitude="0"
    Name="The ISAAC infrared images of Messier 16"
    Opacity="100"
    RA="18.314896395289463"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0142b/thumb.jpg"
    ZoomLevel="0.675324143472"
  >
    <Description>This shows a zoom into the centre of ESO Press Photo eso0142a, with the infrared view of the columns and their immediate surroundings in more detail. The pillars or columns are numbered 1 to 3 from left to right (east to west). The pillars themselves are less prominent than on the Hubble visible-light image of this region - this because near-infrared light penetrates the thinner parts of the gas and dust clouds and only the heads remain opaque. A number of red objects can be seen associated with the pillars : some of these are just background sources seen through the dust, but some are probably real young stars embedded in the pillars. The purple arc near the bottom of the picture is Herbig-Haro object 216, a fast-moving clump of heated gas emanating from a young star (see also ESO Press Photo eso0142e). Technical information: This image shows an enlarged section of the full mosaic covering 6.2 x 7.5 light-years (1.9 x 2.3 pc) centred on the pillars. North is up and East left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08442994688"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.70004"
        CenterY="-13.820092"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The ISAAC infrared images of Messier 16"
        OffsetX="-0.0227578422070229"
        OffsetY="-0.01846792463562831"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.09702325758"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0142b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M.McCaughrean &amp;amp; M.Andersen (AIP)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0142b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0142b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0142c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-12-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.816138367621921"
    Magnitude="0"
    Name="Head of column No. 1 in Eagle Nebula"
    Opacity="100"
    RA="18.31423568664083"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0142c/thumb.jpg"
    ZoomLevel="0.12662090045399998"
  >
    <Description>Enlarged view of the head of the largest of the three main pillars, Column 1. The head is almost transparent around the edges at near-infrared wavelengths, but there is still a substantial opaque core which even these near-infrared VLT observations cannot penetrate. The complex bluish nebulosity bisected by a dark lane near the tip is being lit up by the bright yellow star just below it, which appears to be very young and rather massive. Several of the much fainter stars to the right of and below this source are found to be associated with EGGs seen in the Hubble image, and these all have much lower masses. Finally, there is a faint streak of blue light emanating from from the tip of EGG 23, one of the darkest parts of Column 1, ending in a blue blob further north. An equal distance to the south of the EGG and off the head, there is another curving blue nebulosity. These features are also seen in the Hubble image, and may be part of a Herbig-Haro jet coming from a young star buried deeply in EGG 23 and invisible in this image. Technical information: The region shown measures 1.9 x 2.8 light-years (0.6 x 0.9 pc). The intensity scalings have been adjusted to better show the young stars embedded in the head of each column. North is up and East left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.02122161152"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.700185"
        CenterY="-13.819953"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Head of column No. 1 in Eagle Nebula"
        OffsetX="-0.012937193122792517"
        OffsetY="0.003904349047080714"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.39851629223"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0142c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M.McCaughrean &amp;amp; M.Andersen (AIP)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0142c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0142c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0142d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-12-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.832591432706609"
    Magnitude="0"
    Name="Head of column No. 2 in Eagle Nebula"
    Opacity="100"
    RA="18.313737654685156"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0142d/thumb.jpg"
    ZoomLevel="0.115938086004"
  >
    <Description>Enlarged view of the head of Column 2. The bright blue-yellow source embedded in nebulosity near the tip is another young star unseen in the Hubble images: although it appears to be double here, it is in fact just one relatively massive young star surrounding by nebulosity. Technical information: The region shown measures 1.9 x 2.8 light-years (0.6 x 0.9 pc). The intensity scalings have been adjusted to better show the young stars embedded in the head of each column. North is up and East left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.01946366976"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.70004"
        CenterY="-13.820092"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Head of column No. 2 in Eagle Nebula"
        OffsetX="-0.006568135003594977"
        OffsetY="-0.012137579305003934"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="3.33880678071"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0142d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M.McCaughrean &amp;amp; M.Andersen (AIP)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0142d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0142d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0142e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2001-12-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.88068974612502"
    Magnitude="0"
    Name="Head of Column No. 4 in Eagle Nebula"
    Opacity="100"
    RA="18.316498500589816"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0142e/thumb.jpg"
    ZoomLevel="0.1280166914040612"
  >
    <Description>Enlarged view of the head of Column 4 in the Eagle Nebula. This column is similar to the more familiar ones, but thus far less impacted by the massive stars in NGC6611. The two red nebulosities in the head signpost one or more young stars so deeply embedded that they cannot be seen directly in the VLT infrared image, only indirectly as they illuminate dust around them. One of these sources is thought to be the origin of the Herbig-Haro object HH216 seen in ESO Press Photo eso0142a and ESO Press Photo eso0142b. Technical information: The region shown measures 1.9 x 2.8 light-years (0.6 x 0.9 pc). The intensity scalings have been adjusted to better show the young stars embedded in the head of each column. North is up and East left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.021491424355328"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.747499109"
        CenterY="-13.8807002766"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Head of Column No. 4 in Eagle Nebula"
        OffsetX="2.0987719097e-05"
        OffsetY="1.04938595485e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0142e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M.McCaughrean &amp;amp; M.Andersen (AIP)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0142e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0142e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0202a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-01-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-2.449841894907901"
    Magnitude="0"
    Name="The Horsehead Nebula*"
    Opacity="100"
    RA="5.683655608956735"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0202a/thumb.jpg"
    ZoomLevel="1.14297511272"
  >
    <Description>A reproduction of a composite colour image of the Horsehead Nebula and its immediate surroundings. It is based on three exposures in the visual part of the spectrum with the FORS2 multi-mode instrument at the 8.2-m KUEYEN telescope, part of ESO&amp;#x27;s Very Large Telescope, at Paranal. It was produced from three images, obtained on February 1, 2000, with the FORS2 multi-mode instrument at the 8.2-m KUEYEN Unit Telescope and extracted from the VLT Science Archive Facility . The frames were obtained in the B-band (600 sec exposure; wavelength 429 nm; FWHM 88 nm; here rendered as blue), V-band (300 sec; 554 nm; 112 nm; green) and R-band (120 sec; 655 nm; 165 nm; red). The original pixel size is 0.2 arcsec. The photo shows the full field recorded in all three colours, approximately 6.5 x 6.7 arcmin 2 . The seeing was about 0.75 arcsec. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.17981702144"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.245796"
        CenterY="-2.458232"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Horsehead Nebula*"
        OffsetX="-0.0084113272837653"
        OffsetY="-0.009010080429893798"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.86500162206998"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0202a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0202a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0202a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0202b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-01-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-2.442293981988156"
    Magnitude="0"
    Name="The Horsehead Nebula"
    Opacity="100"
    RA="5.683054883486106"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0202b/thumb.jpg"
    ZoomLevel="0.714101284368"
  >
    <Description>An enlargement of a smaller area. Technical information about these photos is available below. This is an enlargement of a smaller area, measuring 3.8 x 4.1 arcmin 2 . North is to the left and east is down (the usual orientation for showing this object). The frames were recorded with a TK2048 SITe CCD and the ESO-FIERA Controller, built by the Optical Detector Team (ODT). The images were prepared by Cyril Cavadore (ESO-ODT), by means of Prism software.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11424727993013546"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.245796"
        CenterY="-2.458371"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Horsehead Nebula"
        OffsetX="-0.016064241008229688"
        OffsetY="3.2367733225624943e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.89126655800582"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0202b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0202b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0202b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0209a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-03-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-18.878945933314903"
    Magnitude="0"
    Name="The antennae galaxies - NGC4038/9"
    Opacity="100"
    RA="12.03126973459796"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0209a/thumb.jpg"
    ZoomLevel="0.5810062171679999"
  >
    <Description>One of the first images from the new VIMOS facility, obtained right after the moment of &amp;quot;first light&amp;quot; on February 26, 2002. It shows the famous &amp;quot;Antennae Galaxies&amp;quot;  (NGC 4038/9), the result of a recent collision between two galaxies. As an immediate outcome of this dramatic event, stars are born within massive complexes that appear blue in this composite photo, based on exposures through green, orange and red optical filters. Individual exposures of 60 seconds each; image quality 0.6 arcsec FWHM; the field measures 3.5 x 3.5 arcmin2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.07327696896"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="180.472105"
        CenterY="-18.877127"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The antennae galaxies - NGC4038/9"
        OffsetX="0.0028962878178741508"
        OffsetY="-0.0018159844730721614"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.0588489784"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0209a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0209a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0209a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0209e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-03-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="5.017503990770447"
    Magnitude="0"
    Name="NGC 5364"
    Opacity="100"
    RA="13.936846535913945"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0209e/thumb.jpg"
    ZoomLevel="0.9428016370079999"
  >
    <Description>The spiral galaxy NGC 5364 was the first object to be observed with the VIMOS instrument.  This false-colour near-infrared raw First Light image reveal extensive structure in the spiral arms of the galaxy. The image consists of a 60 sec exposure of NGC 5364 on February 26, 2002; image quality 0.6 arcsec FWHM; full moon; field of view 3.5 x 3.5 arcmin2 ; North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.12842590208"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="209.050235"
        CenterY="5.014524"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 5364"
        OffsetX="-0.0024526916958736594"
        OffsetY="0.002980743351110971"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.017469513"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0209e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0209e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0209e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0209f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-03-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.016514231330166"
    Magnitude="0"
    Name="The Crab Nebula"
    Opacity="100"
    RA="5.5754273586260545"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0209f/thumb.jpg"
    ZoomLevel="1.1648891727719999"
  >
    <Description>The Crab Nebula (Messier 1), as observed by VIMOS. This well-known object is the remnant of a stellar explosion in the year 1054. The image is a composite VRI image obtained on March 4, 2002. The individual exposures lasted 180 seconds; image quality 0.7 arcsec FWHM; field 7 x 7 arcmin2; North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11706279936"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.633184"
        CenterY="22.014411"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Crab Nebula"
        OffsetX="0.0016431077254761403"
        OffsetY="0.0021041574553970683"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.03195021403000001"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0209f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0209f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0209f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0209g&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-03-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-22.975885895212947"
    Magnitude="0"
    Name="NGC 2613"
    Opacity="100"
    RA="8.5563331095665"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0209g/thumb.jpg"
    ZoomLevel="0.7287902228775684"
  >
    <Description>VIMOS photo of NGC 2613, a spiral galaxy that resembles our own Milky Way. Composite VRI image obtained on February 28, 2002. The individual exposures lasted 180 seconds; image quality 0.7 arcsec FWHM; field 7 x 7 arcmin2 ; North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11687671305936072"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="128.336612623"
        CenterY="-22.9747509206"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 2613"
        OffsetX="-0.0077471091107826975"
        OffsetY="-0.0009232306194196962"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5697523009788734"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0209g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0209g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0209g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0209h&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-03-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="15.822113821547378"
    Magnitude="0"
    Name="M100 / NGC 4321"
    Opacity="100"
    RA="12.38193146188511"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0209h/thumb.jpg"
    ZoomLevel="1.051466261999256"
  >
    <Description>Messier 100, also known as NGC 4321,  is one of the largest and brightest spiral galaxies in the sky, located at about 50 million light-years from us. A composite VRI image obtained on March 3, 2002. The individual exposures lasted 180 seconds, image quality 0.7 arcsec FWHM; field 7 x 7 arcmin2 ; North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11715756482853891"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="185.724926264"
        CenterY="15.8284192688"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="M100 / NGC 4321"
        OffsetX="-0.004063847655091949"
        OffsetY="-0.0061963617711303"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.571527352997511"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0209h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0209h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0209h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0209i&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-03-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-31.575926928870928"
    Magnitude="0"
    Name="ACO 3341"
    Opacity="100"
    RA="5.426296944128882"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0209i/thumb.jpg"
    ZoomLevel="0.9778930905239999"
  >
    <Description>This photo of the galaxy cluster ACO 3341 is from a collection of the first images obtained with VIMOS. ACO 3341 is located at a distance of almost 500 million light years (redshift z = 0.037), comparatively nearby in cosmological terms. It contains a large number of galaxies of different sizes and brightness  that is bound together by gravity.  The image is in the R-band and was obtained on March 4, 2002. Exposure 300 seconds, image quality 0.5 arcsec FWHM; field 7 x 7 arcmin2; North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.18825080832"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="81.235465"
        CenterY="-31.477969"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="ACO 3341"
        OffsetX="-0.13583734727796462"
        OffsetY="-0.09752016615615283"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.22651649152"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0209i/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0209i/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0209i/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0209j&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-03-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.650348871838885"
    Magnitude="0"
    Name="Distant cluster MS 1008.1-1224"
    Opacity="100"
    RA="10.175391641412025"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0209j/thumb.jpg"
    ZoomLevel="0.6855697399181804"
  >
    <Description>The distant cluster of galaxies MS 1008.1-1224  is some 3 billion light-years distant (redshift z = 0.301). The galaxies in this cluster — that we observe as they were 3 billion years ago — are different from galaxies in our neighbourhood ; their stellar populations, on the average, are younger. This is a composite VRI image with the individual exposures lasting 300 seconds; image quality 0.8 arcsec FWHM ; field 5 x 3 arcmin2 ; North is to the right and East is up.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1170507225683968"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="152.630845285"
        CenterY="-12.6503774014"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Distant cluster MS 1008.1-1224"
        OffsetX="2.857683656455e-05"
        OffsetY="2.857683656455e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="90.09471098712012"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0209j/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0209j/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0209j/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0214a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-05-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-24.527042859304185"
    Magnitude="0"
    Name="Infant Solar System in Ophiuchus"
    Opacity="100"
    RA="16.470445637293274"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0214a/thumb.jpg"
    ZoomLevel="0.08811309641215538"
  >
    <Description>The image is a three-colour reproduction of the discovery image of strange-looking object (nicknamed the &amp;quot;Flying Saucer&amp;quot; by the astronomers), obtained with the SOFI multi-mode instrument at the ESO 3.5-m New Technology Telescope (NTT) at the La Silla  Observatory. Compared to the unresolved stars in the field, the image of this object appears extended. Two characteristic reflection nebulae are barely visible, together with a marginally resolved dark dust lane in front of the star and oriented East-West. This is a colour composite image combining exposures through near-infrared J-, H- and K S filters, here rendered as blue, green and red, respectively, and with logarithmic colour stretch obtained with NTT/SOFI. The field size shown here is 30 x 30 arcsec2 and the exposure time is 24 min in each of the three filters. The seeing was 0.7 arcsec FWHM, and the pixel size is 0.292 arcsec. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.011085042351718402"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="247.056690542"
        CenterY="-24.527037477"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Infant Solar System in Ophiuchus"
        OffsetX="5.412618335800001e-06"
        OffsetY="-5.412618335800001e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.31999999999999995"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0214a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0214a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0214a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0214b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-05-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-24.530445871665872"
    Magnitude="0"
    Name="Sky field in Ophiuchus"
    Opacity="100"
    RA="16.469637845363504"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0214b/thumb.jpg"
    ZoomLevel="0.286249475360898"
  >
    <Description>The image shows the a new stellar system, as imaged with the ISAAC multi-mode instrument on the 8.2-m VLT ANTU telescope at Paranal during the follow-up observations. The circumstellar disk is well visible in the left part of the field as a shadow in front of the nebula. Many background galaxies are visible in this deep image and one edge-on galaxy is seen visible close to the image centre. The image is based on the combination of three 10-min exposures in the mentioned infrared filters, obtained with the ISAAC instrument on the 8.2-m VLT ANTU telescope. The field measures 2.1 x 1.6 arcmin2. The seeing was 0.4 arcsec and the pixel size is 0.148 arcsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04117077683712"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="247.044612172"
        CenterY="-24.5304654254"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Sky field in Ophiuchus"
        OffsetX="4.0205836755e-05"
        OffsetY="2.01029183775e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.7800000000000001"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0214b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0214b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0214b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0214c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-05-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-24.527032034236345"
    Magnitude="0"
    Name="Infant solar system in Ophiuchus"
    Opacity="100"
    RA="16.470445641723696"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0214c/thumb.jpg"
    ZoomLevel="0.08833393124025601"
  >
    <Description>An enlargement of ESO Press Photo eso0214 showing the unusual &amp;quot;Flying Saucer&amp;quot; object in more detail.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.011085042351718402"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="247.056690542"
        CenterY="-24.527037477"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Infant solar system in Ophiuchus"
        OffsetX="5.412618335800001e-06"
        OffsetY="5.412618335800001e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.31999999999999995"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0214c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0214c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0214c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0216a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-06-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.09154237679377"
    Magnitude="0"
    Name="In Tarantula territory (a)"
    Opacity="100"
    RA="5.647722663966637"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0216a/thumb.jpg"
    ZoomLevel="6.01267274706"
  >
    <Description>A reproduction of a composite colour image of the Tarantula Nebula in the Large Magellanic Cloud (LMC) and its surroundings. The LMC is a satellite galaxy to our Milky Way system, located in the southern constellation Dorado (the Swordfish) at a distance of approximately 170,000 light-years. The image is based on 15 exposures in the visual part of the spectrum with the Wide Field Imager (WFI) camera on the 2.2-m MPG/ESO telescope at the La Silla Observatory. A number of small areas near the borders were not covered in all three colours and have been left black. Six smaller fields with particular objects from this photo are reproduced as ESO Press Photos eso0216b-g.   ESO Press Photo eso0216a  was produced from 15 images that were obtained in September 2000 with the Wide-Field-Imager (WFI) at the 2.2-m MPG/ESO telescope. The images were exposed in the B-band (5 x 200 sec; wavelength 456 nm; Full-Width-Half-Maximum (FWHM) 99 nm; here rendered as blue), V-band (5 x 200 sec; 540 nm; 89 nm; green) and R-band (5 x 200 sec; 652 nm; 162 nm; red). The original pixel size is 0.238 arcsec. The photo shows the full field recorded in all three colours. It measures approximately 34 x 34 arcmin 2 ; North is up and East is left. The seeing was about 1.6 arcsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.071920418356848"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.658236"
        CenterY="-69.095049"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="In Tarantula territory (a)"
        OffsetX="-0.020551752918015278"
        OffsetY="0.003530028862448391"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.09310941414926815"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0216a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0216a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0216a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0216b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-06-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.10418022282406"
    Magnitude="0"
    Name="The central area of the Tarantula Nebula"
    Opacity="100"
    RA="5.646804050114055"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0216b/thumb.jpg"
    ZoomLevel="1.146651665082"
  >
    <Description>The bright core of the Tarantula Nebula with the cluster of hot stars. Note also the wisps of luminous gas extending as &amp;quot;legs&amp;quot; from the central area - this is how the nebula got its creepy name.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27149724959396226"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6775406933"
        CenterY="-69.1010798777"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The central area of the Tarantula Nebula"
        OffsetX="-0.008748753395478325"
        OffsetY="-0.003093111533459576"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.05897220232239028"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0216b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0216b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0216b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0216c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-06-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.99999386924142"
    Magnitude="0"
    Name="In Tarantula territory (c)"
    Opacity="100"
    RA="5.664251154411195"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0216c/thumb.jpg"
    ZoomLevel="1.1912176162619998"
  >
    <Description>This image shows a part of the Tarantula Nebula region: in the upper left quadrant, a luminous lobe around a hot blue star and a neighbouring dark cloud. The Tarantula Nebula appears in the lower right quadrant of the image.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27117665711891153"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.657845"
        CenterY="-69.095034"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="In Tarantula territory (c)"
        OffsetX="-0.10975743837214054"
        OffsetY="0.09462335791212402"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.07552591505145836"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0216c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0216c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0216c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0216d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-06-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.23518076540817"
    Magnitude="0"
    Name="In Tarantula territory (d)"
    Opacity="100"
    RA="5.690034727336496"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0216d/thumb.jpg"
    ZoomLevel="1.5522787952219996"
  >
    <Description>The area of the young globular cluster NGC 2100 , located east of the Tarantula Nebula , at the extreme left edge of ESO Press Photo eso0216a and the field of this photo.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27054968108444444"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.53356"
        CenterY="-69.212036"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="In Tarantula territory (d)"
        OffsetX="0.06517711944059898"
        OffsetY="-0.02243491853284645"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.7119879937130273"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0216d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0216d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0216d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0216e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-06-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.86818489326119"
    Magnitude="0"
    Name="In Tarantula territory (e)"
    Opacity="100"
    RA="5.607733520355751"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0216e/thumb.jpg"
    ZoomLevel="1.5048392876999999"
  >
    <Description>This image displays a rich field NW of the centre of the Tarantula Nebula, with the globular cluster KMHK 1137[2] near the upper edge. This image is part of a reproduction of a composite colour image of the Tarantula Nebula in the Large Magellanic Cloud (LMC) and its surroundings. The LMC is a satellite galaxy to our Milky Way system, located in the southern constellation Dorado (The Swordfish) at a distance of approximately 170,000 light-years. The image is based on 15 exposures in the visual part of the spectrum with the Wide Field Imager (WFI) camera on the 2.2-m MPG/ESO telescope at the La Silla Observatory.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2717159385323741"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6775406933"
        CenterY="-69.1010798777"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="In Tarantula territory (e)"
        OffsetX="0.2022896730833267"
        OffsetY="0.2321036464351551"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.03771259801415673"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0216e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0216e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0216e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0216g&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-06-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.18553051617502"
    Magnitude="0"
    Name="In Tarantula territory (g)"
    Opacity="100"
    RA="5.665308640523676"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0216g/thumb.jpg"
    ZoomLevel="1.3623791857679997"
  >
    <Description>Colour composite image of the Tarantula Nebula in the Large Magellanic Cloud (LMC) and its surroundings. It displays numerous &amp;quot;fingers&amp;quot; of dark material, lanes of cold gas and dust, that still hold out against the strong stellar winds in this area, SE of the centre of the Tarantula Nebula.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27003392877425464"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6775406933"
        CenterY="-69.1010798777"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="In Tarantula territory (g)"
        OffsetX="-0.10736781469291735"
        OffsetY="-0.0846862268010966"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.015433503623837901"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0216g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0216g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0216g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0221a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-08-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.65872695773215"
    Magnitude="0"
    Name="Spiral galaxy NGC 300"
    Opacity="100"
    RA="0.9136768044289165"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0221a/thumb.jpg"
    ZoomLevel="5.415830464200001"
  >
    <Description>Colour-composite image of the nearby spiral galaxy NGC 300  and the surrounding sky field, obtained in 1999 and 2000 with the Wide-Field Imager (WFI) on the MPG/ESO 2.2-m telescope at the La Silla Observatory.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.9577046759579457"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="13.72316"
        CenterY="-37.684471"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 300"
        OffsetX="0.014270688275643718"
        OffsetY="0.025734749694732568"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.03218155115134884"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso0221a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0221a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0221a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0221b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-08-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.584330422283905"
    Magnitude="0"
    Name="Cepheids in NGC 300"
    Opacity="100"
    RA="0.9053255904848431"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0221b/thumb.jpg"
    ZoomLevel="0.6520357917610626"
  >
    <Description>Some of the Cepheid type stars in the spiral galaxy NGC 300 (at the centre of the markers), as they were identified by Wolfgang Gieren and collaborators during the research programme for which the WFI images of NGC 300 were first obtained. In this area of NGC 300, there is also a huge cloud of ionized hydrogen (a &amp;quot;HII shell&amp;quot;). It measures about 2,000 light-years in diameter, thus dwarfing even the enormous Tarantula Nebula in the LMC.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1352464452202496"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="13.5799255937"
        CenterY="-37.5843633862"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cepheids in NGC 300"
        OffsetX="3.30191516651e-05"
        OffsetY="3.30191516651e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.09577905361000191"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0221b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0221b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0221b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0221c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-08-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.6786770389453"
    Magnitude="0"
    Name="Spiral galaxy NGC 300 (H-alpha band)"
    Opacity="100"
    RA="0.9129922980490279"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0221c/thumb.jpg"
    ZoomLevel="3.0168786417621156"
  >
    <Description>NGC 300, as seen through a narrow optical filter (H-alpha) in the red light of hydrogen atoms. A population of intrinsically bright and young stars turned &amp;quot;on&amp;quot; just a few million years ago. Their radiation and strong stellar winds have shaped many of the clouds of ionized hydrogen gas (&amp;quot;HII shells&amp;quot;) seen in this photo. The &amp;quot;rings&amp;quot; near some of the bright stars are caused by internal reflections in the telescope.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5414452806071914"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="13.6951773805"
        CenterY="-37.6858028314"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 300 (H-alpha band)"
        OffsetX="0.00042700541269350003"
        OffsetY="0.007116756878225014"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5702789260789576"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0221c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0221c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0221c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0221d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-08-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.54963982810267"
    Magnitude="0"
    Name="Cluster of galaxies CL0053-37 in NGC 300 field"
    Opacity="100"
    RA="0.9340334059809638"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0221d/thumb.jpg"
    ZoomLevel="1.007312283648"
  >
    <Description>The distant cluster of galaxies CL0053-37, as imaged on the WFI photo of the NGC 300 sky field. The elongated distribution of the cluster galaxies, as well as the presence of two large, early-type elliptical galaxies indicate that this cluster is still in the process of formation. Some of the galaxies appear to be merging. From the measured redshift (z  = 0.1625), a distance of about 2.1 billion light-years is deduced.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13519552512000002"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="14.004036"
        CenterY="-37.545709"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cluster of galaxies CL0053-37 in NGC 300 field"
        OffsetX="-0.005121154378093564"
        OffsetY="-0.003936909811910433"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.06604139639999998"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0221d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0221d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0221d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0221f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-08-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.710912305769725"
    Magnitude="0"
    Name="Distant galaxies in NGC 300 field"
    Opacity="100"
    RA="0.9346355172019974"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0221f/thumb.jpg"
    ZoomLevel="0.6216815533574377"
  >
    <Description>A group of galaxies seen on NGC 300 images. They are all quite red and their similar colours indicate that they must be about equally distant. They probably constitute a distant cluster, now in the stage of formation.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06783907828623362"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="14.0195747605"
        CenterY="-37.7109453261"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Distant galaxies in NGC 300 field"
        OffsetX="3.312454994445001e-05"
        OffsetY="3.312454994445001e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.18000000000000288"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0221f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0221f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0221f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0221g&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-08-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.6064651624291"
    Magnitude="0"
    Name="Distant galaxies behind NGC 300"
    Opacity="100"
    RA="0.9235120745898657"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0221g/thumb.jpg"
    ZoomLevel="0.535553409546"
  >
    <Description>An area in the outer regions of NGC 300. Disks of spiral galaxies are usually quite &amp;quot;thin&amp;quot; (some hundred light-years), as compared to their radial extent (tens of thousands of light-years across). In areas where only small amounts of dust are present, it is possible to see much more distant galaxies right through the disk of NGC 300, as demonstrated by this image.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13491935232"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="13.72316"
        CenterY="-37.684471"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Distant galaxies behind NGC 300"
        OffsetX="-0.10291042551944703"
        OffsetY="0.07753731037800657"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.22180156572"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0221g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0221g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0221g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0221h&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-08-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.83810508289187"
    Magnitude="0"
    Name="Outskirts of NGC 300"
    Opacity="100"
    RA="0.9175230199419688"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0221h/thumb.jpg"
    ZoomLevel="1.304798419573026"
  >
    <Description>This is an astronomers&amp;#x27; joy ride to infinity. Such a rarely seen view of our universe imparts a feeling of the vast distances in space. In the upper half of the image, the outer region of NGC 300 is resolved into innumerable stars, while in the lower half, myriads of galaxies — a thousand times more distant — catch the eye. In reality, many of them are very similar to NGC 300, they are just much more remote.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27078351961144626"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="13.7547543154"
        CenterY="-37.8389387797"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Outskirts of NGC 300"
        OffsetX="-0.006364562946821006"
        OffsetY="0.0010082475955360028"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5721772197373913"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0221h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0221h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0221h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0223a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-08-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="14.420868983369768"
    Magnitude="0"
    Name="Spiral galaxy NGC 4254"
    Opacity="100"
    RA="12.31362505682906"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0223a/thumb.jpg"
    ZoomLevel="1.1578583720339999"
  >
    <Description>An image of the Virgo cluster spiral galaxy NGC 4254, with the &amp;quot;metal-rich&amp;quot; H II regions indicated. (VLT ANTU and FORS1).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22494416896"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="184.706759"
        CenterY="14.416278"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 4254"
        OffsetX="-0.004593997258062688"
        OffsetY="0.0023020797182796236"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90.07461706461"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0223a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0223a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0223a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0226a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2002-10-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.007484794832404"
    Magnitude="0"
    Name="The centre of the Milky Way"
    Opacity="100"
    RA="17.761120825467177"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0226a/thumb.jpg"
    ZoomLevel="0.04676811298481935"
  >
    <Description>The centre of our Milky Way galaxy is located in the southern constellation Sagittarius (The Archer) and is &amp;quot;only&amp;quot; 26,000 light-years away. On high-resolution images, it is possible to discern thousands of individual stars within the central, one light-year wide region. Using the motions of these stars to probe the gravitational field, observations over the last decade have shown that a mass of about 3 million times that of the Sun is concentrated within a radius of only 10 light-days of the compact radio and X-ray source SgrA* (Sagittarius A) at the centre of the star cluster. This means that SgrA* is the most likely counterpart of the black hole believed to exist at the centre of our Galaxy. This image was obtained in mid-2002 with the NACO instrument at the 8.2-m VLT Yepun telescope. It combines frames in three infrared wavebands between 1.6 and 3.5 µm. The compact objects are stars and their colours indicate their temperature (blue =&amp;quot;hot&amp;quot;, red =&amp;quot;cool&amp;quot;). There is also diffuse infrared emission from interstellar dust between the stars. A newer image of that region has been published in 2008; see image eso0846a.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00795114603716608"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.416813486"
        CenterY="-29.0074857705"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The centre of the Milky Way"
        OffsetX="9.7059888149e-07"
        OffsetY="9.7059888149e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.30000000000000004"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0226a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0226a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0226a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0302a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-01-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.804236850097908"
    Magnitude="0"
    Name="Chandra Deep Field South"
    Opacity="100"
    RA="3.540742803113665"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0302a/thumb.jpg"
    ZoomLevel="5.446535393232001"
  >
    <Description>Three-colour composite image of the Chandra Deep Field South (CDF-S), obtained with the Wide Field Imager (WFI) camera on the 2.2-m MPG/ESO telescope at the ESO La Silla Observatory (Chile). It was produced by the combination of about 450 images with a total exposure time of nearly 50 hours. The field measures 36 x 34 square arcminutes ; North is up and East is left. Technical information: The very extensive data reduction and colour image processing needed to produce these images were performed by Mischa Schirmer and Thomas Erben at the &amp;quot;Wide Field Expertise Center&amp;quot; of the Institut für Astrophysik und Extraterrestrische Forschung der Universität Bonn (IAEF) in Germany. It was done by means of a software pipeline specialised for reduction of multiple CCD wide-field imaging camera data. This pipeline is mainly based on publicly available software modules and algorithms (EIS, FLIPS, LDAC, Terapix, Wifix).The image was constructed from about 150 exposures in each of the following wavebands: B-band (centred at wavelength 456 nm; here rendered as blue, 15.8 hours total exposure time), V-band (540 nm; green, 15.6 hours) and R-band (652 nm; red, 17.8 hours). Only images taken under sufficiently good observing conditions (defined as seeing less than 1.1 arcsec) were included. In total, 450 images were assembled to produce this colour image, together with about as many calibration images (biases, darks and flats). More than 2 Terabyte (TB) of temporary files were produced during the extensive data reduction. Parallel processing of all data sets took about two weeks on a four-processor Sun Enterprise 450 workstation and a 1.8 GHz dual processor Linux PC. The final colour image was assembled in Adobe Photoshop. The observations were performed by ESO (GOODS, EIS) and the COMBO-17 collaboration in the period 1/1999-10/2002.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5793795343638041"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.1170222695"
        CenterY="-27.8085927855"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Chandra Deep Field South"
        OffsetX="0.005200456559952005"
        OffsetY="0.00435684978410382"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.011493419494834409"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0302a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0302a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0302a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0302c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-01-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.98368044339332"
    Magnitude="0"
    Name="Chandra Deep Field South (detail)"
    Opacity="100"
    RA="3.539409153261862"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0302c/thumb.jpg"
    ZoomLevel="1.3298797435315821"
  >
    <Description>Sky field within the wide field imager (WFI) image of the Chandra Deep Field South (CDF-S), reproduced at full (pixel) size to illustrate the exceptional information richness of these data. This subfield measures 6.8 x 7.8 square arcminutes (1717 x 1975 pixels). Technical information: The very extensive data reduction and colour image processing needed to produce these images were performed by Mischa Schirmer and Thomas Erben at the &amp;quot;Wide Field Expertise Center&amp;quot; of the Institut für Astrophysik und Extraterrestrische Forschung der Universität Bonn (IAEF) in Germany. It was done by means of a software pipeline specialised for reduction of multiple CCD wide-field imaging camera data. This pipeline is mainly based on publicly available software modules and algorithms (EIS, FLIPS, LDAC, Terapix, Wifix).The image was constructed from about 150 exposures in each of the following wavebands: B-band (centred at wavelength 456 nm; here rendered as blue, 15.8 hours total exposure time), V-band (540 nm; green, 15.6 hours) and R-band (652 nm; red, 17.8 hours). Only images taken under sufficiently good observing conditions (defined as seeing less than 1.1 arcsec) were included. In total, 450 images were assembled to produce this colour image, together with about as many calibration images (biases, darks and flats). More than 2 Terabyte (TB) of temporary files were produced during the extensive data reduction. Parallel processing of all data sets took about two weeks on a four-processor Sun Enterprise 450 workstation and a 1.8 GHz dual processor Linux PC. The final colour image was assembled in Adobe Photoshop. The observations were performed by ESO (GOODS, EIS) and the COMBO-17 collaboration in the period 1/1999-10/2002.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1352679795554304"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.0949901774"
        CenterY="-27.988937654"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Chandra Deep Field South (detail)"
        OffsetX="0.003399759712596548"
        OffsetY="0.005258867923851632"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.0288237506600014"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0302c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0302c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0302c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0302d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-01-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.802216924491336"
    Magnitude="0"
    Name="Chandra Deep Field South (Detail)"
    Opacity="100"
    RA="3.5519543440120396"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0302d/thumb.jpg"
    ZoomLevel="1.7775759757638503"
  >
    <Description>Sky field within the wide field imager (WFI) image of the Chandra Deep Field South (CDF-S), reproduced at full (pixel) size to illustrate the exceptional information richness of these data. This subfield measures 10.1 x 10.5 square arcminutes (2545 x 2635 pixels). Technical information: The very extensive data reduction and colour image processing needed to produce these images were performed by Mischa Schirmer and Thomas Erben at the &amp;quot;Wide Field Expertise Center&amp;quot; of the Institut für Astrophysik und Extraterrestrische Forschung der Universität Bonn (IAEF) in Germany. It was done by means of a software pipeline specialised for reduction of multiple CCD wide-field imaging camera data. This pipeline is mainly based on publicly available software modules and algorithms (EIS, FLIPS, LDAC, Terapix, Wifix).The image was constructed from about 150 exposures in each of the following wavebands: B-band (centred at wavelength 456 nm; here rendered as blue, 15.8 hours total exposure time), V-band (540 nm; green, 15.6 hours) and R-band (652 nm; red, 17.8 hours). Only images taken under sufficiently good observing conditions (defined as seeing less than 1.1 arcsec) were included. In total, 450 images were assembled to produce this colour image, together with about as many calibration images (biases, darks and flats). More than 2 Terabyte (TB) of temporary files were produced during the extensive data reduction. Parallel processing of all data sets took about two weeks on a four-processor Sun Enterprise 450 workstation and a 1.8 GHz dual processor Linux PC. The final colour image was assembled in Adobe Photoshop. The observations were performed by ESO (GOODS, EIS) and the COMBO-17 collaboration in the period 1/1999-10/2002.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.270796185423872"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.2763699353"
        CenterY="-27.7980501456"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Chandra Deep Field South (Detail)"
        OffsetX="-0.0025959427412803283"
        OffsetY="-0.00417260667841065"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.12770857842999989"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0302d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0302d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0302d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0304a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-01-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.893831465615747"
    Magnitude="0"
    Name="Bright galaxies in the Virgo cluster"
    Opacity="100"
    RA="12.416184368896678"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0304a/thumb.jpg"
    ZoomLevel="5.304672695200785"
  >
    <Description>Sky field near some of the brighter galaxies in the Virgo Cluster. This image was obtained in April 2000 with the Wide Field Imager (WFI) at the La Silla Observatory. The large elliptical galaxy at the centre is Messier 84; the elongated image of NGC 4388 (an active spiral galaxy, seen from the side) is in the lower left corner. The field measures 16.9 x 15.7 square arcmin.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.9935588308248472"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="186.242833407"
        CenterY="12.8936992572"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Bright galaxies in the Virgo cluster"
        OffsetX="6.611568147850617e-05"
        OffsetY="0.00013223136295702052"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.020129368386373764"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0304a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0304a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0304a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0304b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-01-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.723867117734098"
    Magnitude="0"
    Name="Sky field in Virgo cluster of galaxies"
    Opacity="100"
    RA="12.429261348943488"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0304b/thumb.jpg"
    ZoomLevel="4.839984853392"
  >
    <Description>Larger region of the Virgo cluster, with the galaxies Messier 86 (at the upper edge of the field, to the left of the centre), as well as Messier 84 (upper right) and NGC 4388 (just below the centre). It is reproduced from a long-exposure Subaru Suprime-Cam image, obtained in the red light of ionized hydrogen (the H-alpha spectral line at wavelength 656.2 nm). In order to show the faintest possible hydrogen emitting objects embedded in the outskirts of bright galaxies, their smooth envelopes have been &amp;quot;subtracted&amp;quot; during the image processing. The field measures 34 x 27 square arcminutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.7923302382634162"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="186.633977"
        CenterY="12.723193"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Sky field in Virgo cluster of galaxies"
        OffsetX="0.19026690050733383"
        OffsetY="0.0008660669649970592"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.036589379918400826"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0304b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0304b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0304b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0305b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-01-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-32.33907877761687"
    Magnitude="0"
    Name="Giant star HD 47536"
    Opacity="100"
    RA="6.629926510183443"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0305b/thumb.jpg"
    ZoomLevel="1.6976466397141219"
  >
    <Description>Sky area of 10 x 10 square arcmin around the 6th-magnitude giant star HD 47536 at which an exoplanet has been found in 2003 (reproduced from the Digital Sky Survey). The pattern is caused by internal reflections in the telescope from this relatively bright object.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22148201137321932"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="99.4521987253"
        CenterY="-32.3375221321"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Giant star HD 47536"
        OffsetX="0.002789066889326007"
        OffsetY="-0.001556688496368001"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0305b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>Reproduced from the Digital Sky Survey [STScI Digitized Sky Survey, (C) 1993, 1994, AURA, Inc. all rights reserved - cf.http://archive.eso.org/dss/dss]</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0305b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0305b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0310a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-04-09T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-72.05629247795984"
    Magnitude="0"
    Name="Really hot stars"
    Opacity="100"
    RA="1.0596827500156025"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0310a/thumb.jpg"
    ZoomLevel="1.1164727921760003"
  >
    <Description>This unique image shows AB7, one of the highest excitation nebulae in the Magellanic Clouds (MCs), two satellite galaxies of our own Milky Way. AB7 is a binary star, consisting of one WR-star — highly evolved massive star - and a mid-age massive companion of spectral type O. These exceptional stars have very strong stellar winds: they continuously eject energetic particles — like the &amp;quot;solar wind&amp;quot; from the Sun — but some 10 to 1,000 million times more intensely than our star! These powerful winds exert an enormous pressure on the surrounding interstellar material and forcefully shape those clouds into &amp;quot;bubbles&amp;quot;, well visible in the photos by their blue colour. AB7 is particularly remarkable: the associated huge nebula and HeII region indicate that this star is one of the, if not the, hottest WR-star known so far, with a surface temperature in excess of 120,000 degrees ! Just outside this nebula, a small network of green filaments is visible — they are the remains of another supernova explosion.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.18092834816000003"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="15.953828"
        CenterY="-72.064284"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Really hot stars"
        OffsetX="0.01802959597469277"
        OffsetY="0.00802770176403449"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.14279472618000003"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0310a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0310a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0310a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0310b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-04-09T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.34681783988933"
    Magnitude="0"
    Name="Nebulae near the hot Wolf-Rayet star BAT99-2 in the LMC"
    Opacity="100"
    RA="4.826578597163266"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0310b/thumb.jpg"
    ZoomLevel="1.1255768519999143"
  >
    <Description>Three-colour composite image of the highly excited nebula near the Wolf-Rayet (WR) star BAT99-2 in the Large Magellanic Cloud (LMC), obtained in January 2002 with the FORS1 multi-mode instrument at the 8.2-m VLT MELIPAL telescope at the Paranal Observatory (Chile). It is based on three exposures through narrow-band optical (interference) filters that isolate the light from specific atoms and ions. In this rendering, the blue colour represents the light from singly ionized Helium (He II; wavelength 468.6 nm; exposure time 60 min), green corresponds to doubly ionized oxygen ([O III]; 495.7 + 500.7 nm; 5 min) and red to hydrogen atoms (H; H-alpha line at 656.2 nm; 5 min). Of these three ions, He II is the tracer of high excitation, i.e. the bluest areas of the nebula are the hottest. The sky field measures 400 x 400 square arcsec; the original pixel size on the 2k x 2k CCD is 0.23 arcsec. North is up and east to the left.  Before combination, the CCD frames were flat-fielded and cleaned of cosmic-rays. Moreover, the stars in the blue (He II) image were removed in order to provide a clearer view of the surrounding nebular emission. The reproduced brightness is proportional to the square-root of the actual intensity; this increases the &amp;quot;dynamical range&amp;quot; of the image, i.e. it shows better areas of very different brightness.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11826173509895367"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="72.3988097718"
        CenterY="-69.3469101997"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Nebulae near the hot Wolf-Rayet star BAT99-2 in the LMC"
        OffsetX="4.61718291902507e-05"
        OffsetY="9.234365838050077e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.020010383896942013"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0310b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0310b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0310b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0310c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-04-09T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-70.99076945718818"
    Magnitude="0"
    Name="Nebulae near the hot binary star BAT99-49 in the LMC"
    Opacity="100"
    RA="5.492691316433885"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0310c/thumb.jpg"
    ZoomLevel="1.128428654763384"
  >
    <Description>The nebula around the hot double star BAT99-49 in the Large Magellanic Cloud (LMC), obtained in January 2002 with the FORS1 multi-mode instrument at the 8.2-m VLT MELIPAL telescope at the Paranal Observatory (Chile). It is based on three exposures through narrow-band optical (interference) filters that isolate the light from specific atoms and ions. In this rendering, the blue colour represents the light from singly ionized Helium (He II; wavelength 468.6 nm; exposure time 45 min), green corresponds to doubly ionized oxygen ([O III]; 495.7 + 500.7 nm; 5 min) and red to hydrogen atoms (H; H-alpha line at 656.2 nm; 5 min). Of these three ions, He II is the tracer of high excitation, i.e. the bluest areas of the nebula are the hottest. The sky field measures 400 x 400 square arcsec ; the original pixel size on the 2k x 2k CCD is 0.23 arcsec. North is up and east to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11819028327326248"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="82.3905110684"
        CenterY="-70.9908156174"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Nebulae near the hot binary star BAT99-49 in the LMC"
        OffsetX="4.6095941779550794e-05"
        OffsetY="4.6095941779552366e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.08012539168617475"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0310c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0310c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0310c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0310d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-04-09T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-67.99022279168987"
    Magnitude="0"
    Name="Close-up of N44C in the LMC"
    Opacity="100"
    RA="5.369178235631809"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0310d/thumb.jpg"
    ZoomLevel="0.589765788672"
  >
    <Description>The N44C nebula in the Large Magellanic Cloud (LMC), obtained in January 2002 with the FORS1 multi-mode instrument at the 8.2-m VLT MELIPAL telescope at the Paranal Observatory (Chile). It is based on three exposures through narrow-band optical (interference) filters that isolate the light from specific atoms and ions. In this rendering, the blue colour represents the light from singly ionized Helium (He II; wavelength 468.6 nm; exposure time 45 min), green corresponds to doubly ionized oxygen ([O III]; 495.7 + 500.7 nm; 5 min) and red to hydrogen atoms (H; H-alpha line at 656.2 nm; 5 min). Of these three ions, He II is the tracer of high excitation, i.e. the bluest areas of the nebula are the hottest. The sky field measures 208 x 208 square arcsec. North is up and east to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.09859760128"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="80.533005"
        CenterY="-67.937116"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Close-up of N44C in the LMC"
        OffsetX="-0.0018720556028363857"
        OffsetY="-0.05310269745646945"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.13211623700000003"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0310d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0310d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0310d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0311a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-04-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-30.223649497666287"
    Magnitude="0"
    Name="The Galactic Star OGLE-TR-3"
    Opacity="100"
    RA="17.863611955912017"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0311a/thumb.jpg"
    ZoomLevel="0.1695402894"
  >
    <Description>This photograph shows the 16.5-mag star OGLE-TR-3, a solar-like star in the direction of the Galactic Center, discovered during an extensive photometric search for planetary and low-luminosity object transits. The image is reproduced from an I-band CCD frame of a 1 x 1 arcmin 2 sky field. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.02417686836363636"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="267.953869"
        CenterY="-30.223836"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Galactic Star OGLE-TR-3"
        OffsetX="-0.00026648165766698223"
        OffsetY="0.00018887706737376586"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.5103409749316767"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0311a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0311a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0311a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0313h&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-05-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.007773274402656"
    Magnitude="0"
    Name="K-band image of the Galactic Centre"
    Opacity="100"
    RA="17.761141673948604"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0313h/thumb.jpg"
    ZoomLevel="0.018345870741513344"
  >
    <Description>K-band image of the central 6 x 13 square arcsec around the Galactic Centre obtained by MACAO-VLTI under average atmospheric conditions (0.8 arcsec seeing) with an exposure time of 90 seconds. Although the 14.6 magnitude guide star is located roughly 20 arcsec from the field centre - this leading to isoplanatic degradation of image sharpness - the present image is nearly diffraction limited and has a point-source FWHM of about 0.115 arcsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.005874901222537969"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.417126983"
        CenterY="-29.0077746025"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="K-band image of the Galactic Centre"
        OffsetX="1.4913887052901357e-06"
        OffsetY="1.49138870528996e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-5.98222249195391"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0313h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0313h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0313h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0315a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-06-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-42.983071885326844"
    Magnitude="0"
    Name="Centaurus A (NGC 5128)"
    Opacity="100"
    RA="13.428840733440804"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0315a/thumb.jpg"
    ZoomLevel="4.762796334318"
  >
    <Description>This is a colour composite photo of the peculiar galaxy Centaurus A (NGC 5128) , obtained with the Wide-Field Imager (WFI) camera at the ESO/MPG 2.2-m telescope on La Silla. It is based on a total of nine 3-min exposures made on March 25, 1999, through different broad-band optical filters (B(lue) - total exposure time 9 min - central wavelength 456 nm - here rendered as blue; V(isual) - 540 nm - 9 min - green; I(nfrared) - 784 nm - 9 min - red); it was prepared from files in the ESO Science Data Archive by ESO-astronomer Benoît Vandame. The elliptical shape and the central dust band, the imprint of a galaxy collision, are well visible.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5416566374399999"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.364532209"
        CenterY="-43.0185227975"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centaurus A (NGC 5128)"
        OffsetX="-0.04978529702881129"
        OffsetY="0.03545618957925232"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.029278915519999997"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0315a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0315a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0315a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0315c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-06-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-42.865653418949336"
    Magnitude="0"
    Name="Centaurus A – Field 1 (shell)"
    Opacity="100"
    RA="13.439700520149868"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0315c/thumb.jpg"
    ZoomLevel="1.16151800191872"
  >
    <Description>High-resolution, very deep colour image of a field around the jet in the North-East of the Centaurus A galaxy.  This image was taken in July 1999 through U- and V-band optical filters with the VLT FORS1 multi-mode instrument at the 8.2-m VLT ANTU telescope on Paranal. Note the great variety of object types and colours, including many background galaxies which are seen through these less dense regions of Centaurus A. The total exposure time was 30 min in each filter and the seeing was excellent, 0.5 arcsec. The original pixel size is 0.196 arcsec and the fields measure 6.7 x 6.7 square arcmin (2048 x 2048 square pix). North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11398562800344711"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.595604871"
        CenterY="-42.8657246153"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centaurus A – Field 1 (shell)"
        OffsetX="7.117144619599848e-05"
        OffsetY="7.117144619599695e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.019980468751584223"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0315c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0315c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0315c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0315d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-06-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.16585467421143"
    Magnitude="0"
    Name="Centaurus A – Field 2 (halo)"
    Opacity="100"
    RA="13.423196442463752"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0315d/thumb.jpg"
    ZoomLevel="1.1581951593019202"
  >
    <Description>High-resolution, very deep colour image of a field in the South of the Centaurus A galaxy halo.  This image was taken in July 1999 through U- and V-band optical filters with the VLT FORS1 multi-mode instrument at the 8.2-m VLT ANTU telescope on Paranal. Note the great variety of object types and colours, including many background galaxies which are seen through these less dense regions of Centaurus A. The total exposure time was 30 min in each filter and the seeing was excellent, 0.5 arcsec. The original pixel size is 0.196 arcsec and the fields measure 6.7 x 6.7 square arcmin (2048 x 2048 square pix). North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11410570177655585"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.348043801"
        CenterY="-43.1659257416"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centaurus A – Field 2 (halo)"
        OffsetX="7.096784064349848e-05"
        OffsetY="7.096784064350355e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.07960937550396634"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0315d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0315d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0315d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0315e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-06-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-42.8674126752729"
    Magnitude="0"
    Name="Centaurus A – Field 1 (shell)"
    Opacity="100"
    RA="13.43977508561019"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0315e/thumb.jpg"
    ZoomLevel="0.35234630768945474"
  >
    <Description>Colour composite of &amp;quot;Field 1&amp;quot; (around the jet) in the peculiar galaxy Centaurus A (NGC 5128), based on exposures through three near-infrared filters (the J-, H- and K-bands at wavelengths 1.2, 1.6 and 2.2 µm, respectively) with the  ISAAC multi-mode instrument  at the  8.2-m VLT ANTU telescope at the ESO Paranal observatory. This ISAAC image is one of the two deepest near-infrared images ever obtained in this galaxy and show thousands of its stars of different colours. In the present colour-coding, the redder an image, the cooler is the star. The original pixel size is 0.15 arcsec and both fields measure 2.5 x 2.5 arcmin 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04783340877832156"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.596656944"
        CenterY="-42.8674577363"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centaurus A – Field 1 (shell)"
        OffsetX="2.251874553834979e-05"
        OffsetY="4.503749107670016e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.06006360686579067"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0315e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0315e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0315e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0315f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-06-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.167671297903375"
    Magnitude="0"
    Name="Centaurus A – Field 2 (halo)"
    Opacity="100"
    RA="13.423278188234825"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0315f/thumb.jpg"
    ZoomLevel="0.35517354955682723"
  >
    <Description>Colour composites of &amp;quot;Field 2&amp;quot; in the halo of the peculiar galaxy Centaurus A (NGC 5128), based on exposures through three near-infrared filters (the J-, H- and K-bands at wavelengths 1.2, 1.6 and 2.2 µm, respectively) with the  ISAAC multi-mode instrument  at the  8.2-m VLT ANTU telescope at the ESO Paranal observatory. This ISAAC image is one of the two deepest near-infrared images ever obtained in this galaxy and shows thousands of its stars of different colours. In the present colour-coding, the redder an image, the cooler is the star. The original pixel size is 0.15 arcsec and both fields measure 2.5 x 2.5 arcmin 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04811962037868687"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.349203968"
        CenterY="-43.1677166889"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centaurus A – Field 2 (halo)"
        OffsetX="2.269943691725118e-05"
        OffsetY="4.539887383450058e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.02011402356729347"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0315f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0315f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0315f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0315g&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-06-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.161062997748765"
    Magnitude="0"
    Name="Centaurus A – Field 2 (detail)"
    Opacity="100"
    RA="13.422294080134481"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0315g/thumb.jpg"
    ZoomLevel="0.055586644021244594"
  >
    <Description>Zoomed-in area within &amp;quot;Field 2&amp;quot; (Halo) in Centaurus A, from the ISAAC colour image. Nearly all red stars in this area are of the variable Mira-type.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.007059409343522276"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.334420272"
        CenterY="-43.1610662999"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centaurus A – Field 2 (detail)"
        OffsetX="6.613678376789882e-06"
        OffsetY="3.3068391883952015e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.03940009138810081"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0315g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0315g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0315g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0317a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-06-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-61.26038173833077"
    Magnitude="0"
    Name="The galactic starburst region NGC 3603 (annotated)"
    Opacity="100"
    RA="11.252170580629102"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0317a/thumb.jpg"
    ZoomLevel="0.5697684101099999"
  >
    <Description>The region around NGC 3603, a cluster of young, hot O and B-type stars still partly embedded in its natal cloud of gas and dust. A small group of nascent, very massive stars has been found to the south of the cluster centre — here indicated as &amp;quot;IRS9&amp;quot;. The image was obtained with the ISAAC multi-mode instrument at the 8.2-m VLT ANTU telescope at Paranal. The orientation and the scale at the distance of NGC 3603 (22,000 light-years) are indicated.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.10823137105619678"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="168.788166"
        CenterY="-61.271524"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The galactic starburst region NGC 3603 (annotated)"
        OffsetX="0.0026871175518294044"
        OffsetY="0.011144325245607685"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.04645816545511524"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0317a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0317a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0317a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0322b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-07-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="9.103552572905091"
    Magnitude="0"
    Name="Radio and near-infrared composite of W49A"
    Opacity="100"
    RA="19.17112534915951"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0322b/thumb.jpg"
    ZoomLevel="0.5798619417537016"
  >
    <Description>Three-colour composite of the central region of the star-forming region W49A, based on a radio emission map (wavelength 3.6 cm ; here rendered as red) as well as two SofI images in the Ks- (green) and J-bands (blue). The red-only features in this image represent regions of ionized hydrogen so deeply embedded in the molecular cloud that they cannot be detected in the near-infrared, while blue sources are foreground stars. The radio continuum data were taken with the Very Large Array by Chris De Pree.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08239715642643111"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="287.566920754"
        CenterY="9.10347263017"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Radio and near-infrared composite of W49A"
        OffsetX="3.997834738104843e-05"
        OffsetY="7.995669476210094e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.02000359294647722"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0322b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0322b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0322b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0326a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-08-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.35765860612872"
    Magnitude="0"
    Name="Colour-composite of the sky field with several High-Redshift galaxies"
    Opacity="100"
    RA="22.4527789897622"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0326a/thumb.jpg"
    ZoomLevel="1.1290800945411599"
  >
    <Description>Sky region imaged with the multi-mode FORS2 instrument on the 8.2-m VLT YEPUN telescope, in which a number of galaxies in the redshift range from 4.8 to 5.8 were discovered. They are accordingly located at a distance of about 12,600 million light-years from the Earth. This is a composite image where the blue, green and red colours correspond to the R- (central wavelength at 650 nm), the I- (about 780 nm), and the z-band filter (910 nm), respectively. The size of the sky field corresponds to about 1,000 million light-years at the distance of these galaxies. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1438461750784"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="336.791770788"
        CenterY="-35.3577289905"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Colour-composite of the sky field with several High-Redshift galaxies"
        OffsetX="7.0237390175e-05"
        OffsetY="7.0237390175e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.12"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0326a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0326a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0326a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0332a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-11-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-67.96018256663237"
    Magnitude="0"
    Name="N44 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.370733881471378"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0332a/thumb.jpg"
    ZoomLevel="5.504435806248001"
  >
    <Description>Southern part of the spectacular N44 H II region in the Large Magellanic Cloud. The green colour indicates areas that are particularly hot. The field measures 27.5 x 26.5 square arcminutes. North is up and East is left. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5531553382400001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="80.400795"
        CenterY="-67.911986"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="N44 in the Large Magellanic Cloud"
        OffsetX="-0.060157292326472225"
        OffsetY="-0.048228164539111704"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.044136457340000004"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0332a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0332a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0332a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0332b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-11-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-67.93168031506201"
    Magnitude="0"
    Name="N44 in the Large Magellanic Cloud (central region)"
    Opacity="100"
    RA="5.363535381296413"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0332b/thumb.jpg"
    ZoomLevel="1.7798254118879997"
  >
    <Description>The centre of the associated nebular complex N44 in the Large Magellanic Cloud in more detail. The field size is 8.5 x 8.5 square arcminutes. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.26991013888"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="80.40787"
        CenterY="-67.91188"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="N44 in the Large Magellanic Cloud (central region)"
        OffsetX="-0.017002720596642908"
        OffsetY="-0.019776217554907084"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.10219511272999997"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0332b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0332b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0332b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0332c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-11-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.13743414022802"
    Magnitude="0"
    Name="DEM L 159 nebula and KMHK 840 and 831 star clusters in the LMC"
    Opacity="100"
    RA="5.377708945615565"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0332c/thumb.jpg"
    ZoomLevel="0.7035331712639998"
  >
    <Description>The ionised region DEM L 159 and two clusters with hot stars named KMHK 840 (top left) and KMHK 831 (bottom right). The colours have been enhanced compared to ESO Press Photo eso0332a to clearly show the different shades.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13543473152"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="80.658104"
        CenterY="-68.144999"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="DEM L 159 nebula and KMHK 840 and 831 star clusters in the LMC"
        OffsetX="-0.002830626102368553"
        OffsetY="0.007554803560504544"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.20103262446"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0332c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0332c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0332c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0332d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-11-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.1817839744483"
    Magnitude="0"
    Name="DEM L 144 near N44 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.3590072992692654"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0332d/thumb.jpg"
    ZoomLevel="0.605551300614"
  >
    <Description>Region in the Large Magellanic Cloud towards the South of N44 with pink-green shades that has been designated DEM L 144. It is a region of ionised hydrogen. The colours have been enhanced compared to ESO Press Photo eso0332a to clearly show the different shades.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06777324544"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="80.374725"
        CenterY="-68.180201"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="DEM L 144 near N44 in the Large Magellanic Cloud"
        OffsetX="-0.0038631208743541527"
        OffsetY="-0.0015745185128010356"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.13029032189000003"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0332d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0332d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0332d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0332e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-11-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-67.99108392184908"
    Magnitude="0"
    Name="N44C in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.3675656847082855"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0332e/thumb.jpg"
    ZoomLevel="0.6506683785"
  >
    <Description>Part of the central nebula, known as N44C, in the Large Magellanic Cloud. The green colour indicates areas that are particularly hot. The nature of the exciting source that delivers the necessary energy has been the subject of studies during two decades but is still not known with certainty.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06762112"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="80.533005"
        CenterY="-67.937116"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="N44C in the Large Magellanic Cloud"
        OffsetX="0.007196003154540681"
        OffsetY="-0.05398509365315658"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.12635426728"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0332e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0332e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0332e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0338a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-12-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.417760324951292"
    Magnitude="0"
    Name="NGC 613"
    Opacity="100"
    RA="1.5716633335623993"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0338a/thumb.jpg"
    ZoomLevel="1.1622447604147896"
  >
    <Description>This image of the barred spiral galaxy NGC 613  was obtained with the FORS1 and FORS2 multi-mode instruments (at VLT MELIPAL and YEPUN, respectively) on December 16-18, 2001. It is a composite of three exposures in different wavebands, cf. the technical note below. The full-resolution version of this photo retains the original pixels. Note the many arms and the pronounced dust bands. North is up and East is left. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1160997595029504"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="23.5749662452"
        CenterY="-29.417774522"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 613"
        OffsetX="1.41723339237e-05"
        OffsetY="1.41723339237e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.10000000000000074"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0338a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/P.D. Barthel</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0338a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0338a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0338b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-12-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.98037126664619"
    Magnitude="0"
    Name="The starburst spiral galaxy NGC 1792"
    Opacity="100"
    RA="5.087420083466357"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0338b/thumb.jpg"
    ZoomLevel="1.1561954057519996"
  >
    <Description>Colour composite image of the starburst spiral galaxy NGC 1792 obtained with the FORS1 and FORS2 multi-mode instruments (at VLT MELIPAL and YEPUN, respectively). Its optical appearance of NGC 1792 is quite chaotic, due to the patchy distribution of dust throughout the disc of this galaxy. It is very rich in neutral hydrogen gas - fuel for the formation of new stars - and is indeed rapidly forming such stars. The galaxy is characterized by unusually luminous far-infrared radiation ; this is due to dust heated by young stars. Note the numerous background galaxies in this sky field. North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.20151553912888887"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="76.312713"
        CenterY="-37.979792"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The starburst spiral galaxy NGC 1792"
        OffsetX="0.00111160466382688"
        OffsetY="-0.0005815126388579985"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.11507070545379834"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0338b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/P. Barthel</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0338b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0338b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0338c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2003-12-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.991895288686958"
    Magnitude="0"
    Name="A dusty beauty"
    Opacity="100"
    RA="11.337485158407654"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0338c/thumb.jpg"
    ZoomLevel="1.1636242110000001"
  >
    <Description>NGC 3627, also known as Messier 66, i.e. it is the 66th object in the famous catalogue of nebulae by French astronomer Charles Messier (1730 - 1817). It is located in the constellation Leo (The Lion). NGC 3627 is a beautiful spiral with a well-developed central bulge. It also displays large-scale dust lanes. Many regions of warm hydrogen gas are seen throughout the disc of this galaxy. The latter regions are being ionised by radiation from clusters of newborn stars. Very active star-formation is most likely also occurring in the nuclear regions of NGC 3627. The galaxy forms, together with its neighbours M 65 and NGC 3628, the so-called &amp;quot;Leo Triplet&amp;quot; ; they are located at a distance of about 35 million light-years. M 66 is the largest of the three. Its spiral arms appear distorted and displaced above the main plane of the galaxy. The asymmetric appearance is most likely due to gravitational interaction with its neighbours. This photo of the spiral galaxy M 66 (or NGC 3627) was obtained with the FORS1 and FORS2 multi-mode instruments (at VLT MELIPAL and YEPUN, respectively) on December 16-18, 2001. It is a composite of three exposures in different wavebands. North is towards upper left, West towards upper right.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.188227584"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="170.062782"
        CenterY="12.991112"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A dusty beauty"
        OffsetX="-0.00020430621054872997"
        OffsetY="0.0009019845591733823"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-44.88093796228"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0338c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/P. Barthel</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0338c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0338c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0413a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-04-28T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.50802415579808"
    Magnitude="0"
    Name="Cosmic ballet or devil's mask - galaxy triplet NGC 6769-71 (VLT MELIPAL + VIMOS)"
    Opacity="100"
    RA="19.30877002345684"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0413a/thumb.jpg"
    ZoomLevel="1.0990757111399998"
  >
    <Description>Colour-composite image showing the triplet of galaxies NGC 6769, 6770 and NGC 6771, as observed with the VIMOS instrument on Melipal, one of the four 8.2-m Unit Telescopes of ESO&amp;#x27;s Very Large Telescope. The images were obtained on the morning of April 1, 2004 during twilight in three different wavebands, each of which is here being represented by a different colour: U (around 380 nm; associated to the Blue channel) ; B (425 nm ; Green channel) and V (550 nm ; Red channel). The total exposure time in the U, B and V bands is, respectively, 20, 6 and 12 minutes. The mean seeing was around 0.9 arcsec. The field shown measures 6.1 x 6.8 square arcmin. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1173190656"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="289.594565"
        CenterY="-60.500983"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cosmic ballet or devil's mask - galaxy triplet NGC 6769-71 (VLT MELIPAL + VIMOS)"
        OffsetX="-0.018250302142221668"
        OffsetY="-0.006935838314855832"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.34709913578"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0413a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0413a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0413a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0415a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-05-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-61.446869776227196"
    Magnitude="0"
    Name="Sky Field with OGLE-TR-113"
    Opacity="100"
    RA="10.873029545511987"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0415a/thumb.jpg"
    ZoomLevel="1.664472119934"
  >
    <Description>Sky field in the southern constellation Carina (The Ship Keel) with the images of the star OGLE-TR-113, around which a transiting exoplanet has been identified. The field measures 10 x 10 square arcmin; North is up and East is left. This image has been reproduced from the Digitized Sky Survey (DSS).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.21450570752"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="163.102062"
        CenterY="-61.44688"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Sky Field with OGLE-TR-113"
        OffsetX="0.003162833822573757"
        OffsetY="7.120091133780892e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-1.1073566775099999"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0415a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>DSS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0415a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0415a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0415b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-05-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-61.95620701611645"
    Magnitude="0"
    Name="Sky field with OGLE-TR-132"
    Opacity="100"
    RA="10.843155580704453"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0415b/thumb.jpg"
    ZoomLevel="1.6593142707360005"
  >
    <Description>Sky field in the southern constellation Carina (The Ship Keel) with the images of the star OGLE-TR-132, around which a transiting extra-solar planet (exoplanet) has been identified. The field measures 10 x 10 square arcmin; North is up and East is left. This image has been reproduced from the Digitized Sky Survey (DSS).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.21466770432000004"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="162.645082"
        CenterY="-61.957299"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Sky field with OGLE-TR-132"
        OffsetX="-0.0010722462143356625"
        OffsetY="0.001078601582744831"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.71865853238"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0415b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>DSS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0415b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0415b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0416a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-05-12T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-16.173646290450552"
    Magnitude="0"
    Name="Stellar cluster and star-forming region M 17"
    Opacity="100"
    RA="18.34133521269871"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0416a/thumb.jpg"
    ZoomLevel="1.0363211525999998"
  >
    <Description>Three-colour composite of the sky region of M 17, a H II region excited by a cluster of young, hot stars. A large silhouette disc has been found to the south-west of the cluster centre. The present image was obtained with the ISAAC near-infrared instrument at the 8.2-m VLT ANTU telescope at Paranal.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11247407104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="275.108067"
        CenterY="-16.17704"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stellar cluster and star-forming region M 17"
        OffsetX="-0.01148913924095479"
        OffsetY="0.0033888030330688225"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.02280422246"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0416a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0416a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0416a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0416b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-05-12T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-16.173231608328916"
    Magnitude="0"
    Name="Stellar cluster and star-forming region M 17 (annotated)"
    Opacity="100"
    RA="18.341341366473404"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0416b/thumb.jpg"
    ZoomLevel="1.024198324896"
  >
    <Description>Three-colour composite of the sky region of M 17, a H II region excited by a cluster of young, hot stars. A large silhouette disc has been found to the south-west of the cluster centre. The present image was obtained with the ISAAC near-infrared instrument at the 8.2-m VLT ANTU telescope at Paranal. The orientation and the scale at the distance of M 17 (7,000 light-years) are indicated, and the main regions are identified.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13318844416"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="275.196102"
        CenterY="-16.172013"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stellar cluster and star-forming region M 17 (annotated)"
        OffsetX="0.0729758762952796"
        OffsetY="-0.0011471073745517861"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.06672023219"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0416b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0416b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0416b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0419b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-06-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-19.932538127450535"
    Magnitude="0"
    Name="Cluster of galaxies RXCJ1131.9-1955"
    Opacity="100"
    RA="11.53171361785534"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0419b/thumb.jpg"
    ZoomLevel="1.3762430936555994"
  >
    <Description>Very massive galaxy cluster RXCJ1131.9-1955 at redshift z = 0.306 in a very rich galaxy field with two major concentrations. It was originally found by George Abell and designated &amp;quot;Abell 1300&amp;quot;. The image was obtained with the ESO/MPG 2.2-m telescope and the WFI camera at La Silla.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.24529784738489577"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="172.988186004"
        CenterY="-19.9253789442"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cluster of galaxies RXCJ1131.9-1955"
        OffsetX="0.0115334694674265"
        OffsetY="-0.007478322668377005"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5698427254008833"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0419b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0419b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0419b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0419c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-06-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-20.39345013823487"
    Magnitude="0"
    Name="Cluster of galaxies RXCJ0937.9-2020"
    Opacity="100"
    RA="9.637379870168896"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0419c/thumb.jpg"
    ZoomLevel="1.9017428029679997"
  >
    <Description>Nearby galaxy group RXCJ0937.9-2020 at a redshift of z = 0.034. It is dominated by the massive elliptical galaxy seen at the top of the image. The photo covers only the southern part of this group. Such galaxy groups with typical masses of a few 1013 solar masses constitute the smallest objects included in the REFLEX catalogue. This image was obtained with the FORS1 multi-mode instrument on the ESO 8.2-m VLT Antu telescope.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.18777483332988443"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="144.506497"
        CenterY="-20.343523"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cluster of galaxies RXCJ0937.9-2020"
        OffsetX="-0.0006609376953035826"
        OffsetY="-0.0712241758138919"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-44.96231704612881"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0419c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0419c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0419c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0421a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-06-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-5.385526187095931"
    Magnitude="0"
    Name="The Orion Nebula (M42)"
    Opacity="100"
    RA="5.587773977128852"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0421a/thumb.jpg"
    ZoomLevel="5.48409093232197"
  >
    <Description> The individual images of the Orion Nebula where obtained with WFI at the ESO/MPG 2.2m telescope on the night of Dec.10-11, 2001. Several images were obtained in the following filters: U (363.690 nm; 15 images for a total exposure time of 1.25 hour); B (456.252 nm; 14 images; total exp.: 21 min); Oxygen [OIII] (502.393 nm; 15 images; total exp.: 32 min); Halpha (658.827 nm; 15 images; total exp.: 32 min); Sulphur [SII] (676.340 nm; 10 images; total exp.: 30 min). ESO Press Photo eso0421 is a false-colour composite of all of the images obtained in B, Halpha, [OIII], and [SII] where each waveband was associated to a given colour: B to blue, [OIII] to green; Halpha to orange, and [SII] to red. The field of view covers 34 x 33 arcmin2. North is up and East is to the left. The images were first processed by Massimo Robberto (STSci) then further combined by Hännes Heyer and Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.6536773133003565"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8576331954"
        CenterY="-5.36093378445"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Orion Nebula (M42)"
        OffsetX="0.040804248008348004"
        OffsetY="-0.024657112432852034"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.08890549347008958"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0421a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0421a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0421a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0422a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-07-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.765240276067413"
    Magnitude="0"
    Name="Small part of the K20 Field showing the z=1.9 elliptical galaxy"
    Opacity="100"
    RA="3.5427008560590423"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0422a/thumb.jpg"
    ZoomLevel="0.10257316114446015"
  >
    <Description>Small region in the K20 field centred on a z=1.9 redshift galaxy. The image is based on frames acquired by the Advanced Camera for Surveys (ACS) on the Hubble Space Telescope in the framework of the GOODS Public HST Treasury Program (P.I. M. Giavalisco, STScI, Baltimore, USA). They show the real colours of the galaxies. The four old massive spheroidal galaxies discovered in this survey appear very red compared to the other faint galaxies.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.017602633988926964"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.1405178094"
        CenterY="-27.7652444569"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Small part of the K20 Field showing the z=1.9 elliptical galaxy"
        OffsetX="4.29018441513e-06"
        OffsetY="4.290184415130401e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-1.437543694132353"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0422a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0422a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0422a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0425a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-08-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-53.67395414525847"
    Magnitude="0"
    Name="Globular cluster NGC 6397"
    Opacity="100"
    RA="17.677990371658428"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0425a/thumb.jpg"
    ZoomLevel="2.6765895328019997"
  >
    <Description>The globular cluster NGC 6397, located at a distance of approx. 7,200 light-years in the southern constellation Ara. It has undergone a &amp;quot;core collapse&amp;quot; and the central area is very dense. It contains about 400,000 stars and its age (based on evolutionary models) is 13,400 ± 800 million years. The photo is a composite of exposures in the B-, V- and I-bands obtained in the frame of the Pilot Stellar Survey with the Wide-Field-Imager (WFI) camera at the 2.2-m ESO/MPI telescope at the ESO La Silla Observatory. It was prepared and provided by the ESO Imaging Survey team. The spikes seen at some of the brighter stars are caused by the effect of overexposure (CCD &amp;quot;bleeding&amp;quot;).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27751985151999997"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="265.175412"
        CenterY="-53.674218"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Globular cluster NGC 6397"
        OffsetX="0.0032915993623861884"
        OffsetY="0.0002626364435894389"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.01896852663"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0425a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0425a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0425a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0434a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-11-18T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-31.64059487491888"
    Magnitude="0"
    Name="Big stellar cluster in the blue dwarf galaxy NGC 5253"
    Opacity="100"
    RA="13.665572423749062"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0434a/thumb.jpg"
    ZoomLevel="0.21659097965399998"
  >
    <Description>Composite colour-coded image of the small starburst galaxy NGC 5253, at a distance of 11 million light-years. It is based on one near-infrared image (in the K-band at wavelength 2.16 μm; here coded red) obtained with the ESO Very Large Telescope (VLT) and two images in the visual spectral region (V- (0.55 μm) and I-bands (0.79 μm), here blue and green, respectively) with the NASA/ESA Hubble Space Telescope (HST). The image covers 80 x 80 square arcseconds on the sky. North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.03793115674571304"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="204.982247222"
        CenterY="-31.6415430556"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Big stellar cluster in the blue dwarf galaxy NGC 5253"
        OffsetX="-0.0002505954313080272"
        OffsetY="0.001462988529166832"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="40.51385900251077"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0434a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0434a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0434a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0434b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-11-18T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-31.641377343658796"
    Magnitude="0"
    Name="Big stellar cluster in the blue dwarf galaxy NGC 5253"
    Opacity="100"
    RA="13.665430217977026"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0434b/thumb.jpg"
    ZoomLevel="0.261167863704"
  >
    <Description>Composite colour-coded image of the small starburst galaxy NGC 5253, at a distance of 11 million light-years. It is based on one near-infrared image (in the K-band at wavelength 2.16 μm; here coded red) obtained with the ESO Very Large Telescope (VLT) and two images in the visual spectral region (V- (0.55 μm) and I-bands (0.79 μm), here blue and green, respectively) with the NASA/ESA Hubble Space Telescope (HST). The image covers 80 x 80 arcseconds on the sky. North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04319473664"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="204.982247222"
        CenterY="-31.6415430556"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Big stellar cluster in the blue dwarf galaxy NGC 5253"
        OffsetX="0.0006234525155353906"
        OffsetY="-0.00030927000425431"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="40.15900925955001"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0434b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0434b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0434b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0436a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-01T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-2.2864562137522233"
    Magnitude="0"
    Name="Spiral galaxy NGC 6118"
    Opacity="100"
    RA="16.363712437378748"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0436a/thumb.jpg"
    ZoomLevel="0.9978560145619062"
  >
    <Description>These are almost-true colour composites based on images made with the multi-mode VIMOS instrument on the 8.2-m Melipal (Unit Telescope 3) of ESO&amp;#x27;s Very Large Telescope. In each case, exposures were taken in three different wavebands which were associated to a given colour: R-band (centred around 652 nm; red), V (540 nm; green) and B (456 nm; blue). The images of NGC 6118 were taken on several nights around August 21, 2004 when the observing conditions were somewhat unstable (seeing around 2 arcsec). The total exposure was 12.5 min in R, 25 min in V and 7 min in B. The images of NGC 7424 were obtained on the night of October 9, 2004, (around 4:00 am CET) when the conditions were good (seeing: 1 arcsec). The total exposure time was 7 min in R, 25 min in V and 10 min in B. The pixel scale is 0.205 arcsec/pix. All exposures were taken and pre-processed by ESO Paranal Science Operation Astronomers. Further image processing was made by Hännes Heyer (ESO) for NGC 6118 and by Henri Boffin (ESO) for NGC 7424. The classification of Supernova 2004dk was made by Ferdinando Patat and Giuliano Pignata (ESO) and S. Benetti (INAF, Italy) using data from the Calar Alto Observatory (Spain). Composite colour-coded image of the &amp;quot;grand design&amp;quot; spiral galaxy NGC 6118, at a distance of 80 million light-years. It is based on images obtained with the multi-mode VIMOS instrument on the ESO Very Large Telescope (VLT) in three different wavebands. The image covers 6.7 x 5.8 square arcminutes on the sky. North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11655255094861262"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="245.45713895"
        CenterY="-2.28720953449"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 6118"
        OffsetX="0.0014714483565045043"
        OffsetY="0.0007134295061839988"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5792456181975347"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0436a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0436a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0436a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0436b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-01T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-2.2869712843657886"
    Magnitude="0"
    Name="Spiral galaxy NGC 6118 and SN 2004dk"
    Opacity="100"
    RA="16.363726188807544"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0436b/thumb.jpg"
    ZoomLevel="1.0018150686180003"
  >
    <Description>Composite colour-coded image of the &amp;quot;grand design&amp;quot; spiral galaxy NGC 6118, at a distance of 80 million light-years. It is based on images obtained with the multi-mode VIMOS instrument on the ESO Very Large Telescope (VLT) in three different wavebands. The image covers 6.7 x 5.8 square arcminutes on the sky. North is up and East is to the left. The arrow indicates the position of supernova SN 2004dk.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1520398722844445"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="245.452598"
        CenterY="-2.283416"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 6118 and SN 2004dk"
        OffsetX="-0.00329718358225179"
        OffsetY="-0.003550650820052034"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.08024072019899102"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0436b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0436b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0436b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0437a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.93211665468651"
    Magnitude="0"
    Name="LMC region near the Tarantula Nebula"
    Opacity="100"
    RA="5.713206053223246"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0437a/thumb.jpg"
    ZoomLevel="5.598424144439999"
  >
    <Description>Turbulent region around the ring-shaped nebula DEM L 299 in the Large Magellanic Cloud, a satellite galaxy of the Milky Way system. It was produced by combining three monochromatic images obtained in December 2001 with the Wide-Field-Imager (WFI) at the ESO/MPG 2.2-m telescope at the La Silla Observatory. The sky field measures 33.3 x 33.0 arcmin ; the original pixel size (in the FullRes version) is 0.238 arcsec. North is up and East is left. The coloured rings seen near some of the brighter stars in the field result from light reflections in the telescope optics.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0824032256"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.716991"
        CenterY="-68.948167"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="LMC region near the Tarantula Nebula"
        OffsetX="0.006792436775700548"
        OffsetY="0.016050015614111374"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.006035222489999999"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0437a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0437a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0437a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0437b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.16044396885052"
    Magnitude="0"
    Name="Filaments in the Tarantula Nebula"
    Opacity="100"
    RA="5.67129315397438"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0437b/thumb.jpg"
    ZoomLevel="0.9573598760759996"
  >
    <Description>Filaments of ionized gas in the proximity of the R136 cluster, which lies beyond the lower left edge of the photo. The different hues are due to different physical conditions that manifest themselves in the spectrum of the light emitted by the gas. Note also the dark lanes running roughly from bottom left to upper right, which are due to filaments of obscuring dust seen in projection against the background of bright nebulosity. The sky field measures 6.5 x 5.7 arcmin. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13517780991999997"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6775406933"
        CenterY="-69.1010798777"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Filaments in the Tarantula Nebula"
        OffsetX="-0.14038232580583174"
        OffsetY="-0.05747407494214207"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.9565496455599999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0437b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0437b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0437b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0437c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.94664692087215"
    Magnitude="0"
    Name="SNR 0543-689 in the LMC"
    Opacity="100"
    RA="5.7152990613205334"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0437c/thumb.jpg"
    ZoomLevel="0.5934002949"
  >
    <Description>This is a bright, compact nebula that is located on the North-Western rim of the ringshaped nebula DEM L 299. It is known as SNR 0543-689 and it is the remnant of a more recent supernova explosion. The sky field measures 3.6 x 3.5 arcmin. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.067850496"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6775406933"
        CenterY="-69.1010798777"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SNR 0543-689 in the LMC"
        OffsetX="-0.37419758767232575"
        OffsetY="0.16010695730288715"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.357686077"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0437c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0437c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0437c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0437e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.08146003863654"
    Magnitude="0"
    Name="N 164 nebula in the LMC"
    Opacity="100"
    RA="5.709476263229629"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0437e/thumb.jpg"
    ZoomLevel="1.10987572716"
  >
    <Description>N 164, a bright nebula, the glow of which is caused by hot stars inside it. The heating of the gas by these stars increases the pressure and causes such nebulae to expand, pushing outwards against their surroundings. A careful look at this nebula reveals locations where the expansion is encountering resistance by denser clouds of gas, producing bright, thin rims. The sky field measures 3.6 x 3.5 arcmin. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1355508736"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6775406933"
        CenterY="-69.1010798777"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="N 164 nebula in the LMC"
        OffsetX="-0.3440549568714122"
        OffsetY="0.022763325371176712"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.9739515724100001"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0437e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0437e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0437e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0437f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.96826383023975"
    Magnitude="0"
    Name="DEM L 297 Nebula in the LMC"
    Opacity="100"
    RA="5.703480382790648"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0437f/thumb.jpg"
    ZoomLevel="0.594508921272"
  >
    <Description>DEM L 297 is a diffuse nebula in the Large Magellanic Cloud that glows due to stars embedded in it. Its &amp;quot;divided&amp;quot; appearance is due to the presence of obscuring dust lanes. The sky field measures 6.5 x 5.7 arcsec. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06766897152"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.542374"
        CenterY="-68.966999"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="DEM L 297 Nebula in the LMC"
        OffsetX="-0.003532638920735383"
        OffsetY="-0.0012534097311326998"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.18992393454"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0437f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0437f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0437f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0437g&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.90792144909852"
    Magnitude="0"
    Name="Stellar cluster NGC 2093 in the LMC"
    Opacity="100"
    RA="5.698187055723727"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0437g/thumb.jpg"
    ZoomLevel="0.8650377584760001"
  >
    <Description>Stellar cluster NGC 2093 in the Large Magellanic Cloud, a comparatively rich aggregate of young stars, a few tens of millions of years old. The hot temperature of the most massive of such young stars is responsible for its predominantly blue colour. The sky field measures 5.6 x 5.1 arcmin. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13505910784"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.453636"
        CenterY="-68.922167"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stellar cluster NGC 2093 in the LMC"
        OffsetX="-0.0068273094486765344"
        OffsetY="0.014278784221926185"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.28643634330000006"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0437g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0437g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0437g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0437h&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.18233324583129"
    Magnitude="0"
    Name="NGC 2108 stellar cluster in the LMC"
    Opacity="100"
    RA="5.7322716502395155"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0437h/thumb.jpg"
    ZoomLevel="0.4538430623759999"
  >
    <Description>NGC 2108 is a rich &amp;quot;mid-aged&amp;quot; cluster, about 600 million years old. A careful comparison with its neighbour NGC 2093 shows that the brightest stars of NGC 2108 are fainter and whiter than the brightest members of NGC 2093; this indicates that NGC 2108 is older. Note also the distinctly red star to the East (left) of the center of this cluster. This is a member of a stellar class referred to as &amp;quot;Carbon stars&amp;quot;, cool giant stars that are characterized by the presence of carbon molecules (C2) in their atmospheres and having extremely red colours. This sky field measures 2.8 x 2.6 arcsec. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06820701184"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="86.1106899649"
        CenterY="-69.1464195078"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 2108 stellar cluster in the LMC"
        OffsetX="0.045336851490532855"
        OffsetY="-0.03553259358651708"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.5424419574"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0437h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0437h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0437h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0438d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2004-12-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-30.277133135369002"
    Magnitude="0"
    Name="Spiral galaxy NGC 1097"
    Opacity="100"
    RA="2.771690585599425"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0438d/thumb.jpg"
    ZoomLevel="1.314956654208"
  >
    <Description>It is an almost-true colour composite based on images made with the multi-mode VIMOS instrument on the 8.2-m Melipal (Unit Telescope 3) of ESO&amp;#x27;s Very Large Telescope. Exposures were taken in three different wavebands which were associated to a given colour : R-band (centred around 652 nm; red), V (540 nm; green) and B (456 nm; blue). The images were taken on the night of December 9 to 10, 2004 in the presence of the President of the Republic of Chile, M. Ricardo Lagos. The observing conditions were very good (seeing well below 1 arcsec). The total exposure was 2.25 min in R, 3 min in V and 6 min in B. The scale is 0.205 arcsec/pix and the image covers a 7.7 x 6.6 arcmin2 region on the sky. All exposures were taken and pre-processed by ESO Paranal Science Operation astronomers. Additional image processing by Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13671076732371262"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="41.579331"
        CenterY="-30.274894"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 1097"
        OffsetX="0.0034356073236517103"
        OffsetY="-0.0022317643072804396"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.1336389661473766"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0438d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0438d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0438d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0510a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-03-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-45.851960429619595"
    Magnitude="0"
    Name="The super star cluster Westerlund 1"
    Opacity="100"
    RA="16.784282774409476"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0510a/thumb.jpg"
    ZoomLevel="0.8491659548400001"
  >
    <Description>Composite image of the super star cluster &amp;quot;Westerlund 1&amp;quot; from 2.2-m MPG/ESO Wide-Field Imager (WFI) observations. The image covers a 5 x 5 arcmin sky region and is based on observations made in the V-band (550 nm, 2 min exposure time, associated to the blue channel), R-band (650nm, 1 min, green channel) and I-band (784nm, 18 sec, red channel). Only the central CCD of WFI was used, as the entire cluster fits comfortably inside it. The foreground stars appear blue, while the hot massive members of the cluster look orange, and the cool massive ones come out red.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1352095190179223"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="251.76675"
        CenterY="-45.851219"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The super star cluster Westerlund 1"
        OffsetX="0.0017463838691846776"
        OffsetY="-0.000743200910912291"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.057291299787180304"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0510a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0510a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0510a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0513a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-04-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-71.31510111290811"
    Magnitude="0"
    Name="Part of the LMC H II region N214"
    Opacity="100"
    RA="5.695544322170096"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0513a/thumb.jpg"
    ZoomLevel="0.887774626926"
  >
    <Description>Composite six-colour image of a part of the LMC H II region N214. The image, taken with the ESO NTT/SuSI2, results from the co-addition of several individual exposures taken through various narrow and broadband filters (see Technical Information below). The field size is 248&amp;quot;x 332&amp;quot; corresponding to approximately 200 x 270 light-years. North is up and east to the left. The large nebula in the lower part is N214C which in shown further as ESO Press Photo eso0513b. At upper left to the middle, a stellar cluster is clearly seen. At top-right, another series of compact reddish nebulae, N214H, are present. The new observations reveal that N214H consist of four compact H II regions hosting exciting stars and a diffuse nebula.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1076396251269565"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.415354"
        CenterY="-71.332176"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Part of the LMC H II region N214"
        OffsetX="-0.0056110475668866315"
        OffsetY="0.01710533285060566"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.3181330591060869"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0513a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0513a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0513a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0513b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-04-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-71.33221127985534"
    Magnitude="0"
    Name="The LMC HII region N214C"
    Opacity="100"
    RA="5.69401572883651"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0513b/thumb.jpg"
    ZoomLevel="0.54159212034"
  >
    <Description>Zoom-in on the LMC H II region N214C. The field size is 193&amp;quot;x 201&amp;quot; corresponding to roughly 160 x 170 light-years. The brightest object, situated toward the middle of the nebula, is the Sk-71 51 cluster. The striking compact H II blob lies ~ 60&amp;quot; (~ 50 light-years) north of Sk-71 51.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08416656517151704"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.415354"
        CenterY="-71.332176"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The LMC HII region N214C"
        OffsetX="0.0016379912614054874"
        OffsetY="-4.3724288498714424e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.2926504200771447"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0513b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0513b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0513b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0513e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-04-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-71.31717443477243"
    Magnitude="0"
    Name="The Nebular Blob in N214C"
    Opacity="100"
    RA="5.694060497997522"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0513e/thumb.jpg"
    ZoomLevel="0.272305158534"
  >
    <Description>Zoom-in on the nebular blob lying ~ 60&amp;quot; (50 light-years) north of the Sk-71 51 cluster. The image is based on individual exposures taken through narrow-band filters around H-alpha (red), [O III] (green) and H-beta (blue). The field size is 104&amp;quot; x 101&amp;quot; on the sky, corresponding to roughly 85 by 82 light-years. North is up and east to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.045429667121030325"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.415354"
        CenterY="-71.332176"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Nebular Blob in N214C"
        OffsetX="0.0014913454919998868"
        OffsetY="0.01499498889986389"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.2559226957355282"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0513e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0513e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0513e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0521a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-06-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.9929121905587"
    Magnitude="0"
    Name="Deep image of a region in Fornax"
    Opacity="100"
    RA="3.552490839987965"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0521a/thumb.jpg"
    ZoomLevel="0.9642302570559887"
  >
    <Description>Composite image taken in two bands (B and R) with VLT/FORS1 of a small portion of the sky (field-of-view 7x7&amp;#x27; or 1/15th of the area of the full moon). The faintest object seen in the image has a magnitude 26 ; that is, it is 100 million times fainter than what can be observed with the unaided eye. The bright elliptical galaxy in the lower left quadrant is a dwarf galaxy that is part of a large nearby cluster in the Fornax constellation. As for all deep images of the sky, this field shows a variety of objects, the brightest punctual sources being stars from our galaxy. By far the field is dominated by thousands of faint background galaxies, the colours of which are related to the age of their dominant stellar population, their dust content and their distance. An Einstein ring is visible in the top right part of the image. ESO Press Photo eso0521b zooms-in on the position of the newly found cosmic mirage.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11348318313970675"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.2908220695"
        CenterY="-35.9850642814"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Deep image of a region in Fornax"
        OffsetX="0.0025821344029731"
        OffsetY="-0.007921463168442904"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5759493484524871"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0521a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0521a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0521a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0521b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-06-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.96423011781192"
    Magnitude="0"
    Name="Zoom-in on the Einstein ring on a region in Fornax"
    Opacity="100"
    RA="3.54995143952763"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0521b/thumb.jpg"
    ZoomLevel="0.31753224121688156"
  >
    <Description>Using ESO&amp;#x27;s Very Large Telescope, Remi Cabanac and his European colleagues discovered an amazing cosmic mirage, known to scientists as an Einstein Ring. Dubbed FOR J0332-3557, this phenomenon is seen towards the southern constellation Fornax (the Furnace), and is remarkable on at least two counts : first, it is a bright, almost complete Einstein ring, and second, it is the farthest ever found as of this writing.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06350148718968962"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.2493059101"
        CenterY="-35.9642579324"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Zoom-in on the Einstein ring on a region in Fornax"
        OffsetX="2.7795189182149798e-05"
        OffsetY="2.779518918214914e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.04000809288969892"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0521b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0521b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0521b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0524a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-08-01T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.68206499223349"
    Magnitude="0"
    Name="Observed fields in NGC 300"
    Opacity="100"
    RA="0.914807006010244"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0524a/thumb.jpg"
    ZoomLevel="5.077337131741141"
  >
    <Description>Location of the three fields in the Sculptor spiral galaxy NGC 300 for which deep imaging in the near-infrared J and K filters was obtained with VLT/ISAAC. The fields contain together 16 Cepheids with periods from 6 to 83 days.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.9118512088994577"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="13.667664737"
        CenterY="-37.665274732"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Observed fields in NGC 300"
        OffsetX="-0.04353118725022201"
        OffsetY="-0.01561656941711997"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.577321838442838"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0524a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0524a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0524a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0525a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-08-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="25.988174895819974"
    Magnitude="0"
    Name="Spiral galaxy NGC 4565"
    Opacity="100"
    RA="12.605812355348744"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0525a/thumb.jpg"
    ZoomLevel="1.1629726911"
  >
    <Description>The first galaxy pictured here is NGC 4565, which for obvious reasons is also called the Needle Galaxy. First spotted in 1785 by Uranus&amp;#x27; discoverer, Sir William Herschel (1738-1822), this is one of the most famous example of an edge-on spiral galaxy and is located some 30 million light-years away in the constellation Coma Berenices (Berenice&amp;#x27;s Hair). It displays a bright yellowish central bulge that juts out above most impressive dust lanes. Because it is relatively close (it is only 12 times farther away than Messier 31, the Andromeda galaxy, which is the major galaxy closest to us) and relatively large (roughly one third larger than the Milky Way), it does not fit entirely into the field of view of the FORS instrument (about 7 x 7 arcmin2). Many background galaxies are also visible in this FORS image, giving full meaning to their nickname of &amp;quot;island universes&amp;quot;.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.114128384"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="189.086811"
        CenterY="25.987232"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 4565"
        OffsetX="0.00033648198672278564"
        OffsetY="-0.0009428954653725506"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="179.99985759328"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0525a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0525a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0525a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0525b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-08-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.865137739521774"
    Magnitude="0"
    Name="Spiral galaxy Messier 83"
    Opacity="100"
    RA="13.616738677962058"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0525b/thumb.jpg"
    ZoomLevel="1.1558875211999997"
  >
    <Description>If our Milky Way were to resemble this one, we certainly would be proud of our home ! The beautiful spiral galaxy Messier 83 [4] is located in the southern constellation Hydra (the Water Snake) and is also known as NGC 5236 and as the Southern Pinwheel galaxy. Its distance is about 15 million light-years. Being about twice as small as the Milky Way, its size on the sky is 11x10 arcmin2... The image show clumpy, well-defined spiral arms that are rich in young stars, while the disc reveals a complex system of intricate dust lanes. This galaxy is known to be a site of vigorous star formation.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11376670719999998"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="204.253949"
        CenterY="-29.865712"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy Messier 83"
        OffsetX="0.0024881405895846127"
        OffsetY="0.0005729672070879901"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.02906836637"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0525b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0525b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0525b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0527a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-08-24T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-62.781121508248496"
    Magnitude="0"
    Name="Supernova 2005dh and spiral galaxy NGC 1559"
    Opacity="100"
    RA="4.293937383831776"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0527a/thumb.jpg"
    ZoomLevel="0.9063718572"
  >
    <Description>Colour-composite image of the spiral galaxy NGC 1559 in the Reticulum constellation, obtained with the multi-mode FORS1 instrument on ESO&amp;#x27;s 8.2m VLT. The supernova, SN 2005df, is visible as the bright star just above the galaxy. Many background galaxies can also be seen in this image.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11388313600000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="64.405671"
        CenterY="-62.784163"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Supernova 2005dh and spiral galaxy NGC 1559"
        OffsetX="-0.0015478298772450146"
        OffsetY="0.0030427823729449613"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.04924277874"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0527a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0527a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0527a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0532a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-09-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-33.62629481304104"
    Magnitude="0"
    Name="The colossal cosmic eye NGC 1350"
    Opacity="100"
    RA="3.5184585655167044"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0532a/thumb.jpg"
    ZoomLevel="0.8452044950488444"
  >
    <Description>Colour-composite of the spiral galaxy NGC 1350 taken with FORS2 at the ESO Very Large Telescope. The image, totalling 16 minutes of observations, clearly reveals the delicate structures in this gigantic &amp;quot;eye&amp;quot; as well as many background galaxies.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2142724804243456"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="52.7752155273"
        CenterY="-33.6325375803"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The colossal cosmic eye NGC 1350"
        OffsetX="0.006387724204536193"
        OffsetY="-0.00029384687658958955"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="105.1400000000001"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0532a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0532a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0532a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0533a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-10-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-38.97755826268418"
    Magnitude="0"
    Name="First visible light from GRB 050709"
    Opacity="100"
    RA="23.02415445504652"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0533a/thumb.jpg"
    ZoomLevel="0.335245459176"
  >
    <Description>First image in the visible (more precisely here, in the so-called R-band) of a short gamma-ray burst. The image was taken with the Danish 1.5-m telescope and the DFOSC camera at La Silla on 11 July 2005. It shows the gamma-ray burst to be situated on the edge of a low-redshift galaxy.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05618700288"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="345.36257"
        CenterY="-38.977755"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="First visible light from GRB 050709"
        OffsetX="-5.111951410002282e-07"
        OffsetY="0.00027828340350522407"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-45.11671257801"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0533a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0533a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0533a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0534a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-10-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-30.274621107746498"
    Magnitude="0"
    Name="The centre of the active galaxy NGC 1097"
    Opacity="100"
    RA="2.7719269224488814"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0534a/thumb.jpg"
    ZoomLevel="0.08137966878"
  >
    <Description>Colour-composite image of the central 5,500 light-years wide region of the spiral galaxy NGC 1097, obtained with the NACO adaptive optics on the VLT. More than 300 star forming regions - white spots in the image - are distributed along a ring of dust and gas in the image. At the centre of the ring there is a bright central source where the active galactic nucleus and its super-massive black hole are located. The image was constructed by stacking J- (blue), H- (green), and Ks-band (red) images. North is up and East is to the left. The field of view is 24 x 29 arcsec2, i.e. less than 0.03% the size of the full moon!</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00963997696"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="41.57874"
        CenterY="-30.27411"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The centre of the active galaxy NGC 1097"
        OffsetX="-0.00014604406651399788"
        OffsetY="-0.0005098259436638809"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.5108724014299999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0534a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Prieto et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0534a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0534a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0535a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-11-04T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-48.639655548056695"
    Magnitude="0"
    Name="Robert's Quartet"
    Opacity="100"
    RA="0.3566477378871842"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0535a/thumb.jpg"
    ZoomLevel="0.961154785872"
  >
    <Description>Robert&amp;#x27;s Quartet is a family of four very different galaxies, located at a distance of about 160 million light-years, close to the centre of the southern constellation of the Phoenix. Its members are NGC 87, NGC 88, NGC 89 and NGC 92, discovered by John Herschel in the 1830s. NGC 87 (upper right) is an irregular galaxy similar to the satellites of our Milky Way, the Magellanic Clouds. NGC 88 (centre) is a spiral galaxy with an external diffuse envelope, most probably composed of gas. NGC 89 (lower middle) is another spiral galaxy with two large spiral arms. The largest member of the system, NGC 92 (left), is a spiral Sa galaxy with an unusual appearance. One of its arms, about 100,000 light-years long, has been distorted by interactions and contains a large quantity of dust.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11432749056"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="5.341938"
        CenterY="-48.642716"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Robert's Quartet"
        OffsetX="-0.0050514479614227"
        OffsetY="0.0032037548869018966"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.61416963071"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0535a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0535a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0535a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0535b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-11-04T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-48.63102719191097"
    Magnitude="0"
    Name="NGC 92 in H-alpha"
    Opacity="100"
    RA="0.35976827657840804"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0535b/thumb.jpg"
    ZoomLevel="0.54616282398"
  >
    <Description>The largest member of the galaxy group known as Robert&amp;#x27;&amp;#x27;s Quartet is NGC 92, a spiral Sa galaxy with an unusual appearance. One of its arms, about 100,000 light-years long, has been distorted by interactions and contains a large quantity of dust. Using this H-alpha image obtained with FORS2 on the VLT, astronomers were able to study the properties of regions of active star formation (&amp;quot;HII regions&amp;quot;). They found more than 200 of such regions in NGC 92, with a size between 500 and 1,500 light-years.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0568485888"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="5.382111"
        CenterY="-48.625021"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 92 in H-alpha"
        OffsetX="-0.009554712011265665"
        OffsetY="-0.0059608856853830714"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.27749563431"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0535b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0535b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0535b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0544a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-12-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-26.3676695974746"
    Magnitude="0"
    Name="NGC 2467 and surroundings*"
    Opacity="100"
    RA="7.877678121599026"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0544a/thumb.jpg"
    ZoomLevel="5.061088550399999"
  >
    <Description>Area surrounding the stellar cluster NGC 2467, located in the southern constellation of Puppis (&amp;quot;The Stern&amp;quot;). With an age of a few million years at most, it is a very active stellar nursery, where new stars are born continuously from large clouds of dust and gas. The image, looking like a colourful cosmic ghost or a gigantic celestial Mandrill, contains the open clusters Haffner 18 (centre) and Haffner 19 (middle right: it is located inside the smaller pink region — the lower eye of the Mandrill), as well as vast areas of ionised gas. The bright star at the centre of the largest pink region on the bottom of the image is HD 64315, a massive young star that is helping shaping the structure of the whole nebular region. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.770057547633608"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="118.080542"
        CenterY="-26.441611"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 2467 and surroundings*"
        OffsetX="0.07394075217806632"
        OffsetY="0.07580167311474105"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="90.01827372968"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0544a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0544a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0544a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0544b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2005-12-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-26.38177922696967"
    Magnitude="0"
    Name="Open cluster Haffner 18"
    Opacity="100"
    RA="7.876631105125629"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0544b/thumb.jpg"
    ZoomLevel="1.1648789867110692"
  >
    <Description>Open stellar cluster Haffner 18, perfectly illustrating three different stages of this process of star formation : in the centre of the picture, Haffner 18, a group of mature stars that have already dispersed their birth nebulae, represents the completed product or immediate past of the star formation process. Located at the bottom left of this cluster, a very young star, just come into existence and, still surrounded by its birth cocoon of gas, provides insight into the very present of star birth. Finally, the dust clouds towards the right corner of the image are active stellar nurseries that will produce more new stars in the future. Haffner 18 contains about 50 stars, among which several short lived, massive ones. The massive star still surrounded by a small, dense shell of hydrogen, has the rather cryptic name of FM3060a. The shell is about 2.5 light-years wide and expands at a speed of 20 km/s. It must have been created some 40,000 years ago. The cluster is between 25,000 and 30,000 light-years away from us.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11448332252571045"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="118.149497679"
        CenterY="-26.3818071822"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Open cluster Haffner 18"
        OffsetX="2.7909047464950004e-05"
        OffsetY="2.790904746495004e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.09460434955394825"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0544b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0544b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0544b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0604a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-02-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-1.9467056033773262"
    Magnitude="0"
    Name="The central part of Messier 12"
    Opacity="100"
    RA="16.78729201883444"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0604a/thumb.jpg"
    ZoomLevel="0.5754922112853063"
  >
    <Description>Centre of the globular cluster Messier 12 as observed with the FORS-1 multi-mode instrument on ESO&amp;#x27;s Very Large Telescope (Cerro Paranal, Chile). The picture covers a region of about 3.5 arcmin on a side, corresponding to about 23 light-years at the distance of Messier 12. It is based on data in five different filters : U, B, V, R and H-alpha. Here only the short exposures were used while for their scientific analysis, the authors used much longer exposures. Guido De Marchi (ESA) reduced the data and Kristina Boneva and Haennes Heyer (ESO) did the final image processing. The observations were obtained with very good conditions, the image quality (&amp;#x27;seeing&amp;#x27;) being around 0.6 arcsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0756216025505792"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="251.809389519"
        CenterY="-1.94671483453"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The central part of Messier 12"
        OffsetX="9.2311526551e-06"
        OffsetY="9.2311526551e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0604a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0604a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0604a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0608a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-02-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="15.82021428627975"
    Magnitude="0"
    Name="Spiral galaxy Messier 100"
    Opacity="100"
    RA="12.381616810067177"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0608a/thumb.jpg"
    ZoomLevel="0.9426179419709534"
  >
    <Description>Composite based on five images taken with FORS1 on Kueyen (VLT) by Dominique Naef, Eric Depagne and Chris Lidman (ESO). The images were taken through different filters: U, V, R, I, and a narrow-band filter centred on the H-alpha line. The exposure time is 60 seconds in the V, R and I filters, 3 minutes in the U-band and 5 minutes in the H-alpha filter. The field of view is 6.8 x 5.1 arcmin2. North is up and East is to the left. The final processing was done by Kristina Boneva, Haennes Heyer and Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1332602686738052"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="185.729344538"
        CenterY="15.8285328455"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy Messier 100"
        OffsetX="0.004669595760768751"
        OffsetY="-0.008449744709962499"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5710105299258204"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0608a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0608a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0608a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0613a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-04-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.1003529736711"
    Magnitude="0"
    Name="Cosmic spider: the Tarantula Nebula"
    Opacity="100"
    RA="5.644991719741359"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0613a/thumb.jpg"
    ZoomLevel="1.15032441366"
  >
    <Description>Three-colour image of the Tarantula Nebula in the Large Magellanic Cloud. The image is based on observations made on 10 February 2002 and 22 March 2003 with the FORS1 multi-mode instrument on ESO&amp;#x27;s Very Large Telescope in three different narrow-band filters (centred on 485 nm, 503 nm, and 657 nm), for a total exposure time slightly above 3 minutes only. The data were extracted from the ESO Science Archive and processed by Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1131082752"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.658276"
        CenterY="-69.094909"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cosmic spider: the Tarantula Nebula"
        OffsetX="-0.005907794866216622"
        OffsetY="-0.0054598405604026935"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.14593860690999996"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0613a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0613a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0613a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0613b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-04-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.09966607072079"
    Magnitude="0"
    Name="Tarantula's central cluster, R136"
    Opacity="100"
    RA="5.645943061982171"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0613b/thumb.jpg"
    ZoomLevel="0.4255674495830746"
  >
    <Description>Inside the giant emission nebula lies a cluster of young, massive and hot stars, denoted R 136, whose intense ultra-violet radiation and strong winds make the nebula glow, shaping it in the form of a giant arachnid. The cluster is about 2 to 3 million years old. Several of the brighter members in the immediate surroundings of the dense cluster are among the most massive stars known, with masses well above 50 times the mass of our Sun. The cluster itself contains more than 200 massive stars.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05734715993855354"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.6893024568"
        CenterY="-69.0996942106"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Tarantula's central cluster, R136"
        OffsetX="5.592801471680001e-05"
        OffsetY="2.796400735840047e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.17975871472113925"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0613b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0613b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0613b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0613c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-04-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.07031827162344"
    Magnitude="0"
    Name="The stellar cluster Hodge 301"
    Opacity="100"
    RA="5.638458356142897"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0613c/thumb.jpg"
    ZoomLevel="0.4485250294397951"
  >
    <Description>Above and to the right of the central cluster in the Tarantula Nebula, another cluster of bright, massive stars is seen. Known to astronomers as Hodge 301, it is about 20 million years old, or about 10 times older than R136. The more massive stars of Hodge 301 have therefore already exploded as supernovae, blasting material away at tremendous speed and creating a web of entangled filaments. More explosions will come soon — in astronomical terms — as three red supergiants are indeed present in Hodge 301 that will end their life in the gigantic firework of a supernova within the next million years.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0569259103822848"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.5770308558"
        CenterY="-69.0703739022"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The stellar cluster Hodge 301"
        OffsetX="5.55917093577e-05"
        OffsetY="5.55917093577e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.039999999999999994"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0613c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0613c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0613c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0613d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-04-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.1346490608716"
    Magnitude="0"
    Name="Gas pillars in Tarantula Nebula"
    Opacity="100"
    RA="5.650957782904569"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0613d/thumb.jpg"
    ZoomLevel="0.4480761920390237"
  >
    <Description>Zoom-in on gas pillars in the Tarantula Nebula. Some structures have the appearance of elephant trunks, not unlike the famous and fertile &amp;quot;Pillars of Creation&amp;quot; at the top of which stars are forming.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0567971406030848"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.7644446617"
        CenterY="-69.1346767745"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Gas pillars in Tarantula Nebula"
        OffsetX="2.77329788101e-05"
        OffsetY="2.77329788101e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.03999999999994651"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0613d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0613d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0613d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0614a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-04-14T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.690623264798067"
    Magnitude="0"
    Name="The Deep 3 'empty' field"
    Opacity="100"
    RA="11.353993728828135"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0614a/thumb.jpg"
    ZoomLevel="5.761151776407516"
  >
    <Description>Colour image of the Deep 3 &amp;#x27;empty&amp;#x27; field observed with the Wide-Field Camera on the MPG/ESO 2.2-m telescope at La Silla. The image is the combination of 714 frames for a total exposure time of 64.5 hours obtained through four different filters (B, V, R, and I). It consists of four adjacent Wide-Field Camera pointings (each 33x34 arcmin), covering a total area larger than one square degree. The original image — whose resolution is conserved in the fullsize original version and in  eso0614c — consists of about 300 million pixels. It had to be downscaled to be of reasonable size for the Internet. North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="3.05210793059201"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="170.138033922"
        CenterY="-21.6775904063"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Deep 3 'empty' field"
        OffsetX="-0.16000284937209"
        OffsetY="-0.008743325102300003"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5731418217474424"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0614a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0614a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0614a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0614b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-04-14T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.499054325874546"
    Magnitude="0"
    Name="Galaxy ESO 570-19 and variable star UW Crateris"
    Opacity="100"
    RA="11.330145119489826"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0614b/thumb.jpg"
    ZoomLevel="1.866392895097936"
  >
    <Description>Part of the Deep 3 Deep Public Survey field, showing the brightest galaxy in the field ESO 570-19 (upper left) and the brightest star UW Crateris. This red giant (upper right) is a variable star that is about 8 times fainter than what the unaided eye can see. An &amp;#x27;S&amp;#x27;-shaped ensemble of galaxies is also visible in the lower part of the picture. Imagine: all these island universes are about the same size as our Milky Way and contain billion of stars!</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2707676420407297"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="169.954777537"
        CenterY="-21.4837247386"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy ESO 570-19 and variable star UW Crateris"
        OffsetX="0.002411606943651949"
        OffsetY="-0.01533089791480274"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.03059981704999927"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0614b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0614b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0614b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0614c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-04-14T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.866403186457486"
    Magnitude="0"
    Name="The DPS Deep 3 Field (detail)"
    Opacity="100"
    RA="11.30955865684957"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0614c/thumb.jpg"
    ZoomLevel="1.2708429113660829"
  >
    <Description>Detail of a portion of the Deep 3 field, showing the large variety of shapes and colours of the very numerous galaxies present in the image. The amount of details of the original image is such that this small portion can still be shown in very high resolution.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2708761378041857"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="169.64341555"
        CenterY="-21.8664361892"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The DPS Deep 3 Field (detail)"
        OffsetX="3.306593479055001e-05"
        OffsetY="3.306593479055001e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.10940018295000022"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0614c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0614c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0614c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0617a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-05-11T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="21.829351898614114"
    Magnitude="0"
    Name="Twin explosions in gigantic dusty potato crisp"
    Opacity="100"
    RA="10.301749099340036"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0617a/thumb.jpg"
    ZoomLevel="0.8049631716"
  >
    <Description>The beautiful edge-on spiral galaxy NGC 3190 with tightly wound arms and a warped shape that makes it resemble a gigantic potato crisp, as seen by ESO&amp;#x27;s Very Large Telescope. Supernova SN 2002bo is found in between the &amp;#x27;V&amp;#x27; of the dust lanes in the south-western part of NGC 3190. SN 2002cv is obscured by a large amount of dust and is therefore not visible. Its position is however indicated on the above image. This colour composite is based on images obtained on 26 March 2003 with FORS1 on UT2 (Kueyen) in four filters (B, V, R and I) for a total exposure time of 14 minutes. The observations were done in the framework of a programme aiming at studying the physics of Type Ia supernovae. The field of view is 6.15 x 5 arcminutes. North is up and East is to the left. The data extraction from the archive, data reduction and final colour processing of the image was done by Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.15392759808"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="154.523336"
        CenterY="21.831979"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Twin explosions in gigantic dusty potato crisp"
        OffsetX="-0.00269366690755956"
        OffsetY="-0.0026258916366667415"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.025198441439999993"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0617a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0617a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0617a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0620a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-06-08T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-72.0803185700994"
    Magnitude="0"
    Name="The globular cluster 47 Tuc"
    Opacity="100"
    RA="0.4010472852747298"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0620a/thumb.jpg"
    ZoomLevel="1.1667211588668474"
  >
    <Description>Based on data obtained with FORS1 on Kueyen, UT2 of the Very Large Telescope. The image, 7 arcmin wide, covers the central core of the 30 arcmin large globular cluster. The observations were taken in three different filters: U, R, and a narrow-band filter centred around 485 nm, for a total exposure time of less than 5 minutes. The data were extracted from the ESO Science Archive and processed by Rubina Kotak (ESO) and the final image processing was done by Henri Boffin (ESO). North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1717758439538688"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="6.01574323529"
        CenterY="-72.0803395571"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The globular cluster 47 Tuc"
        OffsetX="1.04843654757e-05"
        OffsetY="2.09687309514e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.10000000000000053"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0620a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0620a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0620a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0622a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-06-28T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-7.4115247041470385"
    Magnitude="0"
    Name="The hooked galaxy and its companion"
    Opacity="100"
    RA="15.360258862450069"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0622a/thumb.jpg"
    ZoomLevel="1.126769679324"
  >
    <Description>Composite image based on data acquired with the FORS1 multi-mode instrument in April and May 2006 for the European Supernova Collaboration. The observations were made in four different filters (B, V, R, and I) that were combined to make a colour image. The field of view covers 5.6 x 8.3 arcmin. North is up and East is to the left. The observations were done by Ferdinando Patat and the Paranal Science team (ESO), and the final processing was done by Olivia Blanchemain, Henri Boffin and Haennes Heyer (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11391625216"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="230.385793"
        CenterY="-7.377376"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The hooked galaxy and its companion"
        OffsetX="-0.017952360196827086"
        OffsetY="-0.03414194853577564"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.02274821198"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0622a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0622a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0622a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0622b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-06-28T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-7.411524683121364"
    Magnitude="0"
    Name="The hooked galaxy and its companion - annotated image"
    Opacity="100"
    RA="15.360258859753598"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0622b/thumb.jpg"
    ZoomLevel="1.1267696793239999"
  >
    <Description>Annotated version of ESO Press Photo eso0622. The two interacting galaxies and the location of SN 2005cf are indicated. When the supernova exploded, more than a year ago, it was almost as bright as its host galaxy. One year later, it is much dimmer and can only be studied with the largest telescopes, such as ESO&amp;#x27;s Very Large Telescope.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1912406397208453"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="230.385793"
        CenterY="-7.377376"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The hooked galaxy and its companion - annotated image"
        OffsetX="-0.017952360196827086"
        OffsetY="-0.034141948535775644"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.02281552022095537"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0622b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0622b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0622b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0627a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-07-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.23408466429496"
    Magnitude="0"
    Name="The starburst galaxy NGC 908"
    Opacity="100"
    RA="2.384971078445727"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0627a/thumb.jpg"
    ZoomLevel="0.93506052357"
  >
    <Description>NGC 908, located 65 million light-years towards the constellation of Cetus (the Whale). This spiral galaxy, discovered in 1786 by William Herschel, is a so-called starburst galaxy, that is, a galaxy undergoing a phase where it spawns stars at a frantic rate. Clusters of young and massive stars can be seen in the spiral arms. Two supernovae, the explosions of massive stars, have been recorded in the near past: one in 1994 and another in May of this year. The galaxy, which is about 75 000 light-years long, also clearly presents uneven and thick spiral arms, the one on the left appearing to go upwards, forming a kind of ribbon. These properties indicate that NGC 908 most probably suffered a close encounter with another galaxy, even though none is visible at present.Data obtained with FORS2 on ESO&amp;#x27;s Very Large Telescope in the night of 13 to 14 August 2000, using images through B, V, and R filters, for a total exposure time of 4 minutes only. North is up and East is to the left. The data were extracted from the ESO Science Archive and further processed by Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11076429824"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="35.769137"
        CenterY="-21.233961"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The starburst galaxy NGC 908"
        OffsetX="-0.005060765000968875"
        OffsetY="-0.00011601772332217509"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.08755585679000001"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0627a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0627a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0627a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0627b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-07-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-46.42977134652932"
    Magnitude="0"
    Name="The spectacular spiral galaxy ESO 269-G57"
    Opacity="100"
    RA="13.16759916477367"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0627b/thumb.jpg"
    ZoomLevel="1.020032393058"
  >
    <Description>Located about 155 million light-years away towards the southern constellation Centaurus (the Centaur), ESO 269-G57 is a spectacular spiral galaxy of symmetrical shape that belongs to a well-known cluster of galaxies seen in this direction. An inner &amp;#x27;ring&amp;#x27;, of several tightly wound spiral arms, surrounded by two outer ones that appear to split into several branches, are clearly visible. Many blue and diffuse objects are seen — most are star-forming regions. ESO 269-G57 extends over about 4 arc minutes in the sky, corresponding to nearly 200,000 light-years across. Resembling a large fleet of spaceships, many other faint, distant galaxies are visible in the background.Obtained with VLT ANTU and FORS1 in the morning of March 27, 1999. The full field measures 6.8 x 6.8 arcmin2. North is up and East is to the left. The image is based on data collected in the B, V, R and H-alpha filters, for a total exposure time of a little over one hour (64 min). The data were extracted from the ESO Science Archive and further processed by Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11397134336"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="197.518662"
        CenterY="-46.437446"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The spectacular spiral galaxy ESO 269-G57"
        OffsetX="0.0032400731488527856"
        OffsetY="0.007666898027321568"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.13584132365"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0627b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0627b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0627b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0627c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-07-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.614876196622774"
    Magnitude="0"
    Name="The irregular galaxy NGC 1427A"
    Opacity="100"
    RA="3.668955346856741"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0627c/thumb.jpg"
    ZoomLevel="0.9976036629990841"
  >
    <Description>Colour composite image of NGC 1427A, based on observations collected with FORS1 in Service mode for Andreas Reisenegger and his colleagues in November 2002 and January 2003. A very tenuous galaxy is also visible in the upper right corner. For the blue, green and red channels the U, V and H-alpha filters were used, respectively. North is on the left and West is up. The entire field of view of this image is ~ 6.7 x 6.7 arcmin which corresponds to ~ 120 x 120 thousand light-years at the Fornax Cluster distance. Henri Boffin (ESO) did the final processing of the image.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.10821348830108389"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="55.0355309437"
        CenterY="-35.6183001593"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The irregular galaxy NGC 1427A"
        OffsetX="-0.00342677817738075"
        OffsetY="0.0009675608971427985"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90.1415174774585"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0627c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0627c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0627c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0630a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-08-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-53.71492038607481"
    Magnitude="0"
    Name="Globular cluster NGC 6397"
    Opacity="100"
    RA="17.674623201553256"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0630a/thumb.jpg"
    ZoomLevel="1.8666994704000004"
  >
    <Description>This image shows the nearby metal-poor globular cluster NGC 6397, located at a distance of approx. 7,200 light-years in the southern constellation Ara. Some of the FLAMES-UVES target stars are highlighted with yellow squares. The photo is a composite of exposures in the B-, V- and I-bands obtained in the frame of the Pilot Stellar Survey with the Wide-Field-Imager (WFI) camera at the 2.2-m ESO/MPI telescope at the ESO La Silla Observatory. It was prepared and provided by the ESO Imaging Survey team. The spikes seen at some of the brighter stars are caused by the effect of overexposure (CCD &amp;quot;bleeding&amp;quot;).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.3023831965276322"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="265.175412"
        CenterY="-53.674218"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Globular cluster NGC 6397"
        OffsetX="0.03307420600453183"
        OffsetY="-0.04080053199949751"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.14710987035999998"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0630a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0630a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0630a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0643a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-11-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-66.48899700263219"
    Magnitude="0"
    Name="The topsy-turvy galaxy NGC 1313*"
    Opacity="100"
    RA="3.30518896032486"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0643a/thumb.jpg"
    ZoomLevel="1.027868432290185"
  >
    <Description>The central parts of the starburst galaxy NGC 1313. The very active state of this galaxy is very evident from the image, showing many star formation regions. A great number of supershell nebulae, that is, cocoon of gas inflated and etched by successive bursts of star formation, are visible. The green nebulosities are regions emitting in the ionised oxygen lines and may harbour clusters with very hot stars. This colour-composite is based on images obtained with the FORS1 instrument on one of the 8.2-m Unit Telescope of ESO&amp;#x27;s Very Large Telescope, located at Cerro Paranal. The data were obtained in the night of 16 December 2003, through different broad- (R, B, and z) and narrow-band filters (H-alpha, OI, and OIII). This image is available as a mounted image in the ESOshop.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1139590600648704"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="49.5657417138"
        CenterY="-66.4976927877"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The topsy-turvy galaxy NGC 1313*"
        OffsetX="-0.004820335923035182"
        OffsetY="0.008697393836970893"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.02466058865000219"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0643a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0643a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0643a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0643b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-11-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-66.49617779326057"
    Magnitude="0"
    Name="Larger field around NGC 1313"
    Opacity="100"
    RA="3.3041593674649414"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0643b/thumb.jpg"
    ZoomLevel="2.5517267964044477"
  >
    <Description>Larger region of the sky around the starburst galaxy NGC 1313 showing the larger scale disturbance of the galaxy. The galaxy shows some large deformations in the lower right part of the image, while diffuse matter is also present at the top of the image. All this signals a very tormented past which could be at the origin of the burst of star formation.The image was made from data from the Digitized Sky Survey, obtained through blue, red and infrared filters. The &amp;quot;Second Epoch Survey&amp;quot; of the southern sky was made by the Anglo-Australian Observatory (AAO) with the UK Schmidt Telescope. Plates from this survey have been digitized and compressed by the ST ScI. The data were extracted and colour-composed by Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.31981692486330254"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="49.557135989"
        CenterY="-66.4980207898"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Larger field around NGC 1313"
        OffsetX="-0.0022441083294064998"
        OffsetY="0.0016586887652135032"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-4.858490879019579"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0643b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0643b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0643b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0649b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-12-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.81551027929093"
    Magnitude="0"
    Name="GRB 060505"
    Opacity="100"
    RA="22.11771244373613"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0649b/thumb.jpg"
    ZoomLevel="0.9200260894212542"
  >
    <Description>Three-colour image (B, V, and R-band) of the gamma-ray burst observed on 5 May 2006, GRB 060505, with FORS on the VLT. The galaxy is a spiral galaxy at a distance of 1,300 million light-years. The yellow arrow on the zoomed-in image (ESO Press Photo eso0649) shows where the star exploded, namely in a star-forming region in one of the spiral arms of the galaxy.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11402889319382283"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="331.766769134"
        CenterY="-27.8158305712"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="GRB 060505"
        OffsetX="0.0009658140749575039"
        OffsetY="0.0002939434141174972"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5691352245587962"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0649b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0649b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0649b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0650a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.37005441740912"
    Magnitude="0"
    Name="Portrait of a dramatic stellar crib*"
    Opacity="100"
    RA="5.632884397480219"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0650a/thumb.jpg"
    ZoomLevel="10.592580532092"
  >
    <Description>One square degree image of the Tarantula Nebula and its surroundings. The spidery nebula is seen in the upper-centre of the image. Slightly to the lower-right, a web of filaments harbours the famous supernova SN 1987A. Many other reddish nebulae are visible in the image, as well as a cluster of young stars on the left, known as NGC 2100. Technical information: the image is based on observations carried out by Joao Alves (Calar Alto, Spain), Benoit Vandame and Yuri Beletsky (ESO) with the Wide Field Imager (WFI) at the 2.2-m telescope on La Silla. These data consist of a 2x2 WFI mosaic in the B- and V-bands, and in the H-alpha and [OIII] narrow bands. The data were first processed with the ESO/MVM pipeline by the Advanced Data Products (ADP) group at ESO. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0822155006834144"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.658276"
        CenterY="-69.094909"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Portrait of a dramatic stellar crib*"
        OffsetX="0.058406754525001284"
        OffsetY="-0.275169144641269"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.05579944461279273"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0650a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/R. Fosbury (ST-ECF)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0650a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0650a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0650b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2006-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.3005538365198"
    Magnitude="0"
    Name="SN 1987A and the Honeycomb Nebula"
    Opacity="100"
    RA="5.593029896620335"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0650b/thumb.jpg"
    ZoomLevel="0.8822815288200001"
  >
    <Description>The brightest supernova which has exploded in the current epoch is SN 1987A, located in the Large Magellanic Cloud, at the edge of the Tarantula nebula. The explosion was seen on 23 February 1987 and since then the ejected material has created a set of ring structures. The outer ring is clearly visible in this image. In the lower part of the image, an amazing structure is seen: the Honeycomb Nebula.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1348160512"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.933263"
        CenterY="-69.297889"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SN 1987A and the Honeycomb Nebula"
        OffsetX="0.013336794983113076"
        OffsetY="-0.002811978524546497"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.61372507932"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0650b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0650b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0650b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0708a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-02-24T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.2949062383112"
    Magnitude="0"
    Name="SN1987A in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.61038233668387"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0708a/thumb.jpg"
    ZoomLevel="11.532810197279998"
  >
    <Description>Image obtained with the ESO Schmidt Telescope of the Tarantula Nebula in the Large Magellanic Cloud. Supernova 1987A is clearly visible as the very bright star in the middle right. At the time of this image, the supernova was visible with the unaided eye.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.55409891328"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.658276"
        CenterY="-69.094909"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SN1987A in the Large Magellanic Cloud"
        OffsetX="0.19427173129959338"
        OffsetY="-0.18471309763577654"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-4.930566152910001"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0708a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0708a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0708a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0709a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-03-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.25798103530901"
    Magnitude="0"
    Name="The overlooked dwarf and its apparent companion"
    Opacity="100"
    RA="13.219982652104228"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0709a/thumb.jpg"
    ZoomLevel="0.7218111367440001"
  >
    <Description>Colour image of the two galaxies NGC 5011B (top) and NGC 5011C (bottom blue galaxy). NGC 5011C is a dwarf galaxy located in the Centaurus A group, while its companion on the sky is in fact an S0 galaxy, located 12 times further away and belonging to the Centaurus cluster of galaxies. The composite image is based on data obtained with the EFOSC2 instrument on the ESO 3.6-metre telescope at the La Silla Observatory in three different wavebands (B, V, and R). The total integration time is 3 minutes. The field of view is about 5 x 4.5 arcmin. North is up, East to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08979451904"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="198.300832"
        CenterY="-43.246554"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The overlooked dwarf and its apparent companion"
        OffsetX="0.00041289426760461975"
        OffsetY="-0.011447248353002457"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.91621097165"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0709a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0709a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0709a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0712a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-03-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-47.0588110231718"
    Magnitude="0"
    Name="The newly identified cluster"
    Opacity="100"
    RA="16.86944373255143"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0712a/thumb.jpg"
    ZoomLevel="0.8200205441999999"
  >
    <Description>Colour-composite image of the newly discovered globular cluster candidate FSR 1735 in the inner parts of the Milky Way. The cluster is the circular regions of stars and enhanced brightness in the centre of the image. The image is based on data obtained through three near-infrared filters (J, H, and K), for a total exposure time of 225 seconds per filter. The SofI instrument on ESO&amp;#x27;s NTT was used. The image size is about 5 x 5 arcmin. North is up and East is to the left. The final image processing was done by Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0819140608"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="253.032265241"
        CenterY="-47.0982214233"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The newly identified cluster"
        OffsetX="-0.006357207289614008"
        OffsetY="0.039416529674080464"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.05846200123"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0712a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0712a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0712a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0715a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-03-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.46593286947247"
    Magnitude="0"
    Name="The cluster collinder 261"
    Opacity="100"
    RA="12.631722390908747"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0715a/thumb.jpg"
    ZoomLevel="5.073791232294"
  >
    <Description>Field around the old open cluster Collinder 261 (upper centre), seen in the red filtre.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.57264625664"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="189.487225"
        CenterY="-68.367064"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The cluster collinder 261"
        OffsetX="-0.005840520553066628"
        OffsetY="-0.09878518899476156"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="5.804748686179999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0715a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0715a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0715a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0716a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-03-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-0.38885771578359213"
    Magnitude="0"
    Name="The spiral galaxy NGC 5584 and SN 2007af"
    Opacity="100"
    RA="14.373042002987502"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0716a/thumb.jpg"
    ZoomLevel="1.0604965080779998"
  >
    <Description>This image is a colour-composite of the barred spiral galaxy NGC 5584. It is based on data collected by the Paranal Science Team with the FORS1 instrument on Kueyen, the second 8.2-m Unit Telescope of ESO&amp;#x27;s Very Large Telescope. The supernova SN 2007af is the bright object seen slightly below and to the right of the galaxy&amp;#x27;s centre. The galaxy and its bright supernova were observed on the nights of 16, 19 and 22 March 2007 through a B, V, R, H-alpha and OII filter. The total exposure time is about 28 minutes. The observers are Susana Randall, Claudio Melo and Swetlana Hubrig, and the day astronomer was Dominique Naef (all ESO). Henri Boffin (ESO) processed the data and made the colour-composite, and Haennes Heyer (ESO) made the final adjustments.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11392780288"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="215.599448"
        CenterY="-0.387497"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The spiral galaxy NGC 5584 and SN 2007af"
        OffsetX="0.0038167301796819906"
        OffsetY="-0.0013639028480638042"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.04782330844"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0716a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0716a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0716a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0722c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-04-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-7.722376229688771"
    Magnitude="0"
    Name="The star Gliese 581"
    Opacity="100"
    RA="15.324108694091594"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0722c/thumb.jpg"
    ZoomLevel="0.8488589545259999"
  >
    <Description>The star Gliese 581.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.12700265472"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="229.861634"
        CenterY="-7.722496"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The star Gliese 581"
        OffsetX="3.636828424448256e-06"
        OffsetY="0.00011976788648085794"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.03862879987"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0722c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>Digital Sky Survey</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0722c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0722c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0736b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-08-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="1.265713250651391"
    Magnitude="0"
    Name="Serpens star forming region"
    Opacity="100"
    RA="18.497161141343497"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0736b/thumb.jpg"
    ZoomLevel="1.2764246499355272"
  >
    <Description>The figure shows the Serpens star-forming region, as it was imaged during commissioning, on HAWK-I&amp;#x27;s four large infrared detectors. The gap between them is real, and multiple exposures are required to make a filled-in picture. The colour composite was created from images taken through three filters, J, H and K.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.24200759901756744"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="277.48095739"
        CenterY="1.2865378011"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Serpens star forming region"
        OffsetX="0.023549366988055355"
        OffsetY="-0.02080765274412374"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.04084111571124785"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0736b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0736b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0736b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0736c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-08-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="1.2337063005097213"
    Magnitude="0"
    Name="Nebula in serpens"
    Opacity="100"
    RA="18.499361756957526"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0736c/thumb.jpg"
    ZoomLevel="0.5774956425033213"
  >
    <Description>This image shows a close-up view of detector 1 of HAWK-I. Despite a total exposure time of only 1 minute in each of three infrared filters, the image shows great detail in this million-year old region, revealing red young stars, reflection nebulae and dark clouds of gas and dust very clearly.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.060676120491622396"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="277.490456143"
        CenterY="1.23367682903"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Nebula in serpens"
        OffsetX="2.9627011958799998e-05"
        OffsetY="2.9627011958799998e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.2999999999999983"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0736c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0736c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0736c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0739a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-09-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-32.57706581925377"
    Magnitude="0"
    Name="VLT image of supernova in beautiful spiral galaxy NGC 1288"
    Opacity="100"
    RA="3.287064407207151"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0739a/thumb.jpg"
    ZoomLevel="0.812408844384"
  >
    <Description>Colour-composite image of the Type Ia supernova SN 2006dr in the spiral galaxy NGC 1288, as observed with ESO&amp;#x27;s Very Large Telescope. It is based on images acquired through several filters (B, V, R, I and H-alpha) for a total exposure time of 5 minutes. The supernova is the bright object visible to the left of the centre of the galaxy. Many distant galaxies are also seen in the vicinity of NGC 1288, of which some are behind. The data were acquired by ESO&amp;#x27;s Paranal Science team. The final image was made by Henri Boffin (ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11390988288000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="49.305132"
        CenterY="-32.576179"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VLT image of supernova in beautiful spiral galaxy NGC 1288"
        OffsetX="-0.0007051193857092284"
        OffsetY="-0.0008850394788385324"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1450734336"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0739a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0739a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0739a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0749a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-11-09T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-33.24713996549395"
    Magnitude="0"
    Name="Twisted spiral galaxy NGC 134"
    Opacity="100"
    RA="0.5060860953299225"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0749a/thumb.jpg"
    ZoomLevel="1.147138864730791"
  >
    <Description>Image obtained with ESO&amp;#x27;s Very Large Telescope (VLT) of the spiral galaxy observed by the European Commissioner for Science and Research, Janez Potocnik, when at Paranal. NGC 134 is a barred spiral with its spiral arms loosely wrapped around a bright, bar-shaped central region. The red features lounging along its spiral arms are glowing clouds of hot gas in which stars are forming, so-called HII regions. The galaxy also shows prominent dark lanes of dust across the disc, obscuring part of the galaxy&amp;#x27;s starlight. The image is a colour composite based on data obtained in the B, V, R, and H- filters with the FORS2 instrument attached to Antu, UT1 of the VLT. During his stay on Paranal, the Commissioner, together with the observatory staff, prepared the observations of this Galaxy. At night, Janez Potocnik initiated these observations, and checked the quality of the images as they appeared on the control screens. Because the high-sensitivity detectors used on the VLT measure only the intensity of the light reaching their pixels, the colour information is acquired by taking a sequence of images through different coloured filters. Consequently, the Commissioner could not immediately see the attached image, but only black-and-white version of it. The final colour processing was done by Haennes Heyer and Henri Boffin, with input from Yuri Beletsky (all ESO).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14332762271487853"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="7.59415019194"
        CenterY="-33.2431687781"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Twisted spiral galaxy NGC 134"
        OffsetX="-0.003970845594561444"
        OffsetY="-0.002391046809628401"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="90"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0749a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0749a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0749a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0755a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.3181723867271"
    Magnitude="0"
    Name="The Tinker Bell triplet"
    Opacity="100"
    RA="19.241952971131415"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0755a/thumb.jpg"
    ZoomLevel="0.092745245934"
  >
    <Description>Using ESO&amp;#x27;s Very Large Telescope, an international team of astronomers has discovered a stunning rare case of a triple merger of galaxies. This system, which astronomers have dubbed &amp;#x27;The Bird&amp;#x27; - although it also bears resemblance with a cosmic Tinker Bell - is composed of two massive spiral galaxies and a third irregular galaxy. In this image, a 30-min VLT/NACO K-band exposure has been combined with archive HST/ACS B and I-band images to produce a three-colour image of the &amp;#x27;Bird&amp;#x27; interacting galaxy system. The NACO image has allowed astronomers to not only see the two previously known galaxies, but to identify a third, clearly separate component, an irregular, yet fairly massive galaxy that seems to form stars at a frantic rate.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.01634924544"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="288.629491"
        CenterY="-21.319267"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Tinker Bell triplet"
        OffsetX="0.0001791533421068306"
        OffsetY="0.0010952480201955755"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.20088509716999997"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0755a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0755a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0755a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0755b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2007-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.319092475102515"
    Magnitude="0"
    Name="Anatomy of a bird"
    Opacity="100"
    RA="19.241903082576584"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0755b/thumb.jpg"
    ZoomLevel="0.10157758128000001"
  >
    <Description>Image taken with the NACO instrument on ESO&amp;#x27;s Very Large Telescope in the K-band. Also indicated are the different parts of the &amp;#x27;Bird&amp;#x27;. There is a barred spiral galaxy at the heart of the Bird, and a strongly disturbed massive galaxy just south of it, while the head of the Bird consists of an irregular galaxy with very active star formation. The wings span a region in space of about 100,000 light-years, as much as our own Milky Way. North is up and East is to the left. The image covers about 25 x 25 arcsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.019043123200000005"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="288.629491"
        CenterY="-21.319267"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Anatomy of a bird"
        OffsetX="0.0008724622595358244"
        OffsetY="0.00020943686194976137"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-2.2825799172699996"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0755b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0755b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0755b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0802a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-01-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-31.963364749411458"
    Magnitude="0"
    Name="Cosmic interactions"
    Opacity="100"
    RA="22.034573563682656"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0802a/thumb.jpg"
    ZoomLevel="0.941412530016"
  >
    <Description>Colour-composite image of the triplet of galaxies, catalogued as NGC 7173 (top), 7174 (bottom right) and 7176 (bottom left), and located 106 million light-years away towards the constellation of Piscis Austrinus (the &amp;#x27;Southern Fish&amp;#x27;). This triplet of galaxies makes up part of the Hickson Compact Group HCG 90.  NGC 7173 and 7176 are elliptical galaxies, while NGC 7174 is a spiral galaxy with quite disturbed dust lanes and a long, twisted tail. This seems to indicate that the two lower galaxies - whose combined shape bears some resemblance to that of a sleeping baby - are currently interacting. Astronomers have suggested that the three galaxies will finally merge.  The size of the image is about 5.3 arcminutes. The image is based on data obtained with the VLT FORS1 instrument on ESO&amp;#x27;s Very Large Telescope through three different filters, B, V, and R. The data were extracted from the ESO Science Archive and fully processed by Henri Boffin (ESO). </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11393662976"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="330.528528"
        CenterY="-31.99353"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cosmic interactions"
        OffsetX="0.00840432396927989"
        OffsetY="0.03016919776990007"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.02949509529"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0802a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0802a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0802a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0803c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-01-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="10.33060485994794"
    Magnitude="0"
    Name="Close-up on MWC 147"
    Opacity="100"
    RA="6.537514435521472"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0803c/thumb.jpg"
    ZoomLevel="10.46490673226832"
  >
    <Description>Close-up on MWC 147 </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="2.7147146207232"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="97.9848698785"
        CenterY="10.2163273976"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Close-up on MWC 147"
        OffsetX="-0.11154454850285996"
        OffsetY="-0.08052681309029999"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-92"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0803c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0803c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0803c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0805a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-02-11T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-34.57811365876325"
    Magnitude="0"
    Name="The Cepheid star RS Pup"
    Opacity="100"
    RA="8.217830934260205"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0805a/thumb.jpg"
    ZoomLevel="0.9698243199359999"
  >
    <Description>The nebula around the Cepheid star RS Pup undoubtedly holds a wealth of information about the mass-loss history of this star. It will thus be instrumental to understand the evolution of Cepheids. Less than five years away from the centenary of the discovery of the Period-Luminosity relation by Leavitt &amp;amp; Pickering, RS Pup could well become a &amp;#x27;&amp;#x27;Rosetta stone&amp;#x27;&amp;#x27; for this important class of stars. This colour composite image is based on observations made with the 3.6-m ESO New Technology Telescope (NTT) installed at the La Silla Observatory (Chile) and equipped with the ESO Multi-Mode Instrument (EMMI). The image is based on data obtained through B, V, and R-filters. In order to avoid a heavy saturation of the detector, RS Pup was positioned in the gap between the detectors.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14151563264"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="123.267384"
        CenterY="-34.578677"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Cepheid star RS Pup"
        OffsetX="0.0005201380455054804"
        OffsetY="-0.00022616336730140696"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="120.17021847331999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0805a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0805a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0805a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0806a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-03-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.87755580776965"
    Magnitude="0"
    Name="A dark filament in scattered light"
    Opacity="100"
    RA="19.014150665394546"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0806a/thumb.jpg"
    ZoomLevel="0.85624162390593"
  >
    <Description>Part of a filament in the Corona Australis molecular cloud. The image is a composite of J-, H-, and K-band near-infrared observations that were made with the SOFI instrument on ESO&amp;#x27;s NTT telescope in August 2006. The observations were made to test, how easily the scattered light can be observed and how good it is as a tracer of cloud structure. The J-, H-, and K-band intensities are coded with blue, green, and red colours. The gradual saturation of the near-infrared bands is visible as a change of colour. In diffuse regions the shorter wavelength J-band is strong and the colour is bluish. When the J-band saturates the colour changes first to green and finally, in the centre of the filament, the red colour corresponding to the K-band becomes the strongest. In the most saturated regions the surface brightness data can only be used to derive a lower limit for the total amount of dust on the line of sight.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1638893106188288"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="285.202423652"
        CenterY="-36.8533023088"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A dark filament in scattered light"
        OffsetX="0.0254824442687515"
        OffsetY="0.0008981805078157379"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-109.99239152975011"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0806a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0806a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0806a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0809a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-04-15T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-50.90389401746917"
    Magnitude="0"
    Name="The planet-host star Iota Horologii"
    Opacity="100"
    RA="2.698681482110662"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0809a/thumb.jpg"
    ZoomLevel="6.869234108064591"
  >
    <Description>Using HARPS on the ESO 3.6-metre telescope at La Silla, astronomers were able to study in great detail the star Iota Horologii, known to harbour a giant planet, and make a very precise portrait of it: its temperature is 6150 K, its mass is 1.25 times that of the Sun, and its age is 625 million years. Moreover, the star is found to be more metal-rich than the Sun by about 50%. This means the star must have drifted from the Hyades cluster where it formed.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.8909783308833842"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="40.4925344715"
        CenterY="-50.9283241286"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The planet-host star Iota Horologii"
        OffsetX="0.008431778697060499"
        OffsetY="0.02420736464639953"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5723288520760734"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0809a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>Digital Sky Survey/VirGO.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0809a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0809a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0823a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-07-24T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="33.12053335566716"
    Magnitude="0"
    Name="The quiet explosion"
    Opacity="100"
    RA="9.159367974400315"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0823a/thumb.jpg"
    ZoomLevel="0.6146350501500002"
  >
    <Description>The spiral galaxy NGC 2770 and its two supernovae as observed at the Asiago Observatory. The image was obtained on 12 January 2008 and shows the then fading SN 2007uy and the newly discovered SN 2008D.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.07154149376000002"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="137.390062"
        CenterY="33.123363"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The quiet explosion"
        OffsetX="-0.0005023558701021664"
        OffsetY="-0.002810945060622022"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="2.41905718416"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0823a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0823a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0823a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0825a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-09-02T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.86976114956284"
    Magnitude="0"
    Name="Spiral galaxy Messier 83*"
    Opacity="100"
    RA="13.616553872402593"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0825a/thumb.jpg"
    ZoomLevel="2.9900742574079997"
  >
    <Description>This dramatic image of the galaxy Messier 83 was captured by the Wide Field Imager at ESO&amp;#x27;s La Silla Observatory, located high in the dry desert mountains of the Chilean Atacama Desert. Messier 83 lies roughly 15 million light-years away towards the huge southern constellation of Hydra (the sea serpent). It stretches over 40 000 light-years, making it roughly 2.5 times smaller than our own Milky Way. However, in some respects, Messier 83 is quite similar to our own galaxy. Both the Milky Way and Messier 83 possess a bar across their galactic nucleus, the dense spherical conglomeration of stars seen at the centre of the galaxies.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.54184116224"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="204.253788"
        CenterY="-29.865715"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy Messier 83*"
        OffsetX="0.004753657832503184"
        OffsetY="-0.004044268705479285"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.02403841655"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0825a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0825a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0825a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0832a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-09-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-65.33970471363428"
    Magnitude="0"
    Name="SN 1996cr in Circinus galaxy"
    Opacity="100"
    RA="14.219271166107717"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0832a/thumb.jpg"
    ZoomLevel="0.10208648900210149"
  >
    <Description>This composite image shows the central regions of the nearby Circinus galaxy, located about 12 million light years away. Data from NASA&amp;#x27;s Chandra X-ray Observatory is shown in blue and data from the NASA/ESA Hubble Space telescope is shown in yellow (&amp;quot;I-band&amp;quot;), red (hydrogen emission), cyan (&amp;quot;V-band&amp;quot;) and light blue (oxygen emission). The blue source near the lower right hand corner of the image is the supernova SN 1996cr, that has finally been identified over a decade after it exploded. The supernova was first singled out in 2001 as a bright, variable object in a Chandra image, but it was not confirmed as a supernova until years later, when clues from a spectrum obtained with ESO&amp;#x27;s Very Large Telescope led the team to start the real detective work of searching through data from 18 different telescopes, both ground- and space-based, nearly all of which was in the archives. SN 1996cr is one of the nearest supernovae in the last 25 years.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.02050761944465408"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="213.289075599"
        CenterY="-65.3397036691"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SN 1996cr in Circinus galaxy"
        OffsetX="2.50337151424e-06"
        OffsetY="2.50337151424e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-62.160000000000025"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0832a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>X-ray (NASA/CXC/Columbia/F.Bauer et al); Visible light (NASA/STScI/UMD/A.Wilson et al.)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0832a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0832a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0832b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-09-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-65.34011913609275"
    Magnitude="0"
    Name="The Circinus galaxy"
    Opacity="100"
    RA="14.219422732434841"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0832b/thumb.jpg"
    ZoomLevel="0.263990773909402"
  >
    <Description>Colour image of the Circinus Galaxy based on ESO SuSI New Technology Telescope data obtained in April 1993, that is, about three years before the supernova exploded. The observations were made through different narrow-band filters (ionised hydrogen, ionised oxygen, and ionised iron).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.027722388268441596"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="213.291385015"
        CenterY="-65.3401137504"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Circinus galaxy"
        OffsetX="1.3536322396699998e-05"
        OffsetY="1.3536322396699998e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-61.34000000000018"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0832b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0832b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0832b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0834a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-10-08T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-72.17281793880994"
    Magnitude="0"
    Name="Star-forming region NGC 346"
    Opacity="100"
    RA="0.9851095921141408"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0834a/thumb.jpg"
    ZoomLevel="1.1226761325"
  >
    <Description>This new portrait of the bright star-forming region NGC 346, in which different wavelengths of light swirl together like watercolours, reveals new information about how stars form. NGC 346 is located 210,000 light-years away in the Small Magellanic Cloud, a neighbouring dwarf galaxy of the Milky Way. The image is based on data from ESA XMM-Newton (X-rays; blue), ESO&amp;#x27;s New Technology Telescope (visible light; green), and NASA&amp;#x27;s Spitzer (infrared; red). The infrared light shows cold dust, while the visible light denotes glowing gas, and the X-rays represent very hot gas. Ordinary stars appear as blue spots with white centres, while young stars enshrouded in dust appear as red spots with white centres.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22666240000000004"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="14.8246"
        CenterY="-72.179994"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Star-forming region NGC 346"
        OffsetX="0.015564814993801078"
        OffsetY="0.004969751103440034"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="8.321998969070002"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0834a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/ESA/ JPL-Caltech/NASA/ D. Gouliermis (MPIA) et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0834a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0834a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0837a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-10-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-57.76784473218854"
    Magnitude="0"
    Name="The Gum 29 nebula"
    Opacity="100"
    RA="10.403552258938879"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0837a/thumb.jpg"
    ZoomLevel="5.598862027584"
  >
    <Description>This image shows the amazing intricacies of the vast stellar nursery Gum 29. At its centre lies the cluster of young stars Westerlund 2. One object at the bottom of the cluster is in fact a system of two of most massive stars known to astronomers.  The image is based on data obtained with the Wide Field Imager (WFI) camera attached to the 2.2-m Max-Planck/ESO telescope through four different filters (B, V, R, and H-alpha).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0865421479784079"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="156.060953"
        CenterY="-57.782754"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Gum 29 nebula"
        OffsetX="0.004171765260712783"
        OffsetY="0.014886442277693722"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.31318855513388594"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0837a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0837a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0837a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0837b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-10-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-57.76706701989881"
    Magnitude="0"
    Name="The Gum 29 nebula"
    Opacity="100"
    RA="10.399576509340255"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0837b/thumb.jpg"
    ZoomLevel="0.74695633311"
  >
    <Description>Marked in the image is a double stellar system. The two stars have masses of 82 and 83 times that of our Sun and rotate around each other in approximately 3.7 days. They are amongst the most massive stars known to astronomers.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13572589568"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="156.060968"
        CenterY="-57.782894"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Gum 29 nebula"
        OffsetX="0.035847969648435035"
        OffsetY="0.015940647505772402"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.21002209981999997"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0837b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0837b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0837b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0839a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-11-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.75850732518046"
    Magnitude="0"
    Name="A pool of distant galaxies"
    Opacity="100"
    RA="3.5409709165797163"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0839a/thumb.jpg"
    ZoomLevel="3.7635332189925745"
  >
    <Description>The Chandra Deep Field South, observed in the U-, B-, and R-bands with ESO&amp;#x27;&amp;#x27;s VIMOS and WFI instruments. The U-band VIMOS observations were made over a period of 40 hours and constitute the deepest image ever taken from the ground in the U-band. The image covers a region of 14.1 x 21.6 arcminutes on the sky and shows galaxies that are 1 billion times fainter than can be seen by the unaided eye. The VIMOS R-band image was assembled by the ESO/GOODS team from archival data, while the WFI B-band image was produced by the GABODS team. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.4664558238015488"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.114593224"
        CenterY="-27.7507113545"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A pool of distant galaxies"
        OffsetX="2.847020408945e-05"
        OffsetY="-0.007795962380154594"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.01754277013000073"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0839a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/ Mario Nonino, Piero Rosati and the ESO GOODS Team</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0839a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0839a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0840a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-11-11T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-38.423424011949244"
    Magnitude="0"
    Name="Glowing stellar nurseries*"
    Opacity="100"
    RA="17.205924783957077"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0840a/thumb.jpg"
    ZoomLevel="6.695422982783998"
  >
    <Description>Colour composite image of RCW120. It reveals how an expanding bubble of ionised gas about ten light-years across is causing the surrounding material to collapse into dense clumps where new stars are then formed. The 870-micron submillimetre-wavelength data were taken with the LABOCA camera on the 12-m Atacama Pathfinder Experiment (APEX) telescope. Here, the submillimetre emission is shown as the blue clouds surrounding the reddish glow of the ionised gas (shown with data from the SuperCosmos H-alpha survey). The image also contains data from the Second Generation Digitized Sky Survey (I-band shown in blue, R-band shown in red). This image is available as a mounted image in the ESOshop</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.1450902118399997"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="258.100145"
        CenterY="-38.469859"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Glowing stellar nurseries*"
        OffsetX="0.01027144080747284"
        OffsetY="0.046137392122212996"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.78180975708"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0840a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/APEX/DSS2/ SuperCosmos/ Deharveng(LAM)/ Zavagno(LAM)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0840a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0840a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0841a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-11-18T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.007676633058786"
    Magnitude="0"
    Name="Submillimetre and infrared view of the Galactic Centre"
    Opacity="100"
    RA="17.76108994025522"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0841a/thumb.jpg"
    ZoomLevel="2.8335434979079683"
  >
    <Description>This is a colour composite image of the central region of our Milky Way galaxy, about 26 000 light years from Earth. Giant clouds of gas and dust are shown in blue, as detected by the LABOCA instrument on the Atacama Pathfinder Experiment (APEX) telescope at submillimetre wavelengths (870 micron). The image also contains near-infrared data from the 2MASS project at K-band (in red), H-band (in green), and J-band (in blue). The image shows a region approximately 100 light-years wide.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.3792873910925176"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.402506756"
        CenterY="-29.0018090468"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Submillimetre and infrared view of the Galactic Centre"
        OffsetX="-0.0122621942119945"
        OffsetY="-0.005534264644351501"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5706900704100002"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0841a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/APEX/2MASS/A. Eckart et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0841a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0841a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0844a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-12-02T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-47.49360735765338"
    Magnitude="0"
    Name="The globular cluster Omega Centauri*"
    Opacity="100"
    RA="13.445655103775147"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0844a/thumb.jpg"
    ZoomLevel="5.0974603056720005"
  >
    <Description>The globular cluster Omega Centauri — with as many as ten million stars — is seen in all its splendour in this image captured with the WFI camera from ESO&amp;#x27;s La Silla Observatory. The image shows only the central part of the cluster — about the size of the full moon on the sky (half a degree). North is up, East is to the left. This colour image is a composite of B, V and I filtered images. Note that because WFI is equipped with a mosaic detector, there are two small gaps in the image which were filled with lower quality data from the Digitized Sky Survey. Can you find them? NGC 5139 is another designation of this cluster.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.541529137152"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.697148"
        CenterY="-47.479684"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The globular cluster Omega Centauri*"
        OffsetX="0.008323500702500002"
        OffsetY="-0.013925070484483337"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.007240133404816772"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0844a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0844a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0844a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0846a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-12-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.00654037486166"
    Magnitude="0"
    Name="The centre of the Milky Way*"
    Opacity="100"
    RA="17.761135592074"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0846a/thumb.jpg"
    ZoomLevel="0.0692305817258412"
  >
    <Description>The central parts of our Galaxy, the Milky Way, as observed in the near-infrared with the NACO instrument on ESO&amp;#x27;s Very Large Telescope. By following the motions of the most central stars over more than 16 years, astronomers were able to determine the mass of the supermassive black hole that lurks there.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00772245268924416"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.417038167"
        CenterY="-29.0065441679"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The centre of the Milky Way*"
        OffsetX="3.77072885217e-06"
        OffsetY="3.77072885217e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.3400000000000001"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0846a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/S. Gillessen et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0846a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0846a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0847a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-12-12T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="3.358453529789815"
    Magnitude="0"
    Name="The Einstein Cross"
    Opacity="100"
    RA="22.675083350611803"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0847a/thumb.jpg"
    ZoomLevel="0.2896336753588224"
  >
    <Description>The Einstein Cross and the galaxy that causes this &amp;#x27;cosmic mirage&amp;#x27;, as seen with the FORS instrument on ESO&amp;#x27;s Very Large Telescope. This cross-shaped configuration consists of four images of a single very distant source. The multiple images are a result of gravitational lensing by a foreground galaxy, an effect that was predicted by Albert Einstein as a consequence of his theory of general relativity. The light source in the Einstein Cross is a quasar approximately ten billion light-years away, whereas the foreground lensing galaxy is ten times closer. The light from the quasar is bent in its path and magnified by the gravitational field of the lensing galaxy.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.028395458368512"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="340.126264148"
        CenterY="3.35843966482"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Einstein Cross"
        OffsetX="1.38649699065e-05"
        OffsetY="1.38649699065e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0847a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/F. Courbin et al</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0847a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0847a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0848a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2008-12-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="9.60278156353886"
    Magnitude="0"
    Name="NGC 2264 and the Christmas Tree cluster*"
    Opacity="100"
    RA="6.682876032266292"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0848a/thumb.jpg"
    ZoomLevel="6.479436333854856"
  >
    <Description>This colour image of the region known as NGC 2264 — an area of sky that includes the sparkling blue baubles of the Christmas Tree star cluster and the Cone Nebula — was created from data taken through four different filters (B, V, R and H-alpha) with the Wide Field Imager at ESO&amp;#x27;s La Silla Observatory, 2400 m high in the Atacama Desert of Chile in the foothills of the Andes. The image shows a region of space about 30 light-years across. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0830128429727812"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="100.221416089"
        CenterY="9.6046709646"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 2264 and the Christmas Tree cluster*"
        OffsetX="-0.02146370196920399"
        OffsetY="-0.001300830422376015"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5702596170160756"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0848a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0848a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0848a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0902a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-01-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.28388582196135"
    Magnitude="0"
    Name="The starburst galaxy NGC 253"
    Opacity="100"
    RA="0.7926034513425805"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0902a/thumb.jpg"
    ZoomLevel="5.063474910124343"
  >
    <Description>NGC 253 is one of the brightest spiral galaxies in the sky, and also one of the dustiest. The whole galaxy is shown here as observed with the WFI instrument, while the insert shows a close-up of the central parts as observed with the NACO instrument on ESO&amp;#x27;s Very Large Telescope and the ACS on the NASA/ESA Hubble Space Telescope. This unique set of observations has allowed a team of astronomers from the Instituto de Astrofísica de Canarias (Spain) to study the galaxy in great detail, uncovering many young, massive and dusty stellar nurseries. They also found that the centre of this galaxy appears to harbour a twin of our own Milky Way&amp;#x27;s supermassive black hole.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0830000904346786"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="11.8902020999"
        CenterY="-25.2849846151"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The starburst galaxy NGC 253"
        OffsetX="0.0010698687690425"
        OffsetY="0.0010698687690424897"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.571225996863739"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0902a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0902a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0902a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0902b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-01-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.287619299014676"
    Magnitude="0"
    Name="The centre of NGC 253"
    Opacity="100"
    RA="0.7925911045416778"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0902b/thumb.jpg"
    ZoomLevel="0.0640581522"
  >
    <Description>Close-up of the central regions of the starburst galaxy NGC 253. This image is based on data obtained with the NACO instrument on ESO&amp;#x27;s Very Large Telescope (VLT) and the ACS on the NASA/ESA Hubble Space Telescope. Thanks to the VLT&amp;#x27;s sharp eye, astronomers have identified 37 bright regions, a threefold increase on previous results. These regions are probably very active nurseries that contain as many as one hundred thousand young, massive stars bursting from their dusty cocoons. The field of view is 15 arcseconds.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.007919872"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="11.8884"
        CenterY="-25.28852"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The centre of NGC 253"
        OffsetX="-0.00044111791966995124"
        OffsetY="0.0008914264347009863"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-1.2313886978399997"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0902b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/NASA/ESA</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0902b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0902b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0902c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-01-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.28388582196135"
    Magnitude="0"
    Name="Spiral galaxy NGC 253*"
    Opacity="100"
    RA="0.7926034513425805"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0902c/thumb.jpg"
    ZoomLevel="5.063474910124343"
  >
    <Description>Measuring 70 000 light-years across and laying 13 million light-years away, the nearly edge-on spiral galaxy NGC 253 is revealed here in an image from the Wide Field Imager (WFI) on the MPG/ESO 2.2-metre telescope at the La Silla Observatory. The image is based on data obtained through four different filters (R, V, H-alpha and OIII). North is up and East to the left. The field of view is 30 arcminutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0830000904346786"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="11.8902020999"
        CenterY="-25.2849846151"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 253*"
        OffsetX="0.0010698687690425"
        OffsetY="0.0010698687690424897"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.571225996863739"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0902c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0902c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0902c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0902d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-07-27T11:54:04+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.311328390810694"
    Magnitude="0"
    Name="Digitized Sky Survey image of NGC 253"
    Opacity="100"
    RA="0.7866681115357739"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0902d/thumb.jpg"
    ZoomLevel="37.256902763364"
  >
    <Description>This image is a colour composite made from exposures from the Digitized Sky Survey 2 (DSS2). The field of view is approximatelly 3.7 x 3.6 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.64021192704"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="11.887832"
        CenterY="-25.28839"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image of NGC 253"
        OffsetX="0.07942409672941188"
        OffsetY="-0.022812861983524255"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.10934695522000001"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0902d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0902d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0902d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0903a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-01-28T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.01749497953733"
    Magnitude="0"
    Name="Centaurus A"
    Opacity="100"
    RA="13.424437991912665"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0903a/thumb.jpg"
    ZoomLevel="4.066306562322001"
  >
    <Description>Colour composite image of Centaurus A, revealing the lobes and jets emanating from the active galaxy’s central black hole. This is a composite of images obtained with three instruments, operating at very different wavelengths. The 870-micron submillimetre data, from LABOCA on APEX, are shown in orange. X-ray data from the Chandra X-ray Observatory are shown in blue. Visible light data from the Wide Field Imager (WFI) on the MPG/ESO 2.2 m telescope located at La Silla, Chile, show the stars and the galaxy’s characteristic dust lane in close to &amp;quot;true colour&amp;quot;. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5522154700800002"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.36542"
        CenterY="-43.019319"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centaurus A"
        OffsetX="-0.0008395587002535628"
        OffsetY="0.0018245534586162977"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.03674151123"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0903a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/WFI (Optical); MPIfR/ESO/APEX/A.Weiss et al. (Submillimetre); NASA/CXC/CfA/R.Kraft et al. (X-ray)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0903a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0903a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0905a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-02-12T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-59.58409423300125"
    Magnitude="0"
    Name="The Carina Nebula *"
    Opacity="100"
    RA="10.742153338396296"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0905a/thumb.jpg"
    ZoomLevel="5.6254304871719985"
  >
    <Description>Colour-composite image of the Carina Nebula, revealing exquisite details in the stars and dust of the region. Several well known astronomical objects can be seen in this wide field image : to the bottom left of the image is one of the most impressive binary stars in the Universe, Eta Carinae, with the famous Keyhole Nebula just adjacent to the star. The collection of very bright, young stars above and to the right of Eta Carinae is the open star cluster Trumpler 14. A second open star cluster, Collinder 228 is also seen in the image, just below Eta Carinae. The Carina Nebula also bears the NGC 3372 designation. On this image, North is up and East is to the left. The field of view is 0.55 x 0.55 degrees, covering a 72 x 72 light-year region at the distance of the nebula. This image is available as a mounted image in the ESOshop.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0838413815782941"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="161.265131"
        CenterY="-59.684619"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Carina Nebula *"
        OffsetX="0.06692324504632854"
        OffsetY="0.10067480984420481"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.18549279756117404"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0905a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0905a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0905a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0905b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-11-16T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.02111682354603"
    Magnitude="0"
    Name="Digitized Sky Survey image of Eta Carinae Nebula"
    Opacity="100"
    RA="10.779661471014817"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0905b/thumb.jpg"
    ZoomLevel="48.65054716638001"
  >
    <Description>This image is a colour composite made from exposures from the Digitized Sky Survey 2 (DSS2). The field of view is approximately 4.7 x 4.9 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="8.890345142362868"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="161.265131"
        CenterY="-59.684619"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image of Eta Carinae Nebula"
        OffsetX="-0.21135286306499262"
        OffsetY="-0.3393476929627353"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.5773485945364512"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso0905b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0905b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0905b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0906e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-07-30T16:37:18+00:00&quot;}"
    DataSetType="Sky"
    Dec="-21.905125807146735"
    Magnitude="0"
    Name="Digitized Sky Survey image of the star T Leporis"
    Opacity="100"
    RA="5.080830886923518"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0906e/thumb.jpg"
    ZoomLevel="22.0060656279"
  >
    <Description>This image is a colour composite made from exposures from the Digitized  Sky Survey 2 (DSS2). The field of view is approximatelly 2.7 x 2.1 degrees. ESO/Digitized Sky Survey 2.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.585856548932019"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="76.211912"
        CenterY="-21.904673"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image of the star T Leporis"
        OffsetX="-0.000506796771366665"
        OffsetY="-0.0004580689658186036"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.5918415501801818"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0906e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0906e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0906e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0907a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-02-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-20.825097188977786"
    Magnitude="0"
    Name="The Helix Nebula*"
    Opacity="100"
    RA="22.49401562063087"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0907a/thumb.jpg"
    ZoomLevel="4.409979793529999"
  >
    <Description>This colour-composite image of the Helix Nebula (NGC 7293) was created from images obtained using the Wide Field Imager (WFI), an astronomical camera attached to the 2.2-metre Max-Planck Society/ESO telescope at the La Silla observatory in Chile. The blue-green glow in the centre of the Helix comes from oxygen atoms shining under effects of the intense ultraviolet radiation of the 120 000 degree Celsius central star and the hot gas. Further out from the star and beyond the ring of knots, the red colour from hydrogen and nitrogen is more prominent. A careful look at the central part of this object reveals not only the knots, but also many remote galaxies seen right through the thinly spread glowing gas.This image was created from images through blue, green and red filters and the total exposure times were 12 minutes, 9 minutes and 7 minutes respectively. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.54197690368"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="337.410689"
        CenterY="-20.837171"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Helix Nebula*"
        OffsetX="0.00039862092367938393"
        OffsetY="0.0120747097930097"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.12510794634"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0907a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0907a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0907a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0907b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2012-01-19T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-20.837374231142533"
    Magnitude="0"
    Name="Digitized Sky Survey image of the Helix Nebula"
    Opacity="100"
    RA="22.494046517453352"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0907b/thumb.jpg"
    ZoomLevel="30.555762968015998"
  >
    <Description>This visible-light wide-field image of the region around the Helix Nebula was created from photographs taken through red and blue filters and forming part of the Digitized Sky Survey 2. The nebula appears prominently at the centre of the image and many faint galaxies are also visible on careful inspection.  The field of view is approximatelly 2.9 x 2.9 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.63815376896"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="337.410585"
        CenterY="-20.837271"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image of the Helix Nebula"
        OffsetX="-0.00010465325603131223"
        OffsetY="-0.00010397443629617352"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.40549758529"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0907b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0907b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0907b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0911a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-03-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-10.171280764029426"
    Magnitude="0"
    Name="A curious pair of galaxies"
    Opacity="100"
    RA="14.825006100610473"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0911a/thumb.jpg"
    ZoomLevel="1.1573757578321469"
  >
    <Description>This colour composite image of Arp 261 was created from images obtained using the FORS2 instrument on the ESO Very Large Telescope (VLT), at the Paranal Observatory in Chile. Located 2,600 m above sea level, in the mountains of the Atacama Desert, the Paranal Observatory enjoys some of the clearest and darkest skies on the whole planet. This image was created from images through blue, green, red and infrared filters and the total exposure time was 45 minutes.  Further information can be found on eso0911.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13956930766297101"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="222.3750575"
        CenterY="-10.1712461"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A curious pair of galaxies"
        OffsetX="-3.407454999634496e-05"
        OffsetY="-3.407453800365503e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0911a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0911a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0911a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0911b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-07-26T15:37:01+00:00&quot;}"
    DataSetType="Sky"
    Dec="-10.15167086204985"
    Magnitude="0"
    Name="Digitized Sky Survey image of ARP 261"
    Opacity="100"
    RA="14.82565586522853"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0911b/thumb.jpg"
    ZoomLevel="28.441683215039994"
  >
    <Description>This image is a colour composite made from exposures from the Digitized Sky Survey 2 (DSS2). The field of view is approximatelly 2.7 x 2.8 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.583181256444301"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="222.386276"
        CenterY="-10.163089"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image of ARP 261"
        OffsetX="0.001327145583541024"
        OffsetY="0.011428745706062615"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.44319541800201206"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0911b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0911b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0911b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0914a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-04-04T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-39.21898760225601"
    Magnitude="0"
    Name="Irregular galaxy NGC 55"
    Opacity="100"
    RA="0.25133702152663084"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0914a/thumb.jpg"
    ZoomLevel="5.406560105387701"
  >
    <Description>Image of the irregular galaxy NGC 55 obtained with the Wide Field Imager on the 2.2-metre MPG/ESO telescope at ESO La Silla Observatory. The galaxy is about 7.5 million light-years away and 70,000 light-years across. The image is based on data obtained through B, V, and H-alpha filters. North is up, East to the left. The field of view is 30 arcminutes wide.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.083385688997888"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="3.72157935194"
        CenterY="-39.1949077926"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Irregular galaxy NGC 55"
        OffsetX="-0.03754388294452472"
        OffsetY="-0.024108795641141465"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.028898411019999928"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0914a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0914a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0914a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0915c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-04-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-7.727350134178115"
    Magnitude="0"
    Name="DSS image"
    Opacity="100"
    RA="15.32494035238957"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0915c/thumb.jpg"
    ZoomLevel="36.93751078617599"
  >
    <Description>A wide-field image of the area of the sky near the system Gliese 581.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.582666411635276"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="229.861571"
        CenterY="-7.722491"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="DSS image"
        OffsetX="-0.012432787577836814"
        OffsetY="-0.004827696855475091"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.14578231883633566"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0915c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO and Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0915c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0915c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0919c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-05-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.478294110993925"
    Magnitude="0"
    Name="The Virgo Cluster"
    Opacity="100"
    RA="12.51429711175327"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0919c/thumb.jpg"
    ZoomLevel="64.65446085680401"
  >
    <Description>Image of the Virgo cluster of galaxies taken with the Palomar Observatory 48-inch Schmidt telescope as part of the Digitized Sky Survey 2. The giant elliptical galaxy Messier 87 is seen in the centre, while Messier 84 and 86 are the two bright galaxies forming part of the small group on the centre right of the image. New observations obtained with ESO’s Very Large Telescope have shown that the halo of stars around Messier 87 has been truncated, possibly because of some interaction with Messier 84. The observations also reveal that Messier 87 and 86 are moving towards each other.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="6.859951939982805"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="186.633604"
        CenterY="12.723296"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Virgo Cluster"
        OffsetX="-1.0504194495745243"
        OffsetY="-0.26373546211606586"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-1.1371215034945332"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0919c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0919c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0919c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0921a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-06-04T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-28.82226670358753"
    Magnitude="0"
    Name="The Arches cluster"
    Opacity="100"
    RA="17.76396555119676"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0921a/thumb.jpg"
    ZoomLevel="0.07831717926599999"
  >
    <Description>This image of the Arches Cluster of young, massive stars was obtained with NACO on ESO’s Very Large Telescope. The field of view is 28 arcseconds. North is up and east is to the left.  This image is a composite of infrared images obtained through J, H and K filters. The stars appear as bright cores surrounded by faint diffuse halos. This is typical of images obtained by adaptive optics instruments. The halo corresponds to light that was not fully corrected for the blurring effects of the Earth’s atmosphere.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.01540143104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.46052"
        CenterY="-28.82235"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Arches cluster"
        OffsetX="0.0009082682188461654"
        OffsetY="8.36497155207201e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.02253672304"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0921a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/P. Espinoza</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0921a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0921a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0921c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-06-04T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.00234242448592"
    Magnitude="0"
    Name="Around the Arches Cluster"
    Opacity="100"
    RA="17.76176380165196"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0921c/thumb.jpg"
    ZoomLevel="5.477684016634743"
  >
    <Description>The turbulent central region of our Milky Way is shown in this beautiful picture taken with the Wide Field Imager attached to the 2.2-metre MPG/ESO telescope. Near the centre of the image — and of our Galaxy — a supermassive black hole lurks (see ESO Press Release eso0846). Dense dust found there obscures all but the brightest stars. The image also includes the area occupied by the Arches Cluster (located in the middle of the upper quarter of the image). Astronomers needed to look in the near-infrared with the acute eye offered by adaptive optics on ESO&amp;#x27;s Very Large Telescope to study the stellar composition of the Arches Cluster. This crowded stellar factory has more than a thousand stars crammed into each cubic light year — an astonishing one million times as star-filled as our Sun’s neighbourhood (ESO Press Release eso0921).  Also see the marvellous zoom to the Arches Cluster. This colour composite image was made from data taken with B, V, and Rc filters.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0830458159380536"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.422798543"
        CenterY="-29.0020408719"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Around the Arches Cluster"
        OffsetX="-0.0032067745507649995"
        OffsetY="-0.00021378497005097646"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5711393957758852"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0921c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0921c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0921c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0923a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-06-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-62.300233871590386"
    Magnitude="0"
    Name="The rim of RCW 86"
    Opacity="100"
    RA="14.752062327706714"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0923a/thumb.jpg"
    ZoomLevel="0.6779613133860001"
  >
    <Description>Image of part of a stellar remnant whose explosion was recorded in 185 AD. By studying this remnant in detail, a team of astronomers was able to solve the mystery of the Milky Way’s super-efficient particle accelerators. The team shows that the shock wave visible in this area is very efficient at accelerating particles and the energy used in this process matches the number of cosmic rays observed on Earth. North is toward the top right and east to the top left. The image is about 6 arc minutes across.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14374234112000003"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="221.283859253"
        CenterY="-62.2992401123"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The rim of RCW 86"
        OffsetX="-0.00048498973297552556"
        OffsetY="-0.0016125200026194588"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="70.5696484674"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0923a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/E. Helder &amp;amp; NASA/Chandra</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0923a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0923a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0923b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-06-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-62.47970967641787"
    Magnitude="0"
    Name="DSS + insert, annotated"
    Opacity="100"
    RA="14.713569233484195"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0923b/thumb.jpg"
    ZoomLevel="18.94840529676"
  >
    <Description>This wide-field image contains the area where a team of researchers confirmed that cosmic rays from our galaxy are very efficiently accelerated in the remnants of exploded stars. The red line guides the eye to various regions where the remnants of the stellar explosion are most visible. The boxed area contains an insert of data from the VLT and Chandra. This region, named RCW 86, is centered on the position where a star exploded in 185 AD. The field of view is 4 degrees across with north to the top and east to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="2.29189310464"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="220.120564"
        CenterY="-62.645116"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="DSS + insert, annotated"
        OffsetX="-0.2715458777224962"
        OffsetY="0.1605676600853095"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.7676749695799998"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0923b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO and Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0923b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0923b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0923c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-06-25T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-62.64970237299539"
    Magnitude="0"
    Name="DSS image"
    Opacity="100"
    RA="14.674663536840315"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0923c/thumb.jpg"
    ZoomLevel="45.329741406552"
  >
    <Description>A wide-field image of the area of the sky where the mystery of the Milky Way’s super-efficient particle accelerators was solved by studying the ancient RCW 86 supernova remnant.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.579659611129495"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="220.120564"
        CenterY="-62.645116"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="DSS image"
        OffsetX="0.00034839891306577173"
        OffsetY="-0.004581726995573896"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.8463089430439452"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0923c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO and Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0923c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0923c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0925a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-07-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-16.17544931834577"
    Magnitude="0"
    Name="The Omega Nebula"
    Opacity="100"
    RA="18.346913072251017"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0925a/thumb.jpg"
    ZoomLevel="1.456784627562"
  >
    <Description>Three-colour composite image of the Omega Nebula (Messier 17, or NGC 6618), based on images obtained with the EMMI instrument on the ESO 3.58-metre New Technology Telescope at the La Silla Observatory. North is down and East is to the right in the image. It spans an angle equal to about one third the diameter of the Full Moon, corresponding to about 15 light-years at the distance of the Omega Nebula. The three filters used are B (blue), V (&amp;quot;visual&amp;quot;, or green) and R (red). #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.19061551104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="275.196248"
        CenterY="-16.172013"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Omega Nebula"
        OffsetX="0.007090591110022369"
        OffsetY="0.0035639163296182965"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="178.97454401562996"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0925a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0925a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0925a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0925b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2015-09-23T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-16.16499248980093"
    Magnitude="0"
    Name="Digitized Sky Survey Image of the Omega Nebula (M 17)"
    Opacity="100"
    RA="18.346701431511217"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0925b/thumb.jpg"
    ZoomLevel="37.837356990192"
  >
    <Description>This image is a colour composite of the Omega Nebula (M 17) made from exposures from the Digitized Sky Survey 2 (DSS2). The field of view is approximatelly 4.7 x 3.7 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="9.165613339118782"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="275.108102"
        CenterY="-16.177118"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey Image of the Omega Nebula (M 17)"
        OffsetX="-0.08873366896269226"
        OffsetY="0.0123379929160013"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1498968709518224"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso0925b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0925b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0925b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0926a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-07-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.763864193871319"
    Magnitude="0"
    Name="The Eagle Nebula"
    Opacity="100"
    RA="18.313725555228167"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0926a/thumb.jpg"
    ZoomLevel="5.452838499552"
  >
    <Description>Three-colour composite mosaic image of the Eagle Nebula (Messier 16, or NGC 6611), based on images obtained with the Wide-Field Imager camera on the MPG/ESO 2.2-metre telescope at the La Silla Observatory. At the centre, the so-called “Pillars of Creation” can be seen. This wide-field  image shows not only the central pillars, but also several others in the same star-forming region, as well as a huge number of stars in front of, in, or behind the Eagle Nebula. The cluster of bright stars to the upper right is NGC 6611, home to the massive and hot stars that illuminate the pillars. The “Spire” — another large pillar — is in the middle left of the image. This image is a composite of 3 filters in the visible range: B (blue), V (green) and R (red). #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.54173401088"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.70004"
        CenterY="-13.819953"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Eagle Nebula"
        OffsetX="-0.005680855754615288"
        OffsetY="0.05608821675944523"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.005433013790000001"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0926a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0926a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0926a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0926b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-07-27T10:55:43+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.854272145870342"
    Magnitude="0"
    Name="Digitized sky survey image of the Eagle Nebula"
    Opacity="100"
    RA="18.313097906997047"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0926b/thumb.jpg"
    ZoomLevel="33.583751824535995"
  >
    <Description>This image is a colour composite of the Eagle Nebula (M 16) made from exposures from the Digitized Sky Survey 2 (DSS2). The field of view is approximatelly 3.8 x 3.3 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.58246045696"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.70002"
        CenterY="-13.806964"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized sky survey image of the Eagle Nebula"
        OffsetX="0.008166209757067418"
        OffsetY="-0.04672543599330089"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-5.74480684349"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0926b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0926b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0926b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0927e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-07-26T15:52:32+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.403320055283865"
    Magnitude="0"
    Name="Digitized Sky Survey image of Betelgeuse"
    Opacity="100"
    RA="5.919549553676611"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0927e/thumb.jpg"
    ZoomLevel="15.207098400000001"
  >
    <Description>This image is a colour composite made from exposures from the Digitized Sky Survey 2 (DSS2). The field of view is approximatelly 2.0 x 1.5 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="2.2905827576894224"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="88.793286"
        CenterY="7.406972"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image of Betelgeuse"
        OffsetX="4.5169446213163614e-05"
        OffsetY="-0.0036519108381215287"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.04440843881277571"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0927e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0927e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0927e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0928a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-08-05T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-58.672073475935555"
    Magnitude="0"
    Name="Reflection nebula around HD 87643"
    Opacity="100"
    RA="10.07514426467726"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0928a/thumb.jpg"
    ZoomLevel="2.2072514693759997"
  >
    <Description>This image, centred on the B[e] star HD 87643, beautifully shows the extended nebula of gas and dust that reflects the light from the star. The central star&amp;#x27;s wind appears to have shaped the nebula, leaving bright, ragged tendrils of gas and dust. A careful investigation of these features seems to indicate that there are regular ejections of matter from the star every 15 to 50 years. The image,  taken with the Wide Field Imager on the MPG/ESO 2.2-metre telescope at La Silla, is based on data obtained through different filters: B, V and R.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.31701106687999997"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="151.126288"
        CenterY="-58.664464"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Reflection nebula around HD 87643"
        OffsetX="-8.828919891347304e-05"
        OffsetY="-0.007622585378891564"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-2.761618749020001"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0928a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/F. Millour et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0928a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0928a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0928e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-08-05T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-58.65211252503549"
    Magnitude="0"
    Name="The field around HD 87643"
    Opacity="100"
    RA="10.073777641573761"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0928e/thumb.jpg"
    ZoomLevel="5.46794426238"
  >
    <Description>This image, showing a very rich field of stars towards the Carina arm of the Milky Way, is centred on the star HD 87643, a member of the class of B[e] stars. The amazing image is set ablaze by a flurry of stars of all colours and brightnesses, some of which are seen against a backdrop of clouds of dust and gas. The red emission nebula is RCW47 and was catalogued in 1960. HD 87643 has been extensively studied with a full range of ESO telescopes, including the Very Large Telescope Interferometer (VLTI). Surrounded by a complex, extended nebula that is the result of previous violent ejections, the star is shown to have a companion. Interactions in this double system, surrounded by a dusty disc, may be the engine fuelling the star&amp;#x27;s remarkable nebula. The image, taken with the Wide Field Imager on the MPG/ESO 2.2-metre telescope at La Silla, is based on data obtained through different filters: B, V and R. The field of view is 33 x 32 arc-minutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0829863735745497"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="151.126558"
        CenterY="-58.664467"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The field around HD 87643"
        OffsetX="0.010363663348127498"
        OffsetY="0.012340802531083734"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.0671511125755728"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0928e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/F. Millour et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0928e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0928e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0928f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-07-26T16:27:16+00:00&quot;}"
    DataSetType="Sky"
    Dec="-58.67668794238824"
    Magnitude="0"
    Name="Digitized Sky Survey image of the double star HD 87643"
    Opacity="100"
    RA="10.074929922608383"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0928f/thumb.jpg"
    ZoomLevel="26.067923615669997"
  >
    <Description>This image is a colour composite made from exposures from the Digitized Sky Survey 2 (DSS2). The field of view is approximatelly 3.9 x 2.5 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.5857234944"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="151.126558"
        CenterY="-58.664467"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image of the double star HD 87643"
        OffsetX="0.0019121570426877917"
        OffsetY="-0.0121464234203699"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-2.61300837467"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0928f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0928f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0928f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0929a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-08-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-47.50931948252524"
    Magnitude="0"
    Name="The region around the massive star IRS2"
    Opacity="100"
    RA="8.984902882073452"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0929a/thumb.jpg"
    ZoomLevel="0.143033565108"
  >
    <Description>Colour composite image of the central part of the stellar cluster RCW 38, around the young, massive  star IRS2, taken with the NACO adaptive optics instrument attached to ESO&amp;#x27;s Very Large  Telescope. Thanks to this image, astronomers were able to discover that IRS2 is in fact a twin  system composed of two almost equally massive stars. The astronomers also found a handful of  protostars – the faintly luminous precursors to fully realised stars – and dozens of other candidate  stars that have eked out an existence here despite the powerful ultraviolet light radiated by IRS2.  The image is based on near-infrared data taken through three different filters (J, H and K). The field of  view is about 1 arcminute across.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.01537414144"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="134.774025124"
        CenterY="-47.5104322223"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The region around the massive star IRS2"
        OffsetX="0.00032614979907922734"
        OffsetY="0.001112549745906153"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.033238566440000006"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0929a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0929a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0929a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0929b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-08-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-47.52451446968712"
    Magnitude="0"
    Name="Star cluster RCW 38"
    Opacity="100"
    RA="8.98498266710363"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0929b/thumb.jpg"
    ZoomLevel="1.984178732110959"
  >
    <Description>The dense star cluster RCW 38 glistens about 5,500 light years away in the direction of the  constellation Vela (the Sails). RCW 38 is an &amp;quot;embedded&amp;quot; cluster, in that the nascent cloud of dust  and gas still envelops its stars. There, young, titanic stars bombard fledgling suns and planets with  powerful winds and large amount of light, helped in their devastating task by short-lived, massive  stars that explode as supernovae. In some cases, this energetic onslaught cooks away the matter  that may eventually form new planetary systems. Scientists think that our own Solar System  emerged from such a dramatic environment.  This image was obtained with the Wide Field Imager instrument on the MPG/ESO 2.2-metre  telescope at La Silla, using data collected through four filters (B, V, R and H-alpha). The field of view  is about 10 arcminutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27064671537745394"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="134.78299193"
        CenterY="-47.5293839654"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Star cluster RCW 38"
        OffsetX="0.005703498632062501"
        OffsetY="0.004714892202505001"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5683889446913049"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0929b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0929b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0929b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0929c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-08-19T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-47.518366884128575"
    Magnitude="0"
    Name="Nebula around star cluster RCW 38"
    Opacity="100"
    RA="8.995775017131026"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0929c/thumb.jpg"
    ZoomLevel="5.619165639623999"
  >
    <Description>The wider region surrounding the star cluster RCW 38, located about 5,500 light years away in the  direction of the constellation Vela (the Sails). RCW 38 is an &amp;quot;embedded&amp;quot; cluster, in that the nascent  cloud of dust and gas still envelops its stars. There, young, titanic stars bombard fledgling suns and  planets with powerful winds and large amount of light, helped in their devastating task by short- lived, massive stars that explode as supernovae. In some cases, this energetic onslaught cooks  away the matter that may eventually form new planetary systems. Scientists think that our own Solar  System emerged from such a dramatic environment.  This image was obtained with the Wide Field Imager instrument on the MPG/ESO 2.2-metre  telescope at La Silla, using data collected through four filters (B, V, R and H-alpha). The field of view  is 30 arcminutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.08328402944"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="134.946773"
        CenterY="-47.532576"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Nebula around star cluster RCW 38"
        OffsetX="0.006853417818748558"
        OffsetY="0.014208620113291102"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.00040516919999999994"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0929c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0929c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0929c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0929d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2018-07-11T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-47.30884365928676"
    Magnitude="0"
    Name="Digitized Sky Survey image around the stellar cluster RCW 38"
    Opacity="100"
    RA="8.978063649655098"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0929d/thumb.jpg"
    ZoomLevel="19.819992549696"
  >
    <Description>This image is a colour composite made from exposures from the Digitized  Sky Survey 2 (DSS2). The field of view is approximately 2.4 x 2.0 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.47831605248"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="134.946416"
        CenterY="-47.532344"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image around the stellar cluster RCW 38"
        OffsetX="0.189004704773872"
        OffsetY="0.2212881085538602"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.5743071904700001"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0929d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0929d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0929d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0930a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-08-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-22.941776124305385"
    Magnitude="0"
    Name="The Trifid Nebula"
    Opacity="100"
    RA="18.038456166520067"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0930a/thumb.jpg"
    ZoomLevel="3.8799492056915317"
  >
    <Description>The massive star factory known as the Trifid Nebula was captured in all its glory with the Wide-Field Imager camera attached to the MPG/ESO 2.2-metre telescope at ESO’s La Silla Observatory in northern Chile. So named for the dark dust bands that trisect its glowing heart, the Trifid Nebula is a rare combination of three nebulae types that reveal the fury of freshly formed stars and point to more star birth in the future. The field of view of the image is approximately 13 x 17 arcminutes. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.541747523334169"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="270.6747998"
        CenterY="-22.971158961"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Trifid Nebula"
        OffsetX="0.0901285677263396"
        OffsetY="0.029599133153191702"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.15653912966357997"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0930a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0930a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0930a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0930b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-08-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-22.929787506471765"
    Magnitude="0"
    Name="The Trifid Nebula (full frame)"
    Opacity="100"
    RA="18.035983054479562"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0930b/thumb.jpg"
    ZoomLevel="4.129349719873495"
  >
    <Description>The massive star factory known as the Trifid Nebula was captured in all its glory with the Wide-Field Imager camera attached to the MPG/ESO 2.2-metre telescope at ESO’s La Silla Observatory in northern Chile. So named for the dark dust bands that trisect its glowing heart, the Trifid Nebula is a rare combination of three nebulae types that reveal the fury of freshly formed stars and point to more star birth in the future. The field of view of the image is approximately 19 x 26 arcminutes. The Trifid Nebula is also known as NGC 6514 and Messier 20.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5417240441929728"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="270.539817569"
        CenterY="-22.929820663"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Trifid Nebula (full frame)"
        OffsetX="6.61284233634e-05"
        OffsetY="3.30642116817e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.0799999999999987"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0930b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0930b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0930b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0931a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-09-02T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-49.48227581016394"
    Magnitude="0"
    Name="Spiral galaxy NGC 4945"
    Opacity="100"
    RA="13.089257189932576"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0931a/thumb.jpg"
    ZoomLevel="3.7328813683199997"
  >
    <Description>Seen edge-on, observations of NGC 4945 suggest that this hive of stars is a spiral galaxy much like our own Milky Way, with swirling, luminous arms and a bar-shaped centre. Sites of active star formation, known as HII regions, are seen prominently in the image, appearing bright pink. These resemblances aside, NGC 4945 has a brighter centre that likely harbours a supermassive black hole, which is devouring reams of matter and blasting energy out into space. NGC 4945 is about 13 million light-years away in the constellation of Centaurus (the Centaur) and is beautifully revealed in this image taken with data in five bands (B, V, R, H-alpha and S II) with the 2.2-metre MPG/ESO telescope at La Silla. The field of view is 30 x 30 arcminutes. North is up, East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5413535744"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="196.363884"
        CenterY="-49.46771"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 4945"
        OffsetX="0.01626444326778036"
        OffsetY="-0.01456251272982921"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.02113003509"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0931a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0931a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0931a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0931b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-07-30T16:17:01+00:00&quot;}"
    DataSetType="Sky"
    Dec="-49.47992125438166"
    Magnitude="0"
    Name="Digitized Sky Survey image of the galaxy NGC 4945"
    Opacity="100"
    RA="13.087996360657296"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0931b/thumb.jpg"
    ZoomLevel="30.517915677480005"
  >
    <Description>This image is a colour composite made from exposures from the Digitized  Sky Survey 2 (DSS2). The field of view is approximatelly 3.0 x 3.0 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.5847502848"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="196.363884"
        CenterY="-49.46771"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized Sky Survey image of the galaxy NGC 4945"
        OffsetX="0.028701380117776894"
        OffsetY="-0.011853726844557232"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.7322864695900001"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0931b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0931b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0931b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0933b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-09-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-1.0627725203141185"
    Magnitude="0"
    Name="The planet-hosting star CoRoT-7"
    Opacity="100"
    RA="6.730399878743658"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0933b/thumb.jpg"
    ZoomLevel="2.4708021226440002"
  >
    <Description>The star CoRoT-7 is located towards the constellation of Monoceros (the Unicorn) at a distance of about 500 light-years. Slightly smaller and cooler than our Sun, CoRoT-7 is also thought to be younger, with an age about 1.5 billion years. It is now known to have two planets, one of them being the first to be found with a density similar to that of Earth. CoRoT-7 is in the centre of the image.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.28643089408000005"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="100.956127"
        CenterY="-1.062854"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The planet-hosting star CoRoT-7"
        OffsetX="0.0001290252233485512"
        OffsetY="8.111730137061015e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.16106417237"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0933b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0933b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0933b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0933c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-09-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-1.0618612374701624"
    Magnitude="0"
    Name="Field around the planet-hosting star CoRoT-7"
    Opacity="100"
    RA="6.730445933044459"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0933c/thumb.jpg"
    ZoomLevel="30.397905736176007"
  >
    <Description>The star CoRoT-7 is located towards the constellation of Monoceros (the Unicorn) at a distance of about 500 light-years. This image shows a larger field of view around the star, covering about 9 square degrees or about 11 times the size of the Full Moon. CoRoT-7 is in the centre of the image.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.585591767040001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="100.956328"
        CenterY="-1.062872"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Field around the planet-hosting star CoRoT-7"
        OffsetX="-0.0003583504251009168"
        OffsetY="0.0010116812434855505"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.14636660912999996"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0933c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0933c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0933c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="191.5899845697926"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0934a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-09-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-28.136074666391668"
    Magnitude="0"
    Name="A 340-million pixel starscape from Paranal"
    Opacity="100"
    RA="17.195404250387398"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0934a/thumb.jpg"
    ZoomLevel="191.5899845697926"
  >
    <Description>The second of three images of ESO’s GigaGalaxy Zoom project is a new and wonderful 340-million-pixel vista of the central parts of our galactic home, a 34 by 20-degree wide image that provides us with a view as experienced by amateur astronomers around the world. Taken by Stéphane Guisard, an ESO engineer and world-renowned astrophotographer, from Cerro Paranal, home of ESO’s Very Large Telescope, this second image directly benefits from the quality of Paranal’s sky, one of the best on the planet. The image shows the region spanning the sky from the constellation of Sagittarius (the Archer) to Scorpius (the Scorpion). The very colourful Rho Ophiuchi and Antares region features prominently to the right, as well as much darker areas, such as the Pipe and Snake Nebulae. The dusty lane of our Milky Way runs obliquely through the image, dotted with remarkable bright, reddish nebulae, such as the Lagoon and the Trifid Nebulae, as well as NGC 6357 and NGC 6334. This dark lane also hosts the very centre of our Galaxy, where a supermassive black hole is lurking. The image was obtained by observing with a 10-cm Takahashi FSQ106Ed f/3.6 telescope and a SBIG STL CCD camera, using a NJP160 mount. Images were collected through three different filters (B, V and R) and then stitched together. This mosaic was assembled from 52 different sky fields made from about 1200 individual images totalling 200 hours exposure time, with the final image having a size of 24 403 x 13 973 pixels. Note that the final, full resolution image is only available through Stéphane Guisard. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="57.23022006371571"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="257.6011431300449"
        CenterY="-28.930939115731398"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A 340-million pixel starscape from Paranal"
        OffsetX="-0.2690654626411493"
        OffsetY="0.6150067717512"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.09167090426356425"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0934a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/S. Guisard (www.eso.org/~sguisard)  </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0934a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0934a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0936a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-09-28T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-24.138078404925906"
    Magnitude="0"
    Name="370-million-pixel starscape of the Lagoon Nebula"
    Opacity="100"
    RA="18.06343968031911"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0936a/thumb.jpg"
    ZoomLevel="10.643732090423999"
  >
    <Description>The third image of ESO’s GigaGalaxy Zoom project is an amazing vista of the Lagoon Nebula taken with the 67-million-pixel Wide Field Imager attached to the MPG/ESO 2.2-metre telescope at the La Silla Observatory in Chile. The image covers more than one and a half square degree — an area eight times larger than that of the Full Moon — with a total of about 370 million pixels. It is based on images acquired using three different broadband filters (B, V, R) and one narrow-band filter (H-alpha). #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="2.166340033708829"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="270.904114"
        CenterY="-24.386937"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="370-million-pixel starscape of the Lagoon Nebula"
        OffsetX="-0.0433494194175698"
        OffsetY="0.24884943390284786"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.00447393587860846"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso0936a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0936a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0936a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0938a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-10-14T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-14.79708547888206"
    Magnitude="0"
    Name="Barnard's Galaxy"
    Opacity="100"
    RA="19.748518268434363"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0938a/thumb.jpg"
    ZoomLevel="3.9563594706959995"
  >
    <Description>Astronomers obtained this portrait of Barnard’s Galaxy using the Wide Field Imager attached to the 2.2-metre MPG/ESO telescope at ESO’s La Silla Observatory in northern Chile. Also known as NGC 6822, this dwarf irregular galaxy is one of the Milky Way’s galactic neighbours. The dwarf galaxy has no shortage of stellar splendour and pyrotechnics. Reddish nebulae in this image reveal regions of active star formation, wherein young, hot stars heat up nearby gas clouds. Also prominent in the upper left of this new image is a striking bubble-shaped nebula. At the nebula’s centre, a clutch of massive, scorching stars send waves of matter smashing into surrounding interstellar material, generating a glowing structure that appears ring-like from our perspective. Other similar ripples of heated matter thrown out by feisty young stars are dotted across Barnard’s Galaxy.   The image was made from data obtained through four different filters (B, V, R, and H-alpha). The field of view is 35 x 34 arcmin.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.54149619712"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="296.240693"
        CenterY="-14.803199"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Barnard's Galaxy"
        OffsetX="-0.0061137121791940835"
        OffsetY="0.012490264305558928"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90.00252607558998"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0938a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0938a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0938a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0938b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-07-30T17:07:25+00:00&quot;}"
    DataSetType="Sky"
    Dec="-14.789138460859135"
    Magnitude="0"
    Name="Digitized sky survey image of the galaxy NGC 6822"
    Opacity="100"
    RA="19.74934890419032"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0938b/thumb.jpg"
    ZoomLevel="30.357254990735996"
  >
    <Description>This image is a colour composite made from exposures from the Digitized  Sky Survey 2 (DSS2). The field of view is approximatelly 2.9 x 2.9 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.58462625792"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="296.240838"
        CenterY="-14.803198"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized sky survey image of the galaxy NGC 6822"
        OffsetX="0.0004982652518170637"
        OffsetY="0.014062855230808306"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.35102993358999995"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0938b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0938b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0938b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0940a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-10-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.365884463048225"
    Magnitude="0"
    Name="A snapshot of the Jewel Box cluster with the ESO VLT"
    Opacity="100"
    RA="12.894878019738787"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0940a/thumb.jpg"
    ZoomLevel="1.114620279330515"
  >
    <Description>The FORS1 instrument on the ESO Very Large Telescope (VLT) at ESO’s Paranal Observatory was used to take this exquisitely sharp close up view of the colourful Jewel Box cluster, NGC 4755. The telescope’s huge mirror allowed very short exposure times: just 2.6 seconds through a blue filter (B), 1.3 seconds through a yellow/green filter (V) and 1.3 seconds through a red filter (R). The field of view spans about seven arcminutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14281957105927992"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="193.415106847"
        CenterY="-60.366797911"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A snapshot of the Jewel Box cluster with the ESO VLT"
        OffsetX="-0.003960527790936457"
        OffsetY="0.0010220716879836063"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5702759177604937"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0940a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Y. Beletsky</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0940a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0940a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0940b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-10-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.37598614990768"
    Magnitude="0"
    Name="Wide field image of the Jewel Box"
    Opacity="100"
    RA="12.894300141831645"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0940b/thumb.jpg"
    ZoomLevel="3.4588365076800005"
  >
    <Description>This image of the well-known NGC 4755 cluster or Jewel Box was taken with the Wide Field Imager (WFI) on the MPG/ESO 2.2-metre telescope at ESO’s La Silla Observatory. It highlights the cluster and its rich surroundings in all their multicoloured glory. The field of view is 20 arcminutes across. The picture is based on images obtained through B, V and I filters.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.54150496256"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="193.304855"
        CenterY="-60.46796"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide field image of the Jewel Box"
        OffsetX="-0.05421400578307644"
        OffsetY="0.09192018768860617"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.00915292822"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso0940b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0940b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0940b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0940c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-10-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.36610315568288"
    Magnitude="0"
    Name="A Hubble gem: the Jewel Box"
    Opacity="100"
    RA="12.896271188175872"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0940c/thumb.jpg"
    ZoomLevel="0.21046132566000003"
  >
    <Description>This image is a “close-up” view from the NASA/ESA Hubble Space Telescope of NGC 4755, or the Jewel Box cluster. Several very bright, pale blue supergiant stars, a solitary ruby-red supergiant and a variety of other brilliantly coloured stars are visible in the image, as well as many much fainter ones, often with intriguing colours. The huge variety in brightness exists because the brighter stars are 15 to 20 times the mass of the Sun, while the dim points are less than half the mass of the Sun. This is the first image of an open galactic cluster with imaging extending from the far ultraviolet to the near-infrared.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05683568640000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="193.425507"
        CenterY="-60.367004"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A Hubble gem: the Jewel Box"
        OffsetX="-0.006967285874409109"
        OffsetY="0.006040933324939376"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="35.32860183997"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0940c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>NASA/ESA and Jesús Maíz Apellániz (Instituto de Astrofísica de Andalucía, Spain)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0940c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0940c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0940d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-10-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.356825901889"
    Magnitude="0"
    Name="Digitized sky survey 2 image of NGC 4755"
    Opacity="100"
    RA="12.892396144843035"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0940d/thumb.jpg"
    ZoomLevel="29.351775474708"
  >
    <Description>A wide-field image of the region around NGC 4755 (the Jewel Box) constructed from data from the Digitized Sky Survey 2. The bright star is Mimosa, one of the four stars in the Southern Cross. The darkness towards the bottom of the image is part of the Coal Sack, a vast area of obscuring dust easily visible to the unaided eye. The field of view is approximately 2.8 degrees x 2.9 degrees, or about 40 times the area of the Full Moon. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.583609640531923"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="193.425507"
        CenterY="-60.367004"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Digitized sky survey 2 image of NGC 4755"
        OffsetX="0.019566160119829694"
        OffsetY="0.010176997889999932"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.013973403836026658"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0940d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO, ESA/Hubble and Digitized Sky Survey 2. Acknowledgment: Davide De Martin (ESA/Hubble)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0940d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0940d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0941c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-11-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="16.46324786827518"
    Magnitude="0"
    Name="Gigantic structure of galaxies"
    Opacity="100"
    RA="0.3145809979965761"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0941c/thumb.jpg"
    ZoomLevel="10.488932176144647"
  >
    <Description>This image, obtained with the Subaru Telescope, operated by the National Astronomical Observatory of Japan was used by a team of astronomers, led by Masayuki Tanaka from the European Southern Observatory (ESO), to uncover a gigantic, previously unknown assembly of galaxies located almost seven billion light-years away from us. This structure was confirmed by further observations made using ESO’s Very Large Telescope and Subaru. It is the first observation of such a prominent galaxy structure in the distant Universe, providing further insight into the cosmic web and how it formed.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.8389111972935306"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="4.69380235661"
        CenterY="16.514497098"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Gigantic structure of galaxies"
        OffsetX="-0.025286721736125048"
        OffsetY="-0.05057344347225003"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5703927790641703"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0941c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Subaru/National Astronomical Observatory of Japan/M. Tanaka</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0941c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0941c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0943b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-11-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.949970449076904"
    Magnitude="0"
    Name="Around the nova V445 Puppis annotated"
    Opacity="100"
    RA="7.632454350536422"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0943b/thumb.jpg"
    ZoomLevel="5.956471663632"
  >
    <Description>This wide-field image, based on data from Digitized Sky Survey 2, shows the whole region around the nova V445 Puppis, with the double star system highlighted.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.14556137472"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="114.487148"
        CenterY="-25.949706"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Around the nova V445 Puppis annotated"
        OffsetX="0.00029598264703434627"
        OffsetY="-0.00026803858190564955"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.69101939305"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0943b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0943b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0943b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0943c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-11-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.94993374603258"
    Magnitude="0"
    Name="Around the nova V445 Puppis"
    Opacity="100"
    RA="7.6324218879450125"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0943c/thumb.jpg"
    ZoomLevel="30.574250969040012"
  >
    <Description>This wide-field image, based on data from Digitized Sky Survey 2, shows the whole region around the nova V445 Puppis.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.58378196639134"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="114.487317"
        CenterY="-25.949656"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Around the nova V445 Puppis"
        OffsetX="0.0008855917668962374"
        OffsetY="-0.0002884289969768529"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.6895618623211497"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0943c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0943c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0943c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0944a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-11-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.01880733873709"
    Magnitude="0"
    Name="Dinner for Centaurus A"
    Opacity="100"
    RA="13.424071091432694"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0944a/thumb.jpg"
    ZoomLevel="0.693912869618706"
  >
    <Description>This image of the central parts of Centaurus A reveals the parallelogram-shaped remains of a smaller galaxy that was gulped down about 200 to 700 million years ago. The image is based on data collected with the SOFI instrument on ESO’s New Technology Telescope at La Silla. The original image, obtained by observing in the near-infrared through three different filters (J, H and K) was specially processed to look through the dust, providing a clear view of the centre. The field of view is about 4 x 4 arcminutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08205348604928"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.361175663"
        CenterY="-43.0188876926"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Dinner for Centaurus A"
        OffsetX="8.013035747e-05"
        OffsetY="8.013035747e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.16000000000000006"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso0944a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Y. Beletsky</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0944a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0944a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0945a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-11-25T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-24.779867694415188"
    Magnitude="0"
    Name="The star cluster Terzan 5"
    Opacity="100"
    RA="17.801293655080052"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0945a/thumb.jpg"
    ZoomLevel="0.108679617288"
  >
    <Description>Peering through the thick dust clouds of our galaxy&amp;#x27;s central parts (the &amp;quot;bulge&amp;quot;) with an amazing amount of detail, a team of astronomers has revealed an unusual mix of stars in the stellar grouping known as Terzan 5. Never observed anywhere in the bulge before, this peculiar cocktail of stars suggests that Terzan 5 is in fact one of the bulge&amp;#x27;s primordial building blocks, most likely the relic of a dwarf galaxy that merged with the Milky Way during its very early days.  This near-infrared image was obtained with the Multi-conjugate Adaptive Optics Demonstrator (MAD) instrument on ESO&amp;#x27;s Very Large Telescope. Observations in two bands (J and K) were combined. The field of view is 40 arcseconds across.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.01589305344"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="267.018475384"
        CenterY="-24.7800669367"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The star cluster Terzan 5"
        OffsetX="0.0008444188682099014"
        OffsetY="-0.00019687292377812952"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="179.83937530639"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso0945a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/F. Ferraro</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0945a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0945a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0946b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-11-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.89319034225999"
    Magnitude="0"
    Name="Revisiting the quasar without a home"
    Opacity="100"
    RA="4.875031013117478"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0946b/thumb.jpg"
    ZoomLevel="0.017155046154"
  >
    <Description>Colour composite image of a peculiar object, the nearby quasar HE0450-2958, which is the only one for which no sign of a host galaxy has yet been detected.  A team of astronomers has identified black hole jets as a possible driver of galaxy formation, which may also represent the long-sought missing link to understanding why the mass of black holes is larger in galaxies that contain more stars. The mid-infrared part of this image was obtained with the VISIR instrument on ESO’s Very Large Telescope, while the visible image comes courtesy of the Hubble Space Telescope and the Advanced Camera for Surveys.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00260155904"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="73.1254374981"
        CenterY="-29.8932138888"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Revisiting the quasar without a home"
        OffsetX="-2.3260204024501182e-05"
        OffsetY="2.4290975927666787e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.8043713193899997"
        Sparse="True"
        StockSet="False"
        TileLevels="1"
        Url="http://data1.wwtassets.org/feeds/eso/eso0946b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0946b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0946b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0947a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-59.54999608963009"
    Magnitude="0"
    Name="Widest adaptive optics view of the open star cluster Trumpler 14"
    Opacity="100"
    RA="10.731739853665811"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0947a/thumb.jpg"
    ZoomLevel="0.251758986780406"
  >
    <Description>This impressive image of the open cluster known as Trumpler 14 was obtained with the Multi-conjugate Adaptive optics Demonstrator (MAD) mounted on ESO’s Very Large Telescope. The cluster, which is found to be only 500 000 years old — a blink of an eye in the Universe’s history — resides at the outskirts of the central region of the Carina Nebula, located some 8,000 light-years away towards the constellation of Carina (the Keel). Trumpler 14 is not only the youngest, but also one of the most populous clusters within the nebula. Astronomers counted about 2000 stars in the very central parts of this cluster. The MAD instrument allows astronomers to obtain very sharp images over a wide area and this image is the adaptive optics image that so far covers the widest area on the sky. The field of view is about 2 arcminutes across and the image is based on data obtained through two different filters (K and H).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.03203374865965056"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="160.976105521"
        CenterY="-59.55"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Widest adaptive optics view of the open star cluster Trumpler 14"
        OffsetX="3.91036970943e-06"
        OffsetY="3.91036970943e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso0947a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/H. Sana</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0947a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0947a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0947b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-59.582760586508975"
    Magnitude="0"
    Name="Trumpler 14 in the Carina Nebula"
    Opacity="100"
    RA="10.742044886717563"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0947b/thumb.jpg"
    ZoomLevel="5.62185799615278"
  >
    <Description>This image of the Carina Nebula shows the position of the Trumpler 14 cluster of stars.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.083153076281344"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="161.130738635"
        CenterY="-59.5828266854"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Trumpler 14 in the Carina Nebula"
        OffsetX="3.305520862675e-05"
        OffsetY="6.61104172535e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.020000000000000018"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0947b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0947b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0947b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0949a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-11T11:30:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-2.074734731414082"
    Magnitude="0"
    Name="The hidden fires of the Flame Nebula*"
    Opacity="100"
    RA="5.695922979727453"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0949a/thumb.jpg"
    ZoomLevel="8.927998392"
  >
    <Description>This image, the first to be released publicly from VISTA, the world’s largest survey telescope, shows the spectacular star-forming region known as the Flame Nebula, or NGC 2024, in the constellation of Orion (the Hunter) and its surroundings. In views of this evocative object in visible light the core of the nebula is completely hidden behind obscuring dust, but in this VISTA view, taken in infrared light, the cluster of very young stars at the object’s heart is revealed. The wide-field VISTA view also includes the glow of the reflection nebula NGC 2023, just below centre, and the ghostly outline of the Horsehead Nebula (Barnard 33) towards the lower right. The bright bluish star towards the right is one of the three bright stars forming the Belt of Orion. The image was created from VISTA images taken through J, H and Ks filters in the near-infrared part of the spectrum. The image shows about half the area of the full VISTA field and is about 40 x 50 arcminutes in extent. The total exposure time was 14 minutes. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.5532130662449908"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.42804"
        CenterY="-1.912271"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The hidden fires of the Flame Nebula*"
        OffsetX="0.017612451259440873"
        OffsetY="-0.16186720314162256"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-10.012203783072763"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0949a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/J. Emerson/VISTA. Acknowledgment: Cambridge Astronomical Survey Unit </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0949a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0949a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0949b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-11T11:30:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.43113601020973"
    Magnitude="0"
    Name="One million stars — towards the dark heart of the Milky Way*"
    Opacity="100"
    RA="17.747743692882477"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0949b/thumb.jpg"
    ZoomLevel="15.052889616662505"
  >
    <Description>With this remarkable VISTA mosaic we look deep into the dusty heart of our own Milky Way galaxy in the constellation of Sagittarius (the Archer). About one million stars are revealed in this picture, most of them not seen in visible light pictures. As well as absorbing light, the dust also scatters blue light from the distant stars and makes the central part of this huge starscape appear very red. This image is a mosaic created from VISTA images taken through Y, J and Ks filters in the near-infrared part of the spectrum. The image is about 2 degrees by 1.5 degrees in extent. The total exposure time for this mosaic was only 80 seconds. This image is available as a mounted image in the ESOshop #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="3.1066520480710658"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.216173336"
        CenterY="-29.4312012024"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="One million stars — towards the dark heart of the Milky Way*"
        OffsetX="4.74037482921e-05"
        OffsetY="4.74037482921e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="31.520000000000056"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso0949b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/VISTA. Acknowledgment: Cambridge Astronomical Survey Unit </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0949b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0949b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0949c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-11T11:30:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.735528278396096"
    Magnitude="0"
    Name="The Fornax Cluster of galaxies"
    Opacity="100"
    RA="3.5976198477185983"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0949c/thumb.jpg"
    ZoomLevel="12.116820747438"
  >
    <Description>The Fornax Galaxy Cluster is one of the closest of such groupings beyond our Local Group of galaxies. This VISTA image was constructed from images taken through Z, J and Ks filters in the near-infrared part of the spectrum and has captured many of the cluster members in a single image. At the lower-right is the elegant barred-spiral galaxy NGC 1365 and to the left the big elliptical NGC 1399, surrounded by a swarm of faint globular clusters. The image is about 1 degree by 1.5 degrees in extent and the total exposure time was 25 minutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.55095547904"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.927525"
        CenterY="-35.753317"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Fornax Cluster of galaxies"
        OffsetX="-0.03341978823846607"
        OffsetY="0.009504347921445225"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-14.90965428876"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0949c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/J. Emerson/VISTA. Acknowledgment: Cambridge Astronomical Survey Unit</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0949c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0949c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0949k&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-11T11:30:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-1.7669769103288828"
    Magnitude="0"
    Name="The region of Orion’s Belt and the Flame Nebula"
    Opacity="100"
    RA="5.695232171267761"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0949k/thumb.jpg"
    ZoomLevel="27.837077590448093"
  >
    <Description>This spectacular visible light wide-field view of part of the famous belt of the great celestial hunter Orion shows the region of the sky around the Flame Nebula. The whole image is filled with glowing gas clouds illuminated by hot blue young stars. It was created from photographs in red and blue light forming part of the Digitized Sky Survey 2. The field of view is approximately three degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.588873990247408"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.3689733755"
        CenterY="-1.72382503574"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The region of Orion’s Belt and the Flame Nebula"
        OffsetX="-0.05948093502232505"
        OffsetY="-0.04315283521227521"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0949k/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO and Digitized Sky Survey 2. Acknowledgment: Davide De Martin </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0949k/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0949k/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0949l&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-11T11:30:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-28.854156004698748"
    Magnitude="0"
    Name="Wide-field view of the centre of the Milky Way"
    Opacity="100"
    RA="17.76173857115268"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0949l/thumb.jpg"
    ZoomLevel="37.005634801550215"
  >
    <Description>This visible light wide-field view shows the rich star clouds in the constellation of Sagittarius (the Archer) in the direction of the centre of our Milky Way galaxy. The entire image is filled with vast numbers of stars — but far more remain hidden behind clouds of dust and are only revealed in infrared images. This view was created from photographs in red and blue light and forming part of the Digitized Sky Survey 2. The field of view is approximately 3.5 degrees x 3.6 degrees.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.588637324443648"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.278104405"
        CenterY="-28.8303708734"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the centre of the Milky Way"
        OffsetX="-0.13015513002611656"
        OffsetY="-0.020646845649167505"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.4200000000000055"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0949l/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO and Digitized Sky Survey 2. Acknowledgment: Davide De Martin and S. Guisard (www.eso.org/~sguisard)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0949l/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0949l/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0949m&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-11T11:30:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.73324695810775"
    Magnitude="0"
    Name="Wide-field view of the Fornax Galaxy Cluster"
    Opacity="100"
    RA="3.5978976018848283"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0949m/thumb.jpg"
    ZoomLevel="30.569214002184005"
  >
    <Description>The Fornax Galaxy Cluster is one of the closest such groupings beyond our own Local Group of galaxies. This visible light wide-field image of the cluster was created from photographs taken through red and blue filters and forming part of the Digitized Sky Survey 2. The field of view is approximately three degrees across.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.64019554304"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="54.624881"
        CenterY="-35.454967"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the Fornax Galaxy Cluster"
        OffsetX="0.5335503919803615"
        OffsetY="-0.2787488450599866"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.14140887389000004"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0949m/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO and Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0949m/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0949m/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0949n&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-11T11:30:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-2.0621120588622364"
    Magnitude="0"
    Name="The hidden fires of the Flame Nebula (full frame)"
    Opacity="100"
    RA="5.696103995735828"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0949n/thumb.jpg"
    ZoomLevel="14.785352967209999"
  >
    <Description>This VISTA image shows the spectacular star-forming region known as the Flame Nebula, or NGC 2024, in the constellation of Orion (the Hunter) and its surroundings. In views of this evocative object in visible light the core of the nebula is completely hidden behind obscuring dust, but in this VISTA view, taken in infrared light, the cluster of very young stars at the object’s heart is revealed. The wide-field VISTA view also includes the glow of the reflection nebula NGC 2023, just below centre, and the ghostly outline of the Horsehead Nebula (Barnard 33) towards the lower right. The bright bluish star towards the right is one of the three bright stars forming the Belt of Orion. The image was created from VISTA images taken through J, H and Ks filters in the near-infrared part of the spectrum. The image shows the full area of the VISTA field and is one degree by 1.5 degrees in extent. The total exposure time was 14 minutes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.5539707904"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.42805"
        CenterY="-1.912129"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The hidden fires of the Flame Nebula (full frame)"
        OffsetX="0.012901323221658587"
        OffsetY="-0.15003625247492994"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-10.0584588008"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0949n/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/J. Emerson/VISTA. Acknowledgment: Cambridge Astronomical Survey Unit</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0949n/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0949n/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso0950b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-16T19:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="4.963444983485225"
    Magnitude="0"
    Name="The star GJ1214"
    Opacity="100"
    RA="17.2631749394822"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso0950b/thumb.jpg"
    ZoomLevel="30.482099936550004"
  >
    <Description>GJ1214 is a star five times smaller than our Sun and three hundred times less bright. Located only 40 light-years away from us, it is found to be surrounded by a super-Earth planet whose interior is likely mostly made of water ice. The planet appears to be rather hot and surrounded by a thick atmosphere, which makes it inhospitable for life as we know it on Earth. This image is based on data obtained through 2 different filters (blue and red), which were taken 7 years apart. Because the star is very close to the Earth, it has a large apparent motion on the sky, and so has moved in between the 7 years. This is why the star appears as a double coloured object in this image.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.5823696896"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="258.829084"
        CenterY="4.963803"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The star GJ1214"
        OffsetX="-0.1180912485554259"
        OffsetY="-0.0010875829168265118"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.35909291742"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso0950b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso0950b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso0950b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1005a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-02-03T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-61.239232308169996"
    Magnitude="0"
    Name="Stellar nursery NGC 3603*"
    Opacity="100"
    RA="11.252300871327874"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1005a/thumb.jpg"
    ZoomLevel="1.5362560182239995"
  >
    <Description>NGC 3603 is a starburst region : a cosmic factory where stars form frantically from the nebula’s extended clouds of gas and dust. Located 22,000 light-years away from the Sun, it is the closest region of this kind known in our galaxy, providing astronomers with a local test bed for studying the intense star formation processes, very common in other galaxies, but hard to observe in detail because of their large distance. The newly released image, obtained with the FORS instrument attached to one of the four 8.2-metre VLT Unit Telescopes at Cerro Paranal, Chile, is a three-colour combination of exposures acquired through visible and near-infrared (V, R, I) filters. This image portrays a wider field around the stellar cluster and reveals the rich texture of the surrounding clouds of gas and dust. The field of view is 7 arcminutes wide.   This image is available as a mounted image in the ESOshop.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.28720308223999996"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="168.788166"
        CenterY="-61.271524"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stellar nursery NGC 3603*"
        OffsetX="0.0017475600499020625"
        OffsetY="0.032292192144178916"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.017850264870000004"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1005a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1005a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1005a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1006a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-02-10T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-5.3220943948268795"
    Magnitude="0"
    Name="VISTA's infrared view of the Orion Nebula*"
    Opacity="100"
    RA="5.585995332166997"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1006a/thumb.jpg"
    ZoomLevel="15.018967422911999"
  >
    <Description>This wide-field view of the Orion Nebula (Messier 42), lying about 1350 light-years from Earth, was taken with the VISTA infrared survey telescope at ESO’s Paranal Observatory in Chile. The new telescope’s huge field of view allows the whole nebula and its surroundings to be imaged in a single picture and its infrared vision also means that it can peer deep into the normally hidden dusty regions and reveal the curious antics of the very active young stars buried there. This image was created from images taken through Z, J and Ks filters in the near-infrared part of the spectrum. The exposure times were ten minutes per filter. The image covers a region of sky about one degree by 1.5 degrees.   #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.5518194091727158"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.822156"
        CenterY="-5.390986"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VISTA's infrared view of the Orion Nebula*"
        OffsetX="0.032001300894799356"
        OffsetY="0.0689306930147772"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.0713523831423867"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1006a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/J. Emerson/VISTA. Acknowledgment: Cambridge Astronomical Survey Unit</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1006a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1006a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1017a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-04-21T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.001546747558386"
    Magnitude="0"
    Name="VISTA’s infrared view of the Cat’s Paw Nebula*"
    Opacity="100"
    RA="17.33353315570455"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1017a/thumb.jpg"
    ZoomLevel="12.077242849728"
  >
    <Description>Infrared view of the Cat’s Paw Nebula (NGC 6334) taken by VISTA. NGC 6334 is a vast region of star formation about 5500 light-years from Earth in the constellation of Scorpius. The whole gas cloud is about 50 light-years across. NGC 6334 is one of the most active nurseries of young massive stars in our galaxy, some nearly ten times the mass of our Sun and most born in the last few million years. The images were taken through Y, J and Ks filters (shown as blue, green and red respectively) and the exposure time was five minutes per filter. The field of view is about one degree across.   This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.55170111488"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="259.991754"
        CenterY="-35.963071"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VISTA’s infrared view of the Cat’s Paw Nebula*"
        OffsetX="-0.027781889741384593"
        OffsetY="-0.02813050792582955"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="31.34210295913"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1017a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/J. Emerson/VISTAAcknowledgment: Cambridge Astronomical Survey Unit</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1017a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1017a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1027a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2010-06-30T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.97404975732432"
    Magnitude="0"
    Name="The R Coronae Australis region imaged with the Wide Field Imager at La Silla*"
    Opacity="100"
    RA="19.03249073944808"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1027a/thumb.jpg"
    ZoomLevel="5.778493944941999"
  >
    <Description>The nearby star-forming region around the star R Coronae Australis imaged by the Wide Field Imager (WFI) on the MPG/ESO 2.2-metre telescope at ESO’s La Silla Observatory in Chile. This picture, which covers a field of 33.7 x 31.9 arcminutes (about the diameter of the full Moon), is a combination of twelve CCD frames, 67 megapixels each, taken through B, V and R filters, with four exposures of five minutes each. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0826837196799999"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="285.473822"
        CenterY="-36.95263"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The R Coronae Australis region imaged with the Wide Field Imager at La Silla*"
        OffsetX="-0.010814663110248302"
        OffsetY="-0.021421449142285783"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.004885251290000001"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1027a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1027a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1027a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1031b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2013-06-28T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-59.624427959815215"
    Magnitude="0"
    Name="Panoramic view of the WR 22 and Eta Carinae regions of the Carina Nebula*"
    Opacity="100"
    RA="10.715244547390022"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1031b/thumb.jpg"
    ZoomLevel="4.7896024332"
  >
    <Description>This spectacular panoramic view combines a new image of the field around the Wolf–Rayet star WR 22 in the Carina Nebula (right) with an earlier picture of the region around the unique star Eta Carinae in the heart of the nebula (left). The picture was created from images taken with the Wide Field Imager on the MPG/ESO 2.2-metre telescope at ESO’s La Silla Observatory in Chile. This image is available as a mounted image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.08357976064"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="161.265131"
        CenterY="-59.684619"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Panoramic view of the WR 22 and Eta Carinae regions of the Carina Nebula*"
        OffsetX="0.27117230271817905"
        OffsetY="0.05954306437625792"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.09456439855999998"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1031b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1031b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1031b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1105a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-02-16T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="0.09489865877103874"
    Magnitude="0"
    Name="Messier 78: a reflection nebula in Orion"
    Opacity="100"
    RA="5.778182129166974"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1105a/thumb.jpg"
    ZoomLevel="5.670950611830696"
  >
    <Description>This new image of the reflection nebula Messier 78 was captured using the Wide Field Imager camera on the MPG/ESO 2.2-metre telescope at the La Silla Observatory, Chile. This colour picture was created from many monochrome exposures taken through blue, yellow/green and red filters, supplemented by exposures through a filter that isolates light from glowing hydrogen gas. The total exposure times were 9, 9, 17.5 and 15.5 minutes per filter, respectively. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0829988603187017"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="86.655912648"
        CenterY="0.111282634177"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Messier 78: a reflection nebula in Orion"
        OffsetX="-0.01726214409831451"
        OffsetY="-0.015917041960783477"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5710565977689896"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1105a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Igor Chekalin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1105a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1105a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1109a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-03-16T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.005470461562915"
    Magnitude="0"
    Name="Close-up of the drama of star formation"
    Opacity="100"
    RA="19.02628974296768"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1109a/thumb.jpg"
    ZoomLevel="1.22192096256"
  >
    <Description>This very detailed enhanced-colour image from ESO’s Very Large Telescope shows the dramatic effects of very young stars on the dust and gas from which they were born in the star-forming region NGC 6729. The baby stars are invisible in this picture, being hidden behind dust clouds at the upper left of the picture, but material they are ejecting is crashing into the surroundings at speeds of that can be as high as one million kilometres per hour. This picture was taken by the FORS1 instrument and records the scene in the light of glowing hydrogen and sulphur.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22929211392"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="285.3927045"
        CenterY="-37.00541629"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Close-up of the drama of star formation"
        OffsetX="-0.0013109816470794262"
        OffsetY="-5.417374999748833e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.00039845992999999996"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1109a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Sergey Stepanenko</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1109a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1109a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="9.078763831458975"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1119a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-06-08T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-16.147686746999746"
    Magnitude="0"
    Name="VST image of the star-forming region Messier 17"
    Opacity="100"
    RA="18.349626156447997"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1119a/thumb.jpg"
    ZoomLevel="9.078763831458975"
  >
    <Description>The first released VST image shows the spectacular star-forming region Messier 17, also known as the Omega Nebula or the Swan Nebula, as it has never been seen before. This vast region of gas, dust and hot young stars lies in the heart of the Milky Way in the constellation of Sagittarius (The Archer). The VST field of view is so large that the entire nebula, including its fainter outer parts, is captured — and retains its superb sharpness across the entire image. The data were processed using the Astro-WISE software system developed by E.A. Valentijn and collaborators at Groningen and elsewhere. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.910469309046784"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="275.24496820499917"
        CenterY="-16.148616143103656"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VST image of the star-forming region Messier 17"
        OffsetX="8.335595480775e-05"
        OffsetY="8.335595480775e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.14000000000000454"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1119a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/INAF-VST/OmegaCAM. Acknowledgement: OmegaCen/Astro-WISE/Kapteyn Institute</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1119a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1119a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1119b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-06-08T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-47.46803553534047"
    Magnitude="0"
    Name="VST image of the giant globular cluster Omega Centauri*"
    Opacity="100"
    RA="13.44598221599121"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1119b/thumb.jpg"
    ZoomLevel="8.64895973376"
  >
    <Description>This VST image may be the best portrait of the globular star cluster Omega Centauri ever made. Omega Centauri, in the constellation of Centaurus (The Centaur), is the largest globular cluster in the sky, but the very wide field of view of VST and its powerful camera OmegaCAM can encompass even the faint outer regions of this spectacular object. This view includes about 300 000 stars. The data were processed using the VST-Tube system developed by A. Grado and collaborators at the INAF-Capodimonte Observatory.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.9554747975694087"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.696944"
        CenterY="-47.479539"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VST image of the giant globular cluster Omega Centauri*"
        OffsetX="0.004874381440874632"
        OffsetY="0.011503282319646504"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.0005117306099999999"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1119b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/INAF-VST/OmegaCAM. Acknowledgement: A. Grado, L. Limatola/INAF-Capodimonte Observatory</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1119b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1119b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1131a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-08-24T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="13.027996102768409"
    Magnitude="0"
    Name="VLT looks into the eyes of the Virgin"
    Opacity="100"
    RA="12.461694437989754"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1131a/thumb.jpg"
    ZoomLevel="1.070361990306"
  >
    <Description>This  striking image, taken with the FORS2 instrument on the Very Large  Telescope, shows a beautiful yet peculiar pair of galaxies, NGC 4438 and  NGC 4435, nicknamed The Eyes. The larger of these, at the top of the picture, NGC 4438, is thought  to have once been a spiral galaxy that was strongly deformed by  collisions in the relatively recent past. The two galaxies belong to the  Virgo Cluster and are about 50 million light-years away.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14337017856"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="186.940312"
        CenterY="13.008617"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VLT looks into the eyes of the Virgin"
        OffsetX="0.009534316928352837"
        OffsetY="-0.02225447725870851"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="119.98155596329"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso1131a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1131a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1131a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1137a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2011-10-03T11:30:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-18.849699685891462"
    Magnitude="0"
    Name="Antennae Galaxies composite of ALMA and Hubble observations"
    Opacity="100"
    RA="12.032523925567581"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1137a/thumb.jpg"
    ZoomLevel="0.49535446752662254"
  >
    <Description>The  Antennae Galaxies (also known as NGC 4038 and 4039) are a pair of  distorted colliding spiral galaxies about 70 million light-years away,  in the constellation of Corvus (The Crow). This view combines ALMA  observations, made in two different wavelength ranges during the observatory’s early testing phase, with  visible-light observations from the NASA/ESA Hubble Space Telescope. The  Hubble image is the sharpest view of this object ever taken and serves  as the ultimate benchmark in terms of resolution. ALMA observes at much  longer wavelengths which makes it much harder to obtain comparably sharp  images. However, when the full ALMA array is completed its vision will  be up to ten times sharper than Hubble. Most of the ALMA test observations used to create this image were made  using only twelve antennas working together — far fewer than will be  used for the first science observations — and much closer together as  well. Both of these factors make the new image just a taster  of what is to come. As the observatory grows, the sharpness, speed, and  quality of its observations will increase dramatically as more antennas  become available and the array grows in size. This is nevertheless the  best submillimetre-wavelength image ever taken of the Antennae Galaxies  and opens a new window on the submillimetre Universe. While  visible light — shown here mainly in blue — reveals the newborn stars  in the galaxies, ALMA’s view shows us something that cannot be seen at  those wavelengths: the clouds of dense cold gas from which new stars  form. The ALMA observations — shown here in red, pink and yellow — were  made at specific wavelengths of millimetre and submillimetre light (ALMA bands 3 and 7),  tuned to detect carbon monoxide molecules in the otherwise invisible  hydrogen clouds, where new stars are forming. Massive  concentrations of gas are found not only in the hearts of the two  galaxies but also in the chaotic region where they are colliding. Here,  the total amount of gas is billions of times the mass of the Sun — a  rich reservoir of material for future generations of stars. Observations  like these will be vital in helping us understand how galaxy collisions  can trigger the birth of new stars. This is just one example of how  ALMA reveals parts of the Universe that cannot be seen with  visible-light and infrared telescopes. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05916680952598961"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="180.468947"
        CenterY="-18.86749"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Antennae Galaxies composite of ALMA and Hubble observations"
        OffsetX="-0.006859634169279972"
        OffsetY="0.024289304043626638"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="29.3968354903"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1137a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO). Visible light image: the NASA/ESA Hubble Space Telescope</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1137a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1137a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1208a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2012-02-08T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-59.563623514169315"
    Magnitude="0"
    Name="ESO’s VLT reveals the Carina Nebula's hidden secrets"
    Opacity="100"
    RA="10.735179474405657"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1208a/thumb.jpg"
    ZoomLevel="2.69361318369718"
  >
    <Description>This broad image of the Carina Nebula, a region of massive star formation in the southern skies, was taken in infrared light using the HAWK-I camera on ESO’s Very Large Telescope. Many previously hidden features, scattered across a spectacular celestial landscape of gas, dust and young stars, have emerged. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.48472800764559354"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="161.027721281"
        CenterY="-59.5636383252"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="ESO’s VLT reveals the Carina Nebula's hidden secrets"
        OffsetX="1.4792724842699998e-05"
        OffsetY="1.4792724842699998e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.07093433710306417"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1208a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/T. Preibisch</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1208a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1208a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1221a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2012-05-16T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.00077077524411"
    Magnitude="0"
    Name="A deep look at the strange galaxy Centaurus A"
    Opacity="100"
    RA="13.425797609008246"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1221a/thumb.jpg"
    ZoomLevel="5.631148657764001"
  >
    <Description>The peculiar galaxy Centaurus A (NGC 5128) is pictured in this image taken with the Wide Field Imager attached to the MPG/ESO 2.2-metre telescope at the La Silla Observatory in Chile. With a total exposure time of more than 50 hours this is probably the deepest view of this peculiar and spectacular object ever created.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.08221710336"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.36542"
        CenterY="-43.019319"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A deep look at the strange galaxy Centaurus A"
        OffsetX="-0.01576171141603539"
        OffsetY="0.01854150979223062"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.017071010889999995"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1221a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1221a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1221a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1233a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2012-08-15T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.437567273611833"
    Magnitude="0"
    Name="The mouthpiece of the Pipe Nebula"
    Opacity="100"
    RA="17.195792930915104"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1233a/thumb.jpg"
    ZoomLevel="9.997897490700003"
  >
    <Description>This picture shows Barnard 59, part of a vast dark cloud of interstellar dust called the Pipe Nebula. This new and very detailed image of what is known as a dark nebula was captured by the Wide Field Imager on the MPG/ESO 2.2-metre telescope at ESO’s La Silla Observatory. This image is so large that it is strongly recommended to use the zoomable version to appreciate it fully.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.083116469342686"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="257.820126"
        CenterY="-27.370073"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The mouthpiece of the Pipe Nebula"
        OffsetX="-0.10366040497286406"
        OffsetY="-0.06750137779602364"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.02299257600499966"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1233a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1233a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1233a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1236a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2012-09-12T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-46.01011068394966"
    Magnitude="0"
    Name="The Pencil Nebula, a strangely shaped leftover from a vast explosion"
    Opacity="100"
    RA="8.996757715651983"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1236a/thumb.jpg"
    ZoomLevel="5.636539839815998"
  >
    <Description>The  oddly shaped Pencil Nebula (NGC 2736) is pictured in this image from  ESO’s La Silla Observatory in Chile. This nebula is a small part of a  huge remnant left over after a supernova explosion that took place about  11 000 years ago. The image was produced by the Wide Field Imager on  the MPG/ESO 2.2-metre telescope at ESO’s La Silla Observatory in Chile. This image is available as a Mounted Image in the ESOshop. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0833828249599997"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="135.050085"
        CenterY="-45.950068"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Pencil Nebula, a strangely shaped leftover from a vast explosion"
        OffsetX="0.06001189824824868"
        OffsetY="0.06862785464562476"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90.06122844783"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1236a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1236a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1236a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1238a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2012-10-05T16:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.23071961181954"
    Magnitude="0"
    Name="Thor’s Helmet Nebula imaged on the occasion of ESO’s 50th anniversary"
    Opacity="100"
    RA="7.308220396351833"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1238a/thumb.jpg"
    ZoomLevel="1.2302490049080002"
  >
    <Description>This VLT image of the Thor’s Helmet Nebula was taken on the occasion of ESO’s 50th Anniversary, 5 October 2012, with the help of Brigitte Bailleul — winner of the Tweet Your Way to the VLT! competition. The observations were broadcast live over the internet from the Paranal Observatory in Chile. This object, also known as NGC 2359, lies in the constellation of Canis Major (The Great Dog). The helmet-shaped nebula is around 15 000 light-years away from Earth and is over 30 light-years across. The helmet is a cosmic bubble, blown as the wind from the bright, massive star near the bubble&amp;#x27;s centre sweeps through the surrounding molecular cloud.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14373855232000002"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="109.625371"
        CenterY="-13.23017"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Thor’s Helmet Nebula imaged on the occasion of ESO’s 50th anniversary"
        OffsetX="0.0005450554979704071"
        OffsetY="0.0020114830387767467"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90.13006012532"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1238a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/B. Bailleul</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1238a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1238a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1302a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2013-01-10T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-72.07770683575035"
    Magnitude="0"
    Name="The globular star cluster 47 Tucanae"
    Opacity="100"
    RA="0.40171686018943603"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1302a/thumb.jpg"
    ZoomLevel="7.971799324272001"
  >
    <Description>This bright cluster of stars is 47 Tucanae (NGC 104), shown here in an image taken by ESO’s VISTA (Visible and Infrared Survey Telescope for Astronomy) from the Paranal Observatory in Chile. This cluster is located around 15 000 light-years away from us and contains millions of stars, some of which are unusual and exotic. This image was taken as part of the VISTA Magellanic Cloud survey, a project that is scanning the region of the Magellanic Clouds, two small galaxies that are very close to our Milky Way.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.55286175744"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="6.022499"
        CenterY="-72.081497"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The globular star cluster 47 Tucanae"
        OffsetX="-0.0005814670113053774"
        OffsetY="0.003876811111354554"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="6.26883496186"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1302a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M.-R. Cioni/VISTA Magellanic Cloud survey.Acknowledgment: Cambridge Astronomical Survey Unit</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1302a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1302a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1303a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2013-01-16T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-39.085082027465894"
    Magnitude="0"
    Name="The Lupus 3 dark cloud and associated hot young stars"
    Opacity="100"
    RA="16.15261719394501"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1303a/thumb.jpg"
    ZoomLevel="5.806052634096"
  >
    <Description>This evocative image shows a dark cloud where new stars are forming along with a cluster of brilliant stars that have already emerged from their dusty stellar nursery. This cloud is known as Lupus 3 and it lies about 600 light-years from Earth in the constellation of Scorpius (The Scorpion). It is likely that the Sun formed in a similar star formation region more than four billion years ago. This picture was taken with the MPG/ESO 2.2-metre telescope at the La Silla Observatory in Chile and is the best image ever taken of this little-known object.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.08354994176"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="242.400328"
        CenterY="-39.04979"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Lupus 3 dark cloud and associated hot young stars"
        OffsetX="0.08628201136011017"
        OffsetY="-0.03517797392198575"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.11076996288"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1303a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/F. Comeron</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1303a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1303a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1320a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2013-05-02T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-24.095014850457254"
    Magnitude="0"
    Name="The star formation region NGC 6559"
    Opacity="100"
    RA="18.16251137976076"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1320a/thumb.jpg"
    ZoomLevel="2.18306123424"
  >
    <Description>The Danish 1.54-metre telescope located at ESO’s La Silla Observatory in Chile has captured a striking image of NGC 6559, an object that showcases the anarchy that reigns when stars form inside an interstellar cloud. This region of sky includes glowing red clouds of mostly hydrogen gas, blue regions where starlight is being reflected from tiny particles of dust and also dark regions where the dust is thick and opaque.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22594043904"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="272.500101"
        CenterY="-24.000082"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The star formation region NGC 6559"
        OffsetX="-0.056252904762636335"
        OffsetY="0.09538466653360171"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-179.55572322046996"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso1320a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/U.G. Jørgensen</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1320a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1320a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1322a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2013-05-23T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-63.36097342605767"
    Magnitude="0"
    Name="The Very Large Telescope snaps a stellar nursery and celebrates fifteen years of operations"
    Opacity="100"
    RA="11.634831038345899"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1322a/thumb.jpg"
    ZoomLevel="1.2198284980440002"
  >
    <Description>This intriguing new view of a spectacular stellar nursery IC 2944 is being released to celebrate a milestone: 15 years of ESO’s Very Large Telescope. This image also shows a group of thick clouds of dust known as the Thackeray globules silhouetted against the pale pink glowing gas of the nebula. These globules are under fierce bombardment from the ultraviolet radiation from nearby hot young stars. They are both being eroded away and also fragmenting, rather like lumps of butter dropped onto a hot frying pan. It is likely that Thackeray’s globules will be destroyed before they can collapse and form new stars.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14194287327879457"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="174.584836"
        CenterY="-63.372898"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Very Large Telescope snaps a stellar nursery and celebrates fifteen years of operations"
        OffsetX="0.027943216488392302"
        OffsetY="0.011960183200126326"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.10410396286180444"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1322a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1322a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1322a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1412a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2014-04-09T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-2.8125212642691024"
    Magnitude="0"
    Name="The planetary nebula Abell 33 captured using ESO's Very Large Telescope"
    Opacity="100"
    RA="9.652514932770117"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1412a/thumb.jpg"
    ZoomLevel="1.23323976588"
  >
    <Description>Astronomers using ESO’s Very Large Telescope in Chile have captured this eye-catching image of planetary nebula Abell 33. Created when an aging star blew off its outer layers, this beautiful blue bubble is, by chance, aligned with a foreground star, and bears an uncanny resemblance to a diamond engagement ring. This cosmic gem is unusually symmetric, appearing to be almost perfectly circular on the sky.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.14313017344"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="144.767251"
        CenterY="-2.839598"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The planetary nebula Abell 33 captured using ESO's Very Large Telescope"
        OffsetX="-0.02031459447956075"
        OffsetY="0.02717704219118386"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.28247630014"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1412a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1412a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1412a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1420a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2014-07-02T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-41.25074934422094"
    Magnitude="0"
    Name="The Gum 15 star formation region"
    Opacity="100"
    RA="8.74926750218958"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1420a/thumb.jpg"
    ZoomLevel="5.001248079986922"
  >
    <Description>This richly detailed new view from the MPG/ESO 2.2-metre telescope at the La Silla Observatory in Chile shows the star formation region Gum 15. This little-known object is located in the constellation of Vela (The Sails), some 3000 light-years from Earth. The glowing cloud is a stunning example of an HII region. It also has a similarity to a more famous HII region, the Trifid Nebula (Messier 20).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0828113368498176"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="131.238968029"
        CenterY="-41.2506834636"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Gum 15 star formation region"
        OffsetX="3.304477956695e-05"
        OffsetY="6.60895591339e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="179.64000000000004"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1420a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1420a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1420a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1422a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2014-07-23T16:48:15+00:00&quot;}"
    DataSetType="Sky"
    Dec="-58.217797815049536"
    Magnitude="0"
    Name="The star cluster NGC 3293"
    Opacity="100"
    RA="10.596373314548595"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1422a/thumb.jpg"
    ZoomLevel="5.68951377044162"
  >
    <Description>In this image from the Wide Field Imager on the MPG/ESO 2.2-metre telescope at ESO’s La Silla Observatory in Chile young stars huddle together against a backdrop of clouds of glowing gas and lanes of dust. The star cluster, known as NGC 3293, would have been just a cloud of gas and dust itself about ten million years ago, but as stars began to form it became the bright group we see here. Clusters like this are celestial laboratories that allow astronomers to learn more about how stars evolve.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0833239619059711"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="158.945662532"
        CenterY="-58.2178308524"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The star cluster NGC 3293"
        OffsetX="3.306042364215e-05"
        OffsetY="3.306042364215e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.040000000000000036"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1422a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/G. Beccari</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1422a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1422a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1424a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2014-08-06T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="30.67390593848268"
    Magnitude="0"
    Name="VST snaps a very detailed view of the Triangulum Galaxy"
    Opacity="100"
    RA="1.564474470068201"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1424a/thumb.jpg"
    ZoomLevel="9.69636984782903"
  >
    <Description>The VLT Survey Telescope (VST) at ESO’s Paranal Observatory in Chile has captured this beautifully detailed image of the galaxy Messier 33, often called the Triangulum Galaxy. This nearby spiral, the second closest large galaxy to our own galaxy, the Milky Way, is packed with bright star clusters, and clouds of gas and dust. This picture is amongst the most detailed wide-field views of this object ever taken and shows the many glowing red gas clouds in the spiral arms with particular clarity.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.948949724607283"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="23.4671516274"
        CenterY="30.6739356771"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VST snaps a very detailed view of the Triangulum Galaxy"
        OffsetX="2.97386127412e-05"
        OffsetY="2.97386127412e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90.0000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso1424a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1424a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1424a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1436a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2014-11-06T13:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="18.233610579266994"
    Magnitude="0"
    Name="ALMA image of the protoplanetary disc around HL Tauri"
    Opacity="100"
    RA="4.5273245109256255"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1436a/thumb.jpg"
    ZoomLevel="0.0055786515129010745"
  >
    <Description>This is the sharpest image ever taken by ALMA — sharper than is routinely achieved in visible light with the NASA/ESA Hubble Space Telescope. It shows the protoplanetary disc surrounding the young star HL Tauri. These new ALMA observations reveal substructures within the disc that have never been seen before and even show the possible positions of planets forming in the dark patches within the system.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.000622280953073061"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="67.9098689076"
        CenterY="18.233609398"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="ALMA image of the protoplanetary disc around HL Tauri"
        OffsetX="1.181266995490017e-06"
        OffsetY="1.181266995490017e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso1436a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1436a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1436a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1503a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2015-01-28T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-46.93510310567392"
    Magnitude="0"
    Name="VLT image of the cometary globule CG4"
    Opacity="100"
    RA="7.572200265603369"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1503a/thumb.jpg"
    ZoomLevel="1.2253499496128275"
  >
    <Description>Like the gaping mouth of a gigantic celestial creature, the cometary globule CG4 glows menacingly in this image from ESO’s Very Large Telescope. Although it looks huge and bright in this image it is actually a faint nebula and not easy to observe. The exact nature of CG4 remains a mystery.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1432078281179136"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="113.582978454"
        CenterY="-46.9351380929"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VLT image of the cometary globule CG4"
        OffsetX="3.49628486616e-05"
        OffsetY="1.74814243308e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="89.91999999999997"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1503a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1503a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1503a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1520a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2015-05-20T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="13.265855261443413"
    Magnitude="0"
    Name="ESO’s Very Large Telescope images the Medusa Nebula"
    Opacity="100"
    RA="7.486477091218025"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1520a/thumb.jpg"
    ZoomLevel="1.2244369098097752"
  >
    <Description>ESO’s Very Large Telescope in Chile has captured the most detailed image ever taken of the Medusa Nebula (also known Abell 21 and Sharpless 2-274). As the star at the heart of this nebula made its final transition into retirement, it shed its outer layers into space, forming this colourful cloud. The image foreshadows the final fate of the Sun, which will eventually also become an object of this kind.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1433514429366272"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="112.297192357"
        CenterY="13.2658378236"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="ESO’s Very Large Telescope images the Medusa Nebula"
        OffsetX="3.49979108732e-05"
        OffsetY="1.74989554366e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.1"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1520a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1520a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1520a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1532a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2015-08-05T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-34.37078940061232"
    Magnitude="0"
    Name="The planetary nebula ESO 378-1"
    Opacity="100"
    RA="11.445541122095431"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1532a/thumb.jpg"
    ZoomLevel="1.053883343396841"
  >
    <Description>This extraordinary bubble, glowing like the ghost of a star in the haunting darkness of space, may appear supernatural and mysterious, but it is a familiar astronomical object: a planetary nebula, the remnants of a dying star. This is the best view of the little-known object ESO 378-1 yet obtained and was captured by ESO’s Very Large Telescope in northern Chile.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1434598263394304"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="171.683138048"
        CenterY="-34.3708069128"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The planetary nebula ESO 378-1"
        OffsetX="1.751218583245e-05"
        OffsetY="1.751218583245e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso1532a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1532a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1532a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1607a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2016-03-02T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-51.185902825186965"
    Magnitude="0"
    Name="The sky around the star formation region RCW 106"
    Opacity="100"
    RA="16.356800472983178"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1607a/thumb.jpg"
    ZoomLevel="11.223474172820843"
  >
    <Description>In this huge image of part of the southern constellation of Norma (The Carpenter’s Square) wisps of crimson gas are illuminated by rare, massive stars that have only recently ignited and are still buried deep in thick dust clouds. These scorching-hot, very young stars are only fleeting characters on the cosmic stage and their origins remain mysterious. The vast nebula where these giants were born, known as RCW 106, is captured here in fine detail by ESO’s VLT Survey Telescope (VST), at the Paranal Observatory in Chile. The brightest part appears just above the centre of the image. Many other interesting objects are also captured in this wide-field image. For example the filaments to the right of the image are the remnants of an ancient supernova (SNR G332.4-00.4, also known as RCW 103), and the glowing red filaments at the lower left surround an unusual and very hot star (RCW 104, surrounding the Wolf–Rayet star  WR 75). Patches of dark obscuring dust are also visible across the entire cosmic landscape.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.9471815602143732"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="245.352198973"
        CenterY="-51.1861149769"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The sky around the star formation region RCW 106"
        OffsetX="0.00012078649511246885"
        OffsetY="0.00021185707304777226"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.14"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso1607a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1607a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1607a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1607b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2016-03-02T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-51.18654844912485"
    Magnitude="0"
    Name="The sky around the star formation region RCW 106 (wide-field  view)"
    Opacity="100"
    RA="16.370148749789394"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1607b/thumb.jpg"
    ZoomLevel="11.241109533512388"
  >
    <Description>In this huge image of part of the southern constellation of Norma (The Carpenter’s Square) wisps of crimson gas are illuminated by rare, massive stars that have only recently ignited and are still buried deep in thick dust clouds. These scorching-hot, very young stars are only fleeting characters on the cosmic stage and their origins remain mysterious. The vast nebula where these giants were born, known as RCW 106, is captured here in fine detail by ESO’s VLT Survey Telescope (VST), at the Paranal Observatory in Chile. The brightest part appears just above the centre of the image. Many other interesting objects are also captured in this wide-field image. For example the filaments to the right of the image are the remnants of an ancient supernova (SNR G332.4-00.4, also known as RCW 103), and the glowing red filaments at the lower left surround an unusual and very hot star (RCW 104, surrounding the Wolf–Rayet starWR 75). Patches of dark obscuring dust are also visible across the entire cosmic landscape.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="3.9004823039574017"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="245.552326202"
        CenterY="-51.1866079658"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The sky around the star formation region RCW 106 (wide-field  view)"
        OffsetX="5.95166367181e-05"
        OffsetY="5.95166367181e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="8"
        Url="http://data1.wwtassets.org/feeds/eso/eso1607b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1607b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1607b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1612a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2016-04-13T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-35.575498867513815"
    Magnitude="0"
    Name="VST image of the Fornax galaxy cluster"
    Opacity="100"
    RA="3.5920028497144316"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1612a/thumb.jpg"
    ZoomLevel="14.420272772912417"
  >
    <Description>The Fornax Galaxy Cluster is one of the closest of such groupings beyond our Local Group of galaxies. This new VLT Survey Telescope image shows the central part of the cluster in great detail. At the lower-right is the elegant barred-spiral galaxy NGC 1365 and to the left the big elliptical NGC 1399.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="3.8227365729337346"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.8801147118"
        CenterY="-35.5755569939"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VST image of the Fornax galaxy cluster"
        OffsetX="5.83303310079e-05"
        OffsetY="5.83303310079e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.20000000000000248"
        Sparse="True"
        StockSet="False"
        TileLevels="8"
        Url="http://data1.wwtassets.org/feeds/eso/eso1612a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO. Acknowledgement: Aniello Grado and Luca Limatola</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1612a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1612a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1625a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2016-07-12T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-5.338774008678209"
    Magnitude="0"
    Name="A deep infrared view of the Orion Nebula from HAWK-I"
    Opacity="100"
    RA="5.587937102637692"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1625a/thumb.jpg"
    ZoomLevel="3.751702690533902"
  >
    <Description>This spectacular image of the Orion Nebula star-formation region was obtained from multiple exposures using the HAWK-I infrared camera on ESO’s Very Large Telescope in Chile. This is the deepest view ever of this region and reveals more very faint planetary-mass objects than expected.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.4855192072323072"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8190714054"
        CenterY="-5.3387591763"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A deep infrared view of the Orion Nebula from HAWK-I"
        OffsetX="1.48168703379e-05"
        OffsetY="1.48168703379e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90.06"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso1625a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/H. Drass et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1625a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1625a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="12.197172761422749"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1628a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2016-08-10T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-17.32910280525223"
    Magnitude="0"
    Name="The star cluster Messier 18 and its surroundings"
    Opacity="100"
    RA="18.29752301009882"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1628a/thumb.jpg"
    ZoomLevel="12.197172761422749"
  >
    <Description>The small smattering of bright blue stars upper left of centre in this huge 615 megapixel ESO image is the perfect cosmic laboratory in which to study the life and death of stars. Known as Messier 18 this open star cluster contains stars that formed together from the same massive cloud of gas and dust. This image was captured by the OmegaCAM camera attached to the VLT Survey Telescope (VST) located at ESO’s Paranal Observatory in Chile.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.9486779091255295"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.46311416379666"
        CenterY="-17.330148621627323"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The star cluster Messier 18 and its surroundings"
        OffsetX="5.94689303322e-05"
        OffsetY="5.94689303322e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.08"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso1628a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1628a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1628a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="21.80904172231677"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1701-compa&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-01-04T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-6.01049339548984"
    Magnitude="0"
    Name="The Orion A molecular cloud (for comparison)"
    Opacity="100"
    RA="5.605819052982753"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1701-compa/thumb.jpg"
    ZoomLevel="21.80904172231677"
  >
    <Description>This image from the VISTA infrared survey telescope at ESO’s Paranal Observatory in northern Chile is part of the largest infrared high-resolution mosaic of Orion ever created. It covers the Orion A molecular cloud, the nearest known massive star factory, lying about 1350 light-years from Earth, and reveals many young stars and other objects normally buried deep inside the dusty clouds.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.006783461261311"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.08765473475479"
        CenterY="-6.0115133079827165"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Orion A molecular cloud (for comparison)"
        OffsetX="0.00012227732730899998"
        OffsetY="0.00012227732730899998"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-116.27999999999996"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso1701-compa/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/VISION survey</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1701-compa/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1701-compa/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="21.80904172231677"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1701-compb&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-01-04T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-6.01049339548984"
    Magnitude="0"
    Name="Orion Molecular Cloud in visible light (for comparison)"
    Opacity="100"
    RA="5.605819052982753"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1701-compb/thumb.jpg"
    ZoomLevel="21.80904172231677"
  >
    <Description>Visible light view of the region of the Orion Molecular Cloud from the Digitized Sky Survey 2 (DSS)</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.006783461261311"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.08800930343618"
        CenterY="-6.011524836278989"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Orion Molecular Cloud in visible light (for comparison)"
        OffsetX="0.00012227732730899998"
        OffsetY="0.00012227732730899998"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-116.27999999999996"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso1701-compb/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1701-compb/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1701-compb/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="21.80927313571974"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1701a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-01-04T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-6.010453760348883"
    Magnitude="0"
    Name="The Orion a molecular cloud from VISTA"
    Opacity="100"
    RA="5.60581995334433"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1701a/thumb.jpg"
    ZoomLevel="21.80927313571974"
  >
    <Description>This image from the VISTA infrared survey telescope at ESO’s Paranal Observatory in northern Chile is part of the largest infrared high-resolution mosaic of Orion ever created. It covers the Orion A molecular cloud, the nearest known massive star factory, lying about 1350 light-years from Earth, and reveals many young stars and other objects normally buried deep inside the dusty clouds.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="6.074243272835071"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.08767188787635"
        CenterY="-6.011917938966319"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Orion a molecular cloud from VISTA"
        OffsetX="9.268559681449999e-05"
        OffsetY="9.268559681449999e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-116.27999999999996"
        Sparse="True"
        StockSet="False"
        TileLevels="8"
        Url="http://data1.wwtassets.org/feeds/eso/eso1701a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/VISION survey</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1701a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1701a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1705a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-02-01T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-34.962351905838155"
    Magnitude="0"
    Name="The Cat’s Paw and Lobster Nebulae"
    Opacity="100"
    RA="17.382068186178508"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1705a/thumb.jpg"
    ZoomLevel="23.732144155605326"
  >
    <Description>This spectacular image from the VLT Survey Telescope shows the Cat’s Paw Nebula (NGC 6334, upper right) and the Lobster Nebula (NGC 6357, lower left). These dramatic objects are regions of active star formation where the hot young stars are causing the surrounding hydrogen gas to glow red. The very rich field of view also includes dark clouds of dust. With around two billion pixels this is one of the largest images ever released by ESO. A zoomable version of this giant image is available here. Note that the circular features in the image around bright stars are not real, they are due to reflections within the optics of the telescope and camera.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="3.8983830055878657"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="260.731095579"
        CenterY="-34.9622925876"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Cat’s Paw and Lobster Nebulae"
        OffsetX="5.94846039671e-05"
        OffsetY="5.94846039671e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.83999999999997"
        Sparse="True"
        StockSet="False"
        TileLevels="8"
        Url="http://data1.wwtassets.org/feeds/eso/eso1705a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1705a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1705a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1714a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-05-03T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-72.9639144221142"
    Magnitude="0"
    Name="VISTA’s view of the Small Magellanic Cloud"
    Opacity="100"
    RA="0.9175126088641634"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1714a/thumb.jpg"
    ZoomLevel="53.292206020717984"
  >
    <Description>The Small Magellanic Cloud (SMC) galaxy is a striking feature of the southern sky even to the unaided eye. But visible-light telescopes cannot get a really clear view of what is in the galaxy because of obscuring clouds of interstellar dust. VISTA’s infrared capabilities have now allowed astronomers to see the myriad of stars in this neighbouring galaxy much more clearly than ever before. The result is this record-breaking image — the biggest infrared image ever taken of the Small Magellanic Cloud — with the whole frame filled with millions of stars. As well as the SMC itself this very wide-field image reveals many background galaxies and several star clusters, including the very bright 47 Tucanae globular cluster at the right of the picture.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="8.955111633256449"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="13.7631652021"
        CenterY="-72.9640481752"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="VISTA’s view of the Small Magellanic Cloud"
        OffsetX="0.000136644159443"
        OffsetY="0.000136644159443"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-1.2000000000000006"
        Sparse="True"
        StockSet="False"
        TileLevels="8"
        Url="http://data1.wwtassets.org/feeds/eso/eso1714a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/VISTA VMC</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1714a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1714a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="21.450537507795914"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1719a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-06-14T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-14.102303096250091"
    Magnitude="0"
    Name="The VST captures three spectacular nebulae in one image"
    Opacity="100"
    RA="18.324954505482552"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1719a/thumb.jpg"
    ZoomLevel="21.450537507795914"
  >
    <Description>Two of the sky’s more famous residents share the stage with a lesser-known neighbour in this enormous three gigapixel image from ESO’s VLT Survey Telescope (VST). On the right lies the faint, glowing cloud of gas called Sharpless 2-54, the iconic Eagle Nebula (Messier 16) is in the centre, and the Omega Nebula (Messier 17) to the left. This cosmic trio makes up just a portion of a vast complex of gas and dust within which new stars are springing to life and illuminating their surroundings.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="7.779390698975764"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.8754561430963"
        CenterY="-14.102689895718903"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The VST captures three spectacular nebulae in one image"
        OffsetX="5.938647558209999e-05"
        OffsetY="5.938647558209999e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="90.02000000000018"
        Sparse="True"
        StockSet="False"
        TileLevels="9"
        Url="http://data1.wwtassets.org/feeds/eso/eso1719a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1719a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1719a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1723a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-07-27T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-5.4786707566698025"
    Magnitude="0"
    Name="The Orion Nebula and cluster from the VLT Survey Telescope"
    Opacity="100"
    RA="5.58562486260458"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1723a/thumb.jpg"
    ZoomLevel="7.91538558418722"
  >
    <Description>OmegaCAM — the wide-field optical camera on ESO’s VLT Survey Telescope (VST) — has captured the spectacular Orion Nebula and its associated cluster of young stars in great detail,  producing this beautiful new image. This famous object, the birthplace of many massive stars, is one of the closest stellar nurseries, at a distance of about 1350 light-years.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.9400750895169536"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.7844027714"
        CenterY="-5.47870026672"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Orion Nebula and cluster from the VLT Survey Telescope"
        OffsetX="2.960319655635e-05"
        OffsetY="2.960319655635e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.17999999999999985"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso1723a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/G. Beccari</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1723a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1723a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1734a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-10-25T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.982188039578276"
    Magnitude="0"
    Name="Revealing the galactic secrets of NGC 1316"
    Opacity="100"
    RA="3.396884376160656"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1734a/thumb.jpg"
    ZoomLevel="24.569403464063377"
  >
    <Description>Countless galaxies vie for attention in this dazzling image of the Fornax Cluster, some appearing only as pinpricks of light while others dominate the foreground. One of these is the lenticular galaxy NGC 1316. The turbulent past of this much-studied galaxy has left it with a delicate structure of loops, arcs and rings that astronomers have now imaged in greater detail than ever before with the VLT Survey Telescope. This image was processed with the VST-Tube data reduction program. Note that the bright stars in this image are surrounded by round features, some orange and some pale blue or white, that are caused by reflections within the telescope and camera optics. These artifacts are not real celestial objects.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="3.8197988245372927"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="50.9533386576"
        CenterY="-36.9822462844"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Revealing the galactic secrets of NGC 1316"
        OffsetX="5.82855045248e-05"
        OffsetY="5.82855045248e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.03999999999999998"
        Sparse="True"
        StockSet="False"
        TileLevels="8"
        Url="http://data1.wwtassets.org/feeds/eso/eso1734a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/A. Grado and L. Limatola</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1734a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1734a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="8.939002193581645"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1740a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2017-12-13T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-24.024947340974713"
    Magnitude="0"
    Name="Stellar Nursery Blooms into View"
    Opacity="100"
    RA="18.16122197073986"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1740a/thumb.jpg"
    ZoomLevel="8.939002193581645"
  >
    <Description>The OmegaCAM imager on ESO’s VLT Survey Telescope has captured this glittering view of the stellar nursery called Sharpless 29. Many astronomical phenomena can be seen in this giant image, including cosmic dust and gas clouds that reflect, absorb, and re-emit the light of hot young stars within the nebula.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.949425207607296"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="272.4185192421764"
        CenterY="-24.025418523886398"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stellar Nursery Blooms into View"
        OffsetX="5.9491736072e-05"
        OffsetY="5.9491736072e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.96000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso1740a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1740a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1740a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1907a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2019-04-10T15:07:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.391123240869875"
    Magnitude="0"
    Name="First Image of a Black Hole"
    Opacity="100"
    RA="12.51372871668847"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1907a/thumb.jpg"
    ZoomLevel="4.6162669940069754e-07"
  >
    <Description>The Event Horizon Telescope (EHT) — a planet-scale array of eight ground-based radio telescopes forged through international collaboration — was designed to capture images of a black hole. In coordinated press conferences across the globe, EHT researchers revealed that they succeeded, unveiling the first direct visual evidence of the supermassive black hole in the centre of Messier 87 and its shadow. The shadow of a black hole seen here is the closest we can come to an image of the black hole itself, a completely dark object from which light cannot escape. The black hole’s boundary — the event horizon from which the EHT takes its name — is around 2.5 times smaller than the shadow it casts and measures just under 40 billion km across. While this may sound large, this ring is only about 40 microarcseconds across — equivalent to measuring the length of a credit card on the surface of the Moon. Although the telescopes making up the EHT are not physically connected, they are able to synchronize their recorded data with atomic clocks — hydrogen masers — which precisely time their observations. These observations were collected at a wavelength of 1.3 mm during a 2017 global campaign. Each telescope of the EHT produced enormous amounts of data – roughly 350 terabytes per day – which was stored on high-performance helium-filled hard drives. These data were flown to highly specialised supercomputers — known as correlators — at the Max Planck Institute for Radio Astronomy and MIT Haystack Observatory to be combined. They were then painstakingly converted into an image using novel computational tools developed by the collaboration.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="8.58216667004928e-08"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="187.70593075"
        CenterY="12.39112325"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="First Image of a Black Hole"
        OffsetX="-3.1946133906803434e-10"
        OffsetY="-9.130122933844522e-09"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso1907a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>EHT Collaboration</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1907a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1907a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1914a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2019-09-13T09:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-70.0727064369465"
    Magnitude="0"
    Name="The Large Magellanic Cloud revealed by VISTA"
    Opacity="100"
    RA="5.419556622906693"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1914a/thumb.jpg"
    ZoomLevel="87.699547963247"
  >
    <Description>ESO’s VISTA telescope reveals a remarkable image of the Large Magellanic Cloud, one of our nearest galactic neighbours. VISTA has been surveying this galaxy and its sibling the Small Magellanic Cloud, as well as their surroundings, in unprecedented detail. This survey allows astronomers to observe a large number of stars, opening up new opportunities to study stellar evolution, galactic dynamics, and variable stars.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="8.80847574892544"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="81.2941037588"
        CenterY="-70.0729864524"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Large Magellanic Cloud revealed by VISTA"
        OffsetX="0.00026881334683"
        OffsetY="0.00026881334683"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="2.439999999999996"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/feeds/eso/eso1914a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/VMC Survey</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1914a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1914a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="2.628822476013557"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso1920a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2019-12-16T17:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-28.99818596273819"
    Magnitude="0"
    Name="HAWK-I view of the Milky Way’s central region"
    Opacity="100"
    RA="17.7599871745714"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso1920a/thumb.jpg"
    ZoomLevel="2.628822476013557"
  >
    <Description>Taken with the HAWK-I instrument on ESO’s Very Large Telescope in the Chilean Atacama Desert, this stunning image shows the Milky Way’s central region with an angular resolution of 0.2 arcseconds. This means the level of detail picked up by HAWK-I is roughly equivalent to seeing a football (soccer ball) in Zurich from Munich, where ESO’s headquarters are located. The image combines observations in three different wavelength bands. The team used the broadband filters J (centred at 1250 nanometres, in blue), H (centred at 1635 nanometres, in green), and Ks (centred at 2150 nanometres, in red), to cover the near infrared region of the electromagnetic spectrum. By observing in this range of wavelengths, HAWK-I can peer through the dust, allowing it to see certain stars in the central region of our galaxy that would otherwise be hidden.   </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.9672130868740096"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.3998805821656"
        CenterY="-28.998616408441507"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="HAWK-I view of the Milky Way’s central region"
        OffsetX="1.47585004711e-05"
        OffsetY="1.47585004711e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-58.75999999999992"
        Sparse="True"
        StockSet="False"
        TileLevels="8"
        Url="http://data1.wwtassets.org/feeds/eso/eso1920a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Nogueras-Lara et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso1920a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso1920a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2001b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-01-15T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="33.79826289006291"
    Magnitude="0"
    Name="ALMA view of the star-forming region AFGL 5142"
    Opacity="100"
    RA="5.513338984393"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2001b/thumb.jpg"
    ZoomLevel="0.18717811200184775"
  >
    <Description>This ALMA image shows a detailed view of the star-forming region AFGL 5142. A bright, massive star in its infancy is visible at the centre of the image. The flows of gas from this star have opened up a cavity in the region, and it is in the walls of this cavity (shown in colour), that phosphorus-bearing molecules like phosphorus monoxide are formed. The different colours represent material moving at different speeds.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0206951700235264"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="82.700096926"
        CenterY="33.798252785"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="ALMA view of the star-forming region AFGL 5142"
        OffsetX="1.010506348805e-05"
        OffsetY="1.010506348805e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2001b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO), Rivilla et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2001b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2001b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2001e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-01-15T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="33.6971779204325"
    Magnitude="0"
    Name="Wide-field view of the region of the sky where AFGL 5142 is located"
    Opacity="100"
    RA="5.507238558007063"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2001e/thumb.jpg"
    ZoomLevel="25.240116023790605"
  >
    <Description>This wide-field view shows the region of the sky, in the constellation of Auriga, where the star-forming region AFGL 5142 is located. This view was created from images forming part of the Digitized Sky Survey 2.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.591455831654401"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="82.6089117874"
        CenterY="33.697032253"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the region of the sky where AFGL 5142 is located"
        OffsetX="0.00028024022410000007"
        OffsetY="0.00014012011205000004"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.140000000000005"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso2001e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgement: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2001e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2001e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2002a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-02-05T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-55.57383512811489"
    Magnitude="0"
    Name="ALMA image of HD101584"
    Opacity="100"
    RA="11.683002637738388"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2002a/thumb.jpg"
    ZoomLevel="0.030055849243040517"
  >
    <Description>This new ALMA image shows the outcome of a stellar fight: a complex and stunning gas environment surrounding the binary HD101584. The colours represent speed, going from blue — gas moving the fastest towards us — to red — gas moving the fastest away from us. Jets, almost along the line of sight, propel the material in blue and red. The stars in the binary are located at the single bright dot at the centre of the ring-like structure shown in green, which is moving with the same velocity as the system as a whole along the line of sight. Astronomers believe this ring has its origin in the material ejected as the lower mass star in the binary spiralled towards its red-giant partner.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0057039159392256"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="175.245042031"
        CenterY="-55.5738365197"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="ALMA image of HD101584"
        OffsetX="1.39255760235e-06"
        OffsetY="1.39255760235e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.040000000000070764"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2002a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO), Olofsson et al. Acknowledgement: Robert Cumming</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2002a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2002a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2002c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-02-05T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-55.5792007273488"
    Magnitude="0"
    Name="Wide-field view of the region of the sky where HD101584 is located"
    Opacity="100"
    RA="11.683168660992495"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2002c/thumb.jpg"
    ZoomLevel="21.23300249054776"
  >
    <Description>This wide-field view shows the region of the sky, in the constellation of Centaurus, where HD101584, a gas cloud surrounding a binary star recently studied with ALMA and APEX, is located. This view was created from images forming part of the Digitized Sky Survey 2.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.594023527366656"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="175.247783246"
        CenterY="-55.5793378593"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the region of the sky where HD101584 is located"
        OffsetX="0.0001401984719045"
        OffsetY="0.0001401984719045"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-1.2400000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso2002c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgement: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2002c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2002c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2003a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-02-14T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.406591537662142"
    Magnitude="0"
    Name="SPHERE's view of Betelgeuse in December 2019"
    Opacity="100"
    RA="5.919561710111802"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2003a/thumb.jpg"
    ZoomLevel="0.0010502567814528862"
  >
    <Description>The red supergiant star Betelgeuse, in the constellation of Orion, has been undergoing unprecedented dimming. This stunning image of the star’s surface, taken with the SPHERE instrument on ESO’s Very Large Telescope late last year, is among the first observations to come out of an observing campaign aimed at understanding why the star is becoming fainter. When compared with the image taken in January 2019, it shows how much the star has faded and how its apparent shape has changed.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.000129212675918848"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="88.7934257153"
        CenterY="7.40659147457"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SPHERE's view of Betelgeuse in December 2019"
        OffsetX="6.30921269135e-08"
        OffsetY="6.30921269135e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2003a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M. Montargès et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2003a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2003a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2003b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-02-14T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.406593022486339"
    Magnitude="0"
    Name="SPHERE’s view of Betelgeuse in January 2019"
    Opacity="100"
    RA="5.91956181117869"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2003b/thumb.jpg"
    ZoomLevel="0.0010353451549833502"
  >
    <Description>The red supergiant star Betelgeuse, in the constellation of Orion, has been undergoing unprecedented dimming. This stunning image of the star’s surface was taken with the SPHERE instrument on ESO’s Very Large Telescope in January 2019, before the star started to dim. When compared with the image taken in December 2019, it shows how much the star has faded and how its apparent shape has changed.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.000127378104419328"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="88.7934272304"
        CenterY="7.40659296029"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SPHERE’s view of Betelgeuse in January 2019"
        OffsetX="6.21963400485e-08"
        OffsetY="6.21963400485e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2003b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M. Montargès et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2003b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2003b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2003d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-02-14T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.406620853119479"
    Magnitude="0"
    Name="Betelgeuse’s dust plumes seen by VISIR image"
    Opacity="100"
    RA="5.919560955694057"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2003d/thumb.jpg"
    ZoomLevel="0.048771124564528784"
  >
    <Description>This image, obtained with the VISIR instrument on ESO’s Very Large Telescope, shows the infrared light being emitted by the dust surrounding Betelgeuse in December 2019. The clouds of dust, which resemble flames in this dramatic image, are formed when the star sheds its material back into space. The black disc obscures the star&amp;#x27;s centre and much of its surroundings, which are very bright and must be masked to allow the fainter dust plumes to be seen. The orange dot in the middle is the SPHERE image of Betelgeuse’s surface, which has a size close to that of Jupiter’s orbit.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.006089848740864"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="88.7934158347"
        CenterY="7.40661936634"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Betelgeuse’s dust plumes seen by VISIR image"
        OffsetX="1.48677947775e-06"
        OffsetY="1.48677947775e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2003d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/P. Kervella/M. Montargès et al., Acknowledgement: Eric Pantin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2003d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2003d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2007c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-05-06T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-56.021957523834814"
    Magnitude="0"
    Name="Wide-field view of the region of the sky where HR 6819 is located"
    Opacity="100"
    RA="18.28541928398465"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2007c/thumb.jpg"
    ZoomLevel="24.732724902211274"
  >
    <Description>This wide-field view shows the region of the sky, in the constellation of Telescopium, where HR 6819 can be found, a triple system consisting of two stars and the closest black hole to Earth ever found. This view was created from images forming part of the Digitized Sky Survey 2. While the black hole is invisible, the two stars in HR 6819 can be viewed from the southern hemisphere on a dark, clear night without binoculars or a telescope.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.589596299493376"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="274.281543868"
        CenterY="-56.0220953205"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the region of the sky where HR 6819 is located"
        OffsetX="0.000140063363632"
        OffsetY="0.000140063363632"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.9200000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso2007c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgement: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2007c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2007c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2008a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-05-20T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="30.55108275671275"
    Magnitude="0"
    Name="SPHERE image of the disc around AB Aurigae"
    Opacity="100"
    RA="4.929407132645148"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2008a/thumb.jpg"
    ZoomLevel="0.022125555680094285"
  >
    <Description>This image shows the disc around the young AB Aurigae star, where ESO’s Very Large Telescope (VLT) has spotted signs of planet birth. Close to the centre of the image, in the inner region of the disc, we see the ‘twist’ (in very bright yellow) that scientists believe marks the spot where a planet is forming. This twist lies at about the same distance from the AB Aurigae star as Neptune from the Sun. The image was obtained with the VLT’s SPHERE instrument in polarised light.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00334522930197504"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="73.9411088864"
        CenterY="30.5510811233"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SPHERE image of the disc around AB Aurigae"
        OffsetX="1.633412745105e-06"
        OffsetY="1.633412745105e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2008a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Boccaletti et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2008a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2008a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2008b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-05-20T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="30.551086681544067"
    Magnitude="0"
    Name="SPHERE image of the inner disc around AB Aurigae"
    Opacity="100"
    RA="4.929408930895761"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2008b/thumb.jpg"
    ZoomLevel="0.006460274249025743"
  >
    <Description>This image shows the inner region of the disc around the young AB Aurigae star, where ESO’s Very Large Telescope has spotted signs of planet birth. The ‘twist’ (in very bright yellow) marks the spot where a planet may be forming. This twist lies at about the same distance from the AB Aurigae star as Neptune from the Sun.  The image was obtained with the VLT’s SPHERE instrument in polarised light.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00098865985637888"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="73.941134524"
        CenterY="30.5510861988"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="SPHERE image of the inner disc around AB Aurigae"
        OffsetX="4.827440704975e-07"
        OffsetY="4.827440704975e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2008b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Boccaletti et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2008b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2008b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2008f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-05-20T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="30.564564322213663"
    Magnitude="0"
    Name="Wide-field view of the region of the sky where AB Aurigae is located"
    Opacity="100"
    RA="4.929235209617453"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2008f/thumb.jpg"
    ZoomLevel="25.908945604083865"
  >
    <Description>This wide-field view shows the region of the sky, in the constellation of Auriga, where AB Aurigae can be found. This view was created from images forming part of the Digitized Sky Survey 2.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.586892857901056"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="73.9388580133"
        CenterY="30.5642884953"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the region of the sky where AB Aurigae is located"
        OffsetX="0.000279961722284"
        OffsetY="0.000279961722284"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.8400000000000003"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso2008f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgement: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2008f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2008f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2010b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-06-30T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-0.11015597487537393"
    Magnitude="0"
    Name="Hubble image of the Kinman Dwarf galaxy"
    Opacity="100"
    RA="22.51022877725166"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2010b/thumb.jpg"
    ZoomLevel="0.0380521008207156"
  >
    <Description>Image of the Kinman Dwarf galaxy, also known as PHL 293B, taken with the NASA/ESA Hubble Space Telescope’s Wide Field Camera 3 in 2011, before the disappearance of the massive star. Located some 75 million light-years away, the galaxy is too far away for astronomers to clearly resolve its individual stars, but in observations done between 2001 and 2011, they detected the signatures of the massive star. These signatures were not present in more recent data.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.005667852336128"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="337.653433353"
        CenterY="-0.110163617017"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Hubble image of the Kinman Dwarf galaxy"
        OffsetX="5.535012047e-06"
        OffsetY="5.535012047e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="32.50000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="1"
        Url="http://data1.wwtassets.org/feeds/eso/eso2010b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>NASA, ESA/Hubble, J. Andrews (U. Arizona)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2010b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2010b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2010d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-06-30T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-0.1241231516869483"
    Magnitude="0"
    Name="Wide-field view of the region of the sky where the Kinman Dwarf galaxy  is located"
    Opacity="100"
    RA="22.507958597953557"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2010d/thumb.jpg"
    ZoomLevel="28.571413624355998"
  >
    <Description>This wide-field view shows the region of the sky, in the constellation of Aquarius, where the Kinman Dwarf galaxy can be found. This view was created from images forming part of the Digitized Sky Survey 2.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.589353341386752"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="337.619519221"
        CenterY="-0.124263011945"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the region of the sky where the Kinman Dwarf galaxy  is located"
        OffsetX="0.000140055949139"
        OffsetY="0.000140055949139"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.08"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso2010d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgement: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2010d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2010d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2011a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-07-22T15:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-64.93938307112971"
    Magnitude="0"
    Name="First ever image of a multi-planet system around a Sun-like star"
    Opacity="100"
    RA="13.419986112029072"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2011a/thumb.jpg"
    ZoomLevel="0.008903642855307713"
  >
    <Description>This image, captured by the SPHERE instrument on ESO’s Very Large Telescope, shows the star TYC 8998-760-1 accompanied by two giant exoplanets. This is the first time astronomers have directly observed more than one planet orbiting a star similar to the Sun. The image was captured by blocking the light from the young, Sun-like star (on the top left corner) using a coronagraph, which allows for the fainter planets to be detected. The bright and dark rings we see on the star’s image are optical artefacts. The two planets are visible as two bright dots in the centre and bottom right of the frame.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.001364665511725056"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.299792467"
        CenterY="-64.9393834043"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="First ever image of a multi-planet system around a Sun-like star"
        OffsetX="3.331702909485e-07"
        OffsetY="3.331702909485e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2011a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Bohn et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2011a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2011a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2011c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-07-22T15:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-64.93918490472561"
    Magnitude="0"
    Name="First ever image of a multi-planet system around a Sun-like star (uncropped, without annotations)"
    Opacity="100"
    RA="13.420010889230433"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2011c/thumb.jpg"
    ZoomLevel="0.013443960291963299"
  >
    <Description>This image, captured by the SPHERE instrument on ESO’s Very Large Telescope, shows the star TYC 8998-760-1 accompanied by two giant exoplanets, TYC 8998-760-1b and TYC 8998-760-1c. This is the first time astronomers have directly observed more than one planet orbiting a star similar to the Sun. The two planets are visible as two bright dots in the centre (TYC 8998-760-1b) and bottom right (TYC 8998-760-1c) of the frame. Other bright dots, which are background stars, are visible in the image as well. By taking different images at different times, the team were able to distinguish these planets from the background stars.    The image was captured by blocking the light from the young, Sun-like star (top-left of centre) using a coronagraph, which allows for the fainter planets to be detected. The bright and dark rings we see on the star’s image are optical artefacts.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0013633011823104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.30016491"
        CenterY="-64.9391855704"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="First ever image of a multi-planet system around a Sun-like star (uncropped, without annotations)"
        OffsetX="6.65674405425e-07"
        OffsetY="6.65674405425e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2011c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Bohn et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2011c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2011c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2012a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-07-30T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-56.106805554083216"
    Magnitude="0"
    Name="New ESO’s VLT image of the NGC 2899 planetary nebula"
    Opacity="100"
    RA="9.450842850060708"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2012a/thumb.jpg"
    ZoomLevel="1.233568599933479"
  >
    <Description>This highly detailed image of the fantastic NGC 2899 planetary nebula was captured using the FORS instrument on ESO’s Very Large Telescope in northern Chile. This object has never before been imaged in such striking detail, with even the faint outer edges of the planetary nebula glowing over the background stars.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1431683380178944"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="141.762705387"
        CenterY="-56.1068405317"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="New ESO’s VLT image of the NGC 2899 planetary nebula"
        OffsetX="3.49532075239e-05"
        OffsetY="3.49532075239e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.039999999999999994"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2012a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2012a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2012a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2012c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-07-30T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-56.099548990043886"
    Magnitude="0"
    Name="The sky around NGC 2899"
    Opacity="100"
    RA="9.44997400268976"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2012c/thumb.jpg"
    ZoomLevel="27.997771533532912"
  >
    <Description>This image shows the sky around the location of NGC 2899, which is visible at the very centre of the frame. This picture was created from images in the Digitized Sky Survey 2.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.586650356514816"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="141.749864739"
        CenterY="-56.0996868471"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The sky around NGC 2899"
        OffsetX="0.000139973460587"
        OffsetY="0.000139973460587"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.8600000000000001"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso2012c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgement: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2012c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2012c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2013a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-08-12T17:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-47.86465054530075"
    Magnitude="0"
    Name="Lensed view of SPT0418-47"
    Opacity="100"
    RA="4.311021089150898"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2013a/thumb.jpg"
    ZoomLevel="0.01295580830026392"
  >
    <Description>Astronomers using ALMA, in which the ESO is a partner, have revealed an extremely distant galaxy that looks surprisingly like our Milky Way. The galaxy, SPT0418-47, is gravitationally lensed by a nearby galaxy, appearing in the sky as a near-perfect ring of light.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00285859678937088"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="64.6653184178"
        CenterY="-47.8646519411"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Lensed view of SPT0418-47"
        OffsetX="1.39579921356e-06"
        OffsetY="1.39579921356e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2013a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO), Rizzo et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2013a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2013a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2014c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2020-09-03T20:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="11.870181301709243"
    Magnitude="0"
    Name="ALMA and SPHERE view of GW Orionis (superimposed)"
    Opacity="100"
    RA="5.48566418217082"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2014c/thumb.jpg"
    ZoomLevel="0.0089599243278675"
  >
    <Description>ALMA, in which ESO is a partner, and the SPHERE instrument on ESO’s Very Large Telescope have imaged GW Orionis, a triple star system with a peculiar inner region. Unlike the flat planet-forming discs we see around many stars, GW Orionis features a warped disc, deformed by the movements of the three stars at its centre. This composite image shows both the ALMA and SPHERE observations of the disc.  The ALMA image shows the disc’s ringed structure, with the innermost ring (part of which is visible as an oblong dot at the very centre of the image) separated from the rest of the disc. The SPHERE observations allowed astronomers to see for the first time the shadow of this innermost ring on the rest of the disc, which made it possible for them to reconstruct its warped shape.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0011929789504"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="82.2849633278"
        CenterY="11.8701807192"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="ALMA and SPHERE view of GW Orionis (superimposed)"
        OffsetX="5.82509253125e-07"
        OffsetY="5.82509253125e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2014c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Exeter/Kraus et al., ALMA (ESO/NAOJ/NRAO)</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2014c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2014c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2103b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-03-08T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="18.799788221108553"
    Magnitude="0"
    Name="Wide-field view of the sky around the quasar P172+18"
    Opacity="100"
    RA="11.489825689510523"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2103b/thumb.jpg"
    ZoomLevel="23.072092238100705"
  >
    <Description>This visible-light, wide-field image of the region around the distant quasar P172+18 was created from images in the Digitized Sky Survey 2. The object itself lies very close to the centre and is not visible in this picture, but many other, much closer, galaxies are seen in this wide-field view.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.59517838188544"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="172.347684907"
        CenterY="18.7995109042"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the sky around the quasar P172+18"
        OffsetX="0.000280467430535"
        OffsetY="0.000280467430535"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.6400000000001964"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso2103b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO and Digitized Sky Survey 2. Acknowledgment: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2103b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2103b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2105a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-03-24T15:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.391123250004458"
    Magnitude="0"
    Name="A view of the M87 supermassive black hole in polarised light"
    Opacity="100"
    RA="12.51372871666636"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2105a/thumb.jpg"
    ZoomLevel="3.1308869164561896e-07"
  >
    <Description>The Event Horizon Telescope (EHT) collaboration, who produced the first ever image of a black hole released in 2019, has today a new view of the massive object at the centre of the Messier 87 (M87) galaxy: how it looks in polarised light. This is the first time astronomers have been able to measure polarisation, a signature of magnetic fields, this close to the edge of a black hole.  This image shows the polarised view of the black hole in M87. The lines mark the orientation of polarisation, which is related to the magnetic field around the shadow of the black hole.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="3.647420834770944e-08"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="187.70593075"
        CenterY="12.39112325"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A view of the M87 supermassive black hole in polarised light"
        OffsetX="4.452418011195e-12"
        OffsetY="4.452418011195e-12"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso2105a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>EHT Collaboration</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2105a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2105a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2105d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-03-24T15:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.391353410230057"
    Magnitude="0"
    Name="ALMA image of M87 jet in polarised light"
    Opacity="100"
    RA="12.513715485318484"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2105d/thumb.jpg"
    ZoomLevel="0.010324786287441023"
  >
    <Description>This image shows a view of the jet in the Messier 87 (M87) galaxy in polarised light. The image was obtained with the Chile-based Atacama Large Millimeter/submillimeter Array (ALMA), in which ESO is a partner, and captures the part of the jet, with a size of 6000 light years, closer to the centre of the galaxy. The lines mark the orientation of polarisation, which is related to the magnetic field in the region imaged. This ALMA image therefore indicates what the structure of the magnetic field along the jet looks like.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.001233961386360832"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="187.705732434"
        CenterY="12.3913532596"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="ALMA image of M87 jet in polarised light"
        OffsetX="1.50630052046e-07"
        OffsetY="1.50630052046e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso2105d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO), Goddi et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2105d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2105d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2107j&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-04-27T12:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.0273896931508"
    Magnitude="0"
    Name="Image of the Centaurus A galaxy taken during the Test-Bed Telescope first light tests"
    Opacity="100"
    RA="13.42125885572896"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2107j/thumb.jpg"
    ZoomLevel="25.19758299103624"
  >
    <Description>Full field-of-view image (in false colour) obtained during the Test-Bed Telescope’s first light tests at ESO’s La Silla Observatory in Chile. The individual light sources are stars, with the galaxy Centaurus A visible in the centre of the image. While the telescope will be used to detect near-Earth objects rather than observing galaxies, images like these are important to test if the telescope is working as expected. Even during its commissioning phase, the 56-centimetre telescope is already showing its promising capabilities, in part thanks to the excellent sky quality at La Silla. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.922675172363217"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.211396815"
        CenterY="-42.3110927879"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Image of the Centaurus A galaxy taken during the Test-Bed Telescope first light tests"
        OffsetX="-0.588081703487169"
        OffsetY="0.4166126339110619"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="119.05874359711001"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso2107j/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESA</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2107j/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2107j/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2109c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-06-16T17:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.407066022235277"
    Magnitude="0"
    Name="Image of Betelgeuse’s surface taken in March 2020"
    Opacity="100"
    RA="5.919529174457701"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2109c/thumb.jpg"
    ZoomLevel="0.0008303248493154215"
  >
    <Description>The red supergiant star Betelgeuse, in the constellation of Orion, underwent an unprecedented dimming in late 2019 and early 2020. This stunning image of the star’s surface was taken with the SPHERE instrument on ESO’s Very Large Telescope in March 2020, and is one of the images taken during an observing campaign aimed at understanding why the star became fainter. Betelgeuse’s brightness returned to normal in April 2020. Astronomers now understand that Betelgeuse’s dip in brightness was the result of a dusty veil that emerged from the star, partially concealing its southern region.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.000104458775087104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="88.7929376683"
        CenterY="7.40706597123"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Image of Betelgeuse’s surface taken in March 2020"
        OffsetX="5.1005261273e-08"
        OffsetY="5.1005261273e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2109c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M. Montargès et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2109c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2109c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2109d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-06-16T17:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.407066022235277"
    Magnitude="0"
    Name="Image of Betelgeuse’s surface taken in January 2020"
    Opacity="100"
    RA="5.919529174457701"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2109d/thumb.jpg"
    ZoomLevel="0.0008303248493154215"
  >
    <Description>The red supergiant star Betelgeuse, in the constellation of Orion, underwent an unprecedented dimming in late 2019 and early 2020. This stunning image of the star’s surface was taken with the SPHERE instrument on ESO’s Very Large Telescope in January 2020, and is one of the images taken during an observing campaign aimed at understanding why the star became fainter. Betelgeuse’s brightness returned to normal in April 2020. Astronomers now understand that Betelgeuse’s dip in brightness was the result of a dusty veil that emerged from the star, partially concealing its southern region. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.000104458775087104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="88.7929376683"
        CenterY="7.40706597123"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Image of Betelgeuse’s surface taken in January 2020"
        OffsetX="5.1005261273e-08"
        OffsetY="5.1005261273e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2109d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M. Montargès et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2109d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2109d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2109e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-06-16T17:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.407066022235277"
    Magnitude="0"
    Name="Image of Betelgeuse’s surface taken in December 2019"
    Opacity="100"
    RA="5.919529174457701"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2109e/thumb.jpg"
    ZoomLevel="0.0008303248493154215"
  >
    <Description>The red supergiant star Betelgeuse, in the constellation of Orion, underwent an unprecedented dimming in late 2019 and early 2020. This stunning image of the star’s surface was taken with the SPHERE instrument on ESO’s Very Large Telescope in December 2019, and is one of the images taken during an observing campaign aimed at understanding why the star became fainter. Betelgeuse’s brightness returned to normal in April 2020. Astronomers now understand that Betelgeuse’s dip in brightness was the result of a dusty veil that emerged from the star, partially concealing its southern region.  An earlier version of this image was released in early 2020.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.000104458775087104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="88.7929376683"
        CenterY="7.40706597123"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Image of Betelgeuse’s surface taken in December 2019"
        OffsetX="5.1005261273e-08"
        OffsetY="5.1005261273e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2109e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M. Montargès et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2109e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2109e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2109f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-06-16T17:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="7.407066022235277"
    Magnitude="0"
    Name="Image of Betelgeuse’s surface taken in January 2019"
    Opacity="100"
    RA="5.919529174457701"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2109f/thumb.jpg"
    ZoomLevel="0.0008303248493154215"
  >
    <Description>When the red supergiant star Betelgeuse became visibly darker in late 2019 and early 2020, astronomers were puzzled. This image of the star was taken before Betelgeuse started to fade, using the SPHERE instrument on ESO’s Very Large Telescope. When compared with later images, taken in December 2019, January 2020 and March 2020, it is clear that the southern region of the star dimmed significantly, before beginning to its normal brightness. Astronomers now know that this unprecedented dimming was the result of a cloud of dust that emerged from the star. An earlier version of this image was released in early 2020.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.000104458775087104"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="88.7929376683"
        CenterY="7.40706597123"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Image of Betelgeuse’s surface taken in January 2019"
        OffsetX="5.1005261273e-08"
        OffsetY="5.1005261273e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2109f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/M. Montargès et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2109f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2109f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="4.473604280065001"
    Magnitude="0"
    Name="NGC 4303 as seen with MUSE on ESO’s VLT at several wavelengths of light"
    Opacity="100"
    RA="12.365246137611551"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110b/thumb.jpg"
    ZoomLevel="0.5015475170506039"
  >
    <Description>This image, taken by the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT), shows the nearby galaxy NGC 4303. NGC 4303 is a spiral galaxy, with a bar of stars and gas at its centre, located approximately 55 million light-years from Earth in the constellation Virgo. The image is an overlay of observations conducted at different wavelengths of light to map stellar populations and warm gas. The golden glows mainly correspond to clouds of ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions in the background reveal the distribution of slightly older stars.   The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0569586391469056"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="185.478719961"
        CenterY="4.47357646823"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 4303 as seen with MUSE on ESO’s VLT at several wavelengths of light"
        OffsetX="2.781183552095e-05"
        OffsetY="2.781183552095e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="14.423061386912122"
    Magnitude="0"
    Name="NGC 4254 as seen with MUSE on ESO’s VLT at several wavelengths of light"
    Opacity="100"
    RA="12.314063919413496"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110c/thumb.jpg"
    ZoomLevel="0.453255073223328"
  >
    <Description>This image, taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT), shows the nearby galaxy NGC 4254. NGC 4254 is a grand-design spiral galaxy located approximately 45 million light-years from Earth in the constellation Coma Berenices. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and warm gas. The golden glows mainly correspond to clouds of ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions in the background reveal the distribution of slightly older stars. The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1137581360246784"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="184.710987478"
        CenterY="14.4230891502"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 4254 as seen with MUSE on ESO’s VLT at several wavelengths of light"
        OffsetX="2.77729824279e-05"
        OffsetY="2.77729824279e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.97999999999999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.981340677882073"
    Magnitude="0"
    Name="NGC 3627 as seen with MUSE on ESO’s VLT at several wavelengths of light"
    Opacity="100"
    RA="11.337580512204081"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110d/thumb.jpg"
    ZoomLevel="0.3275449151593102"
  >
    <Description>This image, taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT), shows the nearby galaxy NGC 3627. NGC 3627 is a spiral galaxy located approximately 31 million light-years from Earth in the constellation Leo. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and warm gas. The golden glows mainly correspond to clouds of ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions in the background reveal the distribution of slightly older stars.  The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1135852867090432"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="170.063736161"
        CenterY="12.9813683893"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 3627 as seen with MUSE on ESO’s VLT at several wavelengths of light"
        OffsetX="2.773078288795e-05"
        OffsetY="2.773078288795e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.95999999999988"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-0.49898894869906774"
    Magnitude="0"
    Name="NGC 1087 as seen with MUSE on ESO’s VLT at several wavelengths of light"
    Opacity="100"
    RA="2.7736525402644725"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110e/thumb.jpg"
    ZoomLevel="0.3375902872681752"
  >
    <Description>This image, taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT), shows the nearby galaxy NGC 1087. NGC 1087 is a spiral galaxy located approximately 80 million light-years from Earth in the constellation of Cetus. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and warm gas. The golden glows mainly correspond to clouds of ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions in the background reveal the distribution of slightly older stars.  The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0569603648315392"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="41.6048159177"
        CenterY="-0.498961136021"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1087 as seen with MUSE on ESO’s VLT at several wavelengths of light"
        OffsetX="2.78126781404e-05"
        OffsetY="2.78126781404e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110f&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-19.41135145458013"
    Magnitude="0"
    Name="NGC 1300 as seen with MUSE on ESO’s VLT at several wavelengths of light"
    Opacity="100"
    RA="3.3280801206363524"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110f/thumb.jpg"
    ZoomLevel="0.4966791985647001"
  >
    <Description>This image, taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT), shows the nearby galaxy NGC 1300. NGC 1300 is a spiral galaxy, with a bar of stars and gas at its centre, located approximately 61 million light-years from Earth in the constellation Eridanus. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and warm gas. The golden glows mainly correspond to clouds of ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions in the background reveal the distribution of slightly older stars.  The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0568559817705472"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="49.9212312547"
        CenterY="-19.4113792066"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1300 as seen with MUSE on ESO’s VLT at several wavelengths of light"
        OffsetX="2.77617098489e-05"
        OffsetY="2.77617098489e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.020000000000000066"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110g&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="4.473604280065001"
    Magnitude="0"
    Name="NGC 4303 as seen with the VLT and ALMA at several wavelengths of light"
    Opacity="100"
    RA="12.365246137611551"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110g/thumb.jpg"
    ZoomLevel="0.5015475170506039"
  >
    <Description>This image of the nearby galaxy NGC 4303 was obtained by combining observations taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT) and with the Atacama Large Millimeter/submillimeter Array (ALMA), in which ESO is a partner. NGC 4303 is a spiral galaxy, with a bar of stars and gas at its centre, located approximately 55 million light-years from Earth in the constellation Virgo. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and gas. ALMA’s observations are represented in brownish-orange tones and highlight the clouds of cold molecular gas that provide the raw material from which stars form. The MUSE data show up mainly in gold and blue. The bright golden glows map warm clouds of mainly ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions reveal the distribution of slightly older stars.    The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0569586391469056"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="185.478719961"
        CenterY="4.47357646823"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 4303 as seen with the VLT and ALMA at several wavelengths of light"
        OffsetX="2.781183552095e-05"
        OffsetY="2.781183552095e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/ALMA (ESO/NAOJ/NRAO)/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110h&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="14.423061386912122"
    Magnitude="0"
    Name="NGC 4254 as seen with the VLT and ALMA at several wavelengths of light"
    Opacity="100"
    RA="12.314063919413496"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110h/thumb.jpg"
    ZoomLevel="0.453255073223328"
  >
    <Description>This image of the nearby galaxy NGC 4254 was obtained by combining observations taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT) and with the Atacama Large Millimeter/submillimeter Array (ALMA), in which ESO is a partner. NGC 4254 is a grand-design spiral galaxy located approximately 45 million light-years from Earth in the constellation Coma Berenices. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and gas. ALMA’s observations are represented in brownish-orange tones and highlight the clouds of cold molecular gas that provide the raw material from which stars form. The MUSE data show up mainly in gold and blue. The bright golden glows map warm clouds of mainly ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions reveal the distribution of slightly older stars. The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1137581360246784"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="184.710987478"
        CenterY="14.4230891502"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 4254 as seen with the VLT and ALMA at several wavelengths of light"
        OffsetX="2.77729824279e-05"
        OffsetY="2.77729824279e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.97999999999999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/ALMA (ESO/NAOJ/NRAO)/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110i&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.981340677882073"
    Magnitude="0"
    Name="NGC 3627 as seen with the VLT and ALMA at several wavelengths of light"
    Opacity="100"
    RA="11.337580512204081"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110i/thumb.jpg"
    ZoomLevel="0.3275449151593102"
  >
    <Description>This image of the nearby galaxy NGC 3627 was obtained by combining observations taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT) and with the Atacama Large Millimeter/submillimeter Array (ALMA), in which ESO is a partner. NGC 3627 is a spiral galaxy located approximately 31 million light-years from Earth in the constellation Leo. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and gas. ALMA’s observations are represented in brownish-orange tones and highlight the clouds of cold molecular gas that provide the raw material from which stars form. The MUSE data show up mainly in gold and blue. The bright golden glows map warm clouds of mainly ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions reveal the distribution of slightly older stars. The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1135852867090432"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="170.063736161"
        CenterY="12.9813683893"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 3627 as seen with the VLT and ALMA at several wavelengths of light"
        OffsetX="2.773078288795e-05"
        OffsetY="2.773078288795e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.95999999999988"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110i/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/ALMA (ESO/NAOJ/NRAO)/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110i/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110i/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110j&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-0.49898894869906774"
    Magnitude="0"
    Name="NGC 1087 as seen with the VLT and ALMA at several wavelengths of light"
    Opacity="100"
    RA="2.7736525402644725"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110j/thumb.jpg"
    ZoomLevel="0.3375902872681752"
  >
    <Description>This image of the nearby galaxy NGC 1087 was obtained by combining observations taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT) and with the Atacama Large Millimeter/submillimeter Array (ALMA), in which ESO is a partner. NGC 1087 is a spiral galaxy located approximately 80 million light-years from Earth in the constellation Cetus. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and gas. ALMA’s observations are represented in brownish-orange tones and highlight the clouds of cold molecular gas that provide the raw material from which stars form. The MUSE data show up mainly in gold and blue. The bright golden glows map warm clouds of mainly ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions reveal the distribution of slightly older stars. The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high-resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0569603648315392"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="41.6048159177"
        CenterY="-0.498961136021"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1087 as seen with the VLT and ALMA at several wavelengths of light"
        OffsetX="2.78126781404e-05"
        OffsetY="2.78126781404e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-90"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110j/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/ALMA (ESO/NAOJ/NRAO)/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110j/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110j/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2110k&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-16T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-19.41135145458013"
    Magnitude="0"
    Name="NGC 1300 as seen with the VLT and ALMA at several wavelengths of light"
    Opacity="100"
    RA="3.3280801206363524"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2110k/thumb.jpg"
    ZoomLevel="0.4966791985647001"
  >
    <Description>This image of the nearby galaxy NGC 1300 was obtained by combining observations taken with the Multi-Unit Spectroscopic Explorer (MUSE) on ESO’s Very Large Telescope (VLT) and with the Atacama Large Millimeter/submillimeter Array (ALMA), in which ESO is a partner. NGC 1300 is a spiral galaxy, with a bar of stars and gas at its centre, located approximately 61 million light-years from Earth in the constellation Eridanus. The image is a combination of observations conducted at different wavelengths of light to map stellar populations and gas. ALMA’s observations are represented in brownish-orange tones and highlight the clouds of cold molecular gas that provide the raw material from which stars form. The MUSE data show up mainly in gold and blue. The bright golden glows map warm clouds of mainly ionised hydrogen, oxygen and sulphur gas, marking the presence of newly born stars, while the bluish regions reveal the distribution of slightly older stars.  The image was taken as part of the Physics at High Angular resolution in Nearby GalaxieS (PHANGS) project, which is making high resolution observations of nearby galaxies with telescopes operating across the electromagnetic spectrum.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0568559817705472"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="49.9212312547"
        CenterY="-19.4113792066"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1300 as seen with the VLT and ALMA at several wavelengths of light"
        OffsetX="2.77617098489e-05"
        OffsetY="2.77617098489e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.020000000000000066"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2110k/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/ALMA (ESO/NAOJ/NRAO)/PHANGS</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2110k/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2110k/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2111b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-22T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-41.39805634786264"
    Magnitude="0"
    Name="The PDS 70 system as seen with ALMA"
    Opacity="100"
    RA="14.136139402483876"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2111b/thumb.jpg"
    ZoomLevel="0.007773449703598704"
  >
    <Description>This image, taken with the Atacama Large Millimeter/submillimeter Array (ALMA), in which ESO is a partner, shows the PDS 70 system, located nearly 400 light-years away and still in the process of being formed. The system features a star at its centre and at least two planets orbiting it, PDS 70b (not visible in the image) and PDS 70c, surrounded by a circumplanetary disc (the dot to the right of the star). The planets have carved a cavity in the circumstellar disc (the ring-like structure that dominates the image) as they gobbled up material from the disc itself, growing in size. It was during this process that PDS 70c acquired its own circumplanetary disc, which contributes to the growth of the planet and where moons can form.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00142407551461376"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="212.042091269"
        CenterY="-41.3980565217"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The PDS 70 system as seen with ALMA"
        OffsetX="1.738373430925e-07"
        OffsetY="1.738373430925e-07"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso2111b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO)/Benisty et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2111b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2111b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2111c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-07-22T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-41.39803946430931"
    Magnitude="0"
    Name="Moon-forming disc around the PDS 70c exoplanet as seen with ALMA"
    Opacity="100"
    RA="14.136135377126179"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2111c/thumb.jpg"
    ZoomLevel="0.000978305648900328"
  >
    <Description>This image, taken with the Atacama Large Millimeter/submillimeter Array (ALMA), in which ESO is a partner, shows a close-up view on the moon-forming disc surrounding PDS 70c, a young Jupiter-like gas giant nearly 400 light-years away. It shows this planet and its disc centre-front, with the larger circumstellar ring-like disc taking up most of the right-hand side of the image. The dusty circumplanetary disc is as large as the Sun-Earth distance and has enough mass to form up to three satellites the size of the Moon.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.000233843367057408"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="212.042030733"
        CenterY="-41.3980395214"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Moon-forming disc around the PDS 70c exoplanet as seen with ALMA"
        OffsetX="5.70906657855e-08"
        OffsetY="5.70906657855e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2111c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ALMA (ESO/NAOJ/NRAO)/Benisty et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2111c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2111c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2116b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-11-11T13:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.76102087404777"
    Magnitude="0"
    Name="NGC1850 as seen with the Very Large Telescope and Hubble"
    Opacity="100"
    RA="5.146161636337546"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2116b/thumb.jpg"
    ZoomLevel="1.15383808513094"
  >
    <Description>This image shows NGC1850, a cluster of thousands of stars roughly 160 000 light-years away in the Large Magellanic Cloud, a Milky Way neighbour. The reddish filaments surrounding the cluster, made of vast clouds of hydrogen, are believed to be the remnants of supernova explosions.  The image is an overlay of observations conducted in visible light with ESO’s Very Large Telescope (VLT) and NASA/ESA’s Hubble Space Telescope (HST). The VLT captured the wide field of the image and the filaments, while the central cluster was imaged by the HST.   Among many stars, this cluster is home to a black hole 11 times as massive as the Sun and to a five-solar-mass star orbiting it. By looking at the star’s orbit, a team of astronomers were able to infer the presence of the black hole, making it the first small black hole outside of our galaxy to be found this way. For this discovery, the team used the Multi Unit Spectroscopic Explorer (MUSE) instrument at the VLT.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1498044539756544"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="77.1924391926"
        CenterY="-68.7610461851"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC1850 as seen with the Very Large Telescope and Hubble"
        OffsetX="1.82866765107e-05"
        OffsetY="1.82866765107e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="33.16000000000012"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso2116b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO, NASA/ESA/R. Gilmozzi/S. Casertano, J. Schmidt</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2116b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2116b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2117b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-11-30T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.292368640806142"
    Magnitude="0"
    Name="Close-up view of the nearest pair of supermassive black holes"
    Opacity="100"
    RA="23.664934263754215"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2117b/thumb.jpg"
    ZoomLevel="0.022912066944181797"
  >
    <Description>Close-up view of the two bright galactic nuclei, each housing a supermassive black hole, in NGC 7727, a galaxy located 89 million light-years away from Earth in the constellation Aquarius. Each nucleus consists of a dense group of stars with a supermassive black hole at its centre. The two black holes are on a collision course and form the closest pair of supermassive black holes found to date. It is also the pair with the smallest separation between two supermassive black holes — observed just 1600 light-years apart in the sky.   The image was taken with the MUSE instrument on ESO’s Very Large Telescope (VLT) at the Paranal Observatory in Chile.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.002489385085184"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="354.974015144"
        CenterY="-12.292369909"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Close-up view of the nearest pair of supermassive black holes"
        OffsetX="1.215520061125e-06"
        OffsetY="1.215520061125e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="2.54000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso2117b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Voggel et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2117b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2117b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2117d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-11-30T14:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.28645042053519"
    Magnitude="0"
    Name="Wide-field view of the region of the sky hosting NGC 7727"
    Opacity="100"
    RA="23.665071028220495"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2117d/thumb.jpg"
    ZoomLevel="43.073876606998496"
  >
    <Description>This image from the Digitized Sky Survey (DSS) shows the region of the sky around NGC 7727, a galaxy located 89 million light-years away from Earth in the constellation Aquarius. The galaxy is the bright spot in the centre.  NGC 7727 is home to the closest pair of supermassive black holes to Earth found to date. It is also the pair with the smallest separation between two supermassive black holes — observed to be just 1600 light-years apart in the sky.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="4.5820178829312"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="354.976208133"
        CenterY="-12.2865906426"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of the region of the sky hosting NGC 7727"
        OffsetX="0.0001398320887125"
        OffsetY="0.0001398320887125"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.16"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso2117d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgement: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2117d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2117d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2118a&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-12-08T17:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.79378768877006"
    Magnitude="0"
    Name="Image of the most massive planet-hosting star pair observed to date"
    Opacity="100"
    RA="14.699270738497505"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2118a/thumb.jpg"
    ZoomLevel="0.02218437911292156"
  >
    <Description>This image shows the most massive planet-hosting star pair to date, b Centauri, and its giant planet b Centauri b. This is the first time astronomers have directly observed a planet orbiting a star pair this massive and hot.  The star pair, which has a total mass of at least six times that of the Sun, is the bright object in the top left corner of the image, the bright and dark rings around it being optical artefacts. The planet, visible as a bright dot in the lower right of the frame, is ten times as massive as Jupiter and orbits the pair at 100 times the distance Jupiter orbits the Sun. The other bright dot in the image (top right) is a background star. By taking different images at different times, astronomers were able to distinguish the planet from the background stars.  The image was captured by the SPHERE instrument on ESO’s Very Large Telescope and using a coronagraph, which blocked the light from the massive star system and allowed astronomers to detect the faint planet.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0041706697899008"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="220.489062366"
        CenterY="-37.793788707"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Image of the most massive planet-hosting star pair observed to date"
        OffsetX="1.018229929175e-06"
        OffsetY="1.018229929175e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2118a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Janson et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2118a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2118a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2119b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-12-14T16:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.00741525318891"
    Magnitude="0"
    Name="Stars around Sgr A* in March 2021"
    Opacity="100"
    RA="17.761117420207096"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2119b/thumb.jpg"
    ZoomLevel="0.000875110897127531"
  >
    <Description>This image show stars orbiting very close to Sgr A* (centre), the supermassive black hole at the heart of the Milky Way. They were obtained with the GRAVITY instrument on ESO’s Very Large Telescope Interferometer (VLTI) at the end of March 2021.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0001679813966667776"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.41676135"
        CenterY="-29.0074152942"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stars around Sgr A* in March 2021"
        OffsetX="4.10110831706e-08"
        OffsetY="4.10110831706e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2119b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/GRAVITY collaboration</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2119b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2119b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2119c&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-12-14T16:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.00741525318891"
    Magnitude="0"
    Name="Stars around Sgr A* in May 2021"
    Opacity="100"
    RA="17.761117420207096"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2119c/thumb.jpg"
    ZoomLevel="0.000875110897127531"
  >
    <Description>This image show stars orbiting very close to Sgr A* (centre), the supermassive black hole at the heart of the Milky Way. They were obtained with the GRAVITY instrument on ESO’s Very Large Telescope Interferometer (VLTI) at the end of May 2021.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0001679813966667776"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.41676135"
        CenterY="-29.0074152942"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stars around Sgr A* in May 2021"
        OffsetX="4.10110831706e-08"
        OffsetY="4.10110831706e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2119c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/GRAVITY collaboration</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2119c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2119c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2119d&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-12-14T16:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.00741525318891"
    Magnitude="0"
    Name="Stars around Sgr A* in June 2021"
    Opacity="100"
    RA="17.761117420207096"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2119d/thumb.jpg"
    ZoomLevel="0.000875110897127531"
  >
    <Description>This image show stars orbiting very close to Sgr A* (centre), the supermassive black hole at the heart of the Milky Way. They were obtained with the GRAVITY instrument on ESO’s Very Large Telescope Interferometer (VLTI) at the end of June 2021.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0001679813966667776"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.41676135"
        CenterY="-29.0074152942"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stars around Sgr A* in June 2021"
        OffsetX="4.10110831706e-08"
        OffsetY="4.10110831706e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2119d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/GRAVITY collaboration</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2119d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2119d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2119e&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-12-14T16:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.00741525318891"
    Magnitude="0"
    Name="Stars around Sgr A* in July 2021"
    Opacity="100"
    RA="17.761117420207096"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2119e/thumb.jpg"
    ZoomLevel="0.000875110897127531"
  >
    <Description>This image show stars orbiting very close to Sgr A* (centre), the supermassive black hole at the heart of the Milky Way. They were obtained with the GRAVITY instrument on ESO’s Very Large Telescope Interferometer (VLTI) at the end of July 2021.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0001679813966667776"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="266.41676135"
        CenterY="-29.0074152942"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stars around Sgr A* in July 2021"
        OffsetX="4.10110831706e-08"
        OffsetY="4.10110831706e-08"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2119e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/GRAVITY collaboration</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2119e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2119e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso2120b&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-12-22T17:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-23.07549938988762"
    Magnitude="0"
    Name="The faint red glow of a rogue planet"
    Opacity="100"
    RA="16.136944360679074"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso2120b/thumb.jpg"
    ZoomLevel="1.2355028644797237"
  >
    <Description>This image shows a small area of the sky in the direction of the region occupied by Upper Scorpius and Ophiucus. It zooms in on a recently discovered rogue planet, meaning a planet that does not orbit a star but instead roams freely on its own. The rogue planet is the tiny, bright red dot at the very centre of the image. The image was created by combining data from the OmegaCam instrument on VLT Survey Telescope (VST) and from the VIRCAM instrument on the Visible and Infrared Survey Telescope for Astronomy (VISTA), both located at ESO’s Paranal Observatory in Chile. Observations with these and other instruments helped the scientists tell the planets apart from stars, brown dwarfs and other objects in this region of the sky. Lurking far away from any star illuminating them, rogue planets would normally be impossible to image, but shortly after formation they emit a faint glow that can be detected by sensitive cameras on powerful telescopes.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.12112773181173761"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="242.054197034"
        CenterY="-23.0755294331"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The faint red glow of a rogue planet"
        OffsetX="2.9572200149350002e-05"
        OffsetY="2.9572200149350002e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.9200000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso2120b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Miret-Roig et al.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso2120b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso2120b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso8709a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1987-06-16T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-0.14573318500224294"
    Magnitude="0"
    Name="Is there a black hole in this galaxy?"
    Opacity="100"
    RA="5.26997258306717"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso8709a/thumb.jpg"
    ZoomLevel="1.148739777054"
  >
    <Description>This is a photo of Arakelian 120, an AGN galaxy which may contain a massive black hole at its centre, cf. ESO Press Release eso8709. The bright nucleus is overexposed and the underlying galaxy is only faintly visible. Most of the other objects in this field are stars in the Milky Way Galaxy.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.17593358336"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="79.047846"
        CenterY="-0.149791"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Is there a black hole in this galaxy?"
        OffsetX="-0.0018406564719863"
        OffsetY="0.00401434799574928"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-1.3899382385300005"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso8709a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso8709a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso8709a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso8906b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1989-07-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="2.8113319278890097"
    Magnitude="0"
    Name="Newly discovered large jet in the HH-111 complex"
    Opacity="100"
    RA="5.861444187088367"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso8906b/thumb.jpg"
    ZoomLevel="0.47516557057200004"
  >
    <Description>This photo shows the  newly discovered large jet in the HH-111 complex. The straight jet emerges from the surrounding interstellar cloud in the lower part of the picture. The outline of the cloud is vaguely visible by the brighter background near the right edge of the picture. Also seen is a diffuse reflection nebula around the lower part of the jet. This nebula is illuminated by the light from the newborn star, hidden deep within the cloud. Because of the heavy obscuration, the star itself is not visible on this photo. The jet produces a ``bow-shock&amp;#x27;&amp;#x27; nebula; this is the bright, mushroom-shaped nebula in the upper part of the picture. The round points are background stars in the Milky Way. Compare this image with the graphic representation of the jet isophotes, also accompanying this Press Release. The picture was produced as a composite of four 1 hour CCD exposures, obtained with the Danish 1.5 m telescope at La Silla through a narrow optical filter. The light seen here from the jet is emitted by singly ionised sulphur atoms. This photo is available in a B/W and a false-colour version. (ESO Press Release eso8906; BW and Colour)</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05454876672"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="87.934281"
        CenterY="2.809292"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Newly discovered large jet in the HH-111 complex"
        OffsetX="-0.001969056083608192"
        OffsetY="0.012614285378558727"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-89.67763830664"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso8906b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso8906b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso8906b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9003c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1990-02-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.015487145134962"
    Magnitude="0"
    Name="The central area of the Crab Nebula"
    Opacity="100"
    RA="5.575263177400504"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9003c/thumb.jpg"
    ZoomLevel="0.436446904338"
  >
    <Description>The Crab Nebula, one of the most famous objects in the northern sky, was observed rather low above the La Silla horizon (altitude) with the NTT. Despite this adverse condition, the picture shows in great detail the complex structure. The Crab Nebula is the remnant of a supernova which exploded in the year 1054.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04959348736"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.633178"
        CenterY="22.014573"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The central area of the Crab Nebula"
        OffsetX="0.0038114655545549506"
        OffsetY="0.0012998395413201316"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-5.709633009849999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9003c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9003c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9003c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9003d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1990-02-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-72.05288956884694"
    Magnitude="0"
    Name="The peculiar galaxy ESO 060-IG26"
    Opacity="100"
    RA="9.06738699765011"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9003d/thumb.jpg"
    ZoomLevel="0.248985452394"
  >
    <Description>Far down in the southern sky, on the border betwenn the constellations of Volans and Carina, lies this small group of galaxies. It was first discovered at ESO in 1974. The central galaxy is visibly disturbed and now carries the designation ``ESO 060-IG26&amp;#x27;&amp;#x27;. The less disturbed galaxy of elliptical shape is ``ESO 060-G27&amp;#x27;&amp;#x27;. The distance to the system has not yet been measured, but is probably in excess of 150 million light-years.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.03553118208"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="136.003474"
        CenterY="-72.055344"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The peculiar galaxy ESO 060-IG26"
        OffsetX="-0.0027010487763389026"
        OffsetY="0.0019572363125964385"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-11.445361819619999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9003d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9003d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9003d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9003g&quot;, &quot;publishedUTCISO8601&quot;: &quot;1990-02-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.13670806522753"
    Magnitude="0"
    Name="NGC 1365"
    Opacity="100"
    RA="3.5599819149940646"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9003g/thumb.jpg"
    ZoomLevel="0.33225152152096676"
  >
    <Description>This image shows the barred spiral galaxy NGC 1365 in the constellation of Fornax.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05318787620716544"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.400474197"
        CenterY="-36.1403971658"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1365"
        OffsetX="0.003629276241825347"
        OffsetY="-0.0008945764691998685"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="94.57792320447034"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9003g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9003g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9003g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9003h&quot;, &quot;publishedUTCISO8601&quot;: &quot;1990-02-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.51275301554883"
    Magnitude="0"
    Name="Galaxy NGC 1808"
    Opacity="100"
    RA="5.1284011549361646"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9003h/thumb.jpg"
    ZoomLevel="0.3278105759024182"
  >
    <Description>This image shows the barred spiral galaxy NGC 1808  in the constellation of Columba.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05309072112484352"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="76.9245338748"
        CenterY="-37.5131051813"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy NGC 1808"
        OffsetX="-0.0002668688080107555"
        OffsetY="-0.0011989221370747732"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-94.11221027842986"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9003h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9003h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9003h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9003i&quot;, &quot;publishedUTCISO8601&quot;: &quot;1990-02-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-62.81725057214346"
    Magnitude="0"
    Name="The galaxy NGC 6300"
    Opacity="100"
    RA="17.28343498204828"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9003i/thumb.jpg"
    ZoomLevel="0.22982357056707256"
  >
    <Description>The barred spiral galaxy NGC 6300 in the constellation of Ara.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05950350469922816"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="259.24746499"
        CenterY="-62.8191398364"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The galaxy NGC 6300"
        OffsetX="0.0026298284252512963"
        OffsetY="-0.00030444400470019234"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="141.07407847751986"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9003i/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9003i/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9003i/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9003k&quot;, &quot;publishedUTCISO8601&quot;: &quot;1990-02-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.51315957603347"
    Magnitude="0"
    Name="NGC 1808"
    Opacity="100"
    RA="5.12844827726421"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9003k/thumb.jpg"
    ZoomLevel="0.10970302622999997"
  >
    <Description>The galaxy NGC 1808.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.01603395584"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="76.926354"
        CenterY="-37.512967"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1808"
        OffsetX="0.00014561746222946432"
        OffsetY="-0.00031951701834920243"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-81.24065229984"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9003k/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9003k/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9003k/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9011a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1990-09-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="4.089941549194487"
    Magnitude="0"
    Name="Minor Planet (3933) Portugal"
    Opacity="100"
    RA="11.693094268924566"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9011a/thumb.jpg"
    ZoomLevel="1.3894189438665354"
  >
    <Description>This a reproduction of a small area of the photographic plate on which  Minor Planet (3933) Portugal was discovered. Due to its orbital motion around the Sun, &amp;quot;Portugal&amp;#x27;&amp;#x27; is seen as a short trail, while the fixed stars in the background are point-like.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.21625854970654088"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="175.357810372"
        CenterY="4.10219917083"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Minor Planet (3933) Portugal"
        OffsetX="-0.03882702373147151"
        OffsetY="-0.011195962480794007"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.571589138767675"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9011a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9011a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9011a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9532a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1995-11-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.01721726925587"
    Magnitude="0"
    Name="Pulsar in the Crab Nebula"
    Opacity="100"
    RA="5.5752808007882555"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9532a/thumb.jpg"
    ZoomLevel="0.413870229360937"
  >
    <Description>The Crab Pulsar is located near the centre of the Crab Nebula, i.e. the remnant of the supernova that exploded in AD 1054 in the constellation of Taurus. On this photo, the pulsar is seen as a 16th magnitude object; it is the lower right of the two stars of about equal brightness, near the centre of the field.The photo was obtained through a narrow optical filtre in the light of doubly ionized oxygen atoms ([O III]) with the ESO 3.5-m New Technology Telescope (NTT) under good seeing conditions.ESO Press Photo eso9532 accompanies ESO Press Release eso9532. It may be reproduced, if credit is given to the European Southern Observatory. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0811510253648896"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.6292586801"
        CenterY="22.0171816552"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Pulsar in the Crab Nebula"
        OffsetX="3.962452410395e-05"
        OffsetY="3.962452410395e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-5.540000000000006"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9532a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>This graph accompanies ESO Press Release 16/95 (20 November 1995). It may be reproduced, if credit is given to the European Southern Observatory.</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9532a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9532a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9533a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1995-11-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-44.643661105156774"
    Magnitude="0"
    Name="Young astronomers observe with ESO telescopes"
    Opacity="100"
    RA="3.7426878151346576"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9533a/thumb.jpg"
    ZoomLevel="1.3319960989759048"
  >
    <Description>NGC 1448 galaxy, observed using the NTT telescope. An example of one of the observations performed by the &amp;quot;Young Astronomers&amp;quot; during their visit to ESO on November 14 - 20, 1995. Those who attended were the winners of the Europe-wide contest &amp;quot;Europe Towards the Stars&amp;quot;, organised by ESO with the support of the European Union, under the auspices of the Third European Week for Scientific and Technological Culture.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.21091792004566812"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="56.1394063644"
        CenterY="-44.64253862"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Young astronomers observe with ESO telescopes"
        OffsetX="-0.0006173243952473"
        OffsetY="-0.0011396758066103984"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-1.5573623599040123"
        Sparse="True"
        StockSet="False"
        TileLevels="1"
        Url="http://data1.wwtassets.org/feeds/eso/eso9533a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9533a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9533a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9720a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1997-08-01T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.43382624958785"
    Magnitude="0"
    Name="The unusual quasar HE 2347-4342"
    Opacity="100"
    RA="23.842793186876406"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9720a/thumb.jpg"
    ZoomLevel="1.272322517544"
  >
    <Description>This is a direct image of HE 2347-4342 at the centre of a 7.5 x 7.5 arcmin 2 sky field.  HE 2347-4342 was discovered in October 1995 by Lutz Wisotzki from the University of Hamburg; the &amp;#x27;HE&amp;#x27; stands for Hamburg-ESO . The visual magnitude is 16.1, i.e. `only&amp;#x27; 10,000 times fainter than what can be seen with the naked eye; this makes it one of the apparently brightest quasars in the sky found so far. Still, it is quite distant - the measured redshift is z = 2.885. This places it at a distance that implies a look-back time of more than 80% of the age of the Universe. We thus observe it, as it was, just a few billion years after the Big Bang.  Being so bright in the sky and yet so distant means that HE 2347-4342 must be one of the intrinsically brightest objects in the Universe. In fact, it is no less than 10 15 times more luminous than the Sun, or 10,000 times brighter than the entire Milky Way galaxy in which we live.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.24145784832"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="357.642961"
        CenterY="-43.433091"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The unusual quasar HE 2347-4342"
        OffsetX="0.0007762781311737484"
        OffsetY="-0.0007308001540390662"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.3296633541799999"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9720a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9720a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9720a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9801a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-01-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-7.736514017771819"
    Magnitude="0"
    Name="NTT SUSI Deep Field"
    Opacity="100"
    RA="12.089648037665667"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9801a/thumb.jpg"
    ZoomLevel="0.38695312563806983"
  >
    <Description>This colour image shows objects as faint as 26th magnitude and it illustrates well the performance in deep imaging at good angular resolution with a relatively modest investment in exposure time at a 4m-class ground-based telescope. Of the approximately 500 galaxies detected in this field, the largest fraction are expected to be at redshifts smaller than z = 1  and about 20 percent to have higher redshifts, up to z = 4  and possibly beyond.  During this project, a total of 122 CCD frames were obtained in four colours [blue (B), green-yellow (V), red (r) and near-infrared (i-band)] with a total exposure time of no less than 31.5 hours. Total exposure times of 50400, 23400, 23400, 16200 seconds were obtained in the four bands, respectively. The frames cover a 2.3 x 2.3 arcmin &amp;#x27;empty sky&amp;#x27; field centered south of the high-redshift quasar QSO BR 1202-0725 (z = 4.7), located just south of the celestial equator.  These frames have been combined to produce a &amp;#x27;true&amp;#x27; colour image in the sense that &amp;#x27;blue&amp;#x27;, &amp;#x27;green&amp;#x27; and &amp;#x27;red&amp;#x27; represent the B-, V- and (r+i)-frames, respectively. This version of the combined image has a high contrast that shows the faintest objects recorded.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0638931889598464"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="181.344712815"
        CenterY="-7.73652967613"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NTT SUSI Deep Field"
        OffsetX="1.55989230859e-05"
        OffsetY="7.79946154295e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="89.56000000000017"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9801a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9801a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9801a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9801b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-01-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-7.736069698630995"
    Magnitude="0"
    Name="NTT SUSI Deep Field"
    Opacity="100"
    RA="12.089584891978516"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9801b/thumb.jpg"
    ZoomLevel="0.3801169251912272"
  >
    <Description>This colour image shows objects as faint as 26th magnitude and it illustrates well the performance in deep imaging at good angular resolution with a relatively modest investment in exposure time at a 4m-class ground-based telescope. Of the approximately 500 galaxies detected in this field, the largest fraction are expected to be at redshifts smaller than z = 1  and about 20 percent to have higher redshifts, up to z = 4  and possibly beyond.  During this project, a total of 122 CCD frames were obtained in four colours [blue (B), green-yellow (V), red (r) and near-infrared (i-band)] with a total exposure time of no less than 31.5 hours. Total exposure times of 50400, 23400, 23400, 16200 seconds were obtained in the four bands, respectively. The frames cover a 2.3 x 2.3 arcmin &amp;#x27;empty sky&amp;#x27; field centered south of the high-redshift quasar QSO BR 1202-0725 (z = 4.7), located just south of the celestial equator.  These frames have been combined to produce a &amp;#x27;true&amp;#x27; colour image in the sense that &amp;#x27;blue&amp;#x27;, &amp;#x27;green&amp;#x27; and &amp;#x27;red&amp;#x27; represent the B-, V- and (r+i)-frames, respectively. This version of the combined image has a lower contrast and brings forward structural details in the brighter objects in the field.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0732452168521728"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="181.343755536"
        CenterY="-7.73608777939"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NTT SUSI Deep Field"
        OffsetX="1.788213302055e-05"
        OffsetY="1.788213302055e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="89.3600000000001"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9801b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9801b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9801b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9805a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-01-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-5.369117419729842"
    Magnitude="0"
    Name="Colour rendering of Orion Nebula area"
    Opacity="100"
    RA="5.587268736183524"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9805a/thumb.jpg"
    ZoomLevel="0.83660399018352"
  >
    <Description>This is a composite of three 1-min exposures of the Orion Nebula through narrow band filters centred on the 2.166 micron Br-gamma atomic hydrogen line (here reproduced in blue colour), the 1.257 micron [FeII] line (green) and the 2.12 micron 1-0 S(1) molecular hydrogen line (red). The colour coding reflects the ionisation state of the gas.  Br-gamma traces hydrogen gas that is ionised by the well known Trapezium and other hot, young, stars in the region ; the [FeII] emission is emitted by high velocity fragments ejected during the birth of new stars in the OMC1 molecular cloud. The hollow filaments seen in molecular hydrogen result from shock heating of the molecular gas in the wake of the outflowing matter.  In this image, the scale is 0.29 arcsec/pixel ; the field is 5x5 arcmin with North at the top and East to the left ; the seeing was around 0.5 arcsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.093320532238336"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8091227692"
        CenterY="-5.369208362"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Colour rendering of Orion Nebula area"
        OffsetX="9.1133332264e-05"
        OffsetY="9.1133332264e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.12000000000000005"
        Sparse="True"
        StockSet="False"
        TileLevels="1"
        Url="http://data1.wwtassets.org/feeds/eso/eso9805a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/N. Devillard</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9805a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9805a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9805b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-01-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-55.215444460585914"
    Magnitude="0"
    Name="Globular cluster NGC 1261"
    Opacity="100"
    RA="3.2041178662672283"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9805b/thumb.jpg"
    ZoomLevel="0.419466272064"
  >
    <Description>This is a short (12 sec) exposure of the globular cluster NGC1261 through an H-filter centred at 1.65 micron. Note the excellent resolution, achievable at this wavelength with the SOFI/NTT combination.  The field measures 2.5 x 2.5 arcmin, with North at the top and East to the left. The scale is 0.14 arcsec/pixel. The stellar images are very sharp (FWHM around 0.7 arcsec).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04144795648"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="48.067468"
        CenterY="-55.216439"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Globular cluster NGC 1261"
        OffsetX="0.0032661321061604265"
        OffsetY="0.0009463017565944932"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.84571264511"
        Sparse="True"
        StockSet="False"
        TileLevels="1"
        Url="http://data1.wwtassets.org/feeds/eso/eso9805b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9805b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9805b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9805c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-01-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.09691393767123"
    Magnitude="0"
    Name="Colour rendering of Tarantula Nebula in LMC"
    Opacity="100"
    RA="5.6449130242820935"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9805c/thumb.jpg"
    ZoomLevel="0.7927581717638016"
  >
    <Description>This image is a composite of three narrow-band filter exposures of the famous Tarantula Nebula (30 Doradus) in our closest neighbouring galaxy, the Large Magellanic Cloud. The filters are centred on the 2.166 micron Br-gamma line of atomic hydrogen (blue); the 1.644 micron [FeII] line (green) and the 2.12 micron 1-0 S(1) line of molecular hydrogen (red). The colour coding reflects the ionization state of the gas.  The scale is 0.26 arcsec/pixel and the field is 4.5x4.5 arcmin with North at the top and East to the left. (Colour composite by F. Selman).</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.146299085907968"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.673895721"
        CenterY="-69.096985323"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Colour rendering of Tarantula Nebula in LMC"
        OffsetX="7.1435100541e-05"
        OffsetY="7.1435100541e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.039999999999999994"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9805c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO / F. Selman</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9805c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9805c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9805d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-01-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-1.5768310755117625"
    Magnitude="0"
    Name="Galaxy cluster Abell 370"
    Opacity="100"
    RA="2.664697731238181"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9805d/thumb.jpg"
    ZoomLevel="0.8342372702340001"
  >
    <Description>This is a J band image (1.25 micron) of the galaxy cluster Abell 370 (A370; redshift z = 0.375), obtained in &amp;#x27;jitter&amp;#x27; mode, showing the famous gravitational arc just below the centre. The observations consisted of 24 exposures of 2 min each, made on randomly generated telescope positions within a sky region of 30 x 30 arcsec. The individual exposures have been sky subtracted using a running average determined from the same data and then re-centred and combined.  The scale is 0.29 arcsec/pixel; the field is about 5 x 5 arcmin with North at the top and East to the left. The seeing was less optimal, about 1.2 arcsec. A J = 22 mag point source yields a signal-to-noise ratio of 4 within a 3 arcsec diameter aperture.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08227001856"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="39.960393"
        CenterY="-1.585615"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy cluster Abell 370"
        OffsetX="-0.010092569499710933"
        OffsetY="0.008756986585124875"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.15296665081"
        Sparse="True"
        StockSet="False"
        TileLevels="1"
        Url="http://data1.wwtassets.org/feeds/eso/eso9805d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9805d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9805d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9805e&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-01-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-24.300342119256463"
    Magnitude="0"
    Name="Radio galaxy MRC 0406-244"
    Opacity="100"
    RA="4.147450895824784"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9805e/thumb.jpg"
    ZoomLevel="0.659286668376"
  >
    <Description>This is another &amp;#x27;jittered&amp;#x27; image of a 5x5 arcmin field, this time in a Ks (2.16 micron) filter and showing the radio galaxy MRC 0406-244 (redshift z = 2.4); it is identified by the arrow. North is at the top and East to the left; the scale is 0.29 arcsec/pixel and the FWHM of point sources in this re-combined set of 38 1-min exposures is about 0.7 arcsec. A K = 21 mag point source yields a signal-to-noise ratio of 4 within a 1.5 arcsec diameter aperture.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08232240128"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="62.214296"
        CenterY="-24.304886"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Radio galaxy MRC 0406-244"
        OffsetX="0.0023014610643071016"
        OffsetY="0.004547266414902317"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.08468637902000002"
        Sparse="True"
        StockSet="False"
        TileLevels="1"
        Url="http://data1.wwtassets.org/feeds/eso/eso9805e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9805e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9805e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9820c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-05-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-26.523847303679883"
    Magnitude="0"
    Name="The central region of globular cluster Messier 4"
    Opacity="100"
    RA="16.39290355475934"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9820c/thumb.jpg"
    ZoomLevel="0.25225259416728374"
  >
    <Description>The globular cluster Messier 4 (M4 for short) is located about 6,000 light-years away. On the sky, it is seen in the southern constellation Scorpius, It is an ensemble of about 500,000 stars, held together by their mutual gravitational pull. There are about 150 such clusters in our Galaxy, and M4 is the one closest to us. This colour picture has been obtained by combining three images taken through three different filters at the wavelengths of blue, green, and red light. They were obtained during the night of May 22, 1998. In this way, the stars are seen in their true colours, ranging from blue for very hot stars (about 10,000 degrees) to red for the cooler ones (about 4,000 degrees). With an exposure time of only 2 minutes, the VLT has been able to detect in the blue light stars as faint as magnitude 24. This corresponds to 15 million times dimmer than the faintest stars visible to the naked eye. This was achieved even though the image has a fairly high background, being taken with the Moon above the horizon (3 days before New Moon, with 18% illumination). The large mirror surface of the VLT UT1 (53 m 2 ) and its ability to produce very sharp images (measured as 0.53 arcsec on these images), unequalled by any ground-based telescope, ensures that faint objects may be observed extremely efficiently, especially under the good conditions that prevailed during this observation. Note that, because of the limitations in the printing process, these faint stars cannot easily be seen in this glossy reproduction.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0384573758582784"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="245.893553948"
        CenterY="-26.5238605699"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The central region of globular cluster Messier 4"
        OffsetX="9.3890077779e-06"
        OffsetY="9.3890077779e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="42.57999999999996"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9820c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9820c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9820c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9820d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-05-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.10185763081834"
    Magnitude="0"
    Name="Fine structure in NGC 6302"
    Opacity="100"
    RA="17.228962787502745"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9820d/thumb.jpg"
    ZoomLevel="0.24558143814057076"
  >
    <Description>This splendid colour image of a famous southern Planetary Nebula, NGC 6302 or the Bug Nebula (sometimes nicknames the Butterfly Nebula), was obtained by combining blue, yellow and red images obtained on May 22, 1998, with 10 minute exposures and an image quality better than 0.6 arcseconds. Towards the end of their life, some massive stars expand to giant dimensions. They shed most of the hydrogen in their outer layers as a strong &amp;quot;stellar wind&amp;quot;, before they contract towards a final compact stage as &amp;quot;white dwarfs&amp;quot;. After this ejection process, the star remains thousands of times brighter and also much hotter than the Sun during a few thousand years. Its strong ultraviolet radiation has the effect of ionizing the previously ejected gas, which then shines before it disperses into interstellar space. The resulting nebulae (traditionally referred to as Planetary Nebulae , because of their resemblance to a planet in a small telescope) often exhibit very complex morphologies. The Butterfly Nebula belongs to the class of bipolar nebulae, as this picture clearly illustrates. A dark, dusty and disc-like structure - seen edge-on in this image - obscures the central star from our view. However, its strong radiation escapes perpendicular to the disk and heats and illuminates the material deposited there by the stellar wind. The origin of the dark disk may be due to the central star being a member of a double star system. This has been shown to be the case in some other bipolar nebulae in which, contrary to the Butterfly Nebula, there is a direct view towards the star.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0362832233412608"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="258.434418327"
        CenterY="-37.1018511903"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Fine structure in NGC 6302"
        OffsetX="8.85820882355e-06"
        OffsetY="1.77164176471e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="135.54000000000005"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9820d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9820d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9820d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9821a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-06-10T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-30.964103347941094"
    Magnitude="0"
    Name="The VLT sharpens its view"
    Opacity="100"
    RA="19.66644635169855"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9821a/thumb.jpg"
    ZoomLevel="0.2268627312452256"
  >
    <Description>This image was obtained in the early morning of June 6, 1998. It shows the central part of the southern globular cluster Messier 55  (or NGC 6809) in the constellation Sagittarius. The exposure lasted 30 seconds and was made with the VLT Test Camera  through an optical filtre isolating mostly red light (570 - 700 nm). It is here shown exactly as it was obtained (&amp;quot;raw image&amp;quot;), without any image processing . The brightness level in the reproduction has been set so that the fainter stars are well visible. The field shown is 83 x 83 arcsec; each pixel measures 0.0455 arcsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0241007819063296"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="294.99669535"
        CenterY="-30.9641116689"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The VLT sharpens its view"
        OffsetX="5.8839799576e-06"
        OffsetY="5.8839799576e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="44.560000000000144"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9821a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9821a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9821a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9825a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-06-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-40.71318413006113"
    Magnitude="0"
    Name="First VLT colour photo of a strange galaxy"
    Opacity="100"
    RA="12.746887456251502"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9825a/thumb.jpg"
    ZoomLevel="0.23938062030334925"
  >
    <Description>This is a colour photo from the VLT that shows NGC 4650A, a member of the so-called Centaurus chain of galaxies in the southern constellation of that name.  NGC 4650A is a complex system that is located at a distance of about 50 Megaparsec (165 million light-years). As it is clear from this high-resolution picture, there are two main components, a lenticular-shaped galaxy (of type S0), surrounded by a knotty extended ring-like distribution of stars, dust and gas, nearly perpendicular to each other. This is a combination of three 10-min B (blue) exposures (seeing 0.68 - 0.82 arcsec), two 10-min V (green-yellow) exposures (0.55 and 0.77 arcsec), and one 4-min and one 10-min R (red) exposures (0.55 and 0.52 arcsec) with the VLT Test Camera. Individual frames were flat-fielded and cleaned for cosmics, combined and deconvolved with the Richardson-Lucy algorithm to produce a final FWHM = 0.53 arcsec before colour combination. The field measures 1.5 x 1.5 arcmin. North is to the upper left; East is to the lower left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.03913996218793984"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="191.203972066"
        CenterY="-40.7137257943"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="First VLT colour photo of a strange galaxy"
        OffsetX="-3.9038776594481174e-05"
        OffsetY="0.0007364185870370398"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-45.76913011945004"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9825a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9825a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9825a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9827a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-06-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-44.14827482005421"
    Magnitude="0"
    Name="The VLT images a &quot;rectangular&quot; planetary nebula"
    Opacity="100"
    RA="14.373862262459731"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9827a/thumb.jpg"
    ZoomLevel="0.25645295736"
  >
    <Description>IC 4406  is a planetary nebula with an unusual, almost &amp;quot;rectangular&amp;quot; shape. It is located in the southern constellation Lupus (the Wolf). The distance is somewhat uncertain, possibly around 5,000 light-years.  Like the Butterfly Nebula (cf. VLT UT1 First Light Photo No. 4), IC 4406 belongs to the class of bipolar nebulae. However, the dark and dusty central band (the &amp;quot;disc-like structure&amp;quot;) is less pronounced in this object and the internal structure is more uniform. The different colours correspond to regions of different composition and physical properties. This is a combination of two 5-min B (blue) exposures (seeing 0.95 arcsec), two 5-min V (green-yellow) exposures (0.90 arcsec), and one 5-min and two 2-min R (red) exposures (0.70 to 0.90 arcsec) with the VLT Test Camera. Individual frames were flat-fielded and cleaned for cosmics before colour combination; there was no further image processing. The field measures 1.5 x 1.5 arcmin. North is to the upper right; East is to the upper left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04027511227719984"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="215.609536"
        CenterY="-44.151483"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The VLT images a &quot;rectangular&quot; planetary nebula"
        OffsetX="0.0031548994051873603"
        OffsetY="0.0014958055627645975"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="45.75618532761755"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9827a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9827a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9827a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9833a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-07-31T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.551644332648095"
    Magnitude="0"
    Name="First VLT excursion into deep space"
    Opacity="100"
    RA="22.548567533866343"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9833a/thumb.jpg"
    ZoomLevel="0.2075581121946584"
  >
    <Description>This photo is a reproduction of a combination of five 15-minute exposures with the VLT Test Camera. They were obtained through a red filtre on June 5, 1998, during a spare period when no technical tests were scheduled. They cover a part of the Hubble Deep Field - South (about 1.3 x 1.3 arcmin, or about 1/400th of the area of the Full Moon). It is the VLT&amp;#x27;s first real look into deep space and represents a most promising demonstration of the VLT&amp;#x27;s future possibilities.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.03161943331954688"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="338.228513039"
        CenterY="-60.5516497912"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="First VLT excursion into deep space"
        OffsetX="3.85979410639e-06"
        OffsetY="3.85979410639e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="44.84000000000024"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9833a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9833a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9833a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9842c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-09-15T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-37.62019830901626"
    Magnitude="0"
    Name="Edge-on galaxy ESO 342-G017"
    Opacity="100"
    RA="21.202751803941943"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9842c/thumb.jpg"
    ZoomLevel="0.23640974887200003"
  >
    <Description>The galaxy ESO 342-G017 was observed on August 19, 1998 during a spell of excellent observing conditions. Two exposures, each lasting 120 seconds, were taken through a red filtre to produce this photo. The quality of the original images is excellent, with seeing (FWHM) of only 0.26 arcsec measured on the stars in the frame.  ESO 342-G017 is an Sc-type spiral galaxy seen edge-on, and the Test Camera was rotated so that the disc of the galaxy appears horizontal in the figure. Thanks to the image quality, the photo shows much detail in the rather flat disc, including a very thin, obscuring dust band and some brighter knots, most probably star-forming regions.This image is reproduced from a composite of two 120-second exposures in the red R-band (~600 nm) of the edge-on galaxy ESO342-G017, both with 0.26 arcsec image quality. The frames were flat-fielded and cleaned for cosmics before combination. The field shown measures 1.5 x 1.5 arcmin. North is inclined 38 o clockwise from the top, East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.042155745280000004"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="318.045349"
        CenterY="-37.627331"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Edge-on galaxy ESO 342-G017"
        OffsetX="0.006325609976688846"
        OffsetY="0.004611222866931604"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="29.576941251970002"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9842c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9842c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9842c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9845a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-09-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-32.57648680780461"
    Magnitude="0"
    Name="FORS1 first light - spiral galaxy NGC 1288"
    Opacity="100"
    RA="3.2868370596014955"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9845a/thumb.jpg"
    ZoomLevel="1.1380667143231353"
  >
    <Description>This image is a reproduction of a colour composite image of the beautiful spiral galaxy NGC 1288 in the southern constellation Fornax. It covers the entire field that was imaged on the 2048 x 2048 pixel CCD camera. It is based on CCD frames in different colours that were taken under good seeing conditions during the night of First Light (15 September 1998). The distance to this galaxy is about 300 million light-years; it recedes with a velocity of 4500 km/sec and its diameter is about 200,000 light-years. This image is based on a composite of three images taken behind three different filters: B (420 nm; 6 min), V (530 nm; 3 min) and I (800 nm; 3min) during a period of 0.7 arcsec seeing. The field shown measures 6.8 x 6.8 arcmin. North is left; East is down.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.15890538540277763"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="49.3025789613"
        CenterY="-32.5765061648"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="FORS1 first light - spiral galaxy NGC 1288"
        OffsetX="1.9397630054050003e-05"
        OffsetY="1.9397630054050003e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.11990552165661782"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9845a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9845a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9845a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9845b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-09-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-0.6344269110229186"
    Magnitude="0"
    Name="FORS1 first light - distant cluster of galaxies"
    Opacity="100"
    RA="0.1498090892604729"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9845b/thumb.jpg"
    ZoomLevel="1.1433559766399999"
  >
    <Description>Produced from a 5-min near-infrared exposure, this image was obtained during the night of First Light of the FORS1 instrument (September 15, 1998). It shows a sky field near the quasar PB5763  in which is also seen a peculiar, quite distant cluster of galaxies. Many other fainter galaxies are seen in other areas, for instance in the right part of the field. Images eso9845b (negative) and eso9845c (positive) are based on a monochrome image taken in 0.8 arcsec seeing through a near-infrared (I; 800 nm) filtre. The exposure time was 5 minutes and the image was flat-fielded. The fields shown measure 6.8 x 6.8 arcmin and 2.5 x 2.3 arcmin, respectively. North is to the upper left; East is to the lower left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.19790340096"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="2.200156"
        CenterY="-0.658975"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="FORS1 first light - distant cluster of galaxies"
        OffsetX="-0.05054328910951321"
        OffsetY="-0.0159642487174323"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-45.11800208931"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9845b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9845b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9845b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9845c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-09-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-0.6208757454924131"
    Magnitude="0"
    Name="FORS1 first light - distant cluster of galaxies"
    Opacity="100"
    RA="0.15229415332634366"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9845c/thumb.jpg"
    ZoomLevel="0.35821675294737704"
  >
    <Description>Produced from a 5-min near-infrared exposure, this image was obtained during the night of First Light of the FORS1 instrument (September 15, 1998). It shows an enlargment of the sky field near the quasar PB5763, showing the individual members of this cluster of galaxies in more detail.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.07178074341867521"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="2.28442469161"
        CenterY="-0.620875607078"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="FORS1 first light - distant cluster of galaxies"
        OffsetX="8.762297780600002e-06"
        OffsetY="8.762297780600002e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-45.64000000000007"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9845c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9845c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9845c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9845d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-09-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-20.57624686776842"
    Magnitude="0"
    Name="Spiral galaxy NGC 1232"
    Opacity="100"
    RA="3.1636673334428678"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9845d/thumb.jpg"
    ZoomLevel="1.16108863074"
  >
    <Description>This spectacular image of the large spiral galaxy NGC 1232 was obtained on September 21, 1998, during a period of good observing conditions. It is based on three exposures in ultra-violet, blue and red light, respectively. The colours of the different regions are well visible : the central areas contain older stars of reddish colour, while the spiral arms are populated by young, blue stars and many star-forming regions. Note the distorted companion galaxy on the left side, shaped like the greek letter &amp;quot;theta&amp;quot;. NGC 1232 is located 20º south of the celestial equator, in the constellation Eridanus (The River). The distance is about 60 million light-years, but the excellent optical quality of the VLT and FORS allows us to see an incredible wealth of details. At the indicated distance, the edge of the field shown corresponds to about 200,000 light-years, or about twice the size of the Milky Way galaxy. The image is a composite of three images taken behind three different filters: U (360 nm; 10 min), B (420 nm; 6 min) and R (600 nm; 2:30 min) during a period of 0.7 arcsec seeing. The field shown measures 6.8 x 6.8 arcmin. North is up; East is to the left. #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.18456477696"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="47.439749"
        CenterY="-20.579584"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 1232"
        OffsetX="-0.014293749025047814"
        OffsetY="0.0033092926535936143"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.10893703474999998"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso9845d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9845d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9845d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9845e&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-09-23T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-20.580402316425097"
    Magnitude="0"
    Name="Spiral galaxy NGC 1232"
    Opacity="100"
    RA="3.162624805662467"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9845e/thumb.jpg"
    ZoomLevel="0.3005066064"
  >
    <Description>This image is of the central region of the large spiral galaxy NGC 1232 and was obtained on September 21, 1998, during a period of good observing conditions. It is based on three exposures in ultra-violet, blue and red light, respectively. This central area contains older stars of reddish colour. Images eso9845d and eso9845e are based on a composite of three images taken behind three different filters: U (360 nm; 10 min), B (420 nm; 6 min) and R (600 nm; 2:30 min) during a period of 0.7 arcsec seeing. The fields shown measure 6.8 x 6.8 arcmin and 1.6 x 1.8 arcmin, respectively. North is up; East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0391798784"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="47.439497"
        CenterY="-20.579348"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 1232"
        OffsetX="0.0001196265439619635"
        OffsetY="-0.0010540153534575865"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.14585734123"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9845e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9845e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9845e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9846a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-10-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.71797133393217"
    Magnitude="0"
    Name="The Dumbbell Nebula"
    Opacity="100"
    RA="19.99339064517643"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9846a/thumb.jpg"
    ZoomLevel="1.158780303216"
  >
    <Description>The Dumbbell Nebula ­— also known as Messier 27 or NGC 6853 — is a typical planetary nebula and is located in the constellation Vulpecula (The Fox). The distance is rather uncertain, but is believed to be around 1,200 light-years. It was first described by the French astronomer and comet hunter Charles Messier who found it in 1764 and included it as no. 27 in his famous list of extended sky objects [2] .Despite its class, the Dumbbell Nebula has nothing to do with planets. It consists of very rarified gas that has been ejected from the hot central star (well visible on this photo), now in one of the last evolutionary stages. The gas atoms in the nebula are excited (heated) by the intense ultraviolet radiation from this star and emit strongly at specific wavelengths.This image is the beautiful by-product of a technical test of some FORS1 narrow-band optical interference filtres. They only allow light in a small wavelength range to pass and are used to isolate emissions from particular atoms and ions. In this three-colour composite, a short exposure was first made through a wide-band filtre registering blue light from the nebula. It was then combined with exposures through two interference filtres in the light of double-ionized oxygen atoms and atomic hydrogen. They were colour-coded as “blue”, “green” and “red”, respectively, and then combined to produce this picture that shows the structure of the nebula in “approximately true” colours.They are three-colour composite based on two interference ([OIII] at 501 nm and 6 nm FWHM — 5 min exposure time; H-alpha at 656 nm and 6 nm FWHM — 5 min) and one broadband (Bessell B at 429 nm and 88 nm FWHM; 30 sec) filtre images, obtained on September 28, 1998, during mediocre seeing conditions (0.8 arcsec). The CCD camera has 2048 x 2048 pixels, each covering 24 x 24 µm and the sky fields shown measure 6.8 x 6.8 arcminutes and 3.5 x 3.9 arcminutes, respectively. North is up; East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11393971985300685"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="299.901693"
        CenterY="22.721112"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Dumbbell Nebula"
        OffsetX="0.0007686707075867268"
        OffsetY="-0.003140663912217106"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9846a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/I. Appenzeller, W. Seifert, O. Stahl, M. Zamani</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9846a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9846a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9846b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-10-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.720632158923234"
    Magnitude="0"
    Name="The Dumbbell Nebula"
    Opacity="100"
    RA="19.993397307878265"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9846b/thumb.jpg"
    ZoomLevel="0.6470477923756894"
  >
    <Description>The Dumbbell Nebula -- also known as Messier 27 or NGC 6853 -- is a typical planetary nebula and is located in the constellation Vulpecula (The Fox). The distance is rather uncertain, but is believed to be around 1200 light-years. It was first described by the French astronomer and comet hunter Charles Messier who found it in 1764 and included it as no. 27 in his famous list of extended sky objects. Despite its class, the Dumbbell Nebula has nothing to do with planets. It consists of very rarefied gas that has been ejected from the hot central star, now in one of the last evolutionary stages. The gas atoms in the nebula are excited (heated) by the intense ultraviolet radiation from this star and emit strongly at specific wavelengths. In this image only light from a small wavelength range was allowed to pass and so was used to isolate emissions from particular atoms and ions. The image shows the intricate structure in the central part of the nebula. They are three-colour composite based on two interference ([OIII] at 501 nm and 6 nm FWHM - 5 min exposure time; H-alpha at 656 nm and 6 nm FWHM - 5 min) and one broadband (Bessell B at 429 nm and 88 nm FWHM; 30 sec) filtre images, obtained on September 28, 1998, during mediocre seeing conditions (0.8 arcsec). The CCD camera has 2048 x 2048 pix, each covering 24 x 24 µm and the sky fields shown measure 6.8 x 6.8 arcmin and 3.5 x 3.9 arcmin, respectively. North is up; East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.084143165116416"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="299.903079934"
        CenterY="22.7208387818"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Dumbbell Nebula"
        OffsetX="0.001955777336596529"
        OffsetY="-0.00020660889948391514"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9846b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/I. Appenzeller, W. Seifert, O. Stahl, M. Zamani</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9846b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9846b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9847b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-10-15T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-52.84547366976027"
    Magnitude="0"
    Name="A strange Supernova with a gamma-ray burst"
    Opacity="100"
    RA="19.58425511883421"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9847b/thumb.jpg"
    ZoomLevel="0.5997704698412295"
  >
    <Description>The image was obtained before the explosion of supernova SN 1998bw. Image obtained using ESO 1-m Schmidt Telescope; 15 May 1985; 120-min exposure in red light.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08325233472512"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="293.763843609"
        CenterY="-52.8454838324"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="A strange Supernova with a gamma-ray burst"
        OffsetX="1.016263851625e-05"
        OffsetY="1.016263851625e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9847b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9847b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9847b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9856d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-11-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-2.0958170513188588"
    Magnitude="0"
    Name="Galaxy cluster CL2244-02 with gravitational arcs"
    Opacity="100"
    RA="22.786692943530763"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9856d/thumb.jpg"
    ZoomLevel="0.23240962254414727"
  >
    <Description>The image is a colour composite image of the galaxy cluster CL2244-02  (redshift z = 0.3), combining a 20 min jittered ISAAC Ks (2.16µm) exposure with 15 min V (green-yellow) and R (red) exposures, obtained with the VLT Test Camera at the UT1 Nasmyth focus. In addition to the prominent blue arc, produced by gravitational lensing of a galaxy at redshift z = 2.24, there are also notable, very red arcs, both closer to the centre and further out. They were only detected in the infrared image and are probably due to lensing of a much more distant galaxy.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.03257536234954752"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="341.800402145"
        CenterY="-2.09582095963"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy cluster CL2244-02 with gravitational arcs"
        OffsetX="3.97648466181e-06"
        OffsetY="7.95296932362e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-37.359999999999914"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9856d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9856d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9856d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9857c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-11-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-1.5685256221682669"
    Magnitude="0"
    Name="Galaxy cluster Abell 370"
    Opacity="100"
    RA="2.664851157728444"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9857c/thumb.jpg"
    ZoomLevel="0.5846857521119999"
  >
    <Description>This is a composite colour image of the Abell 370 cluster of galaxies. The light of a very distant object is deformed by the foreground cluster. Abell 370, at the center of the photo, contains a large number of galaxies — most of them are ellipticals. The two brightest red galaxies slightly above the gravitational arc are the most massive in the cluster and give an important contribution to the lensing event.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.08470110208"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="39.960504"
        CenterY="-1.585536"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy cluster Abell 370"
        OffsetX="-0.012309238111731034"
        OffsetY="0.016973858947072422"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.17016824546"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9857c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9857c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9857c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9857d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-11-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.757520460615282"
    Magnitude="0"
    Name="FORS Deep Field near Q0103-260"
    Opacity="100"
    RA="1.1010801145892728"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9857d/thumb.jpg"
    ZoomLevel="0.5800019802438537"
  >
    <Description>During the commissioning of FORS1, &amp;quot;deep fields&amp;quot; were observed in order to estimate the limiting magnitudes of the new instrument. Fields were selected which do not contain bright stars that might reduce the image quality due to scattered light.  This FORS &amp;quot;deep field&amp;quot; hosts the quasar Q0103-260, which is visible as a bright white source near the bottom, to the lower left (south-east) of the prominent spiral galaxy.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0833311624777728"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="16.5162130727"
        CenterY="-25.7575305791"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="FORS Deep Field near Q0103-260"
        OffsetX="1.017226104465e-05"
        OffsetY="1.017226104465e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.30210531126157797"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9857d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9857d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9857d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9858h&quot;, &quot;publishedUTCISO8601&quot;: &quot;1998-11-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.511618376034065"
    Magnitude="0"
    Name="Very distant galaxy cluster EIS0046-2930"
    Opacity="100"
    RA="0.7742521470134485"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9858h/thumb.jpg"
    ZoomLevel="0.2549135764147278"
  >
    <Description>The image is a colour composite that shows the cluster EIS0046-2930. The image has been produced by combining the V (green-yellow), R (red) and I (Near-IR) exposures with the Test Camera obtained during the VLT-UT1 Science Verification. The yellow-orange galaxies are the cluster members and the bluer objects are galaxies belonging to the general field population. The cluster center is at the location of the largest (yellow-orange) cluster galaxy to the left of the center of the image. The field measures 90 x 90 arcsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.034818127550844506"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="11.6137885561"
        CenterY="-29.5114678118"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Very distant galaxy cluster EIS0046-2930"
        OffsetX="4.302948880765e-06"
        OffsetY="-0.0001506032108267754"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.4657022297235583"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9858h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9858h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9858h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9903a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-01-15T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.255635426664497"
    Magnitude="0"
    Name="Spiral galaxy NGC 253"
    Opacity="100"
    RA="0.7946072531022212"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9903a/thumb.jpg"
    ZoomLevel="5.317318041151711"
  >
    <Description>This photo shows a sky field around the Spiral Galaxy NGC 253 (Type Sc) seen nearly edge-on. It is located in the southern constellation Sculptor at a distance of about 8 million light-years. The image is the sum of five 5-min exposures through a blue (B-band) optical filtre. They were slightly offset with respect to each other so that the small gaps between the eight CCD&amp;#x27;&amp;#x27;&amp;#x27;&amp;#x27;s of the mosaic are no longer visible. This image also shows the faint trails of 2 artificial satellites. Many of the quite numerous and small, slightly fuzzy objects are undoubtedly globular clusters of NGC 253.  The image processing consisted of de-biassing, flat-fielding, and removal (by interpolation) of some bad columns. The full-width-half-maximum (FWHM) of stellar images is about 1.0 arcsec. It was rebinned (2x2) to 4kx4k size and sampling 0.48 arcsec/pixel.North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5451284420489221"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="11.9256757043"
        CenterY="-25.2591278857"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 253"
        OffsetX="0.0060326676053315004"
        OffsetY="0.003328368333976006"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.570247043431199"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9903a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9903a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9903a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9903b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-01-15T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-25.20658010505699"
    Magnitude="0"
    Name="Detail of spiral galaxy NGC 253"
    Opacity="100"
    RA="0.799124481678979"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9903b/thumb.jpg"
    ZoomLevel="1.4771741186490228"
  >
    <Description>This photo shows a sky field around the Spiral Galaxy NGC 253 (Type Sc) seen nearly edge-on. It is located in the southern constellation Sculptor at a distance of about 8 million light-years. The image is the sum of five 5-min exposures through a blue (B-band) optical filtre. They were slightly offset with respect to each other so that the small gaps between the eight CCDs of the mosaic are no longer visible. This image also shows the faint trails of 2 artificial satellites. It contains some fainter and smaller background galaxies. Many of the quite numerous and small, slightly fuzzy objects are undoubtedly globular clusters of NGC 253.  The image processing consisted of de-biassing, flat-fielding, and removal (by interpolation) of some bad columns. The full-width-half-maximum (FWHM) of stellar images is about 1.0 arcsec. It is a subimage of another image, but at the full original sampling of 0.24 arcsec/pixel. It covers about 2kx2k, or about 1/16 of the full field. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2701214860346083"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="11.9794528884"
        CenterY="-25.1928494806"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of spiral galaxy NGC 253"
        OffsetX="-0.007082403757062498"
        OffsetY="-0.013541555983503498"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5716640653664313"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9903b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9903b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9903b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.328626163943063"
    Magnitude="0"
    Name="Dwarf galaxy Antlia"
    Opacity="100"
    RA="10.067756116935014"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920a/thumb.jpg"
    ZoomLevel="0.6788775563634168"
  >
    <Description>True-colour image  of the dwarf galaxy Antlia combined from three exposures with the FORS1 multi-mode instrument at VLT UT1, in the B (blue), V (green) and R (red) optical bands. Many background galaxies are seen in the field. The total exposure times were 2400 sec, 2400 sec and 5400 sec, respectively. The seeing varied between 0.5 and 0.7 arcsec. The field measures about 7 x 7 arcmin 2. North is up and East is left.  Very high quality images of Antlia were obtained in different colours by FORS1 on VLT UT1 in the period 27 - 31 January 1999. These data were taken around full moon, so they do not show as faint stars as they would under normal FORS operating conditions, but the image quality is exceptional. They represent by far the best images ever obtained of this galaxy, and they include the first deep B-band images.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11396986978099201"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="151.016737986"
        CenterY="-27.3334906394"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Dwarf galaxy Antlia"
        OffsetX="-0.0003577560789262233"
        OffsetY="-0.004864055527261205"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-179.93229057758967"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920e&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.76085919501205"
    Magnitude="0"
    Name="Stellar cluster NGC 1850 in the LMC"
    Opacity="100"
    RA="5.146163189227147"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920e/thumb.jpg"
    ZoomLevel="1.1557670300279999"
  >
    <Description>Colour a composite of three individual exposures, taken with FORS1 at the VLT UT1 on 3 February 1999. They were obtained through B (blue), V (green), and H-alpha (red) filters, and each of them was bias-subtracted and flat-fielded before combination. The field-of-view is 6.8 x 6.8 arcmin 2, corresponding to an area of just over 300 x 300 light-years 2 at the distance of the Large Magellanic Cloud. The exposure times were 60, 60 and 450 seconds and the image quality was 1.0, 0.7 and 0.8 arcsec (FWHM) for the B, V, and H-alpha frames, respectively. The intensity scale is linear for the B and V images and logarithmic for H-alpha, in order to enhance the fine structure of the faintest parts of the nebulosity. North is 33° to the right of the vertical. It is a composite of blue and green images plus an image in the light of Hydrogen. It shows that there is indeed still much gas around NGC 1850.  While part of this may well be the remnant of the &amp;quot;parent&amp;quot; gas cloud (i.e. the one from which both clusters were born), the presence of filaments and of various sharp &amp;quot;shocks&amp;quot;, e.g. to the left and below NGC 1850, offers support to the theory of supernova-induced star birth in the younger of the two clusters. Some &amp;quot;protostars&amp;quot; are located near or in some of the filaments — this is interpreted as additional evidence for that theory.  The nebulosity directly above the main cluster, that is shaped like a &amp;quot;3&amp;quot;, is the well-known supernova remnant N103B which itself may also be associated with NGC 1850.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22334926848"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="77.190579"
        CenterY="-68.760854"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Stellar cluster NGC 1850 in the LMC"
        OffsetX="-0.000569621559255095"
        OffsetY="0.0003659210351226415"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="33.15693543345999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920f&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.140129397613386"
    Magnitude="0"
    Name="Barred galaxy NGC 1365"
    Opacity="100"
    RA="3.559720294941702"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920f/thumb.jpg"
    ZoomLevel="1.155005485074"
  >
    <Description>This is a true-colour image  of the major part of NGC 1365, combined from three exposures with the FORS1 multi-mode instrument at VLT UT1, in the B (blue), V (green) and R (red) optical bands. The exposure times were 360, 180 and 140 seconds, respectively. The image quality is about 0.8 arcsec. The field measures about 7 x 7 arcmin 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11384731647999999"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.401181"
        CenterY="-36.141038"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Barred galaxy NGC 1365"
        OffsetX="0.0043379792665781585"
        OffsetY="0.0009274870480690085"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.25089778536"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920g&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.140777551599946"
    Magnitude="0"
    Name="NGC 1365 - H-alpha"
    Opacity="100"
    RA="3.559707930515429"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920g/thumb.jpg"
    ZoomLevel="1.14944038272"
  >
    <Description>This photo was obtained by FORS1 at VLT UT1 through a narrow optical filter that isolates light emitted by hydrogen in the red H-alpha spectral line. It shows predominantly star-forming regions and other emission nebulae, most of which are located in the bar and along the spiral arms. The exposure time was 900 seconds and the image quality is excellent, about 0.36 arcsec. The field measures about 7 x 7 arcmin 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1620713472"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.401355"
        CenterY="-36.141181"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1365 - H-alpha"
        OffsetX="0.004630716698009685"
        OffsetY="0.00042063534860461863"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.21430995564999997"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920h&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.14348839181705"
    Magnitude="0"
    Name="NGC 1365-R"
    Opacity="100"
    RA="3.5606086318560046"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920h/thumb.jpg"
    ZoomLevel="0.20922512923113518"
  >
    <Description>This view of the inner area of NGC 1365 was obtained through a red (R) optical filter with the VLT Test Camera (TC), mounted at one of the Nasmyth foci of VLT UT1. Dark dust clouds that obscure the light from objects behind them are seen along the bar and spiral arms. The gravitational action of the bar structure drives the large dust lanes into the nuclear region where intense star forming activity takes place. The exposure time was 900 seconds and the image quality is 0.5 arcsec (FWHM). North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.02975150423994368"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.4091357733"
        CenterY="-36.1434891226"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1365-R"
        OffsetX="3.631775419915e-06"
        OffsetY="3.631775419915e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-36.82000000000002"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920i&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-36.13973731830917"
    Magnitude="0"
    Name="NGC 1365 central region"
    Opacity="100"
    RA="3.5600359836852897"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920i/thumb.jpg"
    ZoomLevel="0.1874016043212793"
  >
    <Description>This is an enlargement of an image obtained by FORS1 in the light of H-alpha emission of ionized hydrogen, and here processed to show the central region of NGC1365 in great detail. The star-forming regions in this area show up as knots. The nucleus itself is very bright. An analysis has shown that the matter density in the very central region is very high and there are motions with internal velocities up to about 2000 km/sec. The nucleus probably contains a very massive black hole. North is to the upper right and East is to the upper left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.026340428781731838"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.400543734"
        CenterY="-36.1397437502"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="NGC 1365 central region"
        OffsetX="3.2153843727699998e-06"
        OffsetY="6.4307687455399995e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.020000000000250758"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920i/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920i/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920i/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920k&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-20.574456967797772"
    Magnitude="0"
    Name="(UV-B) colour index in NGC 1232"
    Opacity="100"
    RA="3.1631202271900185"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920k/thumb.jpg"
    ZoomLevel="1.0148858451347893"
  >
    <Description>This is a computer processed &amp;quot;(U-B) colour-index image&amp;quot; of NGC 1232. This technique allows to show the &amp;quot;difference&amp;quot; between images of the galaxy, as seen in different wavebands. Since different types of objects have different brightness in different colours, this method is very useful to locate objects of a particular type and to obtain an overview of their distribution in the galaxy.  The photo is based on two individual images of NGC 1232 obtained by the FORS1 Commissioning Team at the ESO VLT UT1 on 20 September 1998. They were taken in ultraviolet (&amp;quot;U-band&amp;quot;) and blue (&amp;quot;B-band&amp;quot;) light. The exposure times were 10 min and 6 min, respectively. To obtain this colour-index image, the two images were carefully recentered and then divided numerically.  Star formation regions that emit strong ultraviolet light therefore appear as particularly bright areas in this colour-index image. They trace the shock fronts of the gas in the spiral arms.  The field measures about 5.5 x 5.5 arcmin 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.15907350345441282"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="47.4468449769"
        CenterY="-20.5745345997"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="(UV-B) colour index in NGC 1232"
        OffsetX="3.8836304554300004e-05"
        OffsetY="7.767260910860001e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.06000000000000091"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920k/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920k/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920k/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920p&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.663725126648103"
    Magnitude="0"
    Name="Galaxy cluster MS1008.1-1224"
    Opacity="100"
    RA="10.17572416304722"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920p/thumb.jpg"
    ZoomLevel="1.067293342848"
  >
    <Description>True-colour image  of the cluster of galaxies, MS1008.1-1224, combined from exposures with the FORS1 multi-mode instrument at VLT UT1, in the four optical bands, B (blue; exposure time 4950 sec; image quality 0.60 - 0.85 arcsec), V (green; 5400 sec; 0.50 - 0.75 arcsec), R (red; 5400 sec; 0.45 - 0.75 arcsec) and I (near-infrared; 4050 sec; 0.45 - 0.75). Two small areas were masked because of two bright stars. The field measures about 7 x 7 arcmin 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.15112536064"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="152.642109"
        CenterY="-12.663548"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy cluster MS1008.1-1224"
        OffsetX="0.006094597739564364"
        OffsetY="-0.00017719948141609696"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920p/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920p/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920p/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920q&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-12.663664077056668"
    Magnitude="0"
    Name="Centre of galaxy cluster MS1008.1-1224"
    Opacity="100"
    RA="10.175719378052936"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920q/thumb.jpg"
    ZoomLevel="0.531610775088"
  >
    <Description>True-colour image of the centre of the cluster of galaxies, MS1008.1-1224, combined from exposures with the FORS1 multi-mode instrument at VLT UT1, in the four optical bands, B (blue; exposure time 4950 sec; image quality 0.60 - 0.85 arcsec), V (green; 5400 sec; 0.50 - 0.75 arcsec), R (red; 5400 sec; 0.45 - 0.75 arcsec) and I (near-infrared; 4050 sec; 0.45 - 0.75). The field measures about 200 x 200 arcsec 2.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.07527440384"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="152.642109"
        CenterY="-12.663548"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centre of galaxy cluster MS1008.1-1224"
        OffsetX="0.00616431541931461"
        OffsetY="-0.00013170504584621205"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.14456192061"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920q/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920q/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920q/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9920v&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-02-27T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-55.95037491508335"
    Magnitude="0"
    Name="Cluster of galaxies-1ESO657-55 (V-band)"
    Opacity="100"
    RA="6.976511096839929"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9920v/thumb.jpg"
    ZoomLevel="0.44401436910000003"
  >
    <Description>Photograph showing a (false-colour) image of the galaxy cluster 1ES 0657-558 prepared from data taken in the V (green) band filter. The arcs and arclets in this cluster are particularly well visible in this image. The total exposure time was 600 seconds. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0525965312"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="104.623691"
        CenterY="-55.944287"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cluster of galaxies-1ESO657-55 (V-band)"
        OffsetX="-0.013396574083363954"
        OffsetY="-0.006150583373066459"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.25780747096000006"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9920v/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9920v/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9920v/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9921a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-03-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-31.183540383339768"
    Magnitude="0"
    Name="Spiral galaxy NGC 2997"
    Opacity="100"
    RA="9.759986442517036"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9921a/thumb.jpg"
    ZoomLevel="0.575309709744"
  >
    <Description>This is a three-colour composite of the spiral galaxy NGC 2997 in the southern constellation Antlia (The Air Pump), obtained with the VLT UT1 and FORS1 in the morning of March 5, 1999. It is based on three exposures in V (green; 3 min; image quality 0.35 arcsec), R (red; 3 min; 0.34 arcsec) and I (near-infrared; 5 min; 0.25 arcsec) bands, with the Moon above the horizon. The field measures 3.4 x 3.4 arcmin 2 or, at the distance of the galaxy (about 55 million light-years), 55,000 x 55,000 light-years. FORS1 was operated in high-resolution imaging mode ; the pixel size was 0.1 arsec.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11302658048000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="146.411765"
        CenterY="-31.19135"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 2997"
        OffsetX="0.01023329059756421"
        OffsetY="0.007816661413218781"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.04253121471999999"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9921a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9921a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9921a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9921b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-03-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-31.183607448372857"
    Magnitude="0"
    Name="Spiral galaxy NGC 2997 I-Band-0.25 arcsec"
    Opacity="100"
    RA="9.759992590771699"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9921b/thumb.jpg"
    ZoomLevel="0.5772216360960001"
  >
    <Description>A reproduction of the sharpest image obtained so far with the VLT UT1 with image quality 0.25 arcsec FWHM. 5 min exposure in I-band.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11318071296000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="146.411765"
        CenterY="-31.19135"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 2997 I-Band-0.25 arcsec"
        OffsetX="0.010160936403253587"
        OffsetY="0.0077410193083581776"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.00556655554"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9921b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9921b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9921b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9921c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-03-06T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-77.63534756839205"
    Magnitude="0"
    Name="Celestial scribbled notes"
    Opacity="100"
    RA="11.133766219975724"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9921c/thumb.jpg"
    ZoomLevel="1.853284813512"
  >
    <Description>This colour-composite image was obtained by FORS1 on ANTU. It displays a sky area near the Chamaeleon I complex of bright nebulae and hot stars in the constellation of the same name, close to the southern celestial pole.This picture was taken a few days before the Paranal Inauguration and the &amp;quot;hand-over&amp;quot; to the astronomers on April 1, 1999.This colour composite photo of the Chamaeleon I area is based on six 1-min exposures obtained with VLT UT1 + FORS1 in the V, R and I bands. The sky field measures 6.8 x 11.2 arcmin2; North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.31035072512"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="166.700467"
        CenterY="-77.299978"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Celestial scribbled notes"
        OffsetX="-0.06788329275968492"
        OffsetY="-0.3350764010507864"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.40192541322"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9921c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9921c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9921c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9922a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-03-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-49.466203369138505"
    Magnitude="0"
    Name="Spiral galaxy NGC 4945"
    Opacity="100"
    RA="13.093702789440671"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9922a/thumb.jpg"
    ZoomLevel="5.33370806406"
  >
    <Description>This photograph shows a sky field around the spiral galaxy NGC 4945 . It is assembled from five 15-minute R(ed)-narrowband (shown in red), four 5-minute B(lue)-band (shown in green), and five 1000-second U(ltraviolet)-band (shown in blue) exposures, obtained in January 1999 during the Science Verification phase with the Wide-Field-Imager (WFI) at the MPG/ESO 2.2-m telescope at La Silla.  At the recession velocity of NGC 4945, the red filter, centred at 665 nm with an FWHM (full width at half maximum) of only 1.2 nm, does not include the H-alpha emission line of interstellar hydrogen in this galaxy. The original resolution of about 1 arcsec corresponds to roughly 62 light-years at the distance of NGC 4945  (13 million light-years).   In addition to NGC 4945 itself, some much more distant galaxies can be recognized as faint, slightly red light patches in the field. The vast majority of the point-like sources are stars in the Milky Way. However, a fair number of those near NGC 4945  are globular clusters belonging to this galaxy.  Each frame records 8184 x 8196 = 67,076,064 pixels, and thus the total number of data points (pixels) of the 14 CCD frames used to make this photo is almost 10 9. Their collective information content corresponds to more than 70 x 10 9 photons (not counting those from the Earth&amp;#x27;s upper atmosphere that were recorded simultaneously). The field covers 32 x 32 arcmin 2. East is to the left and North to the top.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.540871168310303"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="196.363668"
        CenterY="-49.467712"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy NGC 4945"
        OffsetX="-0.027214247434504568"
        OffsetY="0.0014904415898239136"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.022405631744475754"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9922a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9922a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9922a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9922b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-03-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-49.414358663802396"
    Magnitude="0"
    Name="Detail of spiral galaxy NGC 4945"
    Opacity="100"
    RA="13.089326272586854"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9922b/thumb.jpg"
    ZoomLevel="2.0093019446371874"
  >
    <Description>This image is an enlargement at full resolution of a smaller region (about 1/7 by area) of a sky field around the spiral galaxy NGC 4945 . It is assembled from five 15-minute R(ed)-narrowband (shown in red), four 5-minute B(lue)-band (shown in green), and five 1000-second U(ltraviolet)-band (shown in blue) exposures, obtained in January 1999 during the Science Verification phase with the Wide-Field-Imager (WFI) at the MPG/ESO 2.2-m telescope at La Silla.  At the recession velocity of NGC 4945, the red filter, centred at 665 nm with an FWHM (full width at half maximum) of only 1.2 nm, does not include the H-alpha emission line of interstellar hydrogen in this galaxy. The original resolution of about 1 arcsec corresponds to roughly 62 light-years at the distance of NGC 4945  (13 million light-years).  In addition to NGC 4945 itself, some much more distant galaxies can be recognized as faint, slightly red light patches in the field. The vast majority of the point-like sources are stars in the Milky Way. However, a fair number of those near NGC 4945 are globular clusters belonging to this galaxy.  Each frame records 8184 x 8196 = 67,076,064 pixels, and thus the total number of data points (pixels) of the 14 CCD frames used to make this photo is almost 10 9. Their collective information content corresponds to more than 70 x 10 9 photons (not counting those from the Earth&amp;#x27;s upper atmosphere that were recorded simultaneously).  It covers 2997 x 2998 pixels and measures about 12 x 12 arcmin 2 in the sky. Note the many background galaxies in the field.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27039967293650846"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="196.338823173"
        CenterY="-49.4190745515"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of spiral galaxy NGC 4945"
        OffsetX="-0.0006958059185879939"
        OffsetY="0.004716017892652005"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.011112820636074846"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9922b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9922b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9922b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9922c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-03-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-49.53062724149158"
    Magnitude="0"
    Name="Field near spiral galaxy NGC 4945"
    Opacity="100"
    RA="13.11023051198145"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9922c/thumb.jpg"
    ZoomLevel="0.6730166424484788"
  >
    <Description>This image is an enlargement at full resolution of a smaller region (about 1/67 by area) of a sky field around the spiral galaxy NGC 4945 . It is assembled from five 15-minute R(ed)-narrowband (shown in red), four 5-minute B(lue)-band (shown in green), and five 1000-second U(ltraviolet)-band (shown in blue) exposures, obtained in January 1999 during the Science Verification phase with the Wide-Field-Imager (WFI) at the MPG/ESO 2.2-m telescope at La Silla.  At the recession velocity of NGC 4945, the red filter, centred at 665 nm with an FWHM (full width at half maximum) of only 1.2 nm, does not include the H-alpha emission line of interstellar hydrogen in this galaxy. The original resolution of about 1 arcsec corresponds to roughly 62 light-years at the distance of NGC 4945  (13 million light-years).  In addition to NGC 4945 itself, some much more distant galaxies can be recognized as faint, slightly red light patches in the field. The vast majority of the point-like sources are stars in the Milky Way. However, a fair number of those near NGC 4945 are globular clusters belonging to this galaxy.  Each frame records 8184 x 8196 = 67,076,064 pixels, and thus the total number of data points (pixels) of the 14 CCD frames used to make this photo is almost 10 9. Their collective information content corresponds to more than 70 x 10 9 photons (not counting those from the Earth&amp;#x27;s upper atmosphere that were recorded simultaneously).   It covers 1001 x 1002 pixels and measures about 4 x 4 arcmin 2 in the sky. The structure of the faint and distant spiral galaxy at the centre is well visible in this reproduction.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0676332255654912"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="196.653508703"
        CenterY="-49.5306932434"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Field near spiral galaxy NGC 4945"
        OffsetX="3.302403592065e-05"
        OffsetY="6.60480718413e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.07999999999999999"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9922c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9922c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9922c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9922d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-03-26T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-49.53085493893155"
    Magnitude="0"
    Name="Detail of field near spiral galaxy NGC 4945"
    Opacity="100"
    RA="13.109635124944027"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9922d/thumb.jpg"
    ZoomLevel="0.14104233175485795"
  >
    <Description>This image is an enlargement of part of the same area of  a sky field around the spiral galaxy NGC 4945 with a faint spiral galaxy showing the individual pixels. It covers 214 x 210 pixels and measures about 50 x 50 arcsec 2 in the sky. The area is only 1/1500 of the full field; this illustrates the enormous amount of information that can be obtained with the WFI in a short time and hence, the great efficiency of this instrument. Please note that the small, &amp;quot;full resolution&amp;quot; image has the original resolution as recorded at the telescope, while the &amp;quot;enlarged version&amp;quot; is enlarged four times for easy viewing on the screen.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0168968304222208"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="196.644552377"
        CenterY="-49.5308630855"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of field near spiral galaxy NGC 4945"
        OffsetX="1.65008109592e-05"
        OffsetY="8.2504054796e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.36"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9922d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9922d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9922d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9923a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-26.741113118097907"
    Magnitude="0"
    Name="Messier 68"
    Opacity="100"
    RA="12.657808857649833"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9923a/thumb.jpg"
    ZoomLevel="0.2574267549097948"
  >
    <Description>This photo was obtained with VLT KUEYEN on April 4, 1999. It is reproduced from an excellent 60-second R(ed)-band exposure of the innermost region of a globular cluster, Messier 68 (NGC 4590), in the southern constellation Hydra (The Water-Snake). The distance to this 8-mag cluster is about 35,000 light years, and the diameter is about 140 light-years. The excellent image quality is 0.38 arcsec, demonstrating a good optical and mechanical state of the telescope, already at this early stage of the commissioning phase. The field measures about 90 x 90 arcsec 2. The original scale is 0.0455 pix/arcsec and there are 2048x2048 pixels in one frame. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.026065181199769596"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="189.867153"
        CenterY="-26.7411139032"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Messier 68"
        OffsetX="1.2727139257699998e-05"
        OffsetY="1.2727139257699998e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-42.49999999999993"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9923a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9923a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9923a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9923b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-46.43441129288797"
    Magnitude="0"
    Name="Spiral galaxy ESO 269-57"
    Opacity="100"
    RA="13.168165820803544"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9923b/thumb.jpg"
    ZoomLevel="0.2408176033920001"
  >
    <Description>This photo shows the central region of spiral galaxy ESO 269-57, located in the southern constellation Centaurus at a distance of about 150 million light-years. Many galaxies are seen in this direction at about the same distance, forming a loose cluster; there are also some fainter, more distant ones in the background. The designation refers to the ESO/Uppsala Survey of the Southern Sky in the 1970&amp;#x27;s during which over 15,000 southern galaxies were catalogued. ESO 269-57  is a tightly bound object of type Sar, the &amp;quot;r&amp;quot; referring to the &amp;quot;ring&amp;quot; that surrounds the bright centre, that is overexposed here. The photo is a composite, based on three exposures (Blue - 600 sec; Yellow-Green - 300 sec; Red - 300 sec) obtained with KUEYEN on March 28, 1999. The image quality is 0.7 arcsec and the field is 90 x 90 arcsec 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.03316350976000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="197.51859"
        CenterY="-46.437425"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy ESO 269-57"
        OffsetX="-0.0025645864395158415"
        OffsetY="0.003117586700890826"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="2.2682852516999996"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9923b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9923b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9923b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9923c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.88254054619028"
    Magnitude="0"
    Name="Spiral galaxy IC 4248"
    Opacity="100"
    RA="13.44653152978456"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9923c/thumb.jpg"
    ZoomLevel="0.24626306107199997"
  >
    <Description>Somewhat further out in space, and right on the border between the southern constellations Hydra and Centaurus lies this knotty spiral galaxy, IC 4248  ; the distance is about 210 million light-years. The photo is a composite, based on three exposures (Blue - 600 sec; Yellow-Green - 300 sec; Red - 300 sec) obtained with KUEYEN on March 28, 1999.  The image quality is 0.75 arcsec and the field is 90 x 90 arcsec 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.03400671232"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="201.697045"
        CenterY="-29.881286"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy IC 4248"
        OffsetX="-0.0008547461457107319"
        OffsetY="-0.001220919397611514"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="2.3221491388199995"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9923c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9923c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9923c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9923d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-07T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.711395919835724"
    Magnitude="0"
    Name="Interacting galaxies NGC 5090"
    Opacity="100"
    RA="13.354111252866549"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9923d/thumb.jpg"
    ZoomLevel="0.255686700924"
  >
    <Description>This is a close-up view of the double galaxy NGC 5090  (right) and NGC 5091  (left), in the southern constellation Centaurus. The first is a typical S0 galaxy with a bright diffuse centre, surrounded by a fainter envelope of stars (not resolved in this picture). However, some of the starlike objects seen in this region may be globular clusters (or dwarf galaxies) in orbit around NGC 5090. The other galaxy is of type Sa (the spiral structure is more developed) and is seen at a steep angle. The three-colour composite is based on frames obtained with KUEYEN on March 29, 1999, with the same filters and exposure times as used for ESO Press Photo eso9923. The image quality is 0.7 arcsec and the field is 90 x 90 arcsec 2. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.02521506816"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="200.303581"
        CenterY="-43.704728"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Interacting galaxies NGC 5090"
        OffsetX="-0.00611161394064315"
        OffsetY="-0.006425728371144526"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="2.32335154426"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9923d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9923d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9923d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9924a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-23.833069539497323"
    Magnitude="0"
    Name="B68, the black cloud"
    Opacity="100"
    RA="17.377605406822905"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9924a/thumb.jpg"
    ZoomLevel="1.108196723214"
  >
    <Description>This photograph shows an unusual sky field in the Milky Way band. It is centred on one of the classical, dark globules, known as Barnard 68 (B68) after the American astronomer, Edward E. Barnard (1857 - 1923), who included it in a list of such objects, published in 1919. It appears as a compact, opaque and rather sharply defined object against a rich, background star field. Even on this image that registers many faint stars in the area, not a single foreground star is observed. This is a clear sign that this globule must be relatively nearby.  Interstellar clouds consist of gas and dust, including many molecules, some of which contain carbon atoms (i.e. organic). For a long time considered to be &amp;quot;holes in the sky&amp;quot;, molecular clouds are now known to be among the coolest objects in the Universe (the temperature is approx. 10 K, or -263 °C). Moreover, and most importantly, they are nurseries of stars and planets.  It still remains a mystery how a dark cloud like Barnard 68 at some moment begins to contract and subsequently transforms itself into hydrogen-burning stars. However, deep images of these clouds, such as this one obtained by FORS1 on VLT ANTU, may provide important clues. This small cloud seems to be in its very earliest phase of collapse. It has a diameter of only 7 light-months (approx. 0.2 pc) and it is located at a distance of about 500 light-years (160 pc) towards the southern constellation Ophiuchus (The Serpent-holder).  This three-colour composite was reproduced from one blue (B), one green-yellow (V) and one near-infrared (I) exposure that were obtained with VLT ANTU and FORS1 in the early morning of March 27, 1999. The field measures 6.8x6.8 arcmin 2. The image consists of 2048x2048 pixels, each measuring 0.20 arcsec; the &amp;quot;Full Resolution&amp;quot; version of the photo shows all of these. North is up and East is to the left. (See also ESO Press Release eso0102.)</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11393165312"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="260.659296"
        CenterY="-23.826304"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="B68, the black cloud"
        OffsetX="-0.004391366185876828"
        OffsetY="-0.006756336696177874"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.12123380533999999"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9924a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9924a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9924a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9924b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-70.76437626815621"
    Magnitude="0"
    Name="Giant interacting galaxies NGC 6872/IC 4970"
    Opacity="100"
    RA="20.282178932753443"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9924b/thumb.jpg"
    ZoomLevel="1.161335112312"
  >
    <Description>Three-colour composite reproduced from one blue (B), one green-yellow (V) and one red (R) exposure, obtained with FORS1 at ANTU in the morning of March 29, 1999. The field size is again 6.8x6.8 arcmin 2 . It shows the spectacular barred spiral galaxy NGC 6872 that is shaped like an &amp;quot;integral sign&amp;quot;. It is of type SBb and is accompanied by a smaller, interacting galaxy, IC 4970 of type S0 (just above the centre). The bright object to the lower right of the galaxies is a star in the Milky Way whose image has been strongly overexposed and exhibits multiple optical reflections in the telescope and instrument. There are also many other, fainter and more distant galaxies of many different forms in the field. They are particularly well visible on the &amp;quot;Normal&amp;quot; and &amp;quot;Full Resolution&amp;quot; versions of the photo. The upper left spiral arm of NGC 6872 is significantly disturbed and is populated by a plethora of blueish objects, many of which are star-forming regions. This may have been be caused by a recent passage of IC 4970 through it. This interesting system is located in the southern constellation Pavo (The Peacock). It is comparatively distant, almost 300 million light-years away. It extends over more than 7 arcmin in the sky and its real size from tip to tip is thus nearly 750,000 light-years. It is in fact one of the largest known, barred spiral galaxies. In order to image all of this extraordinary object within the available field of the FORS1 camera, the instrument was rotated so that the galaxy extends along the diagonal. For this reason, the orientation is such that North is to the upper right and East is to the upper left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.19744104448"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="304.235742"
        CenterY="-70.76836"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Giant interacting galaxies NGC 6872/IC 4970"
        OffsetX="0.002311545761821519"
        OffsetY="0.0033973039466922935"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="20.03917673546"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9924b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9924b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9924b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9924c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-46.435742442916435"
    Magnitude="0"
    Name="Spiral galaxy ESO 269-57"
    Opacity="100"
    RA="13.167883922106448"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9924c/thumb.jpg"
    ZoomLevel="1.1610151403520002"
  >
    <Description>ESO 269-57  is a spectacular spiral galaxy of symmetrical shape in the southern constellation Centaurus and belongs to a well-known cluster of galaxies seen in this direction. The galaxy received this designation when it was catalogued during the first ESO Survey of the Southern Sky in the 1970&amp;#x27;s.  This photograph shows the complex structure of ESO 269-57, with an inner &amp;quot;ring&amp;quot;, of several tightly wound spiral arms, surrounded by two outer ones that appear to split into several branches. Many blue and diffuse objects are visible — most are star-forming regions. The galaxy type is Sa(r). The velocity is just over 3,100 km/sec, indicating a distance of about 155 million light-years. It extends over about 4 arcmin in the sky, corresponding to nearly 200,000 light-years across. Many other galaxies are visible in the background.  In this and the other photos, the vertical lines extending from the images of some bright stars result from a &amp;quot;bleeding&amp;quot; effect in the CCD detector where the pixels are completely saturated.  This three-colour composite (BVR) was obtained with VLT ANTU and FORS1 in the morning of March 27, 1999. The full field measures 6.8 x 6.8 arcmin 2. North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11382501376000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="197.51859"
        CenterY="-46.437425"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Spiral galaxy ESO 269-57"
        OffsetX="0.00022975809234099812"
        OffsetY="0.0016823486964836474"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.05202025845"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9924c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9924c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9924c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9924d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-43.69443917502746"
    Magnitude="0"
    Name="Galaxy pair NGC 5090 and NGC 5091"
    Opacity="100"
    RA="13.354217975040141"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9924d/thumb.jpg"
    ZoomLevel="1.1533703036940002"
  >
    <Description>A pair of galaxies NGC 5090 - 5091  in Centaurus is shown in this image. They are located at about the same distance as ESO 269-57  and may belong to the same cluster of galaxies.  This is an interacting elliptical-spiral system with some evidence of tidal disruption of NGC 5091 (to the left; seen under a steep angle) by NGC 5090 (to the right). The velocity of the nucleus of NGC 5091 has been measured as 3429 km/sec, while NGC 5090 has a velocity of 3185 km/sec. NGC 5090 is associated with a strong, double radio source (PKS 1318-43).  This three-colour composite (BVR) was obtained with VLT ANTU and FORS1 in the morning of March 29, 1999. A bright star in the Milky Way, just outside the field at the upper left, has produced a pattern of blue straylight. The field size is 6.8x6.8 arcmin 2. North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11368613888000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="200.327601"
        CenterY="-43.723329"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy pair NGC 5090 and NGC 5091"
        OffsetX="0.010417374873772076"
        OffsetY="0.028869037120087503"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.10971439225"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9924d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9924d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9924d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9924e&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-26.78056197387873"
    Magnitude="0"
    Name="Galaxy with warped dust lane"
    Opacity="100"
    RA="13.917709638935177"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9924e/thumb.jpg"
    ZoomLevel="1.161939480474326"
  >
    <Description>Image showing a sky field in the southern constellation Hydra (The Water-snake) that includes the peculiar spiral galaxy ESO 510-13 . It resembles the famous &amp;quot;Sombrero&amp;quot; galaxy, but its equatorial dust plane is pronouncedly warped. The velocity is 3300 km/sec, the distance is about 170 million light-years and the size is 100,000 light-years.  The fact that the dust band and the rest of this galaxy are not well aligned is a clear sign that the former was acquired recently (in astronomical terms). The dust band is still in the process of achieving a more stable state by becoming flat. It is not obvious how it was formed; it may for instance be the result of a merger with a gas-rich dwarf galaxy and the elliptical galaxy. In any case, this is a most interesting object that will undoubtedly soon be studied in more detail, with the VLT and other large telescopes.  The photo displays a very large number of fainter objects near this galaxy. Many of these are likely to be globular clusters of stars associated with the galaxy; others are background galaxies. It would indeed appear that ESO 510-13 is located right in front of one or more, distant clusters of galaxies.  This three-colour composite (BVI) was obtained with VLT ANTU and FORS in the morning of March 15, 1999. Field size: 6.8x6.8 arcmin 2 ; North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.22772007923630078"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="208.767324061"
        CenterY="-26.7795772739"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy with warped dust lane"
        OffsetX="0.00149733078463206"
        OffsetY="-0.0009877534792065805"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1163862717400002"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9924e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9924e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9924e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9924f&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.22807933079615"
    Magnitude="0"
    Name="Edge-on galaxy with dust lane"
    Opacity="100"
    RA="9.043787817906663"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9924f/thumb.jpg"
    ZoomLevel="1.15613306376"
  >
    <Description>This is a colour composite (BVR) of a sky field near the border between the southern constellations Carina (The Ship&amp;#x27;s Keel) and Volans (The Flying Fish). It contains a spiral galaxy, ESO 60-24 that is seen nearly edge-on. This galaxy has a strong equatorial dust band that hides the light from the stars behind it. A bright centre is located just below the dust band and the spiral structure may be perceived in the outer regions. The velocity is 4,000 km/sec, corresponding to a distance of about 200 million light-years.  These observations were made with FORS1 at ANTU on March 27, 1999. Field size: 6.8x6.8 arcmin 2 ; North is up and East is to the left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11384668160000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="135.664883"
        CenterY="-68.226969"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Edge-on galaxy with dust lane"
        OffsetX="0.0029903757796782312"
        OffsetY="-0.001114040783102892"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.06732202199999997"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9924f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9924f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9924f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9925a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-48.82625937163612"
    Magnitude="0"
    Name="Star-forming region RCW 108 in Ara"
    Opacity="100"
    RA="16.682137707456352"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9925a/thumb.jpg"
    ZoomLevel="5.368916908559999"
  >
    <Description>RCW 108  is a molecular cloud that is in the process of being destroyed by intense ultraviolet radiation from heavy and hot stars in the nearby stellar cluster NGC 6193, seen to the left in the photo. A series of images were obtained with the Wide Field Imager (WFI) of areas in the Milky Way band, including some in which interstellar nebulae of gas and dust are seen. Each frame records 8184 x 8196, or over 67 million, pixels in a sky field of 32 x 32 arcmin 2.  The photo shows the RCW 108 complex of bright and dark nebulae in the southern association Ara OB1, a star-forming region in the constellation Ara (the Altar), deep in the southern sky.   The resolution in this image has been degraded by reducing the number of pixels in one direction from about 8000 to 3000 in the &amp;quot;High-Resolution version&amp;quot;, in order to make the image transportable over the web without incurring completely unacceptable transfer times. Still, it is very large, even in the highly compressed jpeg format, reflecting the great amount of details visible. This colour picture is a composite made from 12 separate images, obtained with the WFI on 27 March 1999. The blue component corresponds to the B filter, the green to the V filter, and the red to the H-alpha filter. The images in each filter are the composite of 4 individual frames obtained with the telescope pointing at slightly different positions on the sky, so that the parts of the sky falling in the gaps between the 8 individual 2k x 4k CCDs in any given frame are recorded on the others. The monochromatic images are then produced by superimposing the individual frames, correcting for the telescope offsets ; this ensures that the complete field is well covered. This procedure is not simple, as the observing conditions may change slightly from exposure to exposure, resulting in small differences. Finally, the combined images in each filter are aligned and colour-coded to produce the colour picture.  For the processing of this large photo (8k x 8k; 256 Mbytes), a minimum of contrast correction was made and very faint lines may still be perceived in some places where the individual frames were joined. It may also be noted that there is a slight misalignment of the individual colours in stellar images at the extreme corners of the large field. This is due to the effect of differential atmospheric refraction, i.e. light rays of different colours are bent differently in air.  The exposure time was 300 sec for each frame in H-alpha, and 60 sec in B and V. East is to the left and North to the top. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0832752638456475"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="250.000359"
        CenterY="-48.862457"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Star-forming region RCW 108 in Ara"
        OffsetX="-0.1524456314328069"
        OffsetY="0.03637575204185527"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1541407439490309"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso9925a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9925a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9925a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9925b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-04-30T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-48.823358105746685"
    Magnitude="0"
    Name="Detail of star-forming region RCW 108 in Ara"
    Opacity="100"
    RA="16.67137354551982"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9925b/thumb.jpg"
    ZoomLevel="2.048861728584"
  >
    <Description>RCW 108 is a molecular cloud that is in the process of being destroyed by intense ultraviolet radiation from heavy and hot stars in the nearby stellar cluster NGC 6193, seen to the left in the photos. A series of images were obtained with the Wide Field Imager (WFI) of areas in the Milky Way band, including some in which interstellar nebulae of gas and dust are seen. Each frame records 8184 x 8196, or over 67 million, pixels in a sky field of 32 x 32 arcmin 2.  The present photo shows a detail of the RCW 108 complex of bright and dark nebulae in the southern association Ara OB1, a star-forming region in the constellation Ara (the Altar), deep in the southern sky.  This image retains the original pixel structure and image sharpness. It covers an area that corresponds to about 1/7 of the full WFI field. This colour picture is a composite made from 12 separate images, obtained with the WFI on 27 March 1999. The blue component corresponds to the B filter, the green to the V filter, and the red to the H-alpha filter. The images in each filter are the composite of 4 individual frames obtained with the telescope pointing at slightly different positions on the sky, so that the parts of the sky falling in the gaps between the 8 individual 2k x 4k CCDs in any given frame are recorded on the others. The monochromatic images are then produced by superimposing the individual frames, correcting for the telescope offsets; this ensures that the complete field is well covered. This procedure is not simple, as the observing conditions may change slightly from exposure to exposure, resulting in small differences. Finally, the combined images in each filter are aligned and colour-coded to produce the colour picture.  For the processing of this large photo (8k x 8k; 256 Mbytes), a minimum of contrast correction was made and very faint lines may still be perceived in some places where the individual frames were joined. It may also be noted that there is a slight misalignment of the individual colours in stellar images at the extreme corners of the large field. This is due to the effect of differential atmospheric refraction, i.e. light rays of different colours are bent differently in air.  The exposure time was 300 sec for each frame in H-alpha, and 60 sec in B and V. East is to the left and North to the top. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.27011115961402493"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="250.000572"
        CenterY="-48.862454"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of star-forming region RCW 108 in Ara"
        OffsetX="-0.04598715821413234"
        OffsetY="0.03921551140617637"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.1758937889677087"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9925b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9925b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9925b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9926b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-05-18T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-80.4903229498314"
    Magnitude="0"
    Name="Afterglow of GRB 990510"
    Opacity="100"
    RA="13.634991432827103"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9926b/thumb.jpg"
    ZoomLevel="0.7140645866040001"
  >
    <Description>This is a false-colour composite of the area around the optical image of the afterglow of GRB 990510, based on three near-infrared exposures with the SOFI multi-mode instrument at the 3.6-m ESO New Technology Telescope (NTT) at La Silla, obtained on May 10, 1999, between 23:15 and 23:45 UT. The exposure times were 10 min each in the J- (1.2 µm; here rendered in blue), H- (1.6 µm; green) and K-bands (2.2 µm; red); the image quality is excellent (0.6 arcsec). The field measures about 5 x 5 arcmin 2 ; the original pixel size is 0.29 arcsec. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.12699111424"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="204.531249"
        CenterY="-80.496948"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Afterglow of GRB 990510"
        OffsetX="0.0008173270446846375"
        OffsetY="0.006658279701188861"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-2.03852629653"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9926b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9926b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9926b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9926d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-05-18T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-80.4964422183168"
    Magnitude="0"
    Name="Afterglow of GRB 990510"
    Opacity="100"
    RA="13.635363016308869"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9926d/thumb.jpg"
    ZoomLevel="0.33478925968799994"
  >
    <Description>Enlargement from the 30 sec V-exposure by the VLT, shown in ESO Press Photo eso9926. The field is about 1.9 x 1.9 arcmin 2. North is up and East is left. </Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05842714624"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="204.53208"
        CenterY="-80.496805"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Afterglow of GRB 990510"
        OffsetX="0.00026974596976093816"
        OffsetY="0.0003629017845060159"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.026308819150000006"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9926d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9926d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9926d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9931a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-06-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-68.06838831089722"
    Magnitude="0"
    Name="N44 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.386701537815039"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9931a/thumb.jpg"
    ZoomLevel="5.177940443694001"
  >
    <Description>This image of the spectacular N44 H II region in the LMC displays (very nearly) the full extent of the WFI field. N44 is a very bright, rich and well-studied complex in the LMC, somewhat apart from the other nebulae in this galaxy. The general appearance (in astronomical terminology: the &amp;quot;morphology&amp;quot;) is well explained by a combination of fast outflow from stars (stellar winds) and supernova remnants, as well as sequential star formation.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.9328391372800001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="80.40787"
        CenterY="-67.91188"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="N44 in the Large Magellanic Cloud"
        OffsetX="-0.14768736096567167"
        OffsetY="-0.15600459205000003"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.37773595499999996"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9931a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9931a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9931a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9931b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-06-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-67.93266439606516"
    Magnitude="0"
    Name="Detail of N44 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.371966936156611"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9931b/thumb.jpg"
    ZoomLevel="1.702841727582"
  >
    <Description>This image of the spectacular N44 H II region in the LMC displays (very nearly) its central region, which is dominated by a large, ring-shaped nebula that includes a bright stellar association of very luminous stars. It emits X-rays - this is interpreted as a sign that several heavy stars in this area have exploded as supernova during the last few million years. N44  is a very bright, rich and well-studied complex in the LMC, somewhat apart from the other nebulae in this galaxy. The general appearance (in astronomical terminology: the &amp;quot;morphology&amp;quot;) is well explained by a combination of fast outflow from stars (stellar winds) and supernova remnants, as well as sequential star formation.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.28719353856"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="80.533005"
        CenterY="-67.937116"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of N44 in the Large Magellanic Cloud"
        OffsetX="-0.017449501575124933"
        OffsetY="0.00452291339017371"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.25557009554999993"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9931b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9931b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9931b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9931c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-06-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.24258176797188"
    Magnitude="0"
    Name="N119 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.319285514718817"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9931c/thumb.jpg"
    ZoomLevel="5.208956560241999"
  >
    <Description>N119 is an &amp;quot;H II region&amp;quot; in the LMC. The most remarkable characteristic is its pronounced spiral shape that is reminiscent of a barred spiral galaxy. It is quite large, about 400 x 600 light-years, and it is situated at the northern side of the stellar bar of the Large Magellanic Cloud, near the centre of rotation of the neutral hydrogen in this galaxy. It is this bar that is responsible for the much higher star density in the lower half of the full-field photo.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.93340184576"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="79.657889"
        CenterY="-69.406465"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="N119 in the Large Magellanic Cloud"
        OffsetX="-0.04106194579604495"
        OffsetY="0.1652996180071927"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.9167095012699997"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9931c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9931c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9931c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9931d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-06-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.2270406107871"
    Magnitude="0"
    Name="Detail of N119 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.310539861081408"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9931d/thumb.jpg"
    ZoomLevel="1.9447327866239998"
  >
    <Description>This image shows N119 in detail. N119 is an &amp;quot;H II region&amp;quot; in the LMC. The most remarkable characteristic is its pronounced spiral shape that is reminiscent of a barred spiral galaxy. It is quite large, about 400 x 600 light-years, and it is situated at the northern side of the stellar bar of the Large Magellanic Cloud, near the centre of rotation of the neutral hydrogen in this galaxy. It is this bar that is responsible for the much higher star density in the lower half of the full-field photo.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.33851047936"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="79.6007793941"
        CenterY="-69.2504017914"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of N119 in the Large Magellanic Cloud"
        OffsetX="-0.02009983738776051"
        OffsetY="0.02354914081658035"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.55969573792"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9931d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9931d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9931d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9931e&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-06-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.16855209596949"
    Magnitude="0"
    Name="Detail of N119 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.316961043467347"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9931e/thumb.jpg"
    ZoomLevel="1.0821618482253392"
  >
    <Description>This image shows N119 in detail. N119 is an &amp;quot;H II region&amp;quot; in the LMC. The most remarkable characteristic is its pronounced spiral shape that is reminiscent of a barred spiral galaxy. It is quite large, about 400 x 600 light-years, and it is situated at the northern side of the stellar bar of the Large Magellanic Cloud, near the centre of rotation of the neutral hydrogen in this galaxy. It is this bar that is responsible for the much higher star density in the lower half of the full-field photo.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1979782451351552"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="79.7545516631"
        CenterY="-69.1686003968"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of N119 in the Large Magellanic Cloud"
        OffsetX="4.83345325037e-05"
        OffsetY="4.83345325037e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.040000000000000056"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9931e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9931e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9931e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9931f&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-06-22T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.4066304939943"
    Magnitude="0"
    Name="Globular cluster NGC1916 near N119 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.310485897533261"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9931f/thumb.jpg"
    ZoomLevel="0.58364838396"
  >
    <Description>This image is centered on the bright, rich and compact cluster (NGC 1916), located close to N119. N119 is an &amp;quot;H II region&amp;quot; in the LMC. The most remarkable characteristic is its pronounced spiral shape that is reminiscent of a barred spiral galaxy.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.10199080960000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="79.657491"
        CenterY="-69.406469"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Globular cluster NGC1916 near N119 in the Large Magellanic Cloud"
        OffsetX="7.117884494066819e-05"
        OffsetY="-0.0001615206400106663"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.021344694080000004"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9931f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9931f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9931f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9934a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-07-02T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-23.8320942852482"
    Magnitude="0"
    Name="Looking through the Dark Cloud B68"
    Opacity="100"
    RA="17.377597556831518"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9934a/thumb.jpg"
    ZoomLevel="0.8307521832959999"
  >
    <Description>B68 is a dark cloud situated at a distance of about 500 light-years (160 pc) towards the southern constellation Ophiuchus (The Serpent-holder).  This is a false-colour, infrared composite photo of the dark cloud Barnard 68, obtained on March 8-9, 1999, with the SOFI instrument at the ESO 3.5-m New Technology Telescope (NTT) at La Silla. Three exposures were made through J- (wavelength 1.25 µm - 3 min; here colour-coded as &amp;quot;blue&amp;quot;), H- (1.65 µm - 30 min; &amp;quot;green&amp;quot;) and Ks-filters (2.16 µm - 30 min; &amp;quot;red&amp;quot;), respectively. The &amp;quot;reddening&amp;quot; of the background stars that are seen through the cloud is very obvious. It is due to the larger obscuration in shorter wavebands. The sky field measures about 4.9 x 4.9 arcmin 2 (1024x1024 pixels). A slight mismatch between the individual frames is present in the upper corners; this is caused by atmospheric effects. The pixel size is 0.29/arcsec. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11090558976"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="260.65922"
        CenterY="-23.826369"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Looking through the Dark Cloud B68"
        OffsetX="-0.00433355453071106"
        OffsetY="-0.005729407441870729"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.053508532290000015"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9934a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9934a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9934a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9936a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-07-20T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="12.912678230455976"
    Magnitude="0"
    Name="The 17-mag eclipsing binary system NN Ser"
    Opacity="100"
    RA="15.882260158189075"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9936a/thumb.jpg"
    ZoomLevel="0.7736455812"
  >
    <Description>This photo represents the sky field around the 17-mag variable stellar system NN Serpentis, as seen in a 5 sec exposure through a Visual filter with VLT ANTU and FORS1. It was obtained just before the observation of an eclipse of this unusual object and served to centre the telescope on the corresponding sky position. The field shown here measures 4.5 x 4.5 armin 2 (1365 x 1365 pix 2 ; 0.20 arcsec/pix). The field is somewhat larger than that shown in ESO Press Photo eso9936 and has the same orientation to allow comparison: North is about 20° anticlockwise from the top and East is 90° clockwise from that direction.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13507469312"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="238.23393"
        CenterY="12.912293"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The 17-mag eclipsing binary system NN Ser"
        OffsetX="0.0001522720333734034"
        OffsetY="0.00035488149918138403"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="19.224526100509998"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9936a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9936a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9936a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9944a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-10-05T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-69.26891651632613"
    Magnitude="0"
    Name="Supernova SN 1987A"
    Opacity="100"
    RA="5.591024842611203"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9944a/thumb.jpg"
    ZoomLevel="0.046023771980651405"
  >
    <Description>This is a direct image of SN1987A, flanked by two nearby stars. The distance between these two is 4.5 arcsec.  This reproduction is from a 2-min exposure through a R(ed) filter with the FORS1 multi-mode instrument at VLT ANTU, obtained in 0.55 arcsec seeing on September 20, 1998. North is up and East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.00710834728630272"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8653922496"
        CenterY="-69.2689199872"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Supernova SN 1987A"
        OffsetX="6.94174539678e-06"
        OffsetY="3.47087269839e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9944a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9944a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9944a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9946a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-10-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-61.259795642951154"
    Magnitude="0"
    Name="The galactic starburst region NGC 3603 *"
    Opacity="100"
    RA="11.252094813920753"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9946a/thumb.jpg"
    ZoomLevel="0.5730113857477918"
  >
    <Description>These images of the NGC 3603 region were obtained in three near-IR filter bands (Js, H and Ks) with the ISAAC instrument at the ANTU telescope at the VLT at Paranal. NGC 3603 is located in the Carina spiral arm of the Milky Way galaxy at a distance of about 20,000 light-years (6-7 kpc). It is the only massive, galactic &amp;quot;HII-region&amp;quot; (so denoted by astronomers because part of its hydrogen is ionized) in which a central cluster of strongly UV-radiating stars of types O and B that ionize the nebula can be studied at visual and near-infrared wavelengths. This is because the line-of-sight is reasonably free of dust in this direction; the dimming in near-infrared radiation due to intervening matter between the nebula and us is only about a factor of 2 (compared to 80 in visible light). The total mass of the hot O and B stars in NGC 3603 is over 2,000 solar masses. Together, the more than fifty heavy and bright O stars in NGC 3603 have about 100 times the ionizing power of the well-known Trapezium cluster in the Orion Nebula. In fact, the star cluster in NGC 3603 is in many respects very similar to the core of the large, ionizing cluster in the approximately eight times more distant Tarantula Nebula in the Large Magellanic Cloud. An important conclusion of studying this region is that there are lots of sub-solar mass stars in NGC 3603. Contrary to several theoretical predictions, these low-mass stars do form in violent starbursts. The overall age of stars in the contraction phase that are located in the innermost region of NGC 3603 was found to be  300 000 to 1 000 000 years. The counts clearly show that this cluster is well populated in sub-solar mass stars. This image is available as a mounted image in the ESOshop.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0830098830045184"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="168.786306794"
        CenterY="-61.2699791769"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The galactic starburst region NGC 3603 *"
        OffsetX="0.002348271649065271"
        OffsetY="0.010183544704563915"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.00240140923000004"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9946a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9946a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9946a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9946b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-10-13T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-61.259662072945716"
    Magnitude="0"
    Name="Central star cluster in NGC3603"
    Opacity="100"
    RA="11.251953806546288"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9946b/thumb.jpg"
    ZoomLevel="0.10769677979846581"
  >
    <Description>The central cluster is the densest concentration of massive stars known in the Milky Way. The field shown is about 2.5 x 2.5 light-years 2. It hosts more than 50 hot O-type stars. The brightest star in the field is the red supergiant IRS4 ; it is located about 80 arcsec NE of the center. About 18 arcsec N of the center are the ring nebula and the bipolar outflows around the blue supergiant Sher25. The photo also shows three proplyd-like objects ; they are similar to those seen in Orion Nebula, but 20-30 times more extended. About 1 arcmin SSE of the central cluster are seen the brightest members of the deeply embedded proto cluster IRS9 .</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0209940039051264"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="168.77932837"
        CenterY="-61.2596723465"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Central star cluster in NGC3603"
        OffsetX="1.02509784693e-05"
        OffsetY="1.02509784693e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.12631292359667443"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9946b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9946b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9946b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9948b&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-11-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-6.436211210133079"
    Magnitude="0"
    Name="Protostar HH-34 in Orion"
    Opacity="100"
    RA="5.591725877675993"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9948b/thumb.jpg"
    ZoomLevel="1.1399574917035005"
  >
    <Description>Three-colour composite of the young object Herbig-Haro 34 (HH-34), now in the protostar stage of evolution. It is based on CCD frames obtained with the FORS2 instrument in imaging mode, on November 2 and 6, 1999. This object has a remarkable, very complicated appearance that  includes two opposite jets that ram into the surrounding interstellar  matter. This structure is produced by a machine-gun-like blast of  &amp;quot;bullets&amp;quot; of dense gas ejected from the star at high velocities  (approaching 250 km/sec). This seems to indicate that the star  experiences episodic &amp;quot;outbursts&amp;quot; when large chunks of material fall onto  it from a surrounding disc. HH-34 is located at a distance of approx. 1,500 light-years, near the  famous Orion Nebula, one of the most productive star birth regions.  Note also the enigmatic &amp;quot;waterfall&amp;quot; to the upper left, a feature that is  still unexplained. The composite of three images was taken through three different filters : B (wavelength 429 nm; Full-Width-Half-Maximum (FWHM) 88 nm; exposure time 10 min; here rendered as blue), H-alpha (centered on the hydrogen emission line at wavelength 656 nm; FWHM 6 nm; 30 min; green) and S II (centrered at the emission lines of inonized sulphur at wavelength 673 nm; FWHM 6 nm; 30 min; red) during a period of 0.8 arcsec seeing. The field shown measures 6.8 x 6.8 arcmin and the images were recorded in frames of 2048 x 2048 pixels, each measuring 0.2 arcsec. North is up; East is left.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.18454794005073055"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.8665421207"
        CenterY="-6.42927514071"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Protostar HH-34 in Orion"
        OffsetX="-0.009473451888007805"
        OffsetY="-0.006679438427950203"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.56794867315"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9948b/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9948b/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9948b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9948c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-11-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-6.45976369057974"
    Magnitude="0"
    Name="Protostar HH 34 in Orion"
    Opacity="100"
    RA="5.591735927214859"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9948c/thumb.jpg"
    ZoomLevel="0.5044974789300001"
  >
    <Description>This image is an enlargement of a three-colour composite of the young object Herbig-Haro 34 (HH-34), now in the protostar stage of evolution. It is based on CCD frames obtained with the FORS2  instrument in imaging mode, on November 2 and 6, 1999.  This object has a remarkable, very complicated appearance that includes two opposite jets that ram into the surrounding interstellar matter. This structure is produced by a machine-gun-like blast of &amp;quot;bullets&amp;quot; of dense gas ejected from the star at high velocities (approaching 250 km/sec). This seems to indicate that the star experiences episodic &amp;quot;outbursts&amp;quot; when large chunks of material fall onto it from a surrounding disc.  HH-34 is located at a distance of approx. 1,500 light-years, near the famous Orion Nebula, one of the most productive star birth regions. Note also the enigmatic &amp;quot;waterfall&amp;quot; to the upper left, a feature that is still unexplained.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05658948608000001"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.879095"
        CenterY="-6.477184"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Protostar HH 34 in Orion"
        OffsetX="0.003300666672887229"
        OffsetY="0.017372218105507972"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.8694115657099999"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9948c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9948c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9948c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9948d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-11-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-67.84686301077174"
    Magnitude="0"
    Name="N70 Nebula in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.722446621726287"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9948d/thumb.jpg"
    ZoomLevel="1.1384017697280002"
  >
    <Description>This image shows a three-colour composite of the N 70  nebula. It is a &amp;quot;Super Bubble&amp;quot;  in the Large Magellanic Cloud (LMC), a satellite galaxy to the Milky Way system, located in the southern sky at a distance of about 160,000 light-years. This photo is based on CCD frames obtained with the FORS2  instrument in imaging mode in the morning of November 5, 1999.  N 70 is a luminous bubble of interstellar gas, measuring about 300 light-years in diameter. It was created by winds from hot, massive stars and supernova explosions and the interior is filled with tenuous, hot expanding gas. An object like N70 provides astronomers with an excellent opportunity to explore the connection between the life-cycles of stars and the evolution of galaxies. Very massive stars profoundly affect their environment. They stir and mix the interstellar clouds of gas and dust, and they leave their mark in the compositions and locations of future generations of stars and star systems.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11463050054098296"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.8173585977"
        CenterY="-67.8483778009"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="N70 Nebula in the Large Magellanic Cloud"
        OffsetX="-0.007292719937930899"
        OffsetY="0.0015153249034479648"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.013131745710972503"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9948d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9948d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9948d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9948e&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-11-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-67.83514030476177"
    Magnitude="0"
    Name="Detail of N70 in the Large Magellanic Cloud"
    Opacity="100"
    RA="5.726678641769586"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9948e/thumb.jpg"
    ZoomLevel="0.6221197752659999"
  >
    <Description>This image shows an enlargement of a three-colour composite of the N 70  nebula. It is a &amp;quot;Super Bubble&amp;quot;  in the Large Magellanic Cloud (LMC), a satellite galaxy to the Milky Way system, located in the southern sky at a distance of about 160,000 light-years. This photo is based on CCD frames obtained with the FORS2  instrument in imaging mode in the morning of November 5, 1999.  N 70 is a luminous bubble of interstellar gas, measuring about 300 light-years in diameter. It was created by winds from hot, massive stars and supernova explosions and the interior is filled with tenuous, hot expanding gas. An object like N70 provides astronomers with an excellent opportunity to explore the connection between the lifecycles of stars and the evolution of galaxies. Very massive stars profoundly affect their environment. They stir and mix the interstellar clouds of gas and dust, and they leave their mark in the compositions and locations of future generations of stars and star systems.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.11470329856"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="85.8173585977"
        CenterY="-67.8483778009"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of N70 in the Large Magellanic Cloud"
        OffsetX="-0.031246018317751045"
        OffsetY="0.013216826128639388"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.00044750076"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9948e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9948e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9948e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9948f&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-11-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.01205570386159"
    Magnitude="0"
    Name="The Crab Nebula in Taurus"
    Opacity="100"
    RA="5.5754837345144646"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9948f/thumb.jpg"
    ZoomLevel="1.16687024268"
  >
    <Description>This photo shows a three colour composite of the well-known Crab Nebula (also known as Messier 1), as observed with the FORS2 instrument in imaging mode in the morning of November 10, 1999. It is the remnant of a supernova explosion at a distance of about 6,000 light-years, observed almost 1,000 years ago, in the year 1054. It contains a neutron star near its centre that spins 30 times per second around its axis (see below). In this picture, the green light is predominantly produced by hydrogen emission from material ejected by the star that exploded. The blue light is predominantly emitted by very high-energy (&amp;quot;relativistic&amp;quot;) electrons that spiral in a large-scale magnetic field (so-called synchrotron emission). It is believed that these electrons are continuously accelerated and ejected by the rapidly spinning neutron star at the centre of the nebula and which is the remnant core of the exploded star. This pulsar has been identified with the lower/right of the two close stars near the geometric centre of the nebula, immediately left of the small arc-like feature, best seen in ESO Press Photo eso9948. Technical information: ESO Press Photo eso9948 is based on a composite of three images taken through three different optical filters: B (429 nm; FWHM 88 nm; 5 min; here rendered as blue), R (657 nm; FWHM 150 nm; 1 min; green) and S II (673 nm; FWHM 6 nm; 5 min; red) during periods of 0.65 arcsec (R, S II) and 0.80 (B) seeing, respectively. The field shown measures 6.8 x 6.8 arcminutes and the images were recorded in frames of 2048 x 2048 pixels, each measuring 0.2 arcseconds. North is up; East is left.   #L</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.18780700672"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.633185"
        CenterY="22.014272"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Crab Nebula in Taurus"
        OffsetX="0.0008583262037992777"
        OffsetY="-0.002217432977740546"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.07593199412999999"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9948f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9948f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9948f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9948g&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-11-17T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="22.011150186571545"
    Magnitude="0"
    Name="Centre of the Crab Nebula in Taurus"
    Opacity="100"
    RA="5.575501409990086"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9948g/thumb.jpg"
    ZoomLevel="0.46138883212111925"
  >
    <Description>This image is an enlargement of a three colour composite of the well-known Crab Nebula  (also known as &amp;quot;Messier 1&amp;quot;), as observed with the FORS2 instrument in imaging mode in the morning of November 10, 1999. It is the remnant of a supernova explosion at a distance of about 6,000 light-years, observed almost 1000 years ago, in the year 1054. It contains a neutron star near its centre that spins 30 times per second around its axis. In this picture, the green light is predominantly produced by hydrogen emission from material ejected by the star that exploded. The blue light is predominantly emitted by very high-energy (&amp;quot;relativistic&amp;quot;) electrons that spiral in a large-scale magnetic field (so-called synchrotron emission). It is believed that these electrons are continuously accelerated and ejected by the rapidly spinning neutron star at the centre of the nebula and which is the remnant core of the exploded star.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.05718496297410144"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="83.6341526073"
        CenterY="22.0077207128"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Centre of the Crab Nebula in Taurus"
        OffsetX="0.0015173271248392502"
        OffsetY="0.0034273742114016028"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.07996808878107256"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9948g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9948g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9948g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9949a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-11-29T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.865356124306054"
    Magnitude="0"
    Name="Messier 83 – central region"
    Opacity="100"
    RA="13.616543799417924"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9949a/thumb.jpg"
    ZoomLevel="1.159529422632"
  >
    <Description>This image of a well-known spiral galaxy, Messier 83, was prepared by superposing three CCD frames from this data release that are now available in the archive. This galaxy is located in the southern constellation Hydra (The Water-Snake) and is also known as NGC 5236; the distance is about 15 million light-years. The spiral structure resembles that of the Milky Way Galaxy in which we live, but Messier 83 also possesses a bar-like structure at the centre. This photo shows the central region of a beautiful spiral galaxy, Messier 83, as observed with the FORS1 instrument at VLT ANTU . It is based on a composite of three images, all of which are now available from the ESO Science Data Archive, as described in this Press Release. The three frames were taken in March 1999 through three different filters: B (wavelength 429 nm; Full-Width-Half-Maximum (FWHM) 88 nm; exposure time 10 min; here rendered as blue), R (657 nm; 150 nm; 3 min; green) and I (768 nm; 138 nm; 3 min; red) during a period of 0.8 arcsec average seeing. The field shown measures about 6.8 x 6.8 arcmin and the images were recorded in frames of 2048 x 2048 pixels, each measuring 0.2 arcsec. North is up; East is left. Compare also with ESO Press Photo eso9826 (in B/W) of a small area in this galaxy that was obtained with the VLT Test Camera in June 1998.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.17761992704"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="204.253949"
        CenterY="-29.865712"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Messier 83 – central region"
        OffsetX="0.00502304036406932"
        OffsetY="0.00035260142150991613"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.03590704629"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9949a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9949a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9949a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9954a&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-27.808598479495153"
    Magnitude="0"
    Name="The AXAF Deep Field"
    Opacity="100"
    RA="3.5410737705058564"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9954a/thumb.jpg"
    ZoomLevel="5.0512210236884885"
  >
    <Description>This image displays a 0.5° x 0.5° sky area in the direction of the so-called AXAF Deep Field in which few bright objects are seen. This photo results from the combination of 28 individual WFI exposures behind a B(lue) optical filter with a total exposure time of 7 hours. About 100,000 galaxies are visible in the original image that encompasses approx. 8000 x 8000 pixels (1 pixel = 0.24 arcsec). The light trail of an artificial satellite crosses the field. The High-Res version included here has been compressed by a factor of four in order to facilitate transport over the Web. North is up and East is left. Twenty-eight exposures with a total integration time of 7 hours have been co-added. After each single exposure, the telescope was offset by a small angle in order to cover also the gaps between the eight CCD&amp;#x27;s in the mosaic and to enable removal of minor cosmetical blemishes of the detectors. Since the CCD mosaic of the WFI comprises 67 million pixels, a total of 1,900 million data points was thus used to construct this image. The related image processing, using the EIS WFI data reduction pipeline, recently developed at ESO, kept a powerful workstation fully busy for about 8 hours.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5435187281441914"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="53.075619483"
        CenterY="-27.8021450442"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The AXAF Deep Field"
        OffsetX="-0.03597376160106002"
        OffsetY="-0.005469694746359995"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.5608568885570346"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/eso9954a/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9954a/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9954a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9954c&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.89452119884026"
    Magnitude="0"
    Name="View towards the Great Attractor"
    Opacity="100"
    RA="16.257344541862036"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9954c/thumb.jpg"
    ZoomLevel="5.54711111766"
  >
    <Description>This image covers a field of 0.5° x 0.5° in the Southern constellation of Norma (The Level) and in the direction of the &amp;quot;Great Attractor&amp;quot;. This region is at an angular distance of about 7° from the main plane of the Milky Way, i.e. less than 15 times the width of the image shown. In this colour composite, the foreground stars in the Milky Way mostly appear as whitish spots (the &amp;quot;crosses&amp;quot; around some of the brighter stars are caused by reflections in the telescope optics). Many background galaxies are also seen. They form a huge cluster (ACO 3627) with a number of bright galaxies near the center — they stand out by their larger size and yellowish colour. In order to facilitate transport over the Web, this image has been compressed by a factor of four from its original size (8500 x 8250 pixels). North is up and East is left. Five exposures each were made in blue (B-band filter; 5 x 300 sec), red (R-band filter; 5 x 180 sec) and near-infrared (narrow-band filter centered at 816 nm; 5 x 240 sec) light and combined into a false-colour composite by using blue, green, and red colour for the three images, respectively. A logarithmic intensity scale is used to better show the inner as well as the outer regions of the galaxies in this field.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.0800222050117818"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="243.594037"
        CenterY="-60.868508"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="View towards the Great Attractor"
        OffsetX="-0.12960476022765385"
        OffsetY="-0.025510548057036533"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.34002003426212835"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/eso9954c/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9954c/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9954c/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9954d&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.85338859007254"
    Magnitude="0"
    Name="Detail of a view towards the Great Attractor"
    Opacity="100"
    RA="16.257393559070234"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9954d/thumb.jpg"
    ZoomLevel="2.0188994002500005"
  >
    <Description>This image shows the central region of the Great Attractor at the original resolution of the WFI. Note the strong warping of the galaxy to the left of the center, which may be caused by gravitational interaction with one or both of the bright galaxies that are seen above and below it. The field shown measures about 12 x 12 arcmin 2. Five exposures each were made in blue (B-band filter; 5 x 300 sec), red (R-band filter; 5 x 180 sec) and near-infrared (narrow-band filter centered at 816 nm; 5 x 240 sec) light and combined into a false-colour composite by using blue, green, and red colour for the three images, respectively. A logarithmic intensity scale is used to better show the inner as well as the outer regions of the galaxies in this field.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.2702422203733334"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="243.594037"
        CenterY="-60.868508"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of a view towards the Great Attractor"
        OffsetX="-0.12989659245870233"
        OffsetY="0.01553262509058561"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.29977917877910665"
        Sparse="True"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/feeds/eso/eso9954d/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>  </Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9954d/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9954d/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9954e&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-60.80218967194343"
    Magnitude="0"
    Name="Galaxy in the Great Attractor Field"
    Opacity="100"
    RA="16.263909830095688"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9954e/thumb.jpg"
    ZoomLevel="0.13612025609538017"
  >
    <Description>This image displays a small area (about 2.4 x 2.4 arcmin 2) centered on a bright galaxy in the Great Attractor Field. The dark lane probably indicates that it has already cannibalized one or more of its companions. During the course of hundreds of millions of years or more, others are likely to suffer the same fate. Five exposures each were made in blue (B-band filter; 5 x 300 sec), red (R-band filter; 5 x 180 sec) and near-infrared (narrow-band filter centered at 816 nm; 5 x 240 sec) light and combined into a false-colour composite by using blue, green, and red colour for the three images, respectively. A logarithmic intensity scale is used to better show the inner as well as the outer regions of the galaxies in this field.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0169545981415936"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="243.958681629"
        CenterY="-60.8022227284"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Galaxy in the Great Attractor Field"
        OffsetX="1.655722474765e-05"
        OffsetY="3.31144494953e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.20000000000000026"
        Sparse="True"
        StockSet="False"
        TileLevels="1"
        Url="http://data1.wwtassets.org/feeds/eso/eso9954e/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9954e/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9954e/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9954f&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.238924017466541"
    Magnitude="0"
    Name="Cluster of galaxies Abell 496"
    Opacity="100"
    RA="4.561481266146874"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9954f/thumb.jpg"
    ZoomLevel="5.360054004629999"
  >
    <Description>This image displays a 0.5° x 0.5° sky field centered on the distant cluster of galaxies Abell 496, as imaged by the WFI at the 2.2-m MPG/ESO telescope at La Silla during a total exposure time of just over 2 hours. The original frame is a composite of several shorter exposures and encompasses approx. 8000 x 8000 pixels. The (nearly vertical, divided by the exposures) trail of a minor planet in the solar system is seen to the left of the centre. The WFI image of Abell 496 was obtained in blue light (B-band) and corresponds to a total integration time of 7560 seconds, split into a number of exposures lasting between 600 and 1200 seconds. The faintest objects just detectable in this image have a B-magnitude of about 26.5.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.5410833408"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="68.407298"
        CenterY="-13.261745"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cluster of galaxies Abell 496"
        OffsetX="-0.014505547241157725"
        OffsetY="0.022832568397362522"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.04743835587"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9954f/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9954f/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9954f/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9954g&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.316978382493193"
    Magnitude="0"
    Name="Detail of the cluster of galaxies Abell 496"
    Opacity="100"
    RA="4.554385680607202"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9954g/thumb.jpg"
    ZoomLevel="1.0099782449999999"
  >
    <Description>This image displays part of a sky field centered on the distant cluster of galaxies Abell 496, as imaged by the WFI at the 2.2-m MPG/ESO telescope at La Silla during a total exposure time of just over 2 hours.  Note in particular the large numbers of very faint objects in this field, almost exclusively distant galaxies. North is up and East is left in both photos. The WFI image of Abell 496 was obtained in blue light (B-band) and corresponds to a total integration time of 7560 seconds, split into a number of exposures lasting between 600 and 1200 seconds. The faintest objects just detectable in this image have a B-magnitude of about 26.5.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.1351918592"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="68.407543"
        CenterY="-13.261893"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Detail of the cluster of galaxies Abell 496"
        OffsetX="0.08918688607630414"
        OffsetY="-0.05526957363440097"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.10767528222"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/feeds/eso/eso9954g/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9954g/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9954g/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;eso9954h&quot;, &quot;publishedUTCISO8601&quot;: &quot;1999-12-21T00:00:00+00:00&quot;}"
    DataSetType="Sky"
    Dec="-13.259188199855423"
    Magnitude="0"
    Name="CD galaxy in the Abell 496 field"
    Opacity="100"
    RA="4.560253188698679"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/eso9954h/thumb.jpg"
    ZoomLevel="0.6040391046479183"
  >
    <Description>This image shows the central cD-type galaxy in the Abell 496 cluster, as obtained with the WFI during the observations with the 2.2-m telescope. The WFI image of Abell 496 was obtained in blue light (B-band) and corresponds to a total integration time of 7560 seconds, split into a number of exposures lasting between 600 and 1200 seconds. The faintest objects just detectable in this image have a B-magnitude of about 26.5.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0679068180795587"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="68.4038659235"
        CenterY="-13.2592548489"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="CD galaxy in the Abell 496 field"
        OffsetX="6.646410781540002e-05"
        OffsetY="6.646410781539876e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.16035914515239025"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/eso9954h/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/eso9954h/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/eso9954h/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;helix&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T23:20:46+00:00&quot;}"
    DataSetType="Sky"
    Dec="-20.84996490991734"
    Magnitude="0"
    Name="The Helix Nebula (NGC7293)"
    Opacity="100"
    RA="22.49459064947018"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/helix/thumb.jpg"
    ZoomLevel="5.766539635211999"
  >
    <Description>The Helix Nebula (also known as The Helix, NGC 7293, or Caldwell 63) is a large planetary nebula (PN) located in the constellation Aquarius. Discovered by Karl Ludwig Harding, probably before 1824, this object is one of the closest to the Earth of all the bright planetary nebulae. The estimated distance is about 215 parsecs or 700 light-years. It is similar in appearance to the Ring Nebula, whose size, age, and physical characteristics are similar to the Dumbbell Nebula, varying only in its relative proximity and the appearance from the equatorial viewing angle. The Helix Nebula has sometimes been referred to as the &amp;quot;Eye of God&amp;quot; in pop culture.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.97317142528"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="337.410536"
        CenterY="-20.83703"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Helix Nebula (NGC7293)"
        OffsetX="-0.007773146034810063"
        OffsetY="-0.012938430001771058"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-0.0244538471"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/helix/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/helix/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/helix/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;hh-111&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T23:21:10+00:00&quot;}"
    DataSetType="Sky"
    Dec="2.8100844472182156"
    Magnitude="0"
    Name="Herbig-Haro object HH111"
    Opacity="100"
    RA="5.861959432072142"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/hh-111/thumb.jpg"
    ZoomLevel="0.29422493436"
  >
    <Description>Herbig-Haro object HH111, imaged with the 3.5-metre ESO New Technology Telescope (NTT) on La Silla.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.04160264192"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="87.934281"
        CenterY="2.809292"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Herbig-Haro object HH111"
        OffsetX="0.0004198774544892076"
        OffsetY="0.004929667890069086"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-75.91473915093"
        Sparse="True"
        StockSet="False"
        TileLevels="2"
        Url="http://data1.wwtassets.org/feeds/eso/hh-111/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/hh-111/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/hh-111/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;j16081299-2304314-dss&quot;, &quot;publishedUTCISO8601&quot;: &quot;2021-10-06T12:13:18+00:00&quot;}"
    DataSetType="Sky"
    Dec="-23.096662607724074"
    Magnitude="0"
    Name="Wide-field view of a region of the sky in Upper Scorpius"
    Opacity="100"
    RA="16.13792940985183"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/j16081299-2304314-dss/thumb.jpg"
    ZoomLevel="14.69601081890146"
  >
    <Description>This image shows a wide field view of a region of the sky in the Upper Scorpius constellation. It was created from images in the Digitized Sky Survey 2.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="2.3183880941076476"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="242.069094228"
        CenterY="-23.0968048008"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Wide-field view of a region of the sky in Upper Scorpius"
        OffsetX="0.00014150317957199997"
        OffsetY="0.00014150317957199997"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.2800000000000001"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/j16081299-2304314-dss/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO/Digitized Sky Survey 2. Acknowledgement: Davide De Martin</Credits>
        <CreditsUrl>https://www.eso.org/public/images/j16081299-2304314-dss/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/j16081299-2304314-dss/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;jewel-box&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T23:19:36+00:00&quot;}"
    DataSetType="Sky"
    Dec="-61.03363435842713"
    Magnitude="0"
    Name="The Jewel Box cluster and the Coalsack Nebula"
    Opacity="100"
    RA="12.899754150574362"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/jewel-box/thumb.jpg"
    ZoomLevel="47.64380316665665"
  >
    <Description>The Jewel Box open cluster (NGC 4755 or Kappa Crucis) and the Coalsack Nebula, in the constellation Crux. The Jewel Box is the cluster just above centre in the image. The very bright star up and to the right is Mimosa (Beta Crucis). Image from the ESO/SERC (J) survey plates.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="9.138885428315733"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="193.412603"
        CenterY="-60.361945"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Jewel Box cluster and the Coalsack Nebula"
        OffsetX="-0.008492015385815604"
        OffsetY="-0.6729148212334027"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-2.73084455887"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/feeds/eso/jewel-box/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/jewel-box/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/jewel-box/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;m4&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T23:19:55+00:00&quot;}"
    DataSetType="Sky"
    Dec="-26.589603919680975"
    Magnitude="0"
    Name="Messier 4 (M4) globular cluster"
    Opacity="100"
    RA="16.411178753657357"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/m4/thumb.jpg"
    ZoomLevel="14.018313322169998"
  >
    <Description>Globular cluster Messier 4 (M4, or NGC 6121) in the constellation Scorpius as imaged by the ESO Schmidt Telescope on La Silla.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="1.6220472093247658"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="245.896885"
        CenterY="-26.525755"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Messier 4 (M4) globular cluster"
        OffsetX="-0.2431207101491461"
        OffsetY="-0.060350045003772924"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.887247528153226"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/m4/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/m4/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/m4/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;m55-3point6-m_copy&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T23:19:36+00:00&quot;}"
    DataSetType="Sky"
    Dec="-30.933219404335293"
    Magnitude="0"
    Name="Messier 55 (M55) globular cluster"
    Opacity="100"
    RA="19.66568687479853"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/m55-3point6-m_copy/thumb.jpg"
    ZoomLevel="7.014852319103999"
  >
    <Description>Globular cluster Messier 55 (M55, or NGC 6809) in the constellation Sagittarius, as imaged by the ESO 3.6-metre telescope on La Silla.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.99048685568"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="294.998738"
        CenterY="-30.964858"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Messier 55 (M55) globular cluster"
        OffsetX="0.01236026024677771"
        OffsetY="0.03132065563005908"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="1.52200209283"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/feeds/eso/m55-3point6-m_copy/L{1}X{2}Y{3}.png"
        WidthFactor="2"
      >
        <Credits>ESO</Credits>
        <CreditsUrl>https://www.eso.org/public/images/m55-3point6-m_copy/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/feeds/eso/m55-3point6-m_copy/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Annotation="{&quot;channel&quot;: &quot;eso&quot;, &quot;itemid&quot;: &quot;m83&quot;, &quot;publishedUTCISO8601&quot;: &quot;2009-12-03T23:20:32+00:00&quot;}"
    DataSetType="Sky"
    Dec="-29.871179299250834"
    Magnitude="0"
    Name="The Southern Pinwheel"
    Opacity="100"
    RA="13.616630994324114"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/feeds/eso/m83/thumb.jpg"
    ZoomLevel="2.4183501803240253"
  >
    <Description>Located about 15 million light-years away towards the Hydra (the sea serpent) constellation, Messier 83 is a nearby face-on barred spiral with a classic grand design form. It is the main member of a small galactic group including NGC 5253 and about 9 dwarf galaxies. Messier 83 stretches over 40,000 light-years, making it roughly 2.5 times smaller than our own Milky Way. However, in some respects, Messier 83 is quite similar to our own galaxy. Both the Milky Way and Messier 83 possess a bar across their galactic nucleus, the dense spherical conglomeration of stars seen at the centre of the galaxies. Messier 83 has been a prolific producer of supernovae, with six observed in the past century. This is indicative of an exceptionally high rate of star formation coinciding with its classification as a starburst galaxy. Despite its symmetric appearance, the central 1,000 light-years of the galaxy shows an unusually high level of complexity, containing both a double nucleus and a double circumnuclear starburst ring. The nature of the double nucleus is uncertain but the off centre nucleus could be a remnant core of a small galaxy that merged with Messier 83 in the past. The star clusters in the nuclear starburst rings are mostly young stars between 5 and 10 million years old.   This image is based on dat